/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.gwt.widgets.client.dialogs;

import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.AbsolutePanel;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.Widget;
import org.pentaho.gwt.widgets.client.dialogs.IDialogCallback;
import org.pentaho.gwt.widgets.client.dialogs.IDialogValidatorCallback;
import org.pentaho.gwt.widgets.client.dialogs.WindowController;
import org.pentaho.gwt.widgets.client.dialogs.WindowPanel;
import org.pentaho.gwt.widgets.client.utils.FrameUtils;

public class ResizableDialogBox {
    private AbsolutePanel boundaryPanel;
    private WindowPanel windowPanel;
    private IDialogValidatorCallback validatorCallback;
    private IDialogCallback callback;
    private Widget content;

    public ResizableDialogBox(String headerText, String okText, String cancelText, Widget content, final boolean modal) {
        this.content = content;
        this.boundaryPanel = new AbsolutePanel(){

            public void onBrowserEvent(Event event) {
                super.onBrowserEvent(event);
                if (!modal && event.getTypeInt() == 1) {
                    ResizableDialogBox.this.hide();
                }
            }
        };
        this.boundaryPanel.setSize("100%", Window.getClientHeight() + Window.getScrollTop() + "px");
        this.boundaryPanel.setVisible(true);
        RootPanel.get().add((Widget)this.boundaryPanel, 0, 0);
        this.boundaryPanel.sinkEvents(1);
        this.boundaryPanel.getElement().getStyle().setProperty("cursor", "wait");
        WindowController windowController = new WindowController(this.boundaryPanel);
        Button ok = new Button(okText);
        ok.setStylePrimaryName("pentaho-button");
        ok.getElement().setAttribute("id", "okButton");
        ok.addClickListener(new ClickListener(){

            public void onClick(Widget sender) {
                if (ResizableDialogBox.this.validatorCallback == null || ResizableDialogBox.this.validatorCallback != null && ResizableDialogBox.this.validatorCallback.validate()) {
                    try {
                        if (ResizableDialogBox.this.callback != null) {
                            ResizableDialogBox.this.callback.okPressed();
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    ResizableDialogBox.this.hide();
                }
            }
        });
        HorizontalPanel dialogButtonPanel = new HorizontalPanel();
        dialogButtonPanel.setSpacing(2);
        dialogButtonPanel.add((Widget)ok);
        if (cancelText != null) {
            Button cancel = new Button(cancelText);
            cancel.setStylePrimaryName("pentaho-button");
            cancel.getElement().setAttribute("id", "cancelButton");
            cancel.addClickListener(new ClickListener(){

                public void onClick(Widget sender) {
                    try {
                        if (ResizableDialogBox.this.callback != null) {
                            ResizableDialogBox.this.callback.cancelPressed();
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    ResizableDialogBox.this.hide();
                }
            });
            dialogButtonPanel.add((Widget)cancel);
        }
        HorizontalPanel dialogButtonPanelWrapper = new HorizontalPanel();
        if (okText != null && cancelText != null) {
            dialogButtonPanelWrapper.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_RIGHT);
        } else {
            dialogButtonPanelWrapper.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_CENTER);
        }
        dialogButtonPanelWrapper.setStyleName("dialogButtonPanel");
        dialogButtonPanelWrapper.setWidth("100%");
        dialogButtonPanelWrapper.add((Widget)dialogButtonPanel);
        Grid dialogContent = new Grid(2, 1);
        dialogContent.setCellPadding(0);
        dialogContent.setCellSpacing(0);
        dialogContent.getCellFormatter().setVerticalAlignment(1, 0, HasVerticalAlignment.ALIGN_TOP);
        dialogContent.getCellFormatter().setHorizontalAlignment(1, 0, HasHorizontalAlignment.ALIGN_LEFT);
        dialogContent.setWidget(0, 0, content);
        dialogContent.getCellFormatter().setVerticalAlignment(0, 0, HasVerticalAlignment.ALIGN_TOP);
        dialogContent.setWidget(1, 0, (Widget)dialogButtonPanelWrapper);
        dialogContent.getCellFormatter().setVerticalAlignment(1, 0, HasVerticalAlignment.ALIGN_BOTTOM);
        dialogContent.setWidth("100%");
        dialogContent.setHeight("100%");
        this.windowPanel = new WindowPanel(windowController, headerText, (Widget)dialogContent, true);
    }

    public void hide() {
        this.boundaryPanel.clear();
        RootPanel.get().remove((Widget)this.boundaryPanel);
        FrameUtils.toggleEmbedVisibility(true);
    }

    public void center() {
        this.boundaryPanel.clear();
        int left = Window.getClientWidth() - this.windowPanel.getOffsetWidth() >> 1;
        int top = Window.getClientHeight() - this.windowPanel.getOffsetHeight() >> 1;
        this.boundaryPanel.add((Widget)this.windowPanel, Window.getScrollLeft() + left, Window.getScrollTop() + top);
        left = Window.getClientWidth() - this.windowPanel.getOffsetWidth() >> 1;
        top = Window.getClientHeight() - this.windowPanel.getOffsetHeight() >> 1;
        this.boundaryPanel.clear();
        this.boundaryPanel.add((Widget)this.windowPanel, Window.getScrollLeft() + left, Window.getScrollTop() + top);
        FrameUtils.toggleEmbedVisibility(false);
    }

    public void show() {
        this.center();
    }

    public IDialogValidatorCallback getValidatorCallback() {
        return this.validatorCallback;
    }

    public void setValidatorCallback(IDialogValidatorCallback validatorCallback) {
        this.validatorCallback = validatorCallback;
    }

    public IDialogCallback getCallback() {
        return this.callback;
    }

    public void setCallback(IDialogCallback callback) {
        this.callback = callback;
    }

    public Widget getContent() {
        return this.content;
    }

    public void setText(String text) {
        this.windowPanel.setText(text);
    }

    public void setTitle(String title) {
        this.windowPanel.setTitle(title);
    }

    public void setPixelSize(int width, int height) {
        this.windowPanel.setPixelSize(width, height);
    }
}

