/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.gwt.widgets.client.dialogs;

import com.allen_sauer.gwt.dnd.client.AbstractDragController;
import com.allen_sauer.gwt.dnd.client.drop.BoundaryDropController;
import com.google.gwt.user.client.ui.AbsolutePanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.HashMap;
import org.pentaho.gwt.widgets.client.dialogs.WindowPanel;

final class ResizeDragController
extends AbstractDragController {
    private static final int MIN_WIDGET_SIZE = 20;
    private HashMap<Widget, WindowPanel.DirectionConstant> directionMap = new HashMap();
    private WindowPanel windowPanel = null;

    public ResizeDragController(AbsolutePanel boundaryPanel) {
        super(boundaryPanel);
    }

    public void dragMove() {
        int delta;
        int direction = ((ResizeDragController)this.context.dragController).getDirection((Widget)this.context.draggable).directionBits;
        if ((direction & 2) != 0) {
            delta = this.context.draggable.getAbsoluteTop() - this.context.desiredDraggableY;
            if (delta != 0) {
                int contentHeight = this.windowPanel.getContentHeight();
                int newHeight = Math.max(contentHeight + delta, 20);
                if (newHeight != contentHeight) {
                    this.windowPanel.moveBy(0, contentHeight - newHeight);
                }
                this.windowPanel.setContentSize(this.windowPanel.getContentWidth(), newHeight);
            }
        } else if ((direction & 4) != 0 && (delta = this.context.desiredDraggableY - this.context.draggable.getAbsoluteTop()) != 0) {
            this.windowPanel.setContentSize(this.windowPanel.getContentWidth(), this.windowPanel.getContentHeight() + delta);
        }
        if ((direction & 8) != 0) {
            delta = this.context.draggable.getAbsoluteLeft() - this.context.desiredDraggableX;
            if (delta != 0) {
                int contentWidth = this.windowPanel.getContentWidth();
                int newWidth = Math.max(contentWidth + delta, 20);
                if (newWidth != contentWidth) {
                    this.windowPanel.moveBy(contentWidth - newWidth, 0);
                }
                this.windowPanel.setContentSize(newWidth, this.windowPanel.getContentHeight());
            }
        } else if ((direction & 1) != 0 && (delta = this.context.desiredDraggableX - this.context.draggable.getAbsoluteLeft()) != 0) {
            this.windowPanel.setContentSize(this.windowPanel.getContentWidth() + delta, this.windowPanel.getContentHeight());
        }
    }

    public void dragStart() {
        super.dragStart();
        this.windowPanel = (WindowPanel)this.context.draggable.getParent().getParent();
    }

    public void makeDraggable(Widget widget, WindowPanel.DirectionConstant direction) {
        super.makeDraggable(widget);
        this.directionMap.put(widget, direction);
    }

    protected BoundaryDropController newBoundaryDropController(AbsolutePanel boundaryPanel, boolean allowDroppingOnBoundaryPanel) {
        if (allowDroppingOnBoundaryPanel) {
            throw new IllegalArgumentException();
        }
        return new BoundaryDropController(boundaryPanel, false);
    }

    private WindowPanel.DirectionConstant getDirection(Widget draggable) {
        return this.directionMap.get(draggable);
    }
}

