/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.gwt.widgets.client.dialogs;

import com.allen_sauer.gwt.dnd.client.util.WidgetLocation;
import com.google.gwt.user.client.ui.AbsolutePanel;
import com.google.gwt.user.client.ui.FocusPanel;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.Widget;
import org.pentaho.gwt.widgets.client.dialogs.WindowController;

public class WindowPanel
extends FocusPanel {
    public static final int DIRECTION_EAST = 1;
    public static final int DIRECTION_NORTH = 2;
    public static final int DIRECTION_SOUTH = 4;
    public static final int DIRECTION_WEST = 8;
    public static final DirectionConstant EAST = new DirectionConstant(1, "e");
    public static final DirectionConstant NORTH = new DirectionConstant(2, "n");
    public static final DirectionConstant NORTH_EAST = new DirectionConstant(3, "ne");
    public static final DirectionConstant NORTH_WEST = new DirectionConstant(10, "nw");
    public static final DirectionConstant SOUTH = new DirectionConstant(4, "s");
    public static final DirectionConstant SOUTH_EAST = new DirectionConstant(5, "se");
    public static final DirectionConstant SOUTH_WEST = new DirectionConstant(12, "sw");
    public static final DirectionConstant WEST = new DirectionConstant(8, "w");
    private static final int BORDER_THICKNESS = 5;
    private static final String CSS_RESIZE_PANEL = "resizable-WindowPanel";
    private static final String CSS_RESIZE_PANEL_HEADER = "resizable-WindowPanel-header";
    private int contentHeight;
    private Widget contentOrScrollPanelWidget;
    private int contentWidth;
    private Widget eastWidget;
    private Grid grid = new Grid(3, 3);
    private final FocusPanel headerContainer;
    private final HTML headerWidget;
    private Widget northWidget;
    private Widget southWidget;
    private Widget westWidget;
    private final WindowController windowController;

    public WindowPanel(WindowController windowController, String headerText, Widget contentWidget, boolean wrapContentInScrollPanel) {
        this.windowController = windowController;
        this.headerWidget = new HTML(headerText);
        this.setStyleName(CSS_RESIZE_PANEL);
        this.contentOrScrollPanelWidget = wrapContentInScrollPanel ? new ScrollPanel(contentWidget) : contentWidget;
        this.headerContainer = new FocusPanel();
        this.headerContainer.setStyleName(CSS_RESIZE_PANEL_HEADER);
        this.headerContainer.add((Widget)this.headerWidget);
        windowController.getPickupDragController().makeDraggable((Widget)this, (Widget)this.headerContainer);
        Grid verticalPanel = new Grid(2, 1);
        verticalPanel.setCellPadding(0);
        verticalPanel.setCellSpacing(0);
        verticalPanel.setWidget(0, 0, (Widget)this.headerContainer);
        verticalPanel.setWidget(1, 0, this.contentOrScrollPanelWidget);
        verticalPanel.getCellFormatter().addStyleName(1, 0, "resizable-DialogContentWidget");
        verticalPanel.addStyleName("resizable-DialogHeaderAndContent");
        this.grid.setCellSpacing(0);
        this.grid.setCellPadding(0);
        this.add((Widget)this.grid);
        this.setupCell(0, 0, NORTH_WEST);
        this.northWidget = this.setupCell(0, 1, NORTH);
        this.setupCell(0, 2, NORTH_EAST);
        this.westWidget = this.setupCell(1, 0, WEST);
        this.grid.setWidget(1, 1, (Widget)verticalPanel);
        this.eastWidget = this.setupCell(1, 2, EAST);
        this.setupCell(2, 0, SOUTH_WEST);
        this.southWidget = this.setupCell(2, 1, SOUTH);
        this.setupCell(2, 2, SOUTH_EAST);
    }

    public void setText(String text) {
        this.headerWidget.setHTML(text);
    }

    public void setTitle(String text) {
        this.setText(text);
    }

    public int getContentHeight() {
        return this.contentHeight;
    }

    public int getContentWidth() {
        return this.contentWidth;
    }

    public void moveBy(int right, int down) {
        AbsolutePanel parent = (AbsolutePanel)this.getParent();
        WidgetLocation location = new WidgetLocation((Widget)this, (Widget)parent);
        int left = location.getLeft() + right;
        int top = location.getTop() + down;
        parent.setWidgetPosition((Widget)this, left, top);
    }

    public void setContentSize(int width, int height) {
        if (width != this.contentWidth) {
            this.contentWidth = width;
            this.headerContainer.setPixelSize(this.contentWidth, this.headerWidget.getOffsetHeight());
            this.northWidget.setPixelSize(this.contentWidth, 5);
            this.southWidget.setPixelSize(this.contentWidth, 5);
        }
        if (height != this.contentHeight) {
            this.contentHeight = height;
            int headerHeight = this.headerContainer.getOffsetHeight();
            this.westWidget.setPixelSize(5, this.contentHeight + headerHeight);
            this.eastWidget.setPixelSize(5, this.contentHeight + headerHeight);
        }
        this.contentOrScrollPanelWidget.setPixelSize(this.contentWidth, this.contentHeight);
    }

    protected void onLoad() {
        super.onLoad();
        if (this.contentOrScrollPanelWidget.getOffsetHeight() != 0) {
            this.headerWidget.setPixelSize(this.headerWidget.getOffsetWidth(), this.headerWidget.getOffsetHeight());
            this.setContentSize(this.contentOrScrollPanelWidget.getOffsetWidth(), this.contentOrScrollPanelWidget.getOffsetHeight());
        }
    }

    private Widget setupCell(int row, int col, DirectionConstant direction) {
        FocusPanel widget = new FocusPanel();
        widget.setPixelSize(5, 5);
        this.grid.setWidget(row, col, (Widget)widget);
        this.windowController.getResizeDragController().makeDraggable((Widget)widget, direction);
        widget.setStyleName("dialog-resize-" + direction.directionLetters);
        return widget;
    }

    public static class DirectionConstant {
        public final int directionBits;
        public final String directionLetters;

        private DirectionConstant(int directionBits, String directionLetters) {
            this.directionBits = directionBits;
            this.directionLetters = directionLetters;
        }
    }
}

