/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.gwt.widgets.client.filechooser;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Element;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.http.client.Request;
import com.google.gwt.http.client.RequestBuilder;
import com.google.gwt.http.client.RequestCallback;
import com.google.gwt.http.client.RequestException;
import com.google.gwt.http.client.Response;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.ChangeListener;
import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.FocusWidget;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.KeyboardListener;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.MouseListener;
import com.google.gwt.user.client.ui.MultiWordSuggestOracle;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.SuggestBox;
import com.google.gwt.user.client.ui.SuggestOracle;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.TextBoxBase;
import com.google.gwt.user.client.ui.Tree;
import com.google.gwt.user.client.ui.TreeItem;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.xml.client.Document;
import com.google.gwt.xml.client.NodeList;
import com.google.gwt.xml.client.XMLParser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.pentaho.gwt.widgets.client.dialogs.IDialogCallback;
import org.pentaho.gwt.widgets.client.dialogs.PromptDialogBox;
import org.pentaho.gwt.widgets.client.filechooser.FileChooserEntryPoint;
import org.pentaho.gwt.widgets.client.filechooser.FileChooserListener;
import org.pentaho.gwt.widgets.client.filechooser.FileFilter;
import org.pentaho.gwt.widgets.client.filechooser.TreeBuilder;
import org.pentaho.gwt.widgets.client.filechooser.images.FileChooserImages;
import org.pentaho.gwt.widgets.client.utils.ElementUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileChooser
extends VerticalPanel {
    FileChooserMode mode = FileChooserMode.OPEN;
    String selectedPath;
    String previousPath;
    ListBox navigationListBox;
    Tree repositoryTree;
    TreeItem selectedTreeItem;
    boolean showHiddenFiles = false;
    boolean showLocalizedFileNames = true;
    boolean showSearch = false;
    com.google.gwt.user.client.Element lastSelectedFileElement;
    TextBox fileNameTextBox = new TextBox();
    DateTimeFormat dateFormat = DateTimeFormat.getMediumDateTimeFormat();
    Document solutionRepositoryDocument;
    ArrayList<FileChooserListener> listeners = new ArrayList();
    private String actualFileName;
    boolean fileSelected = false;
    private static final String ACTUAL_FILE_NAME = "name";
    private static final String LOCALIZED_FILE_NAME = "localized-name";
    private FileFilter fileFilter;
    private boolean submitOnEnter = true;

    public FileChooser() {
        this.fileNameTextBox.getElement().setId("fileNameTextBox");
        this.fileNameTextBox.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                FileChooser.this.fileNameTextBox.setFocus(true);
            }
        });
        this.fileNameTextBox.addKeyboardListener(new KeyboardListener(){

            public void onKeyDown(Widget sender, char keyCode, int modifiers) {
            }

            public void onKeyPress(Widget sender, char keyCode, int modifiers) {
            }

            public void onKeyUp(Widget sender, char keyCode, int modifiers) {
                FileChooser.this.actualFileName = FileChooser.this.fileNameTextBox.getText();
                if (keyCode == '\r' && FileChooser.this.isSubmitOnEnter()) {
                    FileChooser.this.fireFileSelected();
                }
            }
        });
        this.setSpacing(3);
    }

    public FileChooser(FileChooserMode mode, String selectedPath, boolean showLocalizedFileNames) {
        this(mode, selectedPath, showLocalizedFileNames, null);
    }

    public FileChooser(FileChooserMode mode, String selectedPath, boolean showLocalizedFileNames, Document solutionRepositoryDocument) {
        this();
        this.mode = mode;
        this.selectedPath = selectedPath;
        this.solutionRepositoryDocument = solutionRepositoryDocument;
        this.showLocalizedFileNames = showLocalizedFileNames;
        if (null != solutionRepositoryDocument) {
            this.repositoryTree = TreeBuilder.buildSolutionTree(solutionRepositoryDocument, this.showHiddenFiles, showLocalizedFileNames, this.fileFilter);
            this.initUI(false);
        }
    }

    public FileChooser(FileChooserMode mode, String selectedPath, IDialogCallback callback) {
        this();
        this.mode = mode;
        this.selectedPath = selectedPath;
        try {
            this.fetchRepositoryDocument(callback);
        }
        catch (RequestException e) {
            Window.alert((String)e.toString());
        }
    }

    public void fetchRepositoryDocument(final IDialogCallback completedCallback) throws RequestException {
        RequestBuilder builder = null;
        builder = GWT.isScript() ? new RequestBuilder(RequestBuilder.GET, this.getWebAppRoot() + "SolutionRepositoryService?component=getSolutionRepositoryDoc&filter=*.xaction,*.url,*.prpt") : new RequestBuilder(RequestBuilder.GET, "http://localhost:8080/pentaho/SolutionRepositoryService?component=getSolutionRepositoryDoc&userid=joe&password=password");
        RequestCallback callback = new RequestCallback(){

            public void onError(Request request, Throwable exception) {
                Window.alert((String)exception.toString());
            }

            public void onResponseReceived(Request request, Response response) {
                if (response.getStatusCode() == 200) {
                    FileChooser.this.solutionRepositoryDocument = XMLParser.parse((String)response.getText());
                    FileChooser.this.repositoryTree = TreeBuilder.buildSolutionTree(FileChooser.this.solutionRepositoryDocument, FileChooser.this.showHiddenFiles, FileChooser.this.showLocalizedFileNames, FileChooser.this.fileFilter);
                    FileChooser.this.initUI(false);
                    if (completedCallback != null) {
                        completedCallback.okPressed();
                    }
                } else {
                    Window.alert((String)"Solution Repository not found.");
                }
            }
        };
        builder.sendRequest(null, callback);
    }

    private void buildOracleValues(List<String> oracleValues, com.google.gwt.xml.client.Element element) {
        String name = element.getAttribute(ACTUAL_FILE_NAME);
        String localizedName = element.getAttribute(LOCALIZED_FILE_NAME);
        boolean isVisible = "true".equals(element.getAttribute("visible"));
        if (isVisible || this.showHiddenFiles) {
            if (name != null) {
                oracleValues.add(name);
            }
            if (localizedName != null) {
                oracleValues.add(localizedName);
            }
            NodeList children = element.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                this.buildOracleValues(oracleValues, (com.google.gwt.xml.client.Element)children.item(i));
            }
        }
    }

    public void initUI(boolean fromSearch) {
        if (this.mode == FileChooserMode.OPEN_READ_ONLY) {
            this.fileNameTextBox.setReadOnly(true);
        }
        this.setFileSelected(false);
        String path = this.selectedPath;
        if (fromSearch) {
            path = this.previousPath;
        }
        final String finalPath = path;
        ArrayList<String> pathSegments = new ArrayList<String>();
        if (path != null) {
            int index = path.indexOf("/", 0);
            while (index >= 0) {
                int oldIndex = index;
                if ((index = path.indexOf("/", oldIndex + 1)) < 0) continue;
                pathSegments.add(path.substring(oldIndex + 1, index));
            }
            pathSegments.add(path.substring(path.lastIndexOf("/") + 1));
        }
        this.navigationListBox = new ListBox();
        this.navigationListBox.getElement().setId("navigationListBox");
        this.navigationListBox.setWidth("350px");
        this.navigationListBox.addItem("/", "/");
        for (int i = 0; i < pathSegments.size(); ++i) {
            String segment = (String)pathSegments.get(i);
            String fullPath = "";
            for (int j = 0; j <= i; ++j) {
                fullPath = fullPath + "/" + (String)pathSegments.get(j);
            }
            if (fullPath.equals("/")) continue;
            this.navigationListBox.addItem(fullPath, segment);
        }
        if (fromSearch) {
            this.navigationListBox.addItem(FileChooserEntryPoint.messages.getString("searchResults"));
        }
        this.navigationListBox.setSelectedIndex(this.navigationListBox.getItemCount() - 1);
        this.navigationListBox.addChangeListener(new ChangeListener(){

            public void onChange(Widget sender) {
                FileChooser.this.changeToPath(FileChooser.this.navigationListBox.getItemText(FileChooser.this.navigationListBox.getSelectedIndex()));
            }
        });
        if (!fromSearch) {
            this.selectedTreeItem = this.getTreeItem(pathSegments);
        }
        this.clear();
        VerticalPanel locationBar = new VerticalPanel();
        locationBar.add((Widget)new Label(FileChooserEntryPoint.messages.getString("location")));
        HorizontalPanel navigationBar = new HorizontalPanel();
        final Image searchImage = new Image();
        FileChooserImages.images.search().applyTo(searchImage);
        searchImage.setTitle(FileChooserEntryPoint.messages.getString("search"));
        DOM.setStyleAttribute((com.google.gwt.user.client.Element)searchImage.getElement(), (String)"border", (String)"1px solid white");
        searchImage.addMouseListener(new MouseListener(){

            public void onMouseDown(Widget sender, int x, int y) {
            }

            public void onMouseEnter(Widget sender) {
                DOM.setStyleAttribute((com.google.gwt.user.client.Element)searchImage.getElement(), (String)"borderLeft", (String)"1px solid gray");
                DOM.setStyleAttribute((com.google.gwt.user.client.Element)searchImage.getElement(), (String)"borderTop", (String)"1px solid gray");
                DOM.setStyleAttribute((com.google.gwt.user.client.Element)searchImage.getElement(), (String)"borderRight", (String)"1px solid black");
                DOM.setStyleAttribute((com.google.gwt.user.client.Element)searchImage.getElement(), (String)"borderBottom", (String)"1px solid black");
            }

            public void onMouseLeave(Widget sender) {
                DOM.setStyleAttribute((com.google.gwt.user.client.Element)searchImage.getElement(), (String)"border", (String)"1px solid white");
            }

            public void onMouseMove(Widget sender, int x, int y) {
            }

            public void onMouseUp(Widget sender, int x, int y) {
                DOM.setStyleAttribute((com.google.gwt.user.client.Element)searchImage.getElement(), (String)"border", (String)"1px solid white");
            }
        });
        searchImage.addClickListener(new ClickListener(){

            public void onClick(Widget sender) {
                MultiWordSuggestOracle oracle = new MultiWordSuggestOracle();
                ArrayList oracleValues = new ArrayList();
                com.google.gwt.xml.client.Element documentElement = FileChooser.this.solutionRepositoryDocument.getDocumentElement();
                for (int i = 0; i < documentElement.getChildNodes().getLength(); ++i) {
                    FileChooser.this.buildOracleValues(oracleValues, (com.google.gwt.xml.client.Element)documentElement.getChildNodes().item(i));
                }
                oracle.addAll(oracleValues);
                final TextBox searchTextBox = new TextBox();
                SuggestBox suggestTextBox = new SuggestBox((SuggestOracle)oracle, (TextBoxBase)searchTextBox);
                IDialogCallback callback = new IDialogCallback(){

                    public void cancelPressed() {
                    }

                    public void okPressed() {
                        TreeItem parentItem = new TreeItem();
                        parentItem.setText(FileChooserEntryPoint.messages.getString("searchResults"));
                        parentItem.setTitle(FileChooserEntryPoint.messages.getString("searchResults"));
                        HashMap<String, String> attributeMap = new HashMap<String, String>();
                        attributeMap.put(FileChooser.ACTUAL_FILE_NAME, FileChooserEntryPoint.messages.getString("searchResults"));
                        attributeMap.put(FileChooser.LOCALIZED_FILE_NAME, FileChooserEntryPoint.messages.getString("searchResults"));
                        attributeMap.put("description", FileChooserEntryPoint.messages.getString("searchResults"));
                        attributeMap.put("lastModifiedDate", "" + new Date().getTime());
                        attributeMap.put("visible", "true");
                        attributeMap.put("isDirectory", "true");
                        parentItem.setUserObject(attributeMap);
                        FileChooser.this.findMatchingTreeItems(parentItem, FileChooser.this.repositoryTree.getItem(0), searchTextBox.getText().replace("*", ""));
                        FileChooser.this.selectedTreeItem = parentItem;
                        FileChooser.this.previousPath = finalPath;
                        FileChooser.this.selectedPath = FileChooserEntryPoint.messages.getString("searchResults");
                        FileChooser.this.initUI(true);
                    }
                };
                PromptDialogBox searchDialog = new PromptDialogBox(FileChooserEntryPoint.messages.getString("search"), FileChooserEntryPoint.messages.getString("ok"), FileChooserEntryPoint.messages.getString("cancel"), false, true, (Widget)suggestTextBox);
                searchDialog.setCallback(callback);
                searchDialog.setFocusWidget((FocusWidget)searchTextBox);
                searchDialog.center();
            }
        });
        Image upDirImage = new Image();
        FileChooserImages.images.up().applyTo(upDirImage);
        upDirImage.setTitle(FileChooserEntryPoint.messages.getString("upOneLevel"));
        upDirImage.addMouseListener(new MouseListener(){

            public void onMouseDown(Widget sender, int x, int y) {
            }

            public void onMouseEnter(Widget sender) {
            }

            public void onMouseLeave(Widget sender) {
            }

            public void onMouseMove(Widget sender, int x, int y) {
            }

            public void onMouseUp(Widget sender, int x, int y) {
            }
        });
        upDirImage.addClickListener(new ClickListener(){

            public void onClick(Widget sender) {
                ArrayList<String> parentSegments = new ArrayList<String>();
                for (TreeItem tmpItem = FileChooser.this.selectedTreeItem; tmpItem != null; tmpItem = tmpItem.getParentItem()) {
                    HashMap attributeMap = (HashMap)tmpItem.getUserObject();
                    if (attributeMap.get(FileChooser.ACTUAL_FILE_NAME) == null) continue;
                    parentSegments.add((String)attributeMap.get(FileChooser.ACTUAL_FILE_NAME));
                }
                Collections.reverse(parentSegments);
                String myPath = "";
                int loopCount = FileChooser.this.isFileSelected() ? parentSegments.size() - 2 : parentSegments.size() - 1;
                for (int i = 0; i < loopCount; ++i) {
                    String pathSegment = (String)parentSegments.get(i);
                    myPath = myPath + "/" + pathSegment;
                }
                if (myPath.equals("")) {
                    myPath = "/";
                }
                FileChooser.this.changeToPath(myPath);
            }
        });
        navigationBar.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_LEFT);
        navigationBar.add((Widget)this.navigationListBox);
        if (this.showSearch) {
            navigationBar.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_RIGHT);
            navigationBar.add((Widget)searchImage);
        }
        navigationBar.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_LEFT);
        navigationBar.add((Widget)upDirImage);
        navigationBar.setCellWidth((Widget)upDirImage, "100%");
        DOM.setStyleAttribute((com.google.gwt.user.client.Element)upDirImage.getElement(), (String)"marginLeft", (String)"4px");
        navigationBar.setWidth("100%");
        locationBar.add((Widget)navigationBar);
        locationBar.setWidth("100%");
        Label filenameLabel = new Label(FileChooserEntryPoint.messages.getString("filename"));
        filenameLabel.setWidth("550px");
        this.add((Widget)filenameLabel);
        this.fileNameTextBox.setWidth("300px");
        this.add((Widget)this.fileNameTextBox);
        this.add((Widget)locationBar);
        this.add(this.buildFilesList(this.selectedTreeItem));
    }

    public void findMatchingTreeItems(TreeItem rootItem, TreeItem parentItem, String searchText) {
        searchText = searchText.toLowerCase();
        for (int i = 0; i < parentItem.getChildCount(); ++i) {
            TreeItem childItem = parentItem.getChild(i);
            HashMap attributeMap = (HashMap)childItem.getUserObject();
            boolean isDir = "true".equals(attributeMap.get("isDirectory"));
            String name = ((String)attributeMap.get(ACTUAL_FILE_NAME)).toLowerCase();
            String localizedName = ((String)attributeMap.get(LOCALIZED_FILE_NAME)).toLowerCase();
            if (isDir) {
                this.findMatchingTreeItems(rootItem, childItem, searchText);
            }
            if (name.indexOf(searchText) == -1 && localizedName.indexOf(searchText) == -1) continue;
            TreeItem copyItem = new TreeItem();
            copyItem.setText(childItem.getText());
            copyItem.setTitle(childItem.getTitle());
            attributeMap.put("original", childItem);
            copyItem.setUserObject((Object)attributeMap);
            rootItem.addItem(copyItem);
        }
    }

    public Widget buildFilesList(TreeItem parentTreeItem) {
        boolean isDir;
        HashMap attributeMap;
        TreeItem childItem;
        int i;
        VerticalPanel filesListPanel = new VerticalPanel();
        filesListPanel.setWidth("100%");
        ScrollPanel filesScroller = new ScrollPanel();
        DOM.setStyleAttribute((com.google.gwt.user.client.Element)filesScroller.getElement(), (String)"background", (String)"#ffffff");
        DOM.setStyleAttribute((com.google.gwt.user.client.Element)filesScroller.getElement(), (String)"border", (String)"1px solid #707070");
        FlexTable filesListTable = new FlexTable();
        filesListTable.setWidth("100%");
        filesListTable.setCellSpacing(0);
        Label nameLabel = new Label(FileChooserEntryPoint.messages.getString(ACTUAL_FILE_NAME), false);
        nameLabel.setStyleName("fileChooserHeader");
        Label typeLabel = new Label(FileChooserEntryPoint.messages.getString("type"), false);
        typeLabel.setStyleName("fileChooserHeader");
        Label dateLabel = new Label(FileChooserEntryPoint.messages.getString("dateModified"), false);
        dateLabel.setStyleName("fileChooserHeader");
        ElementUtils.preventTextSelection((Element)nameLabel.getElement());
        ElementUtils.preventTextSelection((Element)typeLabel.getElement());
        ElementUtils.preventTextSelection((Element)dateLabel.getElement());
        filesListTable.setWidget(0, 0, (Widget)nameLabel);
        filesListTable.getCellFormatter().setWidth(0, 0, "100%");
        filesListTable.setWidget(0, 1, (Widget)typeLabel);
        filesListTable.setWidget(0, 2, (Widget)dateLabel);
        int row = 0;
        for (i = 0; i < parentTreeItem.getChildCount(); ++i) {
            childItem = parentTreeItem.getChild(i);
            attributeMap = (HashMap)childItem.getUserObject();
            isDir = "true".equals(attributeMap.get("isDirectory"));
            if (!isDir) continue;
            this.addFileToList(attributeMap, childItem, filesListTable, row++);
        }
        for (i = 0; i < parentTreeItem.getChildCount(); ++i) {
            childItem = parentTreeItem.getChild(i);
            attributeMap = (HashMap)childItem.getUserObject();
            isDir = "true".equals(attributeMap.get("isDirectory"));
            if (isDir) continue;
            this.addFileToList(attributeMap, childItem, filesListTable, row++);
        }
        filesScroller.setWidget((Widget)filesListTable);
        filesScroller.setHeight("220px");
        filesListPanel.add((Widget)filesScroller);
        return filesListPanel;
    }

    private void addFileToList(HashMap<String, String> attributeMap, final TreeItem item, FlexTable filesListTable, int row) {
        Date lastModDate = new Date(Long.parseLong(attributeMap.get("lastModifiedDate")));
        final boolean isDir = "true".equals(attributeMap.get("isDirectory"));
        Label myDateLabel = new Label(this.dateFormat.format(lastModDate), false);
        String finalFileName = this.showLocalizedFileNames ? attributeMap.get(LOCALIZED_FILE_NAME) : attributeMap.get(ACTUAL_FILE_NAME);
        final Label myNameLabel = new Label(finalFileName, false){

            public void onBrowserEvent(Event event) {
                switch (event.getTypeInt()) {
                    case 1: 
                    case 2: {
                        FileChooser.this.handleFileClicked(item, isDir, event, this.getElement());
                        break;
                    }
                    case 16: {
                        this.addStyleDependentName("over");
                        break;
                    }
                    case 32: {
                        this.removeStyleDependentName("over");
                    }
                }
            }
        };
        myNameLabel.getElement().setAttribute("id", "fileChooser_".concat(attributeMap.get(ACTUAL_FILE_NAME)));
        myNameLabel.sinkEvents(3);
        myNameLabel.sinkEvents(48);
        myNameLabel.setTitle(attributeMap.get(LOCALIZED_FILE_NAME));
        myNameLabel.setStyleName("fileChooserCellLabel");
        HorizontalPanel fileNamePanel = new HorizontalPanel();
        Image fileImage = new Image(){

            public void onBrowserEvent(Event event) {
                FileChooser.this.handleFileClicked(item, isDir, event, myNameLabel.getElement());
            }
        };
        fileImage.sinkEvents(3);
        if (isDir) {
            FileChooserImages.images.folder().applyTo(fileImage);
        } else {
            String fileName = attributeMap.get(ACTUAL_FILE_NAME);
            if (fileName.endsWith("waqr.xaction")) {
                FileChooserImages.images.file_waqr_report().applyTo(fileImage);
            } else if (fileName.endsWith("analysisview.xaction")) {
                FileChooserImages.images.file_analysis().applyTo(fileImage);
            } else if (fileName.endsWith(".url")) {
                FileChooserImages.images.file_url().applyTo(fileImage);
            } else if (fileName.endsWith("xanalyzer")) {
                FileChooserImages.images.file_analyzer().applyTo(fileImage);
            } else if (fileName.endsWith("prpti")) {
                FileChooserImages.images.file_pir_report().applyTo(fileImage);
            } else if (fileName.endsWith("prpt")) {
                FileChooserImages.images.file_prpt_report().applyTo(fileImage);
            } else if (fileName.endsWith("xdash")) {
                FileChooserImages.images.file_dashboard().applyTo(fileImage);
            } else {
                FileChooserImages.images.file_action().applyTo(fileImage);
            }
        }
        fileNamePanel.add((Widget)fileImage);
        fileNamePanel.add((Widget)myNameLabel);
        DOM.setStyleAttribute((com.google.gwt.user.client.Element)myNameLabel.getElement(), (String)"cursor", (String)"default");
        Label typeLabel = new Label(isDir ? FileChooserEntryPoint.messages.getString("folder") : FileChooserEntryPoint.messages.getString("file"), false);
        ElementUtils.preventTextSelection((Element)myNameLabel.getElement());
        ElementUtils.preventTextSelection((Element)typeLabel.getElement());
        ElementUtils.preventTextSelection((Element)myDateLabel.getElement());
        fileNamePanel.setStyleName("fileChooserCell");
        typeLabel.setStyleName("fileChooserCell");
        myDateLabel.setStyleName("fileChooserCell");
        filesListTable.setWidget(row + 1, 0, (Widget)fileNamePanel);
        filesListTable.setWidget(row + 1, 1, (Widget)typeLabel);
        filesListTable.setWidget(row + 1, 2, (Widget)myDateLabel);
    }

    private void handleFileClicked(TreeItem item, boolean isDir, Event event, com.google.gwt.user.client.Element sourceElement) {
        boolean eventWeCareAbout = false;
        if ((DOM.eventGetType((Event)event) & 2) == 2) {
            eventWeCareAbout = true;
        } else if ((DOM.eventGetType((Event)event) & 1) == 1) {
            eventWeCareAbout = true;
        }
        if (eventWeCareAbout) {
            HashMap tmpAttributeMap;
            TreeItem originalItem;
            this.setFileSelected(true);
            HashMap attributeMap = (HashMap)item.getUserObject();
            TreeItem tmpItem = originalItem = (TreeItem)attributeMap.get("original");
            if (originalItem == null) {
                tmpItem = item;
            }
            this.selectedTreeItem = tmpItem;
            ArrayList<String> parentSegments = new ArrayList<String>();
            while (tmpItem != null) {
                HashMap tmpAttributeMap2 = (HashMap)tmpItem.getUserObject();
                if (tmpAttributeMap2.get(ACTUAL_FILE_NAME) != null) {
                    parentSegments.add((String)tmpAttributeMap2.get(ACTUAL_FILE_NAME));
                }
                tmpItem = tmpItem.getParentItem();
            }
            Collections.reverse(parentSegments);
            String myPath = "";
            int i = 0;
            while (isDir ? i < parentSegments.size() : i < parentSegments.size() - 1) {
                myPath = myPath + "/" + (String)parentSegments.get(i);
                ++i;
            }
            this.setSelectedPath(myPath);
            if (!isDir && (tmpAttributeMap = (HashMap)this.selectedTreeItem.getUserObject()).get(ACTUAL_FILE_NAME) != null) {
                this.fileNameTextBox.setText((String)tmpAttributeMap.get(LOCALIZED_FILE_NAME));
                this.actualFileName = (String)tmpAttributeMap.get(ACTUAL_FILE_NAME);
            }
        }
        if ((DOM.eventGetType((Event)event) & 2) == 2) {
            if (isDir) {
                this.initUI(false);
            } else {
                this.fireFileSelected();
            }
        } else if ((DOM.eventGetType((Event)event) & 1) == 1) {
            Element parentRow;
            this.fireFileSelectionChanged();
            if (this.lastSelectedFileElement != null) {
                parentRow = ElementUtils.findElementAboveByTagName((Element)this.lastSelectedFileElement, "table");
                parentRow.getStyle().setProperty("background", "white");
            }
            parentRow = ElementUtils.findElementAboveByTagName((Element)sourceElement, "table");
            parentRow.addClassName("pentaho-file-chooser-selection");
            this.lastSelectedFileElement = sourceElement;
        }
    }

    private void setFileSelected(boolean selected) {
        this.fileSelected = selected;
    }

    public boolean isFileSelected() {
        return this.fileSelected;
    }

    private String getTitle(TreeItem item) {
        ArrayList<String> parentSegments = new ArrayList<String>();
        while (item != null) {
            TreeItem originalItem;
            HashMap tmpAttributeMap = (HashMap)item.getUserObject();
            if (tmpAttributeMap.get(ACTUAL_FILE_NAME) != null) {
                parentSegments.add((String)tmpAttributeMap.get(ACTUAL_FILE_NAME));
            }
            if ((originalItem = (TreeItem)tmpAttributeMap.get("original")) != null) {
                item = originalItem.getParentItem();
                continue;
            }
            item = item.getParentItem();
        }
        Collections.reverse(parentSegments);
        String myPath = "";
        for (int i = 0; i < parentSegments.size(); ++i) {
            String pathSegment = (String)parentSegments.get(i);
            myPath = myPath + "/" + pathSegment;
        }
        if (myPath.equals("")) {
            myPath = "/";
        }
        return myPath;
    }

    public TreeItem getTreeItem(List<String> pathSegments) {
        TreeItem selectedItem = this.repositoryTree.getItem(0);
        for (String segment : pathSegments) {
            for (int i = 0; i < selectedItem.getChildCount(); ++i) {
                TreeItem item = selectedItem.getChild(i);
                HashMap attributeMap = (HashMap)item.getUserObject();
                if (!segment.equals(attributeMap.get(ACTUAL_FILE_NAME))) continue;
                selectedItem = item;
            }
        }
        HashMap attributeMap = (HashMap)selectedItem.getUserObject();
        TreeItem originalItem = (TreeItem)attributeMap.get("original");
        if (originalItem != null) {
            selectedItem = originalItem;
        }
        return selectedItem;
    }

    public FileChooserMode getMode() {
        return this.mode;
    }

    public void setMode(FileChooserMode mode) {
        this.mode = mode;
    }

    public String getSelectedPath() {
        return this.selectedPath;
    }

    public void setSelectedPath(String selectedPath) {
        this.selectedPath = selectedPath;
    }

    public void setSolutionRepositoryDocument(Document doc) {
        this.solutionRepositoryDocument = doc;
        this.repositoryTree = TreeBuilder.buildSolutionTree(this.solutionRepositoryDocument, this.showHiddenFiles, this.showLocalizedFileNames, this.fileFilter);
        this.initUI(false);
    }

    public void fireFileSelected() {
        for (FileChooserListener listener : this.listeners) {
            listener.fileSelected(this.getSolution(), this.getPath(), this.getActualFileName(), this.getLocalizedFileName());
        }
    }

    public void fireFileSelectionChanged() {
        for (FileChooserListener listener : this.listeners) {
            listener.fileSelectionChanged(this.getSolution(), this.getPath(), this.getActualFileName());
        }
    }

    public String getSolution() {
        if (this.getSelectedPath() == null) {
            return null;
        }
        if (this.getSelectedPath().indexOf("/", 1) == -1) {
            return this.getSelectedPath().substring(1);
        }
        return this.getSelectedPath().substring(1, this.getSelectedPath().indexOf("/", 1));
    }

    public String getPath() {
        int startIdx = this.getSelectedPath().indexOf("/", 1);
        if (-1 == startIdx) {
            return "";
        }
        return "/" + this.getSelectedPath().substring(startIdx + 1);
    }

    public String getActualFileName() {
        return this.actualFileName;
    }

    public String getLocalizedFileName() {
        return this.fileNameTextBox.getText();
    }

    public String getFullPath() {
        String name = this.getActualFileName();
        if (!"".equals(name)) {
            name = "/" + name;
        }
        return this.getSolution() + this.getPath() + name;
    }

    public void addFileChooserListener(FileChooserListener listener) {
        this.listeners.add(listener);
    }

    public void removeFileChooserListener(FileChooserListener listener) {
        this.listeners.remove(listener);
    }

    public FileFilter getFileFilter() {
        return this.fileFilter;
    }

    public void setFileFilter(FileFilter fileFilter) {
        this.fileFilter = fileFilter;
        this.repositoryTree = TreeBuilder.buildSolutionTree(this.solutionRepositoryDocument, this.showHiddenFiles, this.showLocalizedFileNames, fileFilter);
        this.initUI(false);
    }

    private List<String> buildPathSegments(String path) {
        ArrayList<String> pathSegments = new ArrayList<String>();
        if (path != null) {
            int index = path.indexOf("/", 0);
            while (index >= 0) {
                int oldIndex = index;
                if ((index = path.indexOf("/", oldIndex + 1)) < 0) continue;
                pathSegments.add(path.substring(oldIndex + 1, index));
            }
            pathSegments.add(path.substring(path.lastIndexOf("/") + 1));
        }
        return pathSegments;
    }

    public List<String> getFilesInPath(String path) {
        List<String> pathSegments = this.buildPathSegments(path);
        ArrayList<String> fileNames = new ArrayList<String>();
        TreeItem treeItem = this.getTreeItem(pathSegments);
        if (treeItem != null) {
            for (int i = 0; i < treeItem.getChildCount(); ++i) {
                HashMap attributeMap = (HashMap)treeItem.getChild(i).getUserObject();
                boolean isDir = "true".equals(attributeMap.get("isDirectory"));
                if (isDir) continue;
                fileNames.add((String)attributeMap.get(ACTUAL_FILE_NAME));
            }
        }
        return fileNames;
    }

    public boolean doesSelectedFileExist() {
        return this.doesFileExist("/" + this.getFullPath());
    }

    public boolean doesFileExist(String path) {
        HashMap attributeMap;
        List<String> pathSegments = this.buildPathSegments(path);
        String name = pathSegments.get(pathSegments.size() - 1);
        TreeItem treeItem = this.getTreeItem(pathSegments);
        return treeItem != null && name.equals((attributeMap = (HashMap)treeItem.getUserObject()).get(ACTUAL_FILE_NAME));
    }

    public void setShowLocalizedFileNames(boolean showLocalizedFileNames) {
        this.showLocalizedFileNames = showLocalizedFileNames;
        this.initUI(false);
    }

    public void changeToPath(String path) {
        this.setSelectedPath(path);
        this.initUI(false);
        this.fireFileSelectionChanged();
    }

    public boolean isShowSearch() {
        return this.showSearch;
    }

    public void setShowSearch(boolean showSearch) {
        this.showSearch = showSearch;
        this.initUI(false);
    }

    public void setSubmitOnEnter(boolean submitOnEnter) {
        this.submitOnEnter = submitOnEnter;
    }

    public boolean isSubmitOnEnter() {
        return this.submitOnEnter;
    }

    public native boolean isMobileSafari();

    public native String getWebAppRoot();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FileChooserMode {
        OPEN,
        OPEN_READ_ONLY,
        SAVE;

    }
}

