/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.gwt.widgets.client.filechooser;

import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.xml.client.Document;
import java.util.ArrayList;
import java.util.List;
import org.pentaho.gwt.widgets.client.dialogs.GlassPane;
import org.pentaho.gwt.widgets.client.dialogs.IDialogCallback;
import org.pentaho.gwt.widgets.client.dialogs.IDialogValidatorCallback;
import org.pentaho.gwt.widgets.client.dialogs.MessageDialogBox;
import org.pentaho.gwt.widgets.client.dialogs.PromptDialogBox;
import org.pentaho.gwt.widgets.client.filechooser.FileChooser;
import org.pentaho.gwt.widgets.client.filechooser.FileChooserEntryPoint;
import org.pentaho.gwt.widgets.client.filechooser.FileChooserListener;
import org.pentaho.gwt.widgets.client.filechooser.FileFilter;
import org.pentaho.gwt.widgets.client.filechooser.TreeBuilder;
import org.pentaho.gwt.widgets.client.utils.string.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileChooserDialog
extends PromptDialogBox
implements FileChooserListener {
    private static final String ILLEGAL_NAME_CHARS = "\\'/?%*:|\"<>&";
    private ArrayList<FileChooserListener> listeners = new ArrayList();
    private FileChooser fileChooser;
    private FileFilter filter;
    private boolean submitOnEnter = true;

    public FileChooserDialog(FileChooser.FileChooserMode mode, String selectedPath, boolean autoHide, boolean modal) {
        this(mode, selectedPath, autoHide, modal, mode == FileChooser.FileChooserMode.OPEN ? FileChooserEntryPoint.messages.getString("Open") : FileChooserEntryPoint.messages.getString("Save"), mode == FileChooser.FileChooserMode.OPEN ? FileChooserEntryPoint.messages.getString("Open") : FileChooserEntryPoint.messages.getString("Save"));
    }

    public FileChooserDialog(FileChooser.FileChooserMode mode, String selectedPath, boolean autoHide, boolean modal, String title, String okText) {
        super(title, okText, FileChooserEntryPoint.messages.getString("Cancel"), false, true);
        this.fileChooser = new FileChooser(mode, selectedPath, new IDialogCallback(){

            public void cancelPressed() {
            }

            public void okPressed() {
                FileChooserDialog.this.center();
            }
        });
        this.setContent((Widget)this.fileChooser);
        this.fileChooser.setWidth("100%");
        this.setValidatorCallback(new IDialogValidatorCallback(){

            public boolean validate() {
                return FileChooserDialog.this.isFileNameValid();
            }
        });
        IDialogCallback callback = new IDialogCallback(){

            public void cancelPressed() {
                for (FileChooserListener listener : FileChooserDialog.this.listeners) {
                    listener.dialogCanceled();
                }
            }

            public void okPressed() {
                FileChooserDialog.this.fileChooser.fireFileSelected();
            }
        };
        this.setCallback(callback);
        this.fileChooser.addFileChooserListener(this);
    }

    public FileChooserDialog(FileChooser.FileChooserMode mode, String selectedPath, Document repositoryDocument, boolean autoHide, boolean modal, String title, String okText) {
        super(title, okText, FileChooserEntryPoint.messages.getString("Cancel"), false, true);
        this.fileChooser = new FileChooser();
        this.setContent((Widget)this.fileChooser);
        this.fileChooser.setWidth("100%");
        this.fileChooser.setMode(mode);
        this.fileChooser.setSelectedPath(selectedPath);
        this.fileChooser.solutionRepositoryDocument = repositoryDocument;
        this.fileChooser.repositoryTree = TreeBuilder.buildSolutionTree(repositoryDocument, this.fileChooser.showHiddenFiles, this.fileChooser.showLocalizedFileNames, this.filter);
        this.setValidatorCallback(new IDialogValidatorCallback(){

            public boolean validate() {
                return FileChooserDialog.this.isFileNameValid();
            }
        });
        IDialogCallback callback = new IDialogCallback(){

            public void cancelPressed() {
                for (FileChooserListener listener : FileChooserDialog.this.listeners) {
                    listener.dialogCanceled();
                }
            }

            public void okPressed() {
                FileChooserDialog.this.fileChooser.fireFileSelected();
            }
        };
        this.setCallback(callback);
        this.fileChooser.addFileChooserListener(this);
        this.fileChooser.initUI(false);
    }

    public FileChooserDialog(FileChooser.FileChooserMode mode, String selectedPath, Document repositoryDocument, boolean autoHide, boolean modal) {
        this(mode, selectedPath, repositoryDocument, autoHide, modal, mode == FileChooser.FileChooserMode.OPEN ? FileChooserEntryPoint.messages.getString("Open") : FileChooserEntryPoint.messages.getString("Save"), mode == FileChooser.FileChooserMode.OPEN ? FileChooserEntryPoint.messages.getString("Open") : FileChooserEntryPoint.messages.getString("Save"));
    }

    public void addFileChooserListener(FileChooserListener listener) {
        this.listeners.add(listener);
    }

    public void removeFileChooserListener(FileChooserListener listener) {
        if (this.listeners.contains(listener)) {
            this.listeners.remove(listener);
        }
    }

    public void setShowSearch(boolean showSearch) {
        this.fileChooser.setShowSearch(showSearch);
    }

    public boolean isShowSearch() {
        return this.fileChooser.isShowSearch();
    }

    public List<String> getFilesInPath(String path) {
        return this.fileChooser.getFilesInPath(path);
    }

    public boolean doesSelectedFileExist() {
        return this.fileChooser.doesSelectedFileExist();
    }

    public boolean doesFileExist(String path) {
        return this.fileChooser.doesFileExist(path);
    }

    public FileFilter getFileFilter() {
        return this.filter;
    }

    public void setFileFilter(FileFilter filter) {
        this.filter = filter;
        this.fileChooser.setFileFilter(filter);
    }

    private String getActualFileName() {
        String actualFileName = this.fileChooser.getActualFileName();
        if (actualFileName != null && !"".equals(actualFileName)) {
            return actualFileName;
        }
        return "";
    }

    private boolean isFileNameValid() {
        String solution = this.fileChooser.getSolution();
        if (solution == null || solution.trim().length() == 0) {
            MessageDialogBox dialogBox = new MessageDialogBox(FileChooserEntryPoint.messages.getString("error"), FileChooserEntryPoint.messages.getString("noSolutionSelected"), false, false, true);
            dialogBox.center();
            return false;
        }
        String fileName = this.getActualFileName();
        if (StringUtils.isEmpty(fileName)) {
            MessageDialogBox dialogBox = new MessageDialogBox(FileChooserEntryPoint.messages.getString("error"), FileChooserEntryPoint.messages.getString("noFilenameEntered"), false, false, true);
            dialogBox.center();
            return false;
        }
        if (StringUtils.containsAnyChars(fileName, ILLEGAL_NAME_CHARS)) {
            MessageDialogBox dialogBox = new MessageDialogBox(FileChooserEntryPoint.messages.getString("error"), FileChooserEntryPoint.messages.getString("invalidFilename"), false, false, true);
            dialogBox.center();
            return false;
        }
        return true;
    }

    @Override
    public void fileSelected(String solution, String path, String name, String localizedFileName) {
        if (this.isFileNameValid()) {
            for (FileChooserListener listener : this.listeners) {
                listener.fileSelected(solution, path, name, localizedFileName);
            }
            this.hide();
        }
    }

    @Override
    public void fileSelectionChanged(String solution, String path, String name) {
        for (FileChooserListener listener : this.listeners) {
            listener.fileSelectionChanged(solution, path, name);
        }
    }

    @Override
    public void dialogCanceled() {
        for (FileChooserListener listener : this.listeners) {
            listener.dialogCanceled();
        }
    }

    public void hide() {
        GlassPane.getInstance().hide();
        super.hide();
    }

    @Override
    public void center() {
        GlassPane.getInstance().show();
        super.center();
        this.setFocus();
    }

    private void setFocus() {
        this.fileChooser.fileNameTextBox.setFocus(true);
    }

    public boolean isSubmitOnEnter() {
        return this.submitOnEnter;
    }

    public void setSubmitOnEnter(boolean submitOnEnter) {
        this.submitOnEnter = submitOnEnter;
        this.fileChooser.setSubmitOnEnter(submitOnEnter);
    }

    @Override
    public boolean onKeyDownPreview(char key, int modifiers) {
        switch (key) {
            case '\r': {
                if (!this.isSubmitOnEnter()) break;
                this.onOk();
                break;
            }
            case '\u001b': {
                this.onCancel();
            }
        }
        return true;
    }
}

