/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.gwt.widgets.client.filechooser;

import com.google.gwt.user.client.ui.Tree;
import com.google.gwt.user.client.ui.TreeItem;
import com.google.gwt.xml.client.Document;
import com.google.gwt.xml.client.Element;
import com.google.gwt.xml.client.NodeList;
import java.util.ArrayList;
import java.util.HashMap;
import org.pentaho.gwt.widgets.client.filechooser.FileFilter;

public class TreeBuilder {
    public static Tree buildSolutionTree(Document doc, boolean showHiddenFiles, boolean showLocalizedFileNames, FileFilter filter) {
        Tree repositoryTree = new Tree();
        Element solutionRoot = doc.getDocumentElement();
        TreeItem rootItem = new TreeItem();
        rootItem.setText(solutionRoot.getAttribute("path"));
        HashMap<String, String> attributeMap = new HashMap<String, String>();
        attributeMap.put("path", solutionRoot.getAttribute("path"));
        rootItem.setUserObject(attributeMap);
        repositoryTree.addItem(rootItem);
        if (filter == null) {
            filter = new DefaultFileFilter();
        }
        TreeBuilder.buildSolutionTree(rootItem, solutionRoot, showHiddenFiles, showLocalizedFileNames, filter);
        return repositoryTree;
    }

    private static void buildSolutionTree(TreeItem parentTreeItem, Element parentElement, boolean showHiddenFiles, boolean showLocalizedFileNames, FileFilter filter) {
        NodeList children = parentElement.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            String fileName;
            Element childElement = (Element)children.item(i);
            boolean isVisible = "true".equals(childElement.getAttribute("visible"));
            boolean isDirectory = "true".equals(childElement.getAttribute("isDirectory"));
            if (!isVisible && !showHiddenFiles || !filter.accept(fileName = childElement.getAttribute("name"), isDirectory, isVisible)) continue;
            String localizedName = childElement.getAttribute("localized-name");
            TreeItem childTreeItem = new TreeItem();
            if (showLocalizedFileNames) {
                childTreeItem.setText(localizedName);
                childTreeItem.setTitle(fileName);
            } else {
                childTreeItem.setText(fileName);
                childTreeItem.setTitle(localizedName);
            }
            HashMap<String, String> attributeMap = new HashMap<String, String>();
            attributeMap.put("name", fileName);
            attributeMap.put("localized-name", childElement.getAttribute("localized-name"));
            attributeMap.put("description", childElement.getAttribute("description"));
            attributeMap.put("lastModifiedDate", childElement.getAttribute("lastModifiedDate"));
            attributeMap.put("visible", childElement.getAttribute("visible"));
            attributeMap.put("isDirectory", childElement.getAttribute("isDirectory"));
            childTreeItem.setUserObject(attributeMap);
            if (parentTreeItem.getChildCount() == 0) {
                parentTreeItem.addItem(childTreeItem);
            } else {
                boolean inserted = false;
                for (int j = 0; j < parentTreeItem.getChildCount(); ++j) {
                    TreeItem kid = parentTreeItem.getChild(j);
                    if (showLocalizedFileNames) {
                        if (childTreeItem.getText().compareTo(kid.getText()) > 0) continue;
                        ArrayList<TreeItem> removedItems = new ArrayList<TreeItem>();
                        for (int x = j; x < parentTreeItem.getChildCount(); ++x) {
                            TreeItem removedItem = parentTreeItem.getChild(x);
                            removedItems.add(removedItem);
                        }
                        for (TreeItem removedItem : removedItems) {
                            parentTreeItem.removeItem(removedItem);
                        }
                        parentTreeItem.addItem(childTreeItem);
                        inserted = true;
                        for (TreeItem removedItem : removedItems) {
                            parentTreeItem.addItem(removedItem);
                        }
                        break;
                    }
                    parentTreeItem.addItem(childTreeItem);
                }
                if (!inserted) {
                    parentTreeItem.addItem(childTreeItem);
                }
            }
            if (!isDirectory) continue;
            TreeBuilder.buildSolutionTree(childTreeItem, childElement, showHiddenFiles, showLocalizedFileNames, filter);
        }
    }

    private static class DefaultFileFilter
    implements FileFilter {
        private DefaultFileFilter() {
        }

        public boolean accept(String name, boolean isDirectory, boolean isVisible) {
            return true;
        }
    }
}

