/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.gwt.widgets.client.listbox;

import com.allen_sauer.gwt.dnd.client.DragController;
import com.google.gwt.dom.client.Element;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.ChangeListener;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.FocusListener;
import com.google.gwt.user.client.ui.FocusPanel;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.KeyboardListener;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.MouseListener;
import com.google.gwt.user.client.ui.PopupListener;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.UIObject;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;
import org.pentaho.gwt.widgets.client.listbox.DefaultListItem;
import org.pentaho.gwt.widgets.client.listbox.ListItem;
import org.pentaho.gwt.widgets.client.listbox.ListItemListener;
import org.pentaho.gwt.widgets.client.utils.ElementUtils;
import org.pentaho.gwt.widgets.client.utils.Rectangle;
import org.pentaho.gwt.widgets.client.utils.string.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomListBox
extends HorizontalPanel
implements ChangeListener,
PopupListener,
MouseListener,
FocusListener,
KeyboardListener,
ListItemListener {
    private List<ListItem> items = new ArrayList<ListItem>();
    private int selectedIndex = -1;
    private DropDownArrow arrow = new DropDownArrow();
    private int visible = 1;
    private int maxDropVisible = 15;
    private boolean editable = false;
    private VerticalPanel listPanel = new VerticalPanel();
    private ScrollPanel listScrollPanel = new ScrollPanel();
    private FlexTable dropGrid = new FlexTable();
    private boolean popupShowing = false;
    private DropPopupPanel popup;
    private PopupList popupVbox = new PopupList();
    private FocusPanel fPanel = new FocusPanel();
    private ScrollPanel popupScrollPanel = new ScrollPanel();
    private List<ChangeListener> listeners = new ArrayList<ChangeListener>();
    private final int spacing = 1;
    private int maxHeight;
    private int maxWidth;
    private int averageHeight;
    private String primaryStyleName;
    private String height;
    private String width;
    private String popupHeight;
    private String popupWidth;
    private boolean suppressLayout;
    private boolean enabled = true;
    private String val;
    private Command command;
    private DragController dragController;
    private boolean multiSelect;
    private TextBox editableTextBox;
    private SimplePanel selectedItemWrapper = new SimplePanel();
    private List<ListItem> selectedItems = new ArrayList<ListItem>();
    private int shiftOriginIdx = -1;

    public CustomListBox() {
        this.dropGrid.getColumnFormatter().setWidth(0, "100%");
        this.dropGrid.setWidget(0, 1, (Widget)this.arrow);
        this.dropGrid.getElement().getStyle().setProperty("tableLayout", "fixed");
        this.arrow.getElement().getParentElement().getStyle().setProperty("width", "20px");
        this.dropGrid.setCellPadding(0);
        this.dropGrid.setCellSpacing(1);
        this.updateUI();
        this.listScrollPanel.add((Widget)this.listPanel);
        this.listScrollPanel.setHeight("100%");
        this.listScrollPanel.setWidth("100%");
        this.listScrollPanel.getElement().getStyle().setProperty("overflowX", "hidden");
        this.listPanel.setSpacing(1);
        this.listPanel.setWidth("100%");
        this.fPanel.add((Widget)this.dropGrid);
        this.fPanel.setHeight("100%");
        super.add((Widget)this.fPanel);
        this.popupScrollPanel.add((Widget)this.popupVbox);
        this.popupScrollPanel.getElement().getStyle().setProperty("overflowX", "hidden");
        this.popupVbox.setWidth("100%");
        this.popupVbox.setSpacing(1);
        this.fPanel.addMouseListener((MouseListener)this);
        this.fPanel.addFocusListener((FocusListener)this);
        this.fPanel.addKeyboardListener((KeyboardListener)this);
        this.setStylePrimaryName("custom-list");
        this.setTdStyles(this.getElement());
        this.setTdStyles(this.listPanel.getElement());
        this.editableTextBox = new TextBox(){

            public void onBrowserEvent(Event event) {
                switch (DOM.eventGetType((Event)event)) {
                    case 512: {
                        CustomListBox.this.onChange((Widget)CustomListBox.this.editableTextBox);
                        CustomListBox.this.val = CustomListBox.this.editableTextBox.getText();
                        break;
                    }
                    case 8: {
                        super.onBrowserEvent(event);
                        event.cancelBubble(true);
                    }
                    default: {
                        return;
                    }
                }
            }
        };
        this.editableTextBox.setStylePrimaryName("custom-list-textbox");
    }

    public void setTableLayout(String tableLayout) {
        if (StringUtils.isEmpty(tableLayout)) {
            this.dropGrid.getElement().getStyle().clearProperty("tableLayout");
        } else {
            this.dropGrid.getElement().getStyle().setProperty("tableLayout", tableLayout);
        }
    }

    private native void setTdStyles(com.google.gwt.user.client.Element var1);

    public void remove(ListItem listItem) {
        this.items.remove(listItem);
        this.setSelectedIndex(0);
        if (!this.suppressLayout) {
            this.updateUI();
        }
    }

    public void removeAll() {
        this.items.clear();
        this.selectedIndex = -1;
        this.selectedItems.clear();
        if (!this.suppressLayout) {
            for (ChangeListener l : this.listeners) {
                l.onChange((Widget)this);
            }
        }
        if (!this.suppressLayout) {
            this.updateUI();
        }
    }

    public void clear() {
        this.removeAll();
    }

    public void add(String label) {
        this.addItem(label);
    }

    public void addItem(ListItem item) {
        this.items.add(item);
        item.setListItemListener(this);
        if (this.items.size() == 1 && this.visible == 1) {
            this.setSelectedIndex(0);
        }
        if (!this.suppressLayout) {
            this.updateUI();
        }
        if (this.dragController != null) {
            this.dragController.makeDraggable(item.getWidget());
        }
    }

    public void add(Widget w) {
        this.addItem((ListItem)w);
    }

    public void setSuppressLayout(boolean supress) {
        this.suppressLayout = supress;
        if (!this.suppressLayout) {
            if (this.selectedIndex < 0 && this.items.size() > 0) {
                this.setSelectedIndex(0);
            } else {
                for (ChangeListener l : this.listeners) {
                    l.onChange((Widget)this);
                }
            }
            this.updateUI();
        }
    }

    public void addItem(String label) {
        DefaultListItem item = new DefaultListItem(label);
        this.items.add(item);
        item.setListItemListener(this);
        if (this.items.size() == 1) {
            this.setSelectedIndex(0);
        }
        if (!this.suppressLayout) {
            this.updateUI();
        }
        if (this.dragController != null) {
            this.dragController.makeDraggable(item.getWidget());
        }
    }

    public List<ListItem> getItems() {
        return this.items;
    }

    public void setVisibleRowCount(int visibleCount) {
        int prevCount = this.visible;
        this.visible = visibleCount;
        if (this.visible > 1 && prevCount == 1) {
            this.fPanel.remove((Widget)this.dropGrid);
            this.fPanel.add((Widget)this.listScrollPanel);
        } else if (this.visible == 1 && prevCount > 1) {
            this.fPanel.remove((Widget)this.listScrollPanel);
            this.fPanel.add((Widget)this.dropGrid);
        }
        if (!this.suppressLayout) {
            this.updateUI();
        }
    }

    public int getVisibleRowCount() {
        return this.visible;
    }

    private void updateUI() {
        if (!this.isAttached()) {
            return;
        }
        if (this.visible > 1) {
            this.updateList();
        } else {
            this.updateDropDown();
        }
    }

    public int getMaxDropVisible() {
        return this.maxDropVisible;
    }

    public void setMaxDropVisible(int maxDropVisible) {
        this.maxDropVisible = maxDropVisible;
        if (this.maxHeight > 0) {
            this.popupHeight = this.maxDropVisible * this.maxHeight + "px";
        }
    }

    private void updateSelectedDropWidget() {
        Label selectedWidget = new Label("");
        boolean updateMade = true;
        if (!this.editable) {
            if (this.selectedIndex >= 0) {
                selectedWidget = this.items.get(this.selectedIndex).getWidgetForDropdown();
            } else if (this.items.size() > 0) {
                selectedWidget = this.items.get(0).getWidgetForDropdown();
            }
        } else {
            String previousVal = this.editableTextBox.getText();
            String newVal = "";
            if (this.val != null) {
                newVal = this.val;
            } else if (this.selectedIndex >= 0) {
                newVal = this.items.get(this.selectedIndex).getValue().toString();
            } else if (this.items.size() > 0) {
                newVal = this.items.get(0).getValue().toString();
            }
            if (!previousVal.equals(newVal)) {
                this.editableTextBox.setText(newVal);
            }
            if (previousVal != null && previousVal.equals(newVal)) {
                updateMade = false;
            }
            this.editableTextBox.setWidth("100%");
            this.editableTextBox.sinkEvents(896);
            this.editableTextBox.sinkEvents(124);
            selectedWidget = this.editableTextBox;
        }
        this.setTdStyles(selectedWidget.getElement());
        this.selectedItemWrapper.clear();
        this.selectedItemWrapper.add((Widget)selectedWidget);
        this.dropGrid.setWidget(0, 0, (Widget)this.selectedItemWrapper);
        if (this.editable && updateMade) {
            this.editableTextBox.setFocus(true);
            this.editableTextBox.selectAll();
        }
    }

    private void updateList() {
        this.listPanel.clear();
        this.maxHeight = 0;
        this.maxWidth = 0;
        for (ListItem li : this.items) {
            Widget w = li.getWidget();
            Rectangle rect = ElementUtils.getSize(w.getElement());
            if (this.height == null) {
                this.maxHeight += rect.height;
            }
            this.maxWidth = Math.max(this.maxWidth, rect.width);
            this.listPanel.add(w);
            this.listPanel.setCellWidth(w, "100%");
        }
        if (this.height == null && this.items.size() > 0) {
            this.maxHeight = Math.round(this.maxHeight / this.items.size());
        }
        if (this.height == null) {
            int h = this.visible * (this.maxHeight + 1);
            this.listScrollPanel.setHeight(h + "px");
            this.fPanel.setHeight(h + "px");
        } else {
            this.listScrollPanel.setHeight(this.height);
            this.fPanel.setHeight(this.height);
        }
        if (this.width == null) {
            this.fPanel.setWidth(this.maxWidth + 40 + "px");
        }
    }

    private void updateDropDown() {
        this.updateSelectedDropWidget();
        this.popupVbox.clear();
        this.maxWidth = 0;
        this.averageHeight = 0;
        this.popupHeight = null;
        int totalHeight = 0;
        for (ListItem li : this.items) {
            Widget w = li.getWidget();
            Rectangle rect = ElementUtils.getSize(w.getElement());
            this.maxWidth = Math.max(this.maxWidth, rect.width);
            this.maxHeight = Math.max(this.maxHeight, rect.height);
            totalHeight += rect.height;
            this.popupVbox.add(w);
            this.popupVbox.setCellWidth(w, "100%");
        }
        if (this.items.size() > 0) {
            this.averageHeight = Math.round(totalHeight / this.items.size());
        }
        if (this.width == null) {
            this.dropGrid.setWidth(this.maxWidth + 60 + "px");
            this.popupWidth = this.maxWidth + 60 + "px";
        } else if (this.width.equals("100%")) {
            this.dropGrid.setWidth("100%");
            this.popupWidth = this.maxWidth + 4 + this.maxHeight + "px";
        } else {
            this.dropGrid.setWidth("100%");
            int w = -1;
            if (this.width.indexOf("px") > 0) {
                w = Integer.parseInt(this.width.replace("px", ""));
            } else if (this.width.indexOf("%") > 0) {
                w = Integer.parseInt(this.width.replace("%", ""));
            }
            this.selectedItemWrapper.setWidth(w - (this.averageHeight + this.spacing * 6) + "px");
        }
        this.popupHeight = this.maxDropVisible > 0 && this.items.size() > this.maxDropVisible ? Math.min(this.maxDropVisible, this.items.size()) * (this.averageHeight + this.spacing * 2) + "px" : null;
    }

    private void togglePopup() {
        if (!this.popupShowing) {
            if (this.popup == null) {
                this.popup = new DropPopupPanel();
                this.popup.addPopupListener(this);
                this.popup.add((Widget)this.popupScrollPanel);
            }
            int x = this.getElement().getAbsoluteLeft();
            int y = this.getElement().getAbsoluteTop() + this.getElement().getOffsetHeight() + 1;
            int windowH = Window.getClientHeight();
            int windowW = Window.getClientWidth();
            Rectangle popupSize = ElementUtils.getSize(this.popup.getElement());
            if (y + popupSize.height > windowH) {
                y = windowH - popupSize.height;
            }
            if (x + popupSize.width > windowW) {
                x = windowW - popupSize.width;
            }
            this.popup.setPopupPosition(x, y);
            this.popup.show();
            if (this.popupHeight != null) {
                this.popupScrollPanel.getElement().getStyle().setProperty("height", this.popupHeight);
            }
            if (this.popupWidth != null) {
                String w = Math.max(this.getElement().getOffsetWidth() - 2, this.maxWidth + 10) + "px";
                this.popupScrollPanel.getElement().getStyle().setProperty("width", w);
                this.popup.getElement().getStyle().setProperty("width", w);
            }
            this.scrollSelectedItemIntoView();
            this.popupShowing = true;
        } else {
            this.popup.hide();
        }
    }

    private void scrollSelectedItemIntoView() {
        if (this.visible > 1) {
            this.listScrollPanel.ensureVisible((UIObject)this.items.get(this.selectedIndex).getWidget());
            return;
        }
        if ((this.selectedIndex + 1) * this.averageHeight > this.popupScrollPanel.getOffsetHeight() + this.popupScrollPanel.getScrollPosition()) {
            this.popupScrollPanel.setScrollPosition(this.selectedIndex * this.averageHeight - this.popupScrollPanel.getOffsetHeight() + this.averageHeight);
            return;
        }
        if (this.selectedIndex * this.averageHeight < this.popupScrollPanel.getScrollPosition()) {
            this.popupScrollPanel.setScrollPosition(this.selectedIndex * this.averageHeight);
        }
    }

    public void setSelectedItem(ListItem item) {
        if (!this.items.contains(item)) {
            throw new RuntimeException("Item not in collection");
        }
        if (this.selectedIndex > -1) {
            this.items.get(this.selectedIndex).onDeselect();
        }
        if (this.visible == 1 && this.popupShowing) {
            this.togglePopup();
        }
        this.setSelectedIndex(this.items.indexOf(item));
    }

    private void handleSelection(ListItem item, Event evt) {
        if (!(evt.getCtrlKey() || evt.getShiftKey() || evt.getMetaKey())) {
            for (ListItem itm : this.selectedItems) {
                itm.onDeselect();
            }
            if (this.selectedIndex > -1) {
                this.items.get(this.selectedIndex).onDeselect();
            }
            this.selectedItems.clear();
            item.onSelect();
            if (!this.selectedItems.contains(item)) {
                this.selectedItems.add(item);
            }
            int prevIdx = this.selectedIndex;
            this.selectedIndex = this.items.indexOf(item);
            this.scrollSelectedItemIntoView();
        } else if (evt.getShiftKey()) {
            int idxOfNewSelection = this.items.indexOf(item);
            int startIdx = Math.min(this.selectedIndex, idxOfNewSelection);
            int endIndex = Math.max(this.selectedIndex, idxOfNewSelection);
            for (int i = startIdx; i <= endIndex; ++i) {
                if (!this.selectedItems.contains(this.items.get(i))) {
                    this.selectedItems.add(this.items.get(i));
                }
                this.items.get(i).onSelect();
            }
        } else if (evt.getCtrlKey() || evt.getMetaKey()) {
            if (this.selectedItems.remove(item)) {
                item.onDeselect();
            } else {
                item.onSelect();
                if (!this.selectedItems.contains(item)) {
                    this.selectedItems.add(item);
                }
            }
        } else if (!this.selectedItems.contains(item)) {
            this.selectedItems.add(item);
        }
        if (!this.suppressLayout) {
            for (ChangeListener l : this.listeners) {
                l.onChange((Widget)this);
            }
        }
    }

    public void setSelectedIndex(int idx) {
        if (idx > this.items.size()) {
            throw new RuntimeException("Index out of bounds: " + idx);
        }
        if (this.selectedIndex > -1) {
            this.items.get(this.selectedIndex).onDeselect();
        }
        this.selectedItems.clear();
        if (idx >= 0 && this.items.size() > idx) {
            this.selectedItems.add(this.items.get(idx));
        }
        int prevIdx = this.selectedIndex;
        if (idx >= 0) {
            this.selectedIndex = idx;
            this.items.get(idx).onSelect();
            this.val = null;
            if (this.visible == 1 && this.isAttached()) {
                this.scrollSelectedItemIntoView();
            }
            this.updateSelectedDropWidget();
        }
        if (!this.suppressLayout && prevIdx != idx) {
            for (ChangeListener l : this.listeners) {
                l.onChange((Widget)this);
            }
        }
    }

    public void setSelectedIndices(int[] indices) {
        if (!this.multiSelect) {
            if (indices.length > 0) {
                this.setSelectedIndex(indices[0]);
            }
            return;
        }
        for (ListItem item : this.selectedItems) {
            item.onDeselect();
        }
        this.selectedItems.clear();
        for (int i = 0; i < indices.length; ++i) {
            int idx = indices[i];
            if (idx < 0 || idx >= this.items.size()) continue;
            this.items.get(idx).onSelect();
            this.selectedItems.add(this.items.get(idx));
        }
        if (!this.suppressLayout) {
            for (ChangeListener l : this.listeners) {
                l.onChange((Widget)this);
            }
        }
    }

    public void addChangeListener(ChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.listeners.remove(listener);
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public int getSize() {
        return this.items.size();
    }

    public ListItem getSelectedItem() {
        if (this.selectedIndex < 0 || this.selectedIndex > this.items.size()) {
            return null;
        }
        return this.items.get(this.selectedIndex);
    }

    public List<ListItem> getSelectedItems() {
        return new ArrayList<ListItem>(this.selectedItems);
    }

    public int[] getSelectedIndices() {
        int[] selectedIndices = new int[this.selectedItems.size()];
        for (int i = 0; i < this.selectedItems.size(); ++i) {
            selectedIndices[i] = this.items.indexOf(this.selectedItems.get(i));
        }
        return selectedIndices;
    }

    public void setStylePrimaryName(String s) {
        super.setStylePrimaryName(s);
        this.primaryStyleName = s;
        for (ListItem item : this.items) {
            item.setStylePrimaryName(s);
        }
    }

    protected void onAttach() {
        super.onAttach();
        this.updateUI();
    }

    public void setHeight(String s) {
        this.height = s;
        this.fPanel.setHeight(s);
        this.listScrollPanel.setHeight("100%");
        if (this.visible == 1) {
            this.setVisibleRowCount(15);
        }
        super.setHeight(s);
        this.updateUI();
    }

    public void setWidth(String s) {
        this.fPanel.setWidth(s);
        this.listScrollPanel.setWidth("100%");
        this.width = s;
        this.popupWidth = s;
        if (s != null) {
            this.dropGrid.setWidth("100%");
        }
        super.setWidth(s);
        this.updateUI();
    }

    public void onPopupClosed(PopupPanel popupPanel, boolean b) {
        this.popupShowing = false;
    }

    public void onMouseDown(Widget widget, int i, int i1) {
    }

    public void onMouseEnter(Widget widget) {
    }

    public void onMouseLeave(Widget widget) {
    }

    public void onMouseMove(Widget widget, int i, int i1) {
    }

    public void onMouseUp(Widget widget, int i, int i1) {
        if (!this.isEnabled()) {
            return;
        }
        if (this.visible == 1) {
            this.togglePopup();
        }
    }

    public void onFocus(Widget widget) {
        if (!this.isEnabled()) {
            return;
        }
    }

    public void onLostFocus(Widget widget) {
    }

    public void onKeyDown(Widget widget, char c, int i) {
        if (c == '\u0010') {
            this.shiftOriginIdx = this.selectedIndex;
        }
    }

    public void onKeyPress(Widget widget, char c, int i) {
    }

    public void onKeyUp(Widget widget, char c, int i) {
        if (!this.isEnabled()) {
            return;
        }
        if (c == '\u0010') {
            this.shiftOriginIdx = -1;
        }
        boolean fireEvents = false;
        switch (c) {
            case '&': {
                ListItem prevItem;
                ListItem itm;
                if (this.selectedIndex <= 0) break;
                if (this.multiSelect && !Event.getCurrentEvent().getShiftKey()) {
                    for (ListItem itm2 : this.selectedItems) {
                        itm2.onDeselect();
                    }
                    this.selectedItems.clear();
                    itm = this.items.get(this.selectedIndex - 1);
                    --this.selectedIndex;
                    itm.onSelect();
                    if (!this.selectedItems.contains(itm)) {
                        this.selectedItems.add(itm);
                    }
                    fireEvents = true;
                    this.listScrollPanel.ensureVisible((UIObject)itm.getWidget());
                    break;
                }
                if (this.multiSelect && Event.getCurrentEvent().getShiftKey()) {
                    itm = this.items.get(this.selectedIndex - 1);
                    if (!this.selectedItems.contains(itm)) {
                        this.selectedItems.add(itm);
                    }
                    itm.onSelect();
                    this.listScrollPanel.ensureVisible((UIObject)itm.getWidget());
                    prevItem = this.items.get(this.selectedIndex);
                    if (this.selectedIndex != this.shiftOriginIdx && this.shiftOriginIdx < this.selectedIndex && this.selectedItems.contains(prevItem)) {
                        this.selectedItems.remove(prevItem);
                        prevItem.onDeselect();
                    }
                    --this.selectedIndex;
                    fireEvents = true;
                    break;
                }
                this.setSelectedIndex(this.selectedIndex - 1);
                this.scrollSelectedItemIntoView();
                break;
            }
            case '(': {
                ListItem prevItem;
                ListItem itm;
                if (this.selectedIndex >= this.items.size() - 1) break;
                if (this.multiSelect && !Event.getCurrentEvent().getShiftKey()) {
                    for (ListItem itm2 : this.selectedItems) {
                        itm2.onDeselect();
                    }
                    this.selectedItems.clear();
                    itm = this.items.get(this.selectedIndex + 1);
                    ++this.selectedIndex;
                    itm.onSelect();
                    if (!this.selectedItems.contains(itm)) {
                        this.selectedItems.add(itm);
                    }
                    fireEvents = true;
                    this.listScrollPanel.ensureVisible((UIObject)itm.getWidget());
                    break;
                }
                if (this.multiSelect && Event.getCurrentEvent().getShiftKey()) {
                    itm = this.items.get(this.selectedIndex + 1);
                    if (!this.selectedItems.contains(itm)) {
                        this.selectedItems.add(itm);
                    }
                    itm.onSelect();
                    prevItem = this.items.get(this.selectedIndex);
                    if (this.selectedIndex != this.shiftOriginIdx && this.shiftOriginIdx > this.selectedIndex && this.selectedItems.contains(prevItem)) {
                        this.selectedItems.remove(prevItem);
                        prevItem.onDeselect();
                    }
                    this.listScrollPanel.ensureVisible((UIObject)itm.getWidget());
                    ++this.selectedIndex;
                    fireEvents = true;
                    break;
                }
                this.setSelectedIndex(this.selectedIndex + 1);
                this.scrollSelectedItemIntoView();
                break;
            }
            case '\r': 
            case '\u001b': {
                if (!this.popupShowing) break;
                this.togglePopup();
                break;
            }
            case 'A': {
                if (!Event.getCurrentEvent().getCtrlKey()) break;
                for (ListItem item : this.items) {
                    item.onSelect();
                }
                this.selectedItems.clear();
                this.selectedItems.addAll(this.items);
                fireEvents = true;
            }
        }
        if (fireEvents && !this.suppressLayout) {
            for (ChangeListener l : this.listeners) {
                l.onChange((Widget)this);
            }
        }
    }

    public void setCommand(Command command) {
        this.command = command;
    }

    @Override
    public void itemSelected(ListItem listItem, Event event) {
        this.fPanel.setFocus(true);
        if (this.multiSelect) {
            this.handleSelection(listItem, event);
        } else {
            this.setSelectedItem(listItem);
        }
    }

    @Override
    public void doAction(ListItem listItem) {
        if (this.command != null) {
            this.command.execute();
        }
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
        this.updateUI();
    }

    public boolean isEditable() {
        return this.editable;
    }

    public String getValue() {
        if (!this.editable) {
            return null;
        }
        return this.editableTextBox != null ? this.editableTextBox.getText() : null;
    }

    public void setValue(String text) {
        this.val = text;
        if (this.editable) {
            this.editableTextBox.setText(text);
            this.selectedIndex = -1;
            this.onChange((Widget)this.editableTextBox);
        }
    }

    public void onChange(Widget sender) {
        for (ChangeListener l : this.listeners) {
            l.onChange((Widget)this);
        }
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        if (this.editableTextBox != null) {
            this.editableTextBox.setEnabled(enabled);
        }
        this.arrow.setEnabled(enabled);
        this.setStylePrimaryName(this.enabled ? "custom-list" : "custom-list-disabled");
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public Widget createProxy() {
        DefaultListItem item = new DefaultListItem();
        item.setText(this.getSelectedItem().getText());
        return item;
    }

    public void setDragController(DragController controller) {
        this.dragController = controller;
        if (this.items.size() > 0) {
            for (ListItem item : this.items) {
                this.dragController.makeDraggable(item.getWidget());
            }
        }
    }

    public boolean isMultiSelect() {
        return this.multiSelect;
    }

    public void setMultiSelect(boolean multiSelect) {
        this.multiSelect = multiSelect;
    }

    private class DropDownArrow
    extends SimplePanel {
        private SimplePanel img = new SimplePanel();
        private boolean enabled = true;

        public DropDownArrow() {
            this.setStylePrimaryName("combo-arrow");
            super.add((Widget)this.img);
            ElementUtils.preventTextSelection((Element)this.getElement());
        }

        public void setEnabled(boolean enabled) {
            if (this.enabled == enabled) {
                return;
            }
            this.enabled = enabled;
            if (enabled) {
                this.setStylePrimaryName("combo-arrow");
            } else {
                this.setStylePrimaryName("combo-arrow-disabled");
            }
        }
    }

    private class PopupList
    extends VerticalPanel {
        public PopupList() {
            this.sinkEvents(124);
        }

        public void onBrowserEvent(Event event) {
            super.onBrowserEvent(event);
        }
    }

    private class DropPopupPanel
    extends PopupPanel {
        public DropPopupPanel() {
            super(true);
            this.setStyleName("drop-popup");
        }

        public boolean onEventPreview(Event event) {
            if (DOM.isOrHasChild((com.google.gwt.user.client.Element)CustomListBox.this.getElement(), (com.google.gwt.user.client.Element)DOM.eventGetTarget((Event)event))) {
                return true;
            }
            return super.onEventPreview(event);
        }
    }
}

