/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.gwt.widgets.client.listbox;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Element;
import com.google.gwt.event.dom.client.MouseDownEvent;
import com.google.gwt.event.dom.client.MouseDownHandler;
import com.google.gwt.event.dom.client.MouseMoveEvent;
import com.google.gwt.event.dom.client.MouseMoveHandler;
import com.google.gwt.event.dom.client.MouseOutEvent;
import com.google.gwt.event.dom.client.MouseOutHandler;
import com.google.gwt.event.dom.client.MouseOverEvent;
import com.google.gwt.event.dom.client.MouseOverHandler;
import com.google.gwt.event.dom.client.MouseUpEvent;
import com.google.gwt.event.dom.client.MouseUpHandler;
import com.google.gwt.event.dom.client.MouseWheelEvent;
import com.google.gwt.event.dom.client.MouseWheelHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import org.pentaho.gwt.widgets.client.listbox.ListItem;
import org.pentaho.gwt.widgets.client.listbox.ListItemListener;
import org.pentaho.gwt.widgets.client.utils.ElementUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultListItem
extends HorizontalPanel
implements ListItem<Object> {
    private static final String DROP_INVALID_PNG = "drop_invalid.png";
    private static final String DROP_VALID_PNG = "drop_valid.png";
    private String text = "";
    private Widget widget;
    private Widget dropWidget;
    private Image img;
    private Widget extraWidget;
    private String baseStyleName = "custom-list";
    private Object value;
    private ListItemListener listItemListener;
    private String styleName = "custom-list";
    private Object backingObject;
    private Image dragIndicator;

    public DefaultListItem() {
        this.init();
    }

    public DefaultListItem(String str) {
        this.text = str;
        this.value = this.text;
        this.init();
    }

    private void init() {
        this.createWidgets();
        this.sinkEvents(124);
        this.setStylePrimaryName(this.styleName);
    }

    public DefaultListItem(String str, Image img) {
        this.text = str;
        this.value = this.text;
        this.img = img;
        this.createWidgets();
        this.setStylePrimaryName(this.styleName);
    }

    public DefaultListItem(String str, Widget widget) {
        this.text = str;
        this.extraWidget = widget;
        this.createWidgets();
        this.setStylePrimaryName(this.styleName);
    }

    @Override
    public void setStylePrimaryName(String style) {
        this.baseStyleName = style;
        this.dropWidget.setStylePrimaryName(style + "-item");
        super.setStylePrimaryName(style + "-item");
    }

    private void createWidgets() {
        this.formatWidget(this);
        this.widget = this;
        HorizontalPanel hbox = new HorizontalPanel();
        hbox.setStylePrimaryName(this.baseStyleName + "-item");
        this.formatWidget(hbox);
        this.dropWidget = hbox;
    }

    private void formatWidget(HorizontalPanel panel) {
        panel.sinkEvents(124);
        if (this.img != null) {
            Image i = new Image(this.img.getUrl(), this.img.getOriginLeft(), this.img.getOriginTop(), this.img.getWidth(), this.img.getHeight());
            panel.add((Widget)i);
            panel.setCellVerticalAlignment((Widget)i, HasVerticalAlignment.ALIGN_MIDDLE);
            i.getElement().getStyle().setProperty("marginRight", "5px");
        } else if (this.extraWidget != null) {
            com.google.gwt.user.client.Element ele = DOM.clone((com.google.gwt.user.client.Element)this.extraWidget.getElement(), (boolean)true);
            WrapperWidget w = new WrapperWidget(ele);
            panel.add((Widget)w);
            panel.setCellVerticalAlignment((Widget)w, HasVerticalAlignment.ALIGN_MIDDLE);
            w.getElement().getStyle().setProperty("marginRight", "5px");
        }
        Label label = new Label(this.text);
        label.getElement().getStyle().setProperty("cursor", "pointer");
        label.setWidth("100%");
        SimplePanel sp = new SimplePanel();
        sp.getElement().getStyle().setProperty("overflowX", "auto");
        sp.add((Widget)label);
        panel.add((Widget)sp);
        panel.setCellWidth((Widget)sp, "100%");
        panel.setCellVerticalAlignment((Widget)label, HasVerticalAlignment.ALIGN_MIDDLE);
        ElementUtils.preventTextSelection((Element)panel.getElement());
        panel.setWidth("100%");
    }

    public void onBrowserEvent(Event event) {
        int code = event.getTypeInt();
        switch (code) {
            case 16: {
                this.addStyleDependentName("hover");
                break;
            }
            case 32: {
                this.removeStyleDependentName("hover");
                break;
            }
            case 8: {
                this.listItemListener.itemSelected(this, event);
                this.removeStyleDependentName("hover");
            }
            case 2: {
                this.listItemListener.doAction(this);
            }
        }
        super.onBrowserEvent(event);
    }

    @Override
    public Widget getWidgetForDropdown() {
        return this.dropWidget;
    }

    @Override
    public Widget getWidget() {
        return this.widget;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public void setValue(Object o) {
        this.value = o;
    }

    @Override
    public void onHoverEnter() {
    }

    @Override
    public void onHoverExit() {
    }

    @Override
    public void onSelect() {
        try {
            this.widget.addStyleDependentName("selected");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onDeselect() {
        try {
            this.widget.removeStyleDependentName("selected");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    @Override
    public void setListItemListener(ListItemListener listener) {
        this.listItemListener = listener;
    }

    public HandlerRegistration addMouseUpHandler(MouseUpHandler handler) {
        return this.addDomHandler((EventHandler)handler, MouseUpEvent.getType());
    }

    public HandlerRegistration addMouseOutHandler(MouseOutHandler handler) {
        return this.addDomHandler((EventHandler)handler, MouseOutEvent.getType());
    }

    public HandlerRegistration addMouseMoveHandler(MouseMoveHandler handler) {
        return this.addDomHandler((EventHandler)handler, MouseMoveEvent.getType());
    }

    public HandlerRegistration addMouseWheelHandler(MouseWheelHandler handler) {
        return this.addDomHandler((EventHandler)handler, MouseWheelEvent.getType());
    }

    public HandlerRegistration addMouseOverHandler(MouseOverHandler handler) {
        return this.addDomHandler((EventHandler)handler, MouseOverEvent.getType());
    }

    public HandlerRegistration addMouseDownHandler(MouseDownHandler handler) {
        return this.addDomHandler((EventHandler)handler, MouseDownEvent.getType());
    }

    private void makeDraggable() {
        this.clear();
        this.dragIndicator = new Image(GWT.getModuleBaseURL() + DROP_INVALID_PNG);
        this.add((Widget)this.dragIndicator);
        Label label = new Label(this.text);
        this.add((Widget)label);
        this.setCellWidth((Widget)this.dragIndicator, "16px");
        this.setCellVerticalAlignment((Widget)this.dragIndicator, HasVerticalAlignment.ALIGN_MIDDLE);
        this.addStyleDependentName("proxy");
    }

    @Override
    public void setDropValid(boolean valid) {
        if (valid) {
            this.addStyleDependentName("proxy-valid");
            this.dragIndicator.setUrl(GWT.getModuleBaseURL() + DROP_VALID_PNG);
        } else {
            this.removeStyleDependentName("proxy-valid");
            this.dragIndicator.setUrl(GWT.getModuleBaseURL() + DROP_INVALID_PNG);
        }
    }

    @Override
    public Widget makeProxy(Widget ele) {
        DefaultListItem item = new DefaultListItem(this.getText());
        item.setWidth("20px");
        item.makeDraggable();
        this.removeStyleDependentName("hover");
        return item;
    }

    public void setBackingObject(Object backingObject) {
        this.backingObject = backingObject;
    }

    @Override
    public Object getDragObject() {
        return this.backingObject;
    }

    @Override
    public void notifyDragFinished() {
    }

    private static class WrapperWidget
    extends Widget {
        public WrapperWidget(com.google.gwt.user.client.Element ele) {
            this.setElement(ele);
        }
    }
}

