/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.gwt.widgets.client.table;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.DeferredCommand;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.ScrollListener;
import com.google.gwt.user.client.ui.SourcesTableEvents;
import com.google.gwt.user.client.ui.TableListener;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.widgetideas.table.client.FixedWidthFlexTable;
import com.google.gwt.widgetideas.table.client.FixedWidthGrid;
import com.google.gwt.widgetideas.table.client.ScrollTable;
import com.google.gwt.widgetideas.table.client.SelectionGrid;
import com.google.gwt.widgetideas.table.client.SortableGrid;
import com.google.gwt.widgetideas.table.client.SourceTableSelectionEvents;
import com.google.gwt.widgetideas.table.client.TableModel;
import com.google.gwt.widgetideas.table.client.TableSelectionListener;
import com.google.gwt.widgetideas.table.client.overrides.FlexTable;
import com.google.gwt.widgetideas.table.client.overrides.HTMLTable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.pentaho.gwt.widgets.client.i18n.WidgetsLocalizedMessages;
import org.pentaho.gwt.widgets.client.i18n.WidgetsLocalizedMessagesSingleton;
import org.pentaho.gwt.widgets.client.table.BaseTableImages;
import org.pentaho.gwt.widgets.client.table.ColumnComparators;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseTable
extends Composite {
    private static final WidgetsLocalizedMessages MSGS = WidgetsLocalizedMessagesSingleton.getInstance().getMessages();
    public static final ColumnComparators.BaseColumnComparator DEFAULT_COLUMN_COMPARATOR = ColumnComparators.BaseColumnComparator.getInstance(ColumnComparators.ColumnComparatorTypes.STRING_NOCASE);
    private Panel parentPanel = new VerticalPanel();
    private ScrollTable scrollTable;
    private FixedWidthFlexTable tableHeader;
    private FixedWidthGrid dataGrid;
    private String[] tableHeaderNames;
    private String scrollTableWidth;
    private String scrollTableHeight;
    private int[] columnWidths;
    private int numberOfColumns;
    private SelectionGrid.SelectionPolicy selectionPolicy;
    private ColumnComparators.BaseColumnComparator[] columnComparators;
    private final TableListener internalDoubleClickListener = new TableListener(){

        public void onCellClicked(SourcesTableEvents sender, int row, int cell) {
            for (TableListener listener : BaseTable.this.doubleClickListeners) {
                listener.onCellClicked(sender, row, cell);
            }
        }
    };
    private List<TableListener> doubleClickListeners = new ArrayList<TableListener>();
    private final TableListener internalTableListener = new TableListener(){

        public void onCellClicked(SourcesTableEvents sender, int row, int cell) {
            for (TableListener listener : BaseTable.this.tableListeners) {
                listener.onCellClicked(sender, row, cell);
            }
        }
    };
    private List<TableListener> tableListeners = new ArrayList<TableListener>();
    private final TableSelectionListener internalSelectionListener = new TableSelectionListener(){

        public void onRowsSelected(SourceTableSelectionEvents sender, int firstRow, int numRows) {
            for (TableSelectionListener listener : BaseTable.this.tableSelectionListeners) {
                listener.onRowsSelected(sender, firstRow, numRows);
            }
        }

        public void onRowUnhover(SourceTableSelectionEvents sender, int row) {
            for (TableSelectionListener listener : BaseTable.this.tableSelectionListeners) {
                listener.onRowUnhover(sender, row);
            }
        }

        public void onRowHover(SourceTableSelectionEvents sender, int row) {
            for (TableSelectionListener listener : BaseTable.this.tableSelectionListeners) {
                listener.onRowHover(sender, row);
            }
        }

        public void onRowDeselected(SourceTableSelectionEvents sender, int row) {
            for (TableSelectionListener listener : BaseTable.this.tableSelectionListeners) {
                listener.onRowDeselected(sender, row);
            }
        }

        public void onCellUnhover(SourceTableSelectionEvents sender, int row, int cell) {
            for (TableSelectionListener listener : BaseTable.this.tableSelectionListeners) {
                listener.onCellUnhover(sender, row, cell);
            }
        }

        public void onCellHover(SourceTableSelectionEvents sender, int row, int cell) {
            for (TableSelectionListener listener : BaseTable.this.tableSelectionListeners) {
                listener.onCellHover(sender, row, cell);
            }
        }

        public void onAllRowsDeselected(SourceTableSelectionEvents sender) {
            for (TableSelectionListener listener : BaseTable.this.tableSelectionListeners) {
                listener.onAllRowsDeselected(sender);
            }
        }
    };
    private List<TableSelectionListener> tableSelectionListeners = new ArrayList<TableSelectionListener>();
    private boolean scrollingFixInPlace = false;

    public BaseTable(String[] tableHeaderNames, int[] columnWidths) {
        this(tableHeaderNames, columnWidths, null);
    }

    public BaseTable(String[] tableHeaderNames, int[] columnWidths, ColumnComparators.BaseColumnComparator[] columnComparators) {
        this(tableHeaderNames, columnWidths, columnComparators, null);
    }

    public BaseTable(String[] tableHeaderNames, int[] columnWidths, ColumnComparators.BaseColumnComparator[] columnComparators, SelectionGrid.SelectionPolicy selectionPolicy) {
        if (tableHeaderNames != null) {
            this.tableHeaderNames = tableHeaderNames;
            this.columnWidths = columnWidths;
            this.numberOfColumns = tableHeaderNames.length;
            this.parentPanel.setWidth("100%");
            if (selectionPolicy != null) {
                this.selectionPolicy = selectionPolicy;
            }
            if (columnComparators == null) {
                this.columnComparators = new ColumnComparators.BaseColumnComparator[tableHeaderNames.length];
                for (int i = 0; i < this.columnComparators.length; ++i) {
                    this.columnComparators[i] = DEFAULT_COLUMN_COMPARATOR;
                }
            } else {
                this.columnComparators = columnComparators;
            }
            this.createTable(tableHeaderNames, columnWidths, new Object[0][0], ScrollTable.ResizePolicy.FIXED_WIDTH, selectionPolicy);
            this.parentPanel.add((Widget)this.scrollTable);
            this.initWidget((Widget)this.parentPanel);
        } else {
            System.err.println(MSGS.tableHeaderInputError());
        }
    }

    private void createTable(String[] tableHeaderNames, int[] columnWidths, Object[][] rowAndColumnValues) {
        this.createTable(tableHeaderNames, columnWidths, rowAndColumnValues, ScrollTable.ResizePolicy.FIXED_WIDTH, this.selectionPolicy);
    }

    private void createTable(String[] tableHeaderNames, int[] columnWidths, Object[][] rowAndColumnValues, ScrollTable.ResizePolicy resizePolicy, SelectionGrid.SelectionPolicy selectionPolicy) {
        this.createTableHeader(tableHeaderNames, columnWidths);
        this.createDataGrid(selectionPolicy);
        this.createScrollTable(resizePolicy);
        this.populateDataGrid(columnWidths, rowAndColumnValues);
    }

    private void createTableHeader(String[] tableHeaderNames, int[] columnWidths) {
        this.tableHeader = new FixedWidthFlexTable();
        FlexTable.FlexCellFormatter cellFormatter = this.tableHeader.getFlexCellFormatter();
        for (int i = 0; i < tableHeaderNames.length; ++i) {
            this.tableHeader.setHTML(0, i, tableHeaderNames[i]);
            cellFormatter.setHorizontalAlignment(0, i, HasHorizontalAlignment.ALIGN_LEFT);
            cellFormatter.setWordWrap(0, i, false);
        }
        if (this.selectionPolicy == null) {
            this.tableHeader.setStylePrimaryName("disabled");
        }
    }

    private void createDataGrid(SelectionGrid.SelectionPolicy selectionPolicy) {
        this.dataGrid = new FixedWidthGrid(){

            public void onBrowserEvent(Event event) {
                Element td = this.getEventTargetCell(event);
                if (td == null) {
                    return;
                }
                Element tr = DOM.getParent((Element)td);
                Element body = DOM.getParent((Element)tr);
                int row = DOM.getChildIndex((Element)body, (Element)tr) - 1;
                int column = DOM.getChildIndex((Element)tr, (Element)td);
                switch (DOM.eventGetType((Event)event)) {
                    case 2: {
                        BaseTable.this.internalDoubleClickListener.onCellClicked((SourcesTableEvents)BaseTable.this.dataGrid, row, column);
                    }
                }
                super.onBrowserEvent(event);
            }
        };
        this.dataGrid.setWidth("100%");
        if (selectionPolicy == null) {
            this.dataGrid.setSelectionPolicy(SelectionGrid.SelectionPolicy.ONE_ROW);
        } else {
            this.dataGrid.setSelectionPolicy(selectionPolicy);
        }
        this.dataGrid.addTableListener(this.internalTableListener);
        this.dataGrid.addTableSelectionListener(this.internalSelectionListener);
        this.dataGrid.sinkEvents(2);
        this.dataGrid.setColumnSorter((SortableGrid.ColumnSorter)new BaseTableColumnSorter());
        if (this.selectionPolicy == null) {
            this.dataGrid.setStylePrimaryName("disabled");
        }
        DeferredCommand.addCommand((Command)new Command(){

            public void execute() {
                BaseTable.this.internalSelectionListener.onAllRowsDeselected((SourceTableSelectionEvents)BaseTable.this.dataGrid);
            }
        });
    }

    private void createScrollTable(ScrollTable.ResizePolicy resizePolicy) {
        int i;
        this.scrollTable = new ScrollTable(this.dataGrid, this.tableHeader, (BaseTableImages)GWT.create(BaseTableImages.class)){

            protected void resizeTablesVerticallyNow() {
                int totalHeight = DOM.getElementPropertyInt((Element)this.getElement(), (String)"clientHeight");
                if (totalHeight == 0) {
                    return;
                }
                super.resizeTablesVerticallyNow();
            }
        };
        this.scrollTable.addScrollListener(new ScrollListener(){

            public void onScroll(Widget widget, int scrollLeft, int scrollTop) {
                if (!BaseTable.this.scrollingFixInPlace) {
                    BaseTable.this.tableHeader.getElement().getParentElement().setAttribute("id", "tableHeaderWrapper" + Math.round(Math.random() * 10000.0));
                    BaseTable.this.scrollingFixInPlace = true;
                }
            }
        });
        this.scrollTable.setResizePolicy(resizePolicy);
        this.scrollTable.setCellPadding(0);
        this.scrollTable.setCellSpacing(0);
        this.scrollTable.setScrollPolicy(ScrollTable.ScrollPolicy.BOTH);
        if (this.columnComparators != null) {
            for (i = 0; i < this.columnComparators.length; ++i) {
                if (this.columnComparators[i] != null) {
                    this.scrollTable.setColumnSortable(i, true);
                    continue;
                }
                this.scrollTable.setColumnSortable(i, false);
            }
        }
        if (this.scrollTableWidth != null) {
            this.setWidth(this.scrollTableWidth);
        }
        if (this.scrollTableHeight != null) {
            this.setHeight(this.scrollTableHeight);
        }
        if (this.columnWidths != null && this.columnWidths.length > 0) {
            for (i = 0; i < this.columnWidths.length; ++i) {
                if (this.columnWidths[i] <= 0) continue;
                this.scrollTable.setColumnWidth(i, this.columnWidths[i]);
            }
        }
        if (this.scrollTableWidth != null) {
            this.scrollTable.setWidth(this.scrollTableWidth);
        }
        this.scrollingFixInPlace = false;
    }

    private void populateDataGrid(int[] columnWidths, Object[][] rowAndColumnValues) {
        int i;
        while (this.dataGrid.getRowCount() > 0) {
            this.dataGrid.removeRow(0);
        }
        for (i = 0; i < rowAndColumnValues.length; ++i) {
            for (int j = 0; j < rowAndColumnValues[i].length; ++j) {
                Object value = rowAndColumnValues[i][j];
                if (value == null) continue;
                if (value instanceof String) {
                    this.dataGrid.setHTML(i, j, value.toString());
                    continue;
                }
                if (value instanceof Widget) {
                    this.dataGrid.setWidget(i, j, (Widget)value);
                    continue;
                }
                System.err.print(MSGS.invalidDataGridTypeSet());
                Window.alert((String)MSGS.invalidDataGridTypeSet());
                return;
            }
        }
        if (columnWidths != null) {
            for (i = 0; i < columnWidths.length; ++i) {
                if (columnWidths[i] < 0) continue;
                this.dataGrid.setColumnWidth(i, columnWidths[i]);
                this.scrollTable.setColumnWidth(i, columnWidths[i]);
            }
        }
        HTMLTable.CellFormatter cellFormatter = this.dataGrid.getCellFormatter();
        for (int i2 = 0; i2 < rowAndColumnValues.length; ++i2) {
            for (int j = 0; j < rowAndColumnValues[i2].length; ++j) {
                Object value = rowAndColumnValues[i2][j];
                Element element = null;
                try {
                    element = cellFormatter.getElement(i2, j);
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (element == null || value == null || !(value instanceof String) || value.equals("&nbsp;")) continue;
                element.setTitle(value.toString());
            }
        }
        this.scrollTable.redraw();
        DeferredCommand.addCommand((Command)new Command(){

            public void execute() {
                BaseTable.this.internalSelectionListener.onAllRowsDeselected((SourceTableSelectionEvents)BaseTable.this.dataGrid);
            }
        });
    }

    public void fillWidth() {
        this.tableHeader.setWidth("100%");
        this.scrollTable.fillWidth();
    }

    public void noFill() {
        this.scrollTable.addStyleName("table-no-fill");
    }

    @Deprecated
    public void populateTableWithSimpleMessage(String message) {
        this.showMessage(message);
    }

    public void showMessage(String message) {
        this.parentPanel.clear();
        String[] simpleMessageHeaderValues = new String[]{"&nbsp;"};
        Object[][] simpleMessageRowAndColumnValues = new String[][]{{message, "&nbsp;"}};
        this.createTable(simpleMessageHeaderValues, null, simpleMessageRowAndColumnValues, ScrollTable.ResizePolicy.FIXED_WIDTH, this.selectionPolicy);
        this.parentPanel.add((Widget)this.scrollTable);
        this.fillWidth();
    }

    public void populateTable(Object[][] rowAndColumnValues) {
        this.populateDataGrid(this.columnWidths, rowAndColumnValues);
    }

    public void addTableListener(TableListener listener) {
        this.tableListeners.add(listener);
    }

    public void addTableSelectionListener(TableSelectionListener listener) {
        this.tableSelectionListeners.add(listener);
    }

    public void addDoubleClickListener(TableListener listener) {
        this.doubleClickListeners.add(listener);
    }

    public String getText(int row, int column) {
        return this.dataGrid.getText(row, column);
    }

    public int getNumberOfColumns() {
        return this.numberOfColumns;
    }

    public void selectRow(int row) {
        this.dataGrid.selectRow(row, false);
    }

    public Set<Integer> getSelectedRows() {
        return this.dataGrid.getSelectedRows();
    }

    public void deselectRows() {
        this.dataGrid.deselectAllRows();
    }

    public void setWidth(final String width) {
        super.setWidth(width);
        this.scrollTableWidth = width;
        DeferredCommand.addCommand((Command)new Command(){

            public void execute() {
                if (BaseTable.this.scrollTable != null) {
                    BaseTable.this.parentPanel.setWidth(width);
                    BaseTable.this.scrollTable.setWidth(width);
                    BaseTable.this.scrollTable.redraw();
                }
            }
        });
    }

    public void setHeight(final String height) {
        super.setHeight(height);
        this.scrollTableHeight = height;
        DeferredCommand.addCommand((Command)new Command(){

            public void execute() {
                if (BaseTable.this.scrollTable != null) {
                    BaseTable.this.scrollTable.setHeight(height);
                    BaseTable.this.scrollTable.redraw();
                }
            }
        });
    }

    @Deprecated
    public void setTableHeight(String height) {
        this.setHeight(height);
    }

    @Deprecated
    public void setTableWidth(String width) {
        this.setWidth(width);
    }

    public void replaceRow(int row, Object[] data) {
        for (int j = 0; j < data.length; ++j) {
            Object value = data[j];
            if (value == null) continue;
            if (value instanceof String) {
                this.dataGrid.setHTML(row, j, value.toString());
                continue;
            }
            if (value instanceof Widget) {
                this.dataGrid.setWidget(row, j, (Widget)value);
                continue;
            }
            System.err.print(MSGS.invalidDataGridTypeSet());
            Window.alert((String)MSGS.invalidDataGridTypeSet());
            return;
        }
    }

    public void suppressHorizontalScrolling() {
        this.dataGrid.addStyleName("hide-h-scrolling");
    }

    final class BaseTableColumnSorter
    extends SortableGrid.ColumnSorter {
        BaseTableColumnSorter() {
        }

        public void onSortColumn(SortableGrid grid, TableModel.ColumnSortList sortList, SortableGrid.ColumnSorterCallback callback) {
            int column = sortList.getPrimaryColumn();
            boolean ascending = sortList.isPrimaryAscending();
            ArrayList<Element> tdElems = new ArrayList<Element>();
            for (int i = 0; i < grid.getRowCount(); ++i) {
                tdElems.add(grid.getCellFormatter().getElement(i, column));
            }
            if (grid.getColumnCount() > column) {
                Collections.sort(tdElems, BaseTable.this.columnComparators != null && BaseTable.this.columnComparators[column] != null ? BaseTable.this.columnComparators[column] : DEFAULT_COLUMN_COMPARATOR);
            }
            Element[] trElems = new Element[tdElems.size()];
            if (ascending) {
                for (int i = 0; i < tdElems.size(); ++i) {
                    trElems[i] = DOM.getParent((Element)((Element)tdElems.get(i)));
                }
            } else {
                int maxElem = tdElems.size() - 1;
                for (int i = 0; i <= maxElem; ++i) {
                    trElems[i] = DOM.getParent((Element)((Element)tdElems.get(maxElem - i)));
                }
            }
            callback.onSortingComplete(trElems);
        }
    }
}

