/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.gwt.widgets.client.table;

import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import java.util.Comparator;
import java.util.Date;

public interface ColumnComparators {

    public static class StringColumnComparator
    extends BaseColumnComparator {
        private boolean caseSensitive = false;

        public void setCaseSensitive(boolean caseSensitive) {
            this.caseSensitive = caseSensitive;
        }

        public boolean isCaseSensitive() {
            return this.caseSensitive;
        }

        public StringColumnComparator() {
        }

        public StringColumnComparator(boolean caseSensitive) {
            this.setCaseSensitive(caseSensitive);
        }

        public int compare(Element arg0, Element arg1) {
            Element left = this.getLeftObject(arg0, arg1);
            Element right = this.getRightObject(arg0, arg1);
            if (left == null) {
                if (right == null) {
                    return 0;
                }
                return -1;
            }
            String vLeft = DOM.getInnerText((Element)left);
            String vRight = DOM.getInnerText((Element)right);
            if (this.caseSensitive) {
                return vLeft.compareTo(vRight);
            }
            return vLeft.compareToIgnoreCase(vRight);
        }
    }

    public static class DateColumnComparator
    extends BaseColumnComparator {
        public int compare(Element arg0, Element arg1) {
            Element left = this.getLeftObject(arg0, arg1);
            Element right = this.getRightObject(arg0, arg1);
            if (left == null) {
                if (right == null) {
                    return 0;
                }
                return -1;
            }
            Date vLeft = null;
            Date vRight = null;
            try {
                vLeft = new Date(DOM.getInnerText((Element)left));
            }
            catch (Exception ex) {
                return -1;
            }
            try {
                vRight = new Date(DOM.getInnerText((Element)right));
            }
            catch (Exception ex) {
                return 1;
            }
            if (vLeft.before(vRight)) {
                return -1;
            }
            if (vLeft.after(vRight)) {
                return 1;
            }
            return 0;
        }
    }

    public static class NumericColumnComparator
    extends BaseColumnComparator {
        public int compare(Element arg0, Element arg1) {
            Element left = this.getLeftObject(arg0, arg1);
            Element right = this.getRightObject(arg0, arg1);
            if (left == null) {
                if (right == null) {
                    return 0;
                }
                return -1;
            }
            Float vLeft = Float.valueOf(DOM.getInnerText((Element)left));
            Float vRight = Float.valueOf(DOM.getInnerText((Element)right));
            if (vLeft.floatValue() < vRight.floatValue()) {
                return -1;
            }
            if (vLeft.floatValue() > vRight.floatValue()) {
                return 1;
            }
            return 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class BaseColumnComparator
    implements Comparator<Element> {
        protected boolean ascending = true;

        public static BaseColumnComparator getInstance(ColumnComparatorTypes type) {
            switch (type) {
                case NUMERIC: {
                    return new NumericColumnComparator();
                }
                case STRING_NOCASE: {
                    return new StringColumnComparator(false);
                }
                case STRING_CASE: {
                    return new StringColumnComparator(true);
                }
                case DATE: {
                    return new DateColumnComparator();
                }
            }
            return null;
        }

        public boolean isAscending() {
            return this.ascending;
        }

        public void setAscending(boolean ascending) {
            this.ascending = ascending;
        }

        public BaseColumnComparator(boolean ascending) {
            this.ascending = ascending;
        }

        public BaseColumnComparator() {
        }

        protected Element getLeftObject(Element o1, Element o2) {
            return this.ascending ? o1 : o2;
        }

        protected Element getRightObject(Element o1, Element o2) {
            return this.ascending ? o2 : o1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ColumnComparatorTypes {
        NUMERIC,
        DATE,
        STRING_CASE,
        STRING_NOCASE;

    }
}

