/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.gwt.widgets.client.tabs;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.MouseOutEvent;
import com.google.gwt.event.dom.client.MouseOutHandler;
import com.google.gwt.event.dom.client.MouseOverEvent;
import com.google.gwt.event.dom.client.MouseOverHandler;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import org.pentaho.gwt.widgets.client.tabs.PentahoTabImages;
import org.pentaho.gwt.widgets.client.tabs.PentahoTabPanel;

public class PentahoTab
extends SimplePanel {
    private PentahoTabPanel tabPanel;
    private Widget content;
    private Label label = new Label();

    public PentahoTab(String text, String tooltip, PentahoTabPanel tabPanel, Widget content, boolean closeable) {
        this.content = content;
        this.tabPanel = tabPanel;
        this.setStylePrimaryName("pentaho-tabWidget");
        this.sinkEvents(10);
        if (closeable) {
            final Image closeTabImage = PentahoTabImages.images.tab_close_off().createImage();
            closeTabImage.setStyleName("pentaho-tabWidget-close");
            closeTabImage.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    event.getNativeEvent().stopPropagation();
                    PentahoTab.this.closeTab();
                }
            });
            closeTabImage.addMouseOverHandler(new MouseOverHandler(){

                public void onMouseOver(MouseOverEvent event) {
                    PentahoTabImages.images.tab_close_on().applyTo(closeTabImage);
                }
            });
            closeTabImage.addMouseOutHandler(new MouseOutHandler(){

                public void onMouseOut(MouseOutEvent event) {
                    PentahoTabImages.images.tab_close_off().applyTo(closeTabImage);
                }
            });
            HorizontalPanel p = new HorizontalPanel();
            this.setupLabel(text, tooltip);
            p.add((Widget)this.label);
            p.add((Widget)closeTabImage);
            this.setWidget((Widget)p);
        } else {
            this.setupLabel(text, tooltip);
            this.setWidget((Widget)this.label);
        }
    }

    public void setupLabel(String text, String tooltip) {
        this.label.setText(text);
        this.label.setTitle(tooltip);
        this.label.setStylePrimaryName("pentaho-tabWidgetLabel");
    }

    public Widget getContent() {
        return this.content;
    }

    public void setContent(Widget content) {
        this.content = content;
    }

    protected PentahoTabPanel getTabPanel() {
        return this.tabPanel;
    }

    protected void setTabPanel(PentahoTabPanel tabPanel) {
        this.tabPanel = tabPanel;
    }

    public void onBrowserEvent(Event event) {
        if ((DOM.eventGetType((Event)event) & 2) == 2) {
            this.onDoubleClick(event);
        } else if (DOM.eventGetButton((Event)event) == 2) {
            this.onRightClick(event);
        } else if (DOM.eventGetButton((Event)event) == 1 && event.getEventTarget().toString().toLowerCase().indexOf("image") == -1) {
            this.fireTabSelected();
        }
        super.onBrowserEvent(event);
    }

    public void onDoubleClick(Event event) {
    }

    public void onRightClick(Event event) {
    }

    public void setSelected(boolean selected) {
        if (selected) {
            this.addStyleDependentName("selected");
        } else {
            this.removeStyleDependentName("selected");
        }
    }

    public String getLabelText() {
        return this.label.getText();
    }

    public void setLabelText(String text) {
        this.label.setText(text);
    }

    public void setLabelTooltip(String tooltip) {
        this.label.setTitle(tooltip);
    }

    public String getLabelTooltip() {
        return this.label.getTitle();
    }

    protected void closeTab() {
        this.tabPanel.closeTab(this, true);
    }

    protected void fireTabSelected() {
        this.tabPanel.selectTab(this);
    }
}

