/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.gwt.widgets.client.tabs;

import com.google.gwt.user.client.ui.DeckPanel;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import org.pentaho.gwt.widgets.client.tabs.PentahoTab;

public class PentahoTabPanel
extends VerticalPanel {
    private FlowPanel tabBar = new FlowPanel();
    private DeckPanel tabDeck = new DeckPanel();
    private PentahoTab selectedTab;

    public PentahoTabPanel() {
        this.setStylePrimaryName("pentaho-tab-panel");
        this.tabBar.setStylePrimaryName("pentaho-tab-bar");
        this.add((Widget)this.tabBar);
        this.add((Widget)this.tabDeck);
        this.tabDeck.getElement().getParentElement().setClassName("pentaho-tab-deck-panel");
    }

    public void addTab(String text, String tooltip, boolean closeable, Widget content) {
        PentahoTab tab = new PentahoTab(text, tooltip, this, content, closeable);
        this.tabBar.add((Widget)tab);
        this.tabDeck.add(content);
        if (this.selectedTab == null) {
            this.selectTab(tab);
        }
    }

    public void closeTab(int index, boolean invokePreTabCloseHook) {
        this.closeTab((PentahoTab)this.tabBar.getWidget(index), invokePreTabCloseHook);
    }

    public void closeTab(PentahoTab closeTab, boolean invokePreTabCloseHook) {
        int index = this.tabBar.getWidgetIndex((Widget)closeTab);
        this.tabBar.remove((Widget)closeTab);
        this.tabDeck.remove(closeTab.getContent());
        if (this.tabBar.getWidgetIndex((Widget)this.selectedTab) != -1) {
            return;
        }
        if (this.tabBar.getWidgetCount() > 0 && index < this.tabBar.getWidgetCount()) {
            this.selectTab((PentahoTab)this.tabBar.getWidget(index));
        } else if (this.tabBar.getWidgetCount() > 0 && index >= this.tabBar.getWidgetCount()) {
            this.selectTab((PentahoTab)this.tabBar.getWidget(this.tabBar.getWidgetCount() - 1));
        }
    }

    public void closeOtherTabs(PentahoTab exceptThisTab) {
        while (exceptThisTab != this.getTab(0)) {
            this.closeTab(0, false);
        }
        while (exceptThisTab != this.getTab(this.getTabCount() - 1)) {
            this.closeTab(this.getTabCount() - 1, false);
        }
        this.selectTab(exceptThisTab);
    }

    public void closeAllTabs() {
        while (this.getTab(0) != null) {
            this.closeTab(0, false);
        }
    }

    public void selectTab(PentahoTab selectedTab) {
        this.selectedTab = selectedTab;
        for (int i = 0; i < this.tabBar.getWidgetCount(); ++i) {
            PentahoTab tab = (PentahoTab)this.tabBar.getWidget(i);
            if (tab == selectedTab) {
                tab.setSelected(true);
                this.tabDeck.showWidget(this.tabDeck.getWidgetIndex(tab.getContent()));
                continue;
            }
            tab.setSelected(false);
        }
    }

    public void selectTab(int index) {
        this.selectTab(this.getTab(index));
    }

    public PentahoTab getTab(int index) {
        if (index >= 0 && index < this.tabBar.getWidgetCount()) {
            return (PentahoTab)this.tabBar.getWidget(index);
        }
        return null;
    }

    public int getTabCount() {
        return this.tabBar.getWidgetCount();
    }

    public int getSelectedTabIndex() {
        if (this.selectedTab != null) {
            return this.tabBar.getWidgetIndex((Widget)this.selectedTab);
        }
        return -1;
    }

    protected FlowPanel getTabBar() {
        return this.tabBar;
    }

    protected void setTabBar(FlowPanel tabBar) {
        this.tabBar = tabBar;
    }

    protected DeckPanel getTabDeck() {
        return this.tabDeck;
    }

    protected void setTabDeck(DeckPanel tabDeck) {
        this.tabDeck = tabDeck;
    }

    public PentahoTab getSelectedTab() {
        return this.selectedTab;
    }

    public void setSelectedTab(PentahoTab selectedTab) {
        this.selectedTab = selectedTab;
    }
}

