/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.gwt.widgets.client.toolbar;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;
import org.pentaho.gwt.widgets.client.toolbar.ToolbarButton;
import org.pentaho.gwt.widgets.client.toolbar.ToolbarComboButton;
import org.pentaho.gwt.widgets.client.toolbar.ToolbarGroup;
import org.pentaho.gwt.widgets.client.toolbar.ToolbarPopupListener;
import org.pentaho.gwt.widgets.client.toolbar.ToolbarPopupSource;
import org.pentaho.gwt.widgets.client.utils.string.StringUtils;

public class Toolbar
extends HorizontalPanel
implements ToolbarPopupListener,
ToolbarPopupSource {
    public static final int SEPARATOR = 1;
    public static final int GLUE = 2;
    private HorizontalPanel bar = new HorizontalPanel();
    private List<ToolbarButton> buttons = new ArrayList<ToolbarButton>();
    private List<ToolbarGroup> groups = new ArrayList<ToolbarGroup>();
    private List<ToolbarPopupListener> popupListeners = new ArrayList<ToolbarPopupListener>();

    public Toolbar() {
        this.setStylePrimaryName("toolbar");
        this.setVerticalAlignment(ALIGN_MIDDLE);
        this.bar.setVerticalAlignment(ALIGN_MIDDLE);
        this.bar.setSpacing(1);
        this.bar.setWidth("100%");
        super.add((Widget)this.bar);
        super.setCellWidth((Widget)this.bar, "100%");
        this.setWidth("100%");
    }

    public void add(ToolbarGroup group) {
        if (this.bar.getWidgetCount() > 0 && !(this.bar.getWidget(this.bar.getWidgetCount() - 1) instanceof Image)) {
            this.bar.add((Widget)group.getLeadingSeparator());
            this.bar.setCellVerticalAlignment((Widget)group.getLeadingSeparator(), ALIGN_MIDDLE);
        }
        if (group.getLabel() != null) {
            this.bar.add((Widget)group.getGroupLabel());
            this.bar.setCellVerticalAlignment((Widget)group.getGroupLabel(), ALIGN_MIDDLE);
        }
        for (ToolbarButton btn : group.getButtons()) {
            this.bar.add((Widget)btn.getPushButton());
        }
        this.bar.add((Widget)group.getTrailingSeparator());
        this.bar.setCellVerticalAlignment((Widget)group.getTrailingSeparator(), ALIGN_MIDDLE);
        this.groups.add(group);
    }

    public void add(Label lbl) {
        this.bar.add((Widget)lbl);
    }

    public void add(Panel p) {
        String flex;
        this.bar.add((Widget)p);
        if (p instanceof SimplePanel && !StringUtils.isEmpty(flex = p.getElement().getAttribute("flex")) && Integer.parseInt(flex) > 0) {
            this.bar.setCellWidth((Widget)p, "100%");
        }
    }

    public void add(ToolbarButton button) {
        this.bar.add((Widget)button.getPushButton());
        this.buttons.add(button);
        if (button instanceof ToolbarComboButton) {
            ((ToolbarComboButton)button).addPopupPanelListener(this);
        }
    }

    public void add(int key) {
        switch (key) {
            case 1: {
                Image img = new Image(GWT.getModuleBaseURL() + "images/toolbarDivider.png");
                this.bar.add((Widget)img);
                this.bar.setCellVerticalAlignment((Widget)img, ALIGN_MIDDLE);
                break;
            }
            case 2: {
                SimplePanel panel = new SimplePanel();
                this.bar.add((Widget)panel);
                this.bar.setCellWidth((Widget)panel, "100%");
                break;
            }
        }
    }

    public void addSpacer(int spacerAmount) {
        SimplePanel panel = new SimplePanel();
        panel.setWidth(spacerAmount + "px");
        this.bar.add((Widget)panel);
        this.bar.setCellWidth((Widget)panel, spacerAmount + "px");
    }

    public void setEnabled(boolean enabled) {
        try {
            for (ToolbarButton button : this.buttons) {
                button.setEnabled(enabled);
                button.setTempDisabled(!enabled);
            }
            for (ToolbarGroup gp : this.groups) {
                gp.setEnabled(enabled);
                gp.setTempDisabled(!enabled);
            }
        }
        catch (Exception e) {
            System.out.println("Error with Disable: " + e);
            e.printStackTrace(System.out);
        }
    }

    public void addPopupPanelListener(ToolbarPopupListener listener) {
        if (!this.popupListeners.contains(listener)) {
            this.popupListeners.add(listener);
        }
    }

    public void removePopupPanelListener(ToolbarPopupListener listener) {
        if (this.popupListeners.contains(listener)) {
            this.popupListeners.remove(listener);
        }
    }

    public void popupClosed(PopupPanel panel) {
        for (ToolbarPopupListener listener : this.popupListeners) {
            listener.popupClosed(panel);
        }
    }

    public void popupOpened(PopupPanel panel) {
        for (ToolbarPopupListener listener : this.popupListeners) {
            listener.popupOpened(panel);
        }
    }

    public void removeAll() {
        this.bar.clear();
        this.buttons.clear();
    }
}

