/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.gwt.widgets.client.toolbar;

import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.DockPanel;
import com.google.gwt.user.client.ui.FocusPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.MouseListener;
import com.google.gwt.user.client.ui.Widget;
import org.pentaho.gwt.widgets.client.text.ToolTip;

public class ToolbarButton {
    protected DockPanel button = new DockPanel();
    protected boolean enabled = true;
    protected boolean visible = true;
    protected String text;
    protected Image image;
    protected Image disabledImage;
    protected Image currentImage;
    protected Label label = new Label();
    protected FocusPanel eventWrapper = new FocusPanel();
    protected String stylePrimaryName = "toolbar-button";
    protected Command command;
    protected String toolTip;
    protected Image downImage;
    protected Image downImageDisabled;

    public ToolbarButton(Image img, String label) {
        this(img);
        this.label.setText(label);
        this.button.add((Widget)this.label, DockPanel.EAST);
    }

    public ToolbarButton(Image img, Image disabledImage, String label) {
        this(img, label);
        this.disabledImage = disabledImage;
    }

    public ToolbarButton(Image img, Image disabledImage) {
        this(img);
        this.disabledImage = disabledImage;
    }

    public ToolbarButton(Image img) {
        this.image = img;
        this.currentImage = img;
        this.button.add((Widget)this.image, DockPanel.CENTER);
        this.button.setCellHorizontalAlignment((Widget)this.image, DockPanel.ALIGN_CENTER);
        this.button.setCellVerticalAlignment((Widget)this.image, DockPanel.ALIGN_MIDDLE);
        this.button.setStyleName(this.stylePrimaryName);
        this.eventWrapper.add((Widget)this.button);
        this.addStyleMouseListener();
    }

    public void setId(String id) {
        if (this.button != null && this.button.getElement() != null) {
            this.button.getElement().setId(id.concat("_btn"));
        }
        if (this.eventWrapper != null && this.eventWrapper.getElement() != null) {
            this.eventWrapper.getElement().setId(id);
        }
    }

    public void setStylePrimaryName(String styleName) {
        this.stylePrimaryName = styleName;
        this.button.setStylePrimaryName(styleName);
    }

    protected void addStyleMouseListener() {
        this.eventWrapper.addClickListener(new ClickListener(){

            public void onClick(Widget sender) {
                if (!ToolbarButton.this.enabled) {
                    return;
                }
                ToolbarButton.this.button.removeStyleName(ToolbarButton.this.stylePrimaryName + "-down");
                ToolbarButton.this.button.removeStyleName(ToolbarButton.this.stylePrimaryName + "-hovering");
                ToolbarButton.this.command.execute();
            }
        });
        this.eventWrapper.addMouseListener(new MouseListener(){

            public void onMouseDown(Widget w, int arg1, int arg2) {
                if (!ToolbarButton.this.enabled) {
                    return;
                }
                ToolbarButton.this.button.addStyleName(ToolbarButton.this.stylePrimaryName + "-down");
            }

            public void onMouseEnter(Widget arg0) {
                if (!ToolbarButton.this.enabled) {
                    return;
                }
                ToolbarButton.this.button.addStyleName(ToolbarButton.this.stylePrimaryName + "-hovering");
            }

            public void onMouseLeave(Widget arg0) {
                if (!ToolbarButton.this.enabled) {
                    return;
                }
                ToolbarButton.this.button.removeStyleName(ToolbarButton.this.stylePrimaryName + "-hovering");
            }

            public void onMouseUp(Widget arg0, int arg1, int arg2) {
                if (!ToolbarButton.this.enabled) {
                    return;
                }
                ToolbarButton.this.button.removeStyleName(ToolbarButton.this.stylePrimaryName + "-down");
                ToolbarButton.this.button.removeStyleName(ToolbarButton.this.stylePrimaryName + "-hovering");
            }

            public void onMouseMove(Widget arg0, int arg1, int arg2) {
            }
        });
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        boolean prevState = this.enabled;
        this.enabled = enabled;
        if (enabled) {
            this.button.removeStyleName(this.stylePrimaryName + "-disabled");
            if (!prevState && this.disabledImage != null) {
                this.button.remove((Widget)this.currentImage);
                this.button.add((Widget)this.calculateApporiateImage(), DockPanel.CENTER);
                this.button.setCellHorizontalAlignment((Widget)this.image, DockPanel.ALIGN_CENTER);
                this.button.setCellVerticalAlignment((Widget)this.image, DockPanel.ALIGN_MIDDLE);
            }
        } else {
            this.button.addStyleName(this.stylePrimaryName + "-disabled");
            if (prevState && this.disabledImage != null) {
                this.button.remove((Widget)this.currentImage);
                this.button.add((Widget)this.calculateApporiateImage(), DockPanel.CENTER);
                this.button.setCellHorizontalAlignment((Widget)this.disabledImage, DockPanel.ALIGN_CENTER);
                this.button.setCellVerticalAlignment((Widget)this.disabledImage, DockPanel.ALIGN_MIDDLE);
            }
        }
    }

    public void setTempDisabled(boolean disable) {
        this.button.setStyleName(this.enabled && !disable ? this.stylePrimaryName : this.stylePrimaryName + "-disabled");
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
        this.button.setVisible(visible);
    }

    public FocusPanel getPushButton() {
        return this.eventWrapper;
    }

    public Image getImage() {
        return this.image;
    }

    public Image getDisabledImage() {
        return this.disabledImage;
    }

    public void setImage(Image img) {
        this.image = img;
        this.button.remove((Widget)this.currentImage);
        Image curImage = this.calculateApporiateImage();
        this.button.add((Widget)curImage, DockPanel.CENTER);
        this.button.setCellHorizontalAlignment((Widget)curImage, DockPanel.ALIGN_CENTER);
        this.button.setCellVerticalAlignment((Widget)curImage, DockPanel.ALIGN_MIDDLE);
    }

    public void setDisabledImage(Image img) {
        if (!this.isEnabled()) {
            this.disabledImage = img;
            this.button.remove((Widget)this.currentImage);
            Image curImage = this.calculateApporiateImage();
            this.button.add((Widget)curImage, DockPanel.CENTER);
            this.button.setCellHorizontalAlignment((Widget)curImage, DockPanel.ALIGN_CENTER);
            this.button.setCellVerticalAlignment((Widget)curImage, DockPanel.ALIGN_MIDDLE);
        }
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
        this.label.setText(text);
    }

    public Command getCommand() {
        return this.command;
    }

    public void setCommand(Command cmd) {
        this.command = cmd;
    }

    public void setToolTip(String toolTip) {
        this.toolTip = toolTip;
        this.eventWrapper.addMouseListener((MouseListener)new ToolTip(toolTip, 1000));
    }

    public String getToolTip() {
        return this.toolTip;
    }

    protected Image calculateApporiateImage() {
        this.currentImage = !this.enabled && this.disabledImage != null ? this.disabledImage : this.image;
        return this.currentImage;
    }

    public Image getDownImage() {
        return this.downImage;
    }

    public void setDownImage(Image downImage) {
        this.downImage = downImage;
    }

    public Image getDownImageDisabled() {
        return this.downImageDisabled;
    }

    public void setDownImageDisabled(Image downImageDisabled) {
        this.downImageDisabled = downImageDisabled;
    }
}

