/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.gwt.widgets.client.toolbar;

import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.MenuBar;
import com.google.gwt.user.client.ui.MouseListener;
import com.google.gwt.user.client.ui.PopupListener;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;
import org.pentaho.gwt.widgets.client.toolbar.ToolbarButton;
import org.pentaho.gwt.widgets.client.toolbar.ToolbarPopupListener;
import org.pentaho.gwt.widgets.client.toolbar.ToolbarPopupSource;

public class ToolbarComboButton
extends ToolbarButton
implements ToolbarPopupSource,
PopupListener {
    private String COMBO_STYLE = "toolbar-combo-button";
    private MenuBar menu;
    PopupPanel popup = new PopupPanel(true){

        public void show() {
            super.show();
            ToolbarComboButton.this.notifyPopupListeners(this, true);
        }
    };
    private List<ToolbarPopupListener> popupListeners = new ArrayList<ToolbarPopupListener>();

    public ToolbarComboButton(Image img, String label) {
        super(img, label);
        this.addDropdownControl();
        super.setStylePrimaryName(this.COMBO_STYLE);
    }

    public ToolbarComboButton(Image img, Image disabledImage, String label) {
        super(img, disabledImage, label);
        this.addDropdownControl();
        super.setStylePrimaryName(this.COMBO_STYLE);
    }

    public ToolbarComboButton(Image img, Image disabledImage) {
        super(img, disabledImage);
        this.addDropdownControl();
        super.setStylePrimaryName(this.COMBO_STYLE);
    }

    public ToolbarComboButton(Image img) {
        super(img);
        this.addDropdownControl();
        super.setStylePrimaryName(this.COMBO_STYLE);
    }

    private void addDropdownControl() {
        this.popup.addPopupListener((PopupListener)this);
    }

    public void setCommand(Command cmd) {
        throw new UnsupportedOperationException("Not implemented in this class");
    }

    protected void addStyleMouseListener() {
        this.eventWrapper.addClickListener(new ClickListener(){

            public void onClick(Widget sender) {
                if (!ToolbarComboButton.this.enabled) {
                    return;
                }
                ToolbarComboButton.this.popup.setPopupPosition(sender.getAbsoluteLeft(), sender.getAbsoluteTop() + sender.getOffsetHeight());
                ToolbarComboButton.this.popup.show();
            }
        });
        this.eventWrapper.addMouseListener(new MouseListener(){

            public void onMouseDown(Widget w, int x, int y) {
            }

            public void onMouseEnter(Widget w) {
                if (!ToolbarComboButton.this.enabled) {
                    return;
                }
                ToolbarComboButton.this.button.addStyleName(ToolbarComboButton.this.stylePrimaryName + "-hovering");
            }

            public void onMouseLeave(Widget w) {
                if (!ToolbarComboButton.this.enabled) {
                    return;
                }
                ToolbarComboButton.this.button.removeStyleName(ToolbarComboButton.this.stylePrimaryName + "-hovering");
            }

            public void onMouseUp(Widget w, int x, int y) {
                if (!ToolbarComboButton.this.enabled) {
                    return;
                }
                ToolbarComboButton.this.popup.setPopupPosition(w.getAbsoluteLeft(), w.getAbsoluteTop() + w.getOffsetHeight());
            }

            public void onMouseMove(Widget w, int x, int y) {
            }
        });
    }

    public void setMenu(MenuBar bar) {
        this.menu = bar;
        this.popup.setWidget((Widget)this.menu);
    }

    public PopupPanel getPopup() {
        return this.popup;
    }

    public void addPopupPanelListener(ToolbarPopupListener listener) {
        if (!this.popupListeners.contains(listener)) {
            this.popupListeners.add(listener);
        }
    }

    public void removePopupPanelListener(ToolbarPopupListener listener) {
        if (this.popupListeners.contains(listener)) {
            this.popupListeners.remove(listener);
        }
    }

    public void notifyPopupListeners(PopupPanel panel, boolean visible) {
        for (ToolbarPopupListener listener : this.popupListeners) {
            if (visible) {
                listener.popupOpened(panel);
                continue;
            }
            listener.popupClosed(panel);
        }
    }

    public void onPopupClosed(PopupPanel sender, boolean autoClosed) {
        this.notifyPopupListeners(sender, false);
    }
}

