/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.gwt.widgets.client.toolbar;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import java.util.ArrayList;
import java.util.List;
import org.pentaho.gwt.widgets.client.toolbar.ToolbarButton;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToolbarGroup {
    private List<ToolbarButton> buttons = new ArrayList<ToolbarButton>();
    private boolean enabled = true;
    private boolean visible = true;
    private String label = null;
    private Image trailingSeparator = null;
    private Image leadingSeparator = null;
    private Label groupLabel = new Label();
    public static final String CSS_ENABLED = "toolbar-group-label";
    public static final String CSS_DISABLED = "toolbar-group-label-disabled";

    public ToolbarGroup() {
        this.groupLabel.setStyleName(CSS_ENABLED);
        String url = "mantle/style/images/toolbarDivider.png";
        if (GWT.isScript()) {
            String mypath = Window.Location.getPath();
            if (!mypath.endsWith("/")) {
                mypath = mypath.substring(0, mypath.lastIndexOf("/") + 1);
            }
            if (!(mypath = mypath.replaceAll("/mantle/", "/")).endsWith("/")) {
                mypath = "/" + mypath;
            }
            url = mypath + url;
        }
        this.trailingSeparator = new Image(url, 0, 0, 2, 16);
        this.leadingSeparator = new Image(url, 0, 0, 2, 16);
    }

    public ToolbarGroup(String groupName) {
        this();
        this.setLabel(groupName);
    }

    public void add(ToolbarButton btn) {
        if (!this.buttons.contains(btn)) {
            this.buttons.add(btn);
        }
    }

    public void setEnabled(boolean enabled) {
        if (enabled == this.enabled) {
            return;
        }
        this.enabled = enabled;
        for (ToolbarButton btn : this.buttons) {
            btn.setEnabled(this.enabled);
        }
        this.groupLabel.setStyleName(this.enabled ? CSS_ENABLED : CSS_DISABLED);
    }

    public void setTempDisabled(boolean disable) {
        for (ToolbarButton btn : this.buttons) {
            btn.setTempDisabled(disable);
        }
        this.groupLabel.setStyleName(disable ? CSS_DISABLED : CSS_ENABLED);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public List<ToolbarButton> getButtons() {
        return this.buttons;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        if (visible == this.visible) {
            return;
        }
        this.visible = visible;
        for (ToolbarButton btn : this.buttons) {
            btn.setVisible(this.visible);
        }
        this.groupLabel.setVisible(this.visible);
        this.trailingSeparator.setVisible(this.visible);
        this.leadingSeparator.setVisible(this.visible);
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
        this.groupLabel.setText(this.label);
    }

    public Image getTrailingSeparator() {
        return this.trailingSeparator;
    }

    public Image getLeadingSeparator() {
        return this.leadingSeparator;
    }

    public Label getGroupLabel() {
        return this.groupLabel;
    }
}

