/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.gwt.widgets.client.toolbar;

import com.google.gwt.dom.client.Element;
import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.DockPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.MouseListener;
import com.google.gwt.user.client.ui.Widget;
import org.pentaho.gwt.widgets.client.toolbar.ToolbarButton;
import org.pentaho.gwt.widgets.client.utils.ElementUtils;

public class ToolbarToggleButton
extends ToolbarButton {
    private boolean selected = false;
    private String TOGGLE_STYLE = "toolbar-toggle-button";

    public ToolbarToggleButton(Image img, String label, boolean selected) {
        super(img, label);
        super.setStylePrimaryName(this.TOGGLE_STYLE);
        this.selected = selected;
        this.updateSelectedStyle();
    }

    public ToolbarToggleButton(Image img, Image disabledImage, String label, boolean selected) {
        super(img, disabledImage, label);
        super.setStylePrimaryName(this.TOGGLE_STYLE);
        this.selected = selected;
        this.updateSelectedStyle();
    }

    public ToolbarToggleButton(Image img, Image disabledImage, boolean selected) {
        super(img, disabledImage);
        super.setStylePrimaryName(this.TOGGLE_STYLE);
        this.selected = selected;
        this.updateSelectedStyle();
    }

    public ToolbarToggleButton(Image img) {
        super(img);
        super.setStylePrimaryName(this.TOGGLE_STYLE);
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected, boolean fireEvent) {
        this.selected = selected;
        if (fireEvent) {
            this.command.execute();
        }
        this.updateSelectedStyle();
    }

    private void toggleSelectedState() {
        this.selected = !this.selected;
        this.updateSelectedStyle();
    }

    private void updateSelectedStyle() {
        if (this.selected) {
            this.button.addStyleName(this.stylePrimaryName + "-down");
            if (this.downImage != null) {
                this.button.remove((Widget)this.currentImage);
                this.button.add((Widget)this.calculateApporiateImage(), DockPanel.CENTER);
            }
        } else {
            if (this.downImage != null) {
                this.button.remove((Widget)this.currentImage);
                this.button.add((Widget)this.calculateApporiateImage(), DockPanel.CENTER);
            }
            this.button.removeStyleName(this.stylePrimaryName + "-down");
            this.button.removeStyleName(this.stylePrimaryName + "-down-hovering");
        }
    }

    protected Image calculateApporiateImage() {
        Image retVal = this.enabled ? (this.selected && this.downImage != null ? this.downImage : super.calculateApporiateImage()) : (this.selected && this.downImageDisabled != null ? this.downImageDisabled : super.calculateApporiateImage());
        this.currentImage = retVal;
        return retVal;
    }

    protected void addStyleMouseListener() {
        this.eventWrapper.addClickListener(new ClickListener(){

            public void onClick(Widget sender) {
                if (!ToolbarToggleButton.this.enabled) {
                    ElementUtils.blur((Element)ToolbarToggleButton.this.eventWrapper.getElement());
                    return;
                }
                ToolbarToggleButton.this.toggleSelectedState();
                ToolbarToggleButton.this.command.execute();
            }
        });
        this.eventWrapper.addMouseListener(new MouseListener(){

            public void onMouseDown(Widget arg0, int arg1, int arg2) {
                if (ToolbarToggleButton.this.enabled) {
                    ToolbarToggleButton.this.button.addStyleName(ToolbarToggleButton.this.stylePrimaryName + "-down-hovering");
                    ToolbarToggleButton.this.button.addStyleName(ToolbarToggleButton.this.stylePrimaryName + "-hovering");
                }
            }

            public void onMouseEnter(Widget arg0) {
                if (ToolbarToggleButton.this.enabled) {
                    ToolbarToggleButton.this.button.addStyleName(ToolbarToggleButton.this.stylePrimaryName + (ToolbarToggleButton.this.selected ? "-down" : "") + "-hovering");
                }
            }

            public void onMouseLeave(Widget arg0) {
                if (ToolbarToggleButton.this.enabled) {
                    ToolbarToggleButton.this.button.removeStyleName(ToolbarToggleButton.this.stylePrimaryName + (ToolbarToggleButton.this.selected ? "-down" : "") + "-hovering");
                    ToolbarToggleButton.this.button.removeStyleName(ToolbarToggleButton.this.stylePrimaryName + "-hovering");
                }
            }

            public void onMouseUp(Widget arg0, int arg1, int arg2) {
            }

            public void onMouseMove(Widget arg0, int arg1, int arg2) {
            }
        });
    }

    public void setDownImageDisabled(Image img) {
        this.downImageDisabled = img;
    }

    public Image getDownImageDisabled() {
        return this.downImageDisabled;
    }
}

