/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.gwt.widgets.client.utils;

import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;

public final class ButtonHelper {
    public static String createButtonLabel(Image image, String text, ButtonLabelType type) {
        return ButtonHelper.createButtonLabel(image, text, type, null);
    }

    public static Panel createButtonElement(Image image, String text, ButtonLabelType type) {
        return ButtonHelper.createButtonElement(image, text, type, null);
    }

    public static String createButtonLabel(Image img, String text, ButtonLabelType type, String cssName) {
        HTML html = new HTML(text, false);
        if (cssName != null) {
            html.addStyleDependentName(cssName);
            img.addStyleDependentName(cssName);
        }
        if (type == ButtonLabelType.TEXT_ONLY) {
            return text;
        }
        if (type == ButtonLabelType.TEXT_ON_LEFT || type == ButtonLabelType.TEXT_ON_RIGHT) {
            HorizontalPanel hpanel = new HorizontalPanel();
            if (cssName != null) {
                hpanel.addStyleName(cssName);
            }
            if (type == ButtonLabelType.TEXT_ON_LEFT) {
                hpanel.add((Widget)html);
                hpanel.add((Widget)new HTML("&nbsp;"));
                hpanel.add((Widget)img);
            } else {
                hpanel.add((Widget)img);
                hpanel.add((Widget)new HTML("&nbsp;"));
                hpanel.add((Widget)html);
            }
            hpanel.setCellVerticalAlignment((Widget)html, HasVerticalAlignment.ALIGN_MIDDLE);
            hpanel.setCellVerticalAlignment((Widget)img, HasVerticalAlignment.ALIGN_MIDDLE);
            return hpanel.getElement().getString();
        }
        VerticalPanel vpanel = new VerticalPanel();
        if (type == ButtonLabelType.TEXT_ON_TOP) {
            vpanel.add((Widget)html);
            vpanel.add((Widget)img);
        } else {
            vpanel.add((Widget)img);
            vpanel.add((Widget)html);
        }
        vpanel.setCellHorizontalAlignment((Widget)html, HasHorizontalAlignment.ALIGN_CENTER);
        vpanel.setCellHorizontalAlignment((Widget)img, HasHorizontalAlignment.ALIGN_CENTER);
        return vpanel.getElement().getString();
    }

    public static Panel createButtonElement(Image img, String text, ButtonLabelType type, String cssName) {
        HTML html = new HTML(text, false);
        if (cssName != null) {
            html.addStyleDependentName(cssName);
            img.addStyleDependentName(cssName);
        }
        if (type == ButtonLabelType.TEXT_ONLY) {
            SimplePanel sp = new SimplePanel();
            sp.add((Widget)html);
            return sp;
        }
        if (type == ButtonLabelType.TEXT_ON_LEFT || type == ButtonLabelType.TEXT_ON_RIGHT) {
            HorizontalPanel hpanel = new HorizontalPanel();
            if (cssName != null) {
                hpanel.addStyleName(cssName);
            }
            if (type == ButtonLabelType.TEXT_ON_LEFT) {
                hpanel.add((Widget)html);
                hpanel.add((Widget)new HTML("&nbsp;"));
                hpanel.add((Widget)img);
            } else {
                hpanel.add((Widget)img);
                hpanel.add((Widget)new HTML("&nbsp;"));
                hpanel.add((Widget)html);
            }
            hpanel.setCellVerticalAlignment((Widget)html, HasVerticalAlignment.ALIGN_MIDDLE);
            hpanel.setCellVerticalAlignment((Widget)img, HasVerticalAlignment.ALIGN_MIDDLE);
            return hpanel;
        }
        VerticalPanel vpanel = new VerticalPanel();
        if (type == ButtonLabelType.TEXT_ON_TOP) {
            vpanel.add((Widget)html);
            vpanel.add((Widget)img);
        } else {
            vpanel.add((Widget)img);
            vpanel.add((Widget)html);
        }
        vpanel.setCellHorizontalAlignment((Widget)html, HasHorizontalAlignment.ALIGN_CENTER);
        vpanel.setCellHorizontalAlignment((Widget)img, HasHorizontalAlignment.ALIGN_CENTER);
        return vpanel;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ButtonLabelType {
        TEXT_ON_TOP,
        TEXT_ON_RIGHT,
        TEXT_ON_BOTTOM,
        TEXT_ON_LEFT,
        TEXT_ONLY,
        NO_TEXT;

    }
}

