/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.gwt.widgets.client.utils;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import org.pentaho.gwt.widgets.client.i18n.WidgetsLocalizedMessages;
import org.pentaho.gwt.widgets.client.i18n.WidgetsLocalizedMessagesSingleton;
import org.pentaho.gwt.widgets.client.utils.ParseException;
import org.pentaho.gwt.widgets.client.utils.ValueSet;

public class CronExpression {
    private static final WidgetsLocalizedMessages MSGS = WidgetsLocalizedMessagesSingleton.getInstance().getMessages();
    private static final long serialVersionUID = 12423409423L;
    protected static final int SECOND = 0;
    protected static final int MINUTE = 1;
    protected static final int HOUR = 2;
    protected static final int DAY_OF_MONTH = 3;
    protected static final int MONTH = 4;
    protected static final int DAY_OF_WEEK = 5;
    protected static final int YEAR = 6;
    protected static final int ALL_SPEC_INT = 99;
    protected static final int NO_SPEC_INT = 98;
    protected static final Integer ALL_SPEC = new Integer(99);
    protected static final Integer NO_SPEC = new Integer(98);
    protected static Map monthMap = new HashMap(20);
    protected static Map dayMap = new HashMap(60);
    private String cronExpression = null;
    protected transient TreeSet seconds;
    protected transient TreeSet minutes;
    protected transient TreeSet hours;
    protected transient TreeSet daysOfMonth;
    protected transient TreeSet months;
    protected transient TreeSet daysOfWeek;
    protected transient TreeSet years;
    protected transient boolean lastdayOfWeek = false;
    protected transient int nthdayOfWeek = 0;
    protected transient boolean lastdayOfMonth = false;
    protected transient boolean nearestWeekday = false;
    protected transient boolean calendardayOfWeek = false;
    protected transient boolean calendardayOfMonth = false;
    protected transient boolean expressionParsed = false;

    public CronExpression(String cronExpression) throws ParseException {
        if (cronExpression == null) {
            throw new IllegalArgumentException(MSGS.cronExpressionNull());
        }
        this.cronExpression = cronExpression;
        this.buildExpression(cronExpression.toUpperCase());
    }

    public String toString() {
        return this.cronExpression;
    }

    public static boolean isValidExpression(String cronExpression) {
        try {
            new CronExpression(cronExpression);
        }
        catch (ParseException pe) {
            return false;
        }
        return true;
    }

    protected void buildExpression(String expression) throws ParseException {
        this.expressionParsed = true;
        try {
            if (this.seconds == null) {
                this.seconds = new TreeSet();
            }
            if (this.minutes == null) {
                this.minutes = new TreeSet();
            }
            if (this.hours == null) {
                this.hours = new TreeSet();
            }
            if (this.daysOfMonth == null) {
                this.daysOfMonth = new TreeSet();
            }
            if (this.months == null) {
                this.months = new TreeSet();
            }
            if (this.daysOfWeek == null) {
                this.daysOfWeek = new TreeSet();
            }
            if (this.years == null) {
                this.years = new TreeSet();
            }
            int exprOn = 0;
            String[] exprsTok = expression.split(" |\\t");
            for (int i = 0; i < exprsTok.length && exprOn <= 6; ++exprOn, ++i) {
                String expr = exprsTok[i];
                String[] vtok = expr.split(",");
                for (int j = 0; j < vtok.length; ++j) {
                    String v = vtok[j];
                    this.storeExpressionVals(0, v, exprOn);
                }
            }
            if (exprOn <= 5) {
                throw new ParseException(MSGS.cronUnexpectedEndOfExpression(), expression.length());
            }
            if (exprOn <= 6) {
                this.storeExpressionVals(0, "*", 6);
            }
        }
        catch (ParseException pe) {
            throw pe;
        }
        catch (Exception e) {
            throw new ParseException(MSGS.cronIllegalExpressionFormat(e.toString()), 0);
        }
    }

    protected int storeExpressionVals(int pos, String s, int type) throws ParseException {
        int val;
        int incr = 0;
        int i = this.skipWhiteSpace(pos, s);
        if (i >= s.length()) {
            return i;
        }
        char c = s.charAt(i);
        if (c >= 'A' && c <= 'Z' && !s.equals("L") && !s.equals("LW")) {
            int eval;
            int sval;
            block45: {
                String sub = s.substring(i, i + 3);
                sval = -1;
                eval = -1;
                if (type == 4) {
                    sval = this.getMonthNumber(sub) + 1;
                    if (sval < 0) {
                        throw new ParseException(MSGS.cronInvalidMonthValue(sub), i);
                    }
                    if (s.length() > i + 3 && (c = s.charAt(i + 3)) == '-' && (eval = this.getMonthNumber(sub = s.substring(i += 4, i + 3)) + 1) < 0) {
                        throw new ParseException(MSGS.cronInvalidMonthValue(sub), i);
                    }
                } else if (type == 5) {
                    sval = this.getDayOfWeekNumber(sub);
                    if (sval < 0) {
                        throw new ParseException(MSGS.cronInvalidDOWValue(sub), i);
                    }
                    if (s.length() > i + 3) {
                        c = s.charAt(i + 3);
                        if (c == '-') {
                            if ((eval = this.getDayOfWeekNumber(sub = s.substring(i += 4, i + 3))) < 0) {
                                throw new ParseException(MSGS.cronInvalidDOWValue(sub), i);
                            }
                            if (sval > eval) {
                                throw new ParseException(MSGS.cronInvalidDOWSequence(Integer.toString(sval), Integer.toString(eval)), i);
                            }
                        } else {
                            if (c == '#') {
                                try {
                                    this.nthdayOfWeek = Integer.parseInt(s.substring(i += 4));
                                    if (this.nthdayOfWeek < 1 || this.nthdayOfWeek > 5) {
                                        throw new Exception();
                                    }
                                    break block45;
                                }
                                catch (Exception e) {
                                    throw new ParseException(MSGS.cronIllegalHashFollowingNumeric(), i);
                                }
                            }
                            if (c == 'L') {
                                this.lastdayOfWeek = true;
                                ++i;
                            }
                        }
                    }
                } else {
                    throw new ParseException(MSGS.cronIllegalCharactersForPosition(sub), i);
                }
            }
            if (eval != -1) {
                incr = 1;
            }
            this.addToSet(sval, eval, incr, type);
            return i + 3;
        }
        if (c == '?') {
            int val2;
            if (++i + 1 < s.length() && s.charAt(i) != ' ' && s.charAt(i + 1) != '\t') {
                throw new ParseException(MSGS.cronIllegalCharacterAfter("?", String.valueOf(s.charAt(i))), i);
            }
            if (type != 5 && type != 3) {
                throw new ParseException(MSGS.cronIllegalQuestionMark(), i);
            }
            if (type == 5 && !this.lastdayOfMonth && (val2 = ((Integer)this.daysOfMonth.last()).intValue()) == 98) {
                throw new ParseException(MSGS.cronIllegalQuestionMark(), i);
            }
            this.addToSet(98, -1, 0, type);
            return i;
        }
        if (c == '*' || c == '/') {
            if (c == '*' && i + 1 >= s.length()) {
                this.addToSet(99, -1, incr, type);
                return i + 1;
            }
            if (c == '/' && (i + 1 >= s.length() || s.charAt(i + 1) == ' ' || s.charAt(i + 1) == '\t')) {
                throw new ParseException(MSGS.cronIllegalSlash(), i);
            }
            if (c == '*') {
                ++i;
            }
            if ((c = s.charAt(i)) == '/') {
                if (++i >= s.length()) {
                    throw new ParseException(MSGS.cronUnexpectedEndOfString(), i);
                }
                incr = this.getNumericValue(s, i);
                ++i;
                if (incr > 10) {
                    ++i;
                }
                if (incr > 59 && (type == 0 || type == 1)) {
                    throw new ParseException(MSGS.cronIllegalIncrement("60", Integer.toString(incr)), i);
                }
                if (incr > 23 && type == 2) {
                    throw new ParseException(MSGS.cronIllegalIncrement("24", Integer.toString(incr)), i);
                }
                if (incr > 31 && type == 3) {
                    throw new ParseException(MSGS.cronIllegalIncrement("31", Integer.toString(incr)), i);
                }
                if (incr > 7 && type == 5) {
                    throw new ParseException(MSGS.cronIllegalIncrement("7", Integer.toString(incr)), i);
                }
                if (incr > 12 && type == 4) {
                    throw new ParseException(MSGS.cronIllegalIncrement("12", Integer.toString(incr)), i);
                }
            } else {
                incr = 1;
            }
            this.addToSet(99, -1, incr, type);
            return i;
        }
        if (c == 'L') {
            ++i;
            if (type == 3) {
                this.lastdayOfMonth = true;
            }
            if (type == 5) {
                this.addToSet(7, 7, 0, type);
            }
            if (type == 3 && s.length() > i && (c = s.charAt(i)) == 'W') {
                this.nearestWeekday = true;
                ++i;
            }
            return i;
        }
        if (c >= '0' && c <= '9') {
            val = Integer.parseInt(String.valueOf(c));
            if (++i < s.length()) {
                c = s.charAt(i);
                if (c >= '0' && c <= '9') {
                    ValueSet vs = this.getValue(val, s, i);
                    val = vs.value;
                    i = vs.pos;
                }
                i = this.checkNext(i, s, val, type);
                return i;
            }
        } else {
            throw new ParseException(MSGS.cronUnexpectedCharacter(String.valueOf(c)), i);
        }
        this.addToSet(val, -1, -1, type);
        return i;
    }

    protected int checkNext(int pos, String s, int val, int type) throws ParseException {
        int end = -1;
        int i = pos;
        if (i >= s.length()) {
            this.addToSet(val, end, -1, type);
            return i;
        }
        char c = s.charAt(pos);
        if (c == 'L') {
            if (type != 5) {
                throw new ParseException(MSGS.cronOptionIsNotValidHere("L", Integer.toString(i)), i);
            }
            this.lastdayOfWeek = true;
            TreeSet set = this.getSet(type);
            set.add(new Integer(val));
            return ++i;
        }
        if (c == 'W') {
            if (type != 3) {
                throw new ParseException(MSGS.cronOptionIsNotValidHere("W", Integer.toString(i)), i);
            }
            this.nearestWeekday = true;
            TreeSet set = this.getSet(type);
            set.add(new Integer(val));
            return ++i;
        }
        if (c == '#') {
            if (type != 5) {
                throw new ParseException(MSGS.cronOptionIsNotValidHere("#", Integer.toString(i)), i);
            }
            ++i;
            try {
                this.nthdayOfWeek = Integer.parseInt(s.substring(i));
                if (this.nthdayOfWeek < 1 || this.nthdayOfWeek > 5) {
                    throw new Exception();
                }
            }
            catch (Exception e) {
                throw new ParseException(MSGS.cronIllegalHashFollowingNumeric(), i);
            }
            TreeSet set = this.getSet(type);
            set.add(new Integer(val));
            return ++i;
        }
        if (c == 'C') {
            if (type == 5) {
                this.calendardayOfWeek = true;
            } else if (type == 3) {
                this.calendardayOfMonth = true;
            } else {
                throw new ParseException(MSGS.cronOptionIsNotValidHere("C", Integer.toString(i)), i);
            }
            TreeSet set = this.getSet(type);
            set.add(new Integer(val));
            return ++i;
        }
        if (c == '-') {
            int v;
            c = s.charAt(++i);
            end = v = Integer.parseInt(String.valueOf(c));
            if (++i >= s.length()) {
                this.addToSet(val, end, 1, type);
                return i;
            }
            c = s.charAt(i);
            if (c >= '0' && c <= '9') {
                int v1;
                ValueSet vs = this.getValue(v, s, i);
                end = v1 = vs.value;
                i = vs.pos;
            }
            if (i < s.length() && (c = s.charAt(i)) == '/') {
                c = s.charAt(++i);
                int v2 = Integer.parseInt(String.valueOf(c));
                if (++i >= s.length()) {
                    this.addToSet(val, end, v2, type);
                    return i;
                }
                c = s.charAt(i);
                if (c >= '0' && c <= '9') {
                    ValueSet vs = this.getValue(v2, s, i);
                    int v3 = vs.value;
                    this.addToSet(val, end, v3, type);
                    i = vs.pos;
                    return i;
                }
                this.addToSet(val, end, v2, type);
                return i;
            }
            this.addToSet(val, end, 1, type);
            return i;
        }
        if (c == '/') {
            c = s.charAt(++i);
            int v2 = Integer.parseInt(String.valueOf(c));
            if (++i >= s.length()) {
                this.addToSet(val, end, v2, type);
                return i;
            }
            c = s.charAt(i);
            if (c >= '0' && c <= '9') {
                ValueSet vs = this.getValue(v2, s, i);
                int v3 = vs.value;
                this.addToSet(val, end, v3, type);
                i = vs.pos;
                return i;
            }
            throw new ParseException(MSGS.cronUnexpectedCharacterAfterSlash(String.valueOf(c)), i);
        }
        this.addToSet(val, end, 0, type);
        return ++i;
    }

    public String getCronExpression() {
        return this.cronExpression;
    }

    protected int skipWhiteSpace(int i, String s) {
        while (i < s.length() && (s.charAt(i) == ' ' || s.charAt(i) == '\t')) {
            ++i;
        }
        return i;
    }

    protected int findNextWhiteSpace(int i, String s) {
        while (i < s.length() && (s.charAt(i) != ' ' || s.charAt(i) != '\t')) {
            ++i;
        }
        return i;
    }

    protected void addToSet(int val, int end, int incr, int type) throws ParseException {
        TreeSet set = this.getSet(type);
        if (type == 0 || type == 1) {
            if ((val < 0 || val > 59 || end > 59) && val != 99) {
                throw new ParseException(MSGS.cronInvalidMinuteSecondValue(), -1);
            }
        } else if (type == 2) {
            if ((val < 0 || val > 23 || end > 23) && val != 99) {
                throw new ParseException(MSGS.cronInvalidHourValue(), -1);
            }
        } else if (type == 3) {
            if ((val < 1 || val > 31 || end > 31) && val != 99 && val != 98) {
                throw new ParseException(MSGS.cronInvalidDayOfMonthValue(), -1);
            }
        } else if (type == 4) {
            if ((val < 1 || val > 12 || end > 12) && val != 99) {
                throw new ParseException(MSGS.cronInvalidMonthValueGeneral(), -1);
            }
        } else if (type == 5 && (val == 0 || val > 7 || end > 7) && val != 99 && val != 98) {
            throw new ParseException(MSGS.cronInvalidDayOfWeekValue(), -1);
        }
        if ((incr == 0 || incr == -1) && val != 99) {
            if (val != -1) {
                set.add(new Integer(val));
            } else {
                set.add(NO_SPEC);
            }
            return;
        }
        int startAt = val;
        int stopAt = end;
        if (val == 99 && incr <= 0) {
            incr = 1;
            set.add(ALL_SPEC);
        }
        if (type == 0 || type == 1) {
            if (stopAt == -1) {
                stopAt = 59;
            }
            if (startAt == -1 || startAt == 99) {
                startAt = 0;
            }
        } else if (type == 2) {
            if (stopAt == -1) {
                stopAt = 23;
            }
            if (startAt == -1 || startAt == 99) {
                startAt = 0;
            }
        } else if (type == 3) {
            if (stopAt == -1) {
                stopAt = 31;
            }
            if (startAt == -1 || startAt == 99) {
                startAt = 1;
            }
        } else if (type == 4) {
            if (stopAt == -1) {
                stopAt = 12;
            }
            if (startAt == -1 || startAt == 99) {
                startAt = 1;
            }
        } else if (type == 5) {
            if (stopAt == -1) {
                stopAt = 7;
            }
            if (startAt == -1 || startAt == 99) {
                startAt = 1;
            }
        } else if (type == 6) {
            if (stopAt == -1) {
                stopAt = 2099;
            }
            if (startAt == -1 || startAt == 99) {
                startAt = 1970;
            }
        }
        for (int i = startAt; i <= stopAt; i += incr) {
            set.add(new Integer(i));
        }
    }

    protected TreeSet getSet(int type) {
        switch (type) {
            case 0: {
                return this.seconds;
            }
            case 1: {
                return this.minutes;
            }
            case 2: {
                return this.hours;
            }
            case 3: {
                return this.daysOfMonth;
            }
            case 4: {
                return this.months;
            }
            case 5: {
                return this.daysOfWeek;
            }
            case 6: {
                return this.years;
            }
        }
        return null;
    }

    protected ValueSet getValue(int v, String s, int i) {
        char c = s.charAt(i);
        String s1 = String.valueOf(v);
        while (c >= '0' && c <= '9') {
            s1 = s1 + c;
            if (++i >= s.length()) break;
            c = s.charAt(i);
        }
        ValueSet val = new ValueSet();
        val.pos = i < s.length() ? i : i + 1;
        val.value = Integer.parseInt(s1);
        return val;
    }

    protected int getNumericValue(String s, int i) {
        int endOfVal = this.findNextWhiteSpace(i, s);
        String val = s.substring(i, endOfVal);
        return Integer.parseInt(val);
    }

    protected int getMonthNumber(String s) {
        Integer integer = (Integer)monthMap.get(s);
        if (integer == null) {
            return -1;
        }
        return integer;
    }

    protected int getDayOfWeekNumber(String s) {
        Integer integer = (Integer)dayMap.get(s);
        if (integer == null) {
            return -1;
        }
        return integer;
    }

    static {
        monthMap.put("JAN", new Integer(0));
        monthMap.put("FEB", new Integer(1));
        monthMap.put("MAR", new Integer(2));
        monthMap.put("APR", new Integer(3));
        monthMap.put("MAY", new Integer(4));
        monthMap.put("JUN", new Integer(5));
        monthMap.put("JUL", new Integer(6));
        monthMap.put("AUG", new Integer(7));
        monthMap.put("SEP", new Integer(8));
        monthMap.put("OCT", new Integer(9));
        monthMap.put("NOV", new Integer(10));
        monthMap.put("DEC", new Integer(11));
        dayMap.put("SUN", new Integer(1));
        dayMap.put("MON", new Integer(2));
        dayMap.put("TUE", new Integer(3));
        dayMap.put("WED", new Integer(4));
        dayMap.put("THU", new Integer(5));
        dayMap.put("FRI", new Integer(6));
        dayMap.put("SAT", new Integer(7));
    }
}

