/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.gwt.widgets.client.utils;

import java.util.EnumSet;
import org.pentaho.gwt.widgets.client.i18n.WidgetsLocalizedMessages;
import org.pentaho.gwt.widgets.client.i18n.WidgetsLocalizedMessagesSingleton;
import org.pentaho.gwt.widgets.client.utils.CronParseException;
import org.pentaho.gwt.widgets.client.utils.EnumException;
import org.pentaho.gwt.widgets.client.utils.StringUtils;
import org.pentaho.gwt.widgets.client.utils.TimeUtil;

public class CronParser {
    private static final WidgetsLocalizedMessages MSGS = WidgetsLocalizedMessagesSingleton.getInstance().getMessages();
    private String cronStr;
    private RecurrenceType recurrenceType = RecurrenceType.EveryWeekday;
    private int startSecond = -1;
    private int startMinute = -1;
    private int startHour = -1;
    private String dayOfMonthToke = null;
    private String monthToke = null;
    private String dayOfWeekToke = null;
    public static final int REQUIRED_NUM_TOKENS = 6;
    public static final String ALL = "*";
    public static final String DONT_CARE = "?";
    public static final String N_TH = "#";
    public static final String LAST = "L";
    private static final int MIN_CRON_FIELDS = 6;
    private static final int MAX_CRON_FIELDS = 7;
    private static final String MATCH_DAY_OF_MONTH_FIELD_RE = "^(\\*|\\?|L|([0-9]{1,2}(W|(,[0-9]{1,2}){0,30}))|([0-9]{1,2}[/-][0-9]{1,2}))$";
    private static final String MATCH_MONTH_FIELD_RE = "^(\\*|([0-9]{1,2}(,[0-9]{1,2}){0,11})|([0-9]{1,2}[/-][0-9]{1,2}))$";
    private static final String MATCH_DAY_OF_WEEK_FIELD_RE = "^(\\*|\\?|L|([0-9]{1,2}(,[0-9]{1,2}){0,6})|([0-9]{1,2}[/#-][0-9]{1,2}))$";
    private static final String MATCH_YEAR_FIELD_RE = "^[0-9]{1,4}$";
    private static String MATCH_SECONDS_RE;
    private static String MATCH_MINUTES_RE;
    private static String MATCH_HOURS_RE;
    private static final String EVERY_WEEK_DAY_RE = "^\\d{1,2}\\s+\\d{1,2}\\s+\\d{1,2}\\s+\\?\\s+\\*\\s+2\\-6$";
    private static final String WEEKLY_ON_RE = "^\\d{1,2}\\s+\\d{1,2}\\s+\\d{1,2}\\s+\\?\\s+\\*\\s+\\d(,\\d){0,6}$";
    private static final String DAY_N_OF_MONTH_RE = "^\\d{1,2}\\s+\\d{1,2}\\s+\\d{1,2}\\s+\\d{1,2}\\s+\\*\\s+\\?$";
    private static final String NTH_DAY_NAME_OF_MONTH_RE = "^\\d{1,2}\\s+\\d{1,2}\\s+\\d{1,2}\\s+\\?\\s+\\*\\s+[1-7]{1}#[1-4]{1}$";
    private static final String LAST_DAY_NAME_OF_MONTH_RE = "^\\d{1,2}\\s+\\d{1,2}\\s+\\d{1,2}\\s+\\?\\s+\\*\\s+[1-7]{1}L$";
    private static final String EVERY_MONTH_NAME_N_RE = "^\\d{1,2}\\s+\\d{1,2}\\s+\\d{1,2}\\s+\\d{1,2}\\s+\\d{1,2}\\s+\\?$";
    private static final String N_DAY_NAME_OF_MONTH_NAME_RE = "^\\d{1,2}\\s+\\d{1,2}\\s+\\d{1,2}\\s+\\?\\s+\\d{1,2}\\s+[1-7]{1}#[1-4]{1}$";
    private static final String LAST_DAY_NAME_OF_MONTH_NAME_RE = "^\\d{1,2}\\s+\\d{1,2}\\s+\\d{1,2}\\s+\\?\\s+\\d{1,2}\\s+\\d{1}L$";
    private static final String COMMA_SEPARATED_LIST_OF_WEEKDAY_INTS = "^[1-7](,[1-7]){0,6}$";

    public CronParser(String cronStr) {
        this.cronStr = cronStr.trim();
    }

    private static boolean isMultipleOfN(int testValue, int n) {
        assert (n != 0) : "isMultipleOfN(), n cannot be zero.";
        return testValue / n * n == testValue;
    }

    public static boolean isDayOfMonthField(String fld) {
        return fld.matches(MATCH_DAY_OF_MONTH_FIELD_RE);
    }

    public static boolean isMonthField(String fld) {
        return fld.matches(MATCH_MONTH_FIELD_RE);
    }

    public static boolean isDayOfWeekField(String fld) {
        return fld.matches(MATCH_DAY_OF_WEEK_FIELD_RE);
    }

    public static boolean isYearField(String fld) {
        return fld.matches(MATCH_YEAR_FIELD_RE);
    }

    public static boolean isValidCronString(String strInt) {
        boolean isValid = true;
        String[] parts = strInt.split("\\s");
        if (parts.length < 6 || parts.length > 7) {
            return false;
        }
        isValid &= CronParser.isValidSecondsField(parts[0]);
        isValid &= CronParser.isValidMinutesField(parts[1]);
        isValid &= CronParser.isValidHoursField(parts[2]);
        isValid &= CronParser.isDayOfMonthField(parts[3]);
        isValid &= CronParser.isMonthField(parts[4]);
        isValid &= CronParser.isDayOfWeekField(parts[5]);
        isValid &= DONT_CARE.equals(parts[3]) || DONT_CARE.equals(parts[5]);
        if (parts.length == 7) {
            isValid &= CronParser.isYearField(parts[6]);
        }
        return isValid;
    }

    private static boolean isValidSecondsField(String strSecs) {
        return strSecs.matches(MATCH_SECONDS_RE);
    }

    private static boolean isValidMinutesField(String strMins) {
        return strMins.matches(MATCH_MINUTES_RE);
    }

    private static boolean isValidHoursField(String strHours) {
        return strHours.matches(MATCH_HOURS_RE);
    }

    private String getCronString() {
        return this.cronStr;
    }

    private int getStartSecond() {
        return this.startSecond;
    }

    private int getStartMinute() {
        return this.startMinute;
    }

    private int getStartHour() {
        return this.startHour;
    }

    private boolean isEveryWeekdayToken() {
        return this.cronStr.matches(EVERY_WEEK_DAY_RE);
    }

    private boolean isWeeklyOnToken() {
        return this.cronStr.matches(WEEKLY_ON_RE);
    }

    private boolean isDayNOfMonthToken() {
        boolean bReMatch = this.cronStr.matches(DAY_N_OF_MONTH_RE);
        return bReMatch;
    }

    private boolean isNthDayNameOfMonthToken() {
        boolean bReMatch = this.cronStr.matches(NTH_DAY_NAME_OF_MONTH_RE);
        return bReMatch;
    }

    private boolean isLastDayNameOfMonthToken() {
        boolean bReMatch = this.cronStr.matches(LAST_DAY_NAME_OF_MONTH_RE);
        return bReMatch;
    }

    private boolean isEveryMonthNameNToken() {
        boolean bReMatch = this.cronStr.matches(EVERY_MONTH_NAME_N_RE);
        return bReMatch;
    }

    private boolean isNthDayNameOfMonthNameToken() {
        boolean bReMatch = this.cronStr.matches(N_DAY_NAME_OF_MONTH_NAME_RE);
        return bReMatch;
    }

    private boolean isLastDayNameOfMonthNameToken() {
        boolean bReMatch = this.cronStr.matches(LAST_DAY_NAME_OF_MONTH_NAME_RE);
        return bReMatch;
    }

    private RecurrenceType getSchedType() {
        return this.recurrenceType;
    }

    private RecurrenceType getScheduleType() throws CronParseException {
        if (this.isEveryWeekdayToken()) {
            return RecurrenceType.EveryWeekday;
        }
        if (this.isWeeklyOnToken()) {
            return RecurrenceType.WeeklyOn;
        }
        if (this.isDayNOfMonthToken()) {
            return RecurrenceType.DayNOfMonth;
        }
        if (this.isNthDayNameOfMonthToken()) {
            return RecurrenceType.NthDayNameOfMonth;
        }
        if (this.isLastDayNameOfMonthToken()) {
            return RecurrenceType.LastDayNameOfMonth;
        }
        if (this.isEveryMonthNameNToken()) {
            return RecurrenceType.EveryMonthNameN;
        }
        if (this.isNthDayNameOfMonthNameToken()) {
            return RecurrenceType.NthDayNameOfMonthName;
        }
        if (this.isLastDayNameOfMonthNameToken()) {
            return RecurrenceType.LastDayNameOfMonthName;
        }
        return RecurrenceType.Unknown;
    }

    public String parseToRecurrenceString() throws CronParseException {
        this.tokenizeForRecurrence();
        return this.getRecurrenceString();
    }

    private void tokenizeForRecurrence() throws CronParseException {
        int num;
        String[] tokens = this.cronStr.split("\\s");
        if (6 != tokens.length) {
            throw new CronParseException(MSGS.invalidNumTokens());
        }
        this.recurrenceType = this.getScheduleType();
        if (RecurrenceType.Unknown == this.recurrenceType) {
            throw new CronParseException(MSGS.cronStringCannotTransformToRecurrenceString(this.cronStr));
        }
        if (StringUtils.isPositiveInteger(tokens[CronField.SECONDS.value])) {
            num = Integer.parseInt(tokens[CronField.SECONDS.value]);
            if (!TimeUtil.isSecond(num)) {
                throw new CronParseException(MSGS.invalidSecondsToken(tokens[0]));
            }
            this.startSecond = num;
        }
        if (StringUtils.isPositiveInteger(tokens[CronField.MINUTES.value])) {
            num = Integer.parseInt(tokens[CronField.MINUTES.value]);
            if (!TimeUtil.isMinute(num)) {
                throw new CronParseException(MSGS.invalidMinutesToken(tokens[0]));
            }
            this.startMinute = num;
        }
        if (StringUtils.isPositiveInteger(tokens[CronField.HOURS.value])) {
            num = Integer.parseInt(tokens[CronField.HOURS.value]);
            if (!TimeUtil.isHour(num)) {
                throw new CronParseException(MSGS.invalidHoursToken(tokens[0]));
            }
            this.startHour = num;
        }
        this.dayOfMonthToke = tokens[CronField.DAY_OF_MONTH.value];
        this.monthToke = tokens[CronField.MONTH.value];
        this.dayOfWeekToke = tokens[CronField.DAY_OF_WEEK.value];
    }

    private boolean isDayOfMonthValid() {
        switch (this.recurrenceType) {
            case DayNOfMonth: 
            case EveryMonthNameN: {
                return true;
            }
        }
        return false;
    }

    private int getDayOfMonth() throws CronParseException {
        String strVal;
        switch (this.recurrenceType) {
            case DayNOfMonth: 
            case EveryMonthNameN: {
                strVal = this.dayOfMonthToke;
                break;
            }
            default: {
                throw new CronParseException(MSGS.invalidDayOfMonthForRecurrenceType(this.recurrenceType.toString()));
            }
        }
        int dayOfMonth = Integer.parseInt(strVal);
        if (!TimeUtil.isDayOfMonth(dayOfMonth)) {
            throw new CronParseException(MSGS.invalidDayOfMonth(strVal));
        }
        return dayOfMonth;
    }

    private boolean isDaysOfWeekValid() {
        switch (this.recurrenceType) {
            case WeeklyOn: {
                return true;
            }
        }
        return false;
    }

    private int[] getDaysOfWeek() throws CronParseException {
        switch (this.recurrenceType) {
            case WeeklyOn: {
                String[] days = this.dayOfWeekToke.split(",");
                int[] intDays = new int[days.length];
                for (int ii = 0; ii < days.length; ++ii) {
                    intDays[ii] = Integer.parseInt(days[ii]);
                    if (TimeUtil.isDayOfWeek(intDays[ii])) continue;
                    throw new CronParseException(MSGS.invalidDayOfWeek(days[ii]));
                }
                return intDays;
            }
        }
        throw new CronParseException(MSGS.invalidDayOfWeekForRecurrenceType(this.recurrenceType.toString()));
    }

    private boolean isWhichWeekOfMonthValid() {
        switch (this.recurrenceType) {
            case NthDayNameOfMonth: 
            case NthDayNameOfMonthName: {
                return true;
            }
        }
        return false;
    }

    private int getWhichWeekOfMonth() throws CronParseException {
        switch (this.recurrenceType) {
            case NthDayNameOfMonth: 
            case NthDayNameOfMonthName: {
                String strVal = this.dayOfWeekToke.split(N_TH)[1];
                int weekOfMonth = Integer.parseInt(strVal);
                if (!TimeUtil.isWeekOfMonth(weekOfMonth)) {
                    throw new CronParseException(MSGS.invalidWeekOfMonth(strVal));
                }
                return weekOfMonth;
            }
        }
        throw new CronParseException(MSGS.invalidWeekOfMonthForRecurrenceType(this.recurrenceType.toString()));
    }

    private boolean isWhichDayOfWeekValid() {
        switch (this.recurrenceType) {
            case NthDayNameOfMonth: 
            case NthDayNameOfMonthName: 
            case LastDayNameOfMonth: 
            case LastDayNameOfMonthName: {
                return true;
            }
        }
        return false;
    }

    private int getWhichDayOfWeek() throws CronParseException {
        int dayOfWeek;
        switch (this.recurrenceType) {
            case NthDayNameOfMonth: 
            case NthDayNameOfMonthName: {
                dayOfWeek = Integer.parseInt(this.dayOfWeekToke.split(N_TH)[0]);
                break;
            }
            case LastDayNameOfMonth: 
            case LastDayNameOfMonthName: {
                String strDay = this.dayOfWeekToke.substring(0, this.dayOfWeekToke.length() - 1);
                dayOfWeek = Integer.parseInt(strDay);
                break;
            }
            default: {
                throw new CronParseException(MSGS.invalidDayOfMonthForRecurrenceType(this.recurrenceType.toString()));
            }
        }
        if (!TimeUtil.isDayOfWeek(dayOfWeek)) {
            throw new CronParseException(MSGS.invalidDayOfMonth(Integer.toString(dayOfWeek)));
        }
        return dayOfWeek;
    }

    private boolean isWhichMonthOfYearValid() {
        switch (this.recurrenceType) {
            case EveryMonthNameN: 
            case NthDayNameOfMonthName: 
            case LastDayNameOfMonthName: {
                return true;
            }
        }
        return false;
    }

    private int getWhichMonthOfYear() throws CronParseException {
        int monthOfYear;
        switch (this.recurrenceType) {
            case EveryMonthNameN: 
            case NthDayNameOfMonthName: 
            case LastDayNameOfMonthName: {
                monthOfYear = Integer.parseInt(this.monthToke);
                break;
            }
            default: {
                throw new CronParseException(MSGS.invalidMonthOfYearForRecurrenceType(this.recurrenceType.toString()));
            }
        }
        if (!TimeUtil.isMonthOfYear(monthOfYear)) {
            throw new CronParseException(MSGS.invalidMonthOfYear(this.monthToke));
        }
        return monthOfYear;
    }

    private String getRecurrenceString() throws CronParseException {
        StringBuilder sb = new StringBuilder();
        sb.append(this.recurrenceType.toString()).append(" ");
        sb.append(this.startSecond).append(" ").append(this.startMinute).append(" ").append(this.startHour).append(" ");
        if (this.isDaysOfWeekValid()) {
            int[] days = this.getDaysOfWeek();
            for (int ii = 0; ii < days.length; ++ii) {
                int day = days[ii];
                sb.append(day).append(ii < days.length - 1 ? "," : "");
            }
            sb.append(" ");
        }
        if (this.isDayOfMonthValid()) {
            sb.append(this.getDayOfMonth()).append(" ");
        }
        if (this.isWhichDayOfWeekValid()) {
            sb.append(this.getWhichDayOfWeek()).append(" ");
        }
        if (this.isWhichWeekOfMonthValid()) {
            sb.append(this.getWhichWeekOfMonth()).append(" ");
        }
        if (this.isWhichMonthOfYearValid()) {
            sb.append(this.getWhichMonthOfYear()).append(" ");
        }
        return sb.toString().trim();
    }

    private static void validateIsInt(String strInt) throws CronParseException {
        if (!StringUtils.isPositiveInteger(strInt)) {
            throw new CronParseException(MSGS.invalidIntegerToken(strInt));
        }
    }

    private static void validateIsCommaSeparatedListOfWeekdays(String strInts) throws CronParseException {
        boolean matches = strInts.matches(COMMA_SEPARATED_LIST_OF_WEEKDAY_INTS);
        if (!matches) {
            throw new CronParseException(MSGS.invalidIntegerListToken(strInts));
        }
    }

    public static String recurrenceStringToCronString(String recurrenceTokenString) throws RuntimeException, CronParseException {
        String cronToken5;
        String cronToken4;
        String cronToken3;
        RecurrenceType st;
        StringBuilder sb = new StringBuilder();
        String[] recurrenceTokens = recurrenceTokenString.trim().split("\\s+");
        CronParser.validateIsInt(recurrenceTokens[1]);
        CronParser.validateIsInt(recurrenceTokens[2]);
        CronParser.validateIsInt(recurrenceTokens[3]);
        sb.append(recurrenceTokens[1]).append(" ").append(recurrenceTokens[2]).append(" ").append(recurrenceTokens[3]).append(" ");
        try {
            st = RecurrenceType.stringToScheduleType(recurrenceTokens[0]);
        }
        catch (EnumException e) {
            throw new CronParseException(e.getMessage());
        }
        switch (st) {
            case EveryWeekday: {
                cronToken3 = DONT_CARE;
                cronToken4 = ALL;
                cronToken5 = "2-6";
                break;
            }
            case WeeklyOn: {
                CronParser.validateIsCommaSeparatedListOfWeekdays(recurrenceTokens[4]);
                cronToken3 = DONT_CARE;
                cronToken4 = ALL;
                cronToken5 = recurrenceTokens[4];
                break;
            }
            case DayNOfMonth: {
                CronParser.validateIsInt(recurrenceTokens[4]);
                cronToken3 = recurrenceTokens[4];
                cronToken4 = ALL;
                cronToken5 = DONT_CARE;
                break;
            }
            case NthDayNameOfMonth: {
                CronParser.validateIsInt(recurrenceTokens[4]);
                CronParser.validateIsInt(recurrenceTokens[5]);
                cronToken3 = DONT_CARE;
                cronToken4 = ALL;
                cronToken5 = recurrenceTokens[4] + N_TH + recurrenceTokens[5];
                break;
            }
            case LastDayNameOfMonth: {
                CronParser.validateIsInt(recurrenceTokens[4]);
                cronToken3 = DONT_CARE;
                cronToken4 = ALL;
                cronToken5 = recurrenceTokens[4] + LAST;
                break;
            }
            case EveryMonthNameN: {
                CronParser.validateIsInt(recurrenceTokens[4]);
                CronParser.validateIsInt(recurrenceTokens[5]);
                cronToken3 = recurrenceTokens[4];
                cronToken4 = recurrenceTokens[5];
                cronToken5 = DONT_CARE;
                break;
            }
            case NthDayNameOfMonthName: {
                CronParser.validateIsInt(recurrenceTokens[4]);
                CronParser.validateIsInt(recurrenceTokens[5]);
                CronParser.validateIsInt(recurrenceTokens[6]);
                cronToken3 = DONT_CARE;
                cronToken4 = recurrenceTokens[6];
                cronToken5 = recurrenceTokens[4] + N_TH + recurrenceTokens[5];
                break;
            }
            case LastDayNameOfMonthName: {
                cronToken3 = DONT_CARE;
                cronToken4 = recurrenceTokens[5];
                cronToken5 = recurrenceTokens[4] + LAST;
                break;
            }
            case Unknown: {
                throw new RuntimeException(MSGS.illegalRecurrenceTypeUnknown());
            }
            default: {
                throw new RuntimeException(MSGS.invalidRecurrenceType(recurrenceTokens[0]));
            }
        }
        sb.append(cronToken3).append(" ");
        sb.append(cronToken4).append(" ");
        sb.append(cronToken5).append(" ");
        return sb.toString().trim();
    }

    public static void main(String[] args) {
        RecurrenceType st;
        CronParser cp;
        block167: {
            block166: {
                String recurrenceTokens;
                block165: {
                    block164: {
                        block163: {
                            block162: {
                                block161: {
                                    block160: {
                                        block159: {
                                            block158: {
                                                block157: {
                                                    block156: {
                                                        block155: {
                                                            String[] cronSamples = new String[]{"0 59 23 ? *", "0 59 23 ? * 2#4 2008", "0 22 4 0/3 * ?", "0 14 21 ? * 2-6", "0 33 6 ? * 1", "0 33 6 ? * 1,2", "0 33 6 ? * 1,2,3", "0 33 6 ? * 1,2,3,4", "0 33 6 ? * 1,2,3,4,5", "0 33 6 ? * 1,2,3,4,5,6", "0 33 6 ? * 1,2,3,4,5,6,7", "0 33 6 ? * 1,2,3,4,5,6,7,8", "0 5 5 13 * ?", "0 59 23 ? * 2#4", "0 59 23 ? * 5#4", "0 59 23 ? * 2#8", "0 59 23 ? * 2#4", "0 33 5 ? * 3L", "0 23 4 ? * 7L", "0 01 02 28 2 ?", "1 1 1 8 4 ?", "0 3 5 ? 4 2#1", "0 3 5 ? 4 7#4", "0 3 5 ? 4 1#1", "0 3 8 ? 6 5L", "0 59 12 ? 1 1L", ""};
                                                            for (int ii = 0; ii < cronSamples.length; ++ii) {
                                                                String cronStr = cronSamples[ii];
                                                                try {
                                                                    CronParser cp2 = new CronParser(cronStr);
                                                                    cp2.parseToRecurrenceString();
                                                                    System.out.println("cront str: " + cronStr + "  --  " + cp2.getSchedType().toString());
                                                                    continue;
                                                                }
                                                                catch (CronParseException e) {
                                                                    System.out.println("cron str: " + cronStr + " " + e.getMessage());
                                                                }
                                                            }
                                                            cp = new CronParser("0 22 4 0/3 * ?");
                                                            try {
                                                                cp.parseToRecurrenceString();
                                                            }
                                                            catch (CronParseException e) {
                                                                System.out.println(e);
                                                            }
                                                            try {
                                                                recurrenceTokens = cp.getRecurrenceString();
                                                                System.out.println("recurrenceTokens: " + recurrenceTokens + " [" + CronParser.recurrenceStringToCronString(recurrenceTokens) + "]  (" + cp.getCronString() + ")");
                                                                assert (cp.getCronString().equals(CronParser.recurrenceStringToCronString(recurrenceTokens))) : "Failed on: " + recurrenceTokens;
                                                            }
                                                            catch (CronParseException e) {
                                                                e.printStackTrace();
                                                            }
                                                            assert (cp.isDayOfMonthValid()) : "isDayOfMonthValid EveryNthDayOfMonth";
                                                            try {
                                                                assert (cp.getDayOfMonth() == 3) : "cp.getDayOfMonth() == 3";
                                                            }
                                                            catch (CronParseException e1) {
                                                                if ($assertionsDisabled) break block155;
                                                                throw new AssertionError((Object)"CronParseException");
                                                            }
                                                        }
                                                        assert (!cp.isDaysOfWeekValid()) : "isDaysOfWeekValid EveryNthDayOfMonth";
                                                        assert (!cp.isWhichDayOfWeekValid()) : "isWhichDayOfWeekValid EveryNthDayOfMonth";
                                                        assert (!cp.isWhichMonthOfYearValid()) : "isWhichMonthOfYearValid EveryNthDayOfMonth";
                                                        assert (!cp.isWhichWeekOfMonthValid()) : "isWhichWeekOfMonthValid EveryNthDayOfMonth";
                                                        cp = new CronParser("0 14 21 ? * 2-6");
                                                        try {
                                                            cp.parseToRecurrenceString();
                                                        }
                                                        catch (CronParseException e) {
                                                            System.out.println(e);
                                                        }
                                                        try {
                                                            recurrenceTokens = cp.getRecurrenceString();
                                                            System.out.println("recurrenceTokens: " + recurrenceTokens + " [" + CronParser.recurrenceStringToCronString(recurrenceTokens) + "]  (" + cp.getCronString() + ")");
                                                            assert (cp.getCronString().equals(CronParser.recurrenceStringToCronString(recurrenceTokens))) : "Failed on: " + recurrenceTokens;
                                                        }
                                                        catch (CronParseException e) {
                                                            e.printStackTrace();
                                                        }
                                                        assert (!cp.isDayOfMonthValid()) : "isDayOfMonthValid EveryWeekday";
                                                        assert (!cp.isDaysOfWeekValid()) : "isDaysOfWeekValid EveryWeekday";
                                                        assert (!cp.isWhichDayOfWeekValid()) : "isWhichDayOfWeekValid EveryWeekday";
                                                        assert (!cp.isWhichMonthOfYearValid()) : "isWhichMonthOfYearValid EveryWeekday";
                                                        assert (!cp.isWhichWeekOfMonthValid()) : "isWhichWeekOfMonthValid EveryWeekday";
                                                        cp = new CronParser("0 33 6 ? * 1,3,5");
                                                        try {
                                                            cp.parseToRecurrenceString();
                                                        }
                                                        catch (CronParseException e) {
                                                            System.out.println(e);
                                                        }
                                                        try {
                                                            recurrenceTokens = cp.getRecurrenceString();
                                                            System.out.println("recurrenceTokens: " + recurrenceTokens + " [" + CronParser.recurrenceStringToCronString(recurrenceTokens) + "]  (" + cp.getCronString() + ")");
                                                            assert (cp.getCronString().equals(CronParser.recurrenceStringToCronString(recurrenceTokens))) : "Failed on: " + recurrenceTokens;
                                                        }
                                                        catch (CronParseException e) {
                                                            e.printStackTrace();
                                                        }
                                                        assert (!cp.isDayOfMonthValid()) : "isDayOfMonthValid WeeklyOn";
                                                        assert (cp.isDaysOfWeekValid()) : "isDaysOfWeekValid WeeklyOn";
                                                        try {
                                                            int[] days = cp.getDaysOfWeek();
                                                            assert (days[0] == 1) : "days[0] == 1";
                                                            assert (days[1] == 3) : "days[0] == 3";
                                                            assert (days[2] == 5) : "days[0] == 5";
                                                        }
                                                        catch (CronParseException e1) {
                                                            if ($assertionsDisabled) break block156;
                                                            throw new AssertionError((Object)"CronParseException");
                                                        }
                                                    }
                                                    assert (!cp.isWhichDayOfWeekValid()) : "isWhichDayOfWeekValid WeeklyOn";
                                                    assert (!cp.isWhichMonthOfYearValid()) : "isWhichMonthOfYearValid WeeklyOn";
                                                    assert (!cp.isWhichWeekOfMonthValid()) : "isWhichWeekOfMonthValid WeeklyOn";
                                                    cp = new CronParser("0 5 5 13 * ?");
                                                    try {
                                                        cp.parseToRecurrenceString();
                                                    }
                                                    catch (CronParseException e) {
                                                        System.out.println(e);
                                                    }
                                                    try {
                                                        recurrenceTokens = cp.getRecurrenceString();
                                                        System.out.println("recurrenceTokens: " + recurrenceTokens + " [" + CronParser.recurrenceStringToCronString(recurrenceTokens) + "]  (" + cp.getCronString() + ")");
                                                        assert (cp.getCronString().equals(CronParser.recurrenceStringToCronString(recurrenceTokens))) : "Failed on: " + recurrenceTokens;
                                                    }
                                                    catch (CronParseException e) {
                                                        e.printStackTrace();
                                                    }
                                                    assert (cp.isDayOfMonthValid()) : "isDayOfMonthValid DayNOfMonth";
                                                    try {
                                                        assert (cp.getDayOfMonth() == 13) : "cp.getDayOfMonth() == 13";
                                                    }
                                                    catch (CronParseException e1) {
                                                        if ($assertionsDisabled) break block157;
                                                        throw new AssertionError((Object)"CronParseException");
                                                    }
                                                }
                                                assert (!cp.isDaysOfWeekValid()) : "isDaysOfWeekValid DayNOfMonth";
                                                assert (!cp.isWhichDayOfWeekValid()) : "isWhichDayOfWeekValid DayNOfMonth";
                                                assert (!cp.isWhichMonthOfYearValid()) : "isWhichMonthOfYearValid DayNOfMonth";
                                                assert (!cp.isWhichWeekOfMonthValid()) : "isWhichWeekOfMonthValid DayNOfMonth";
                                                cp = new CronParser("0 59 23 ? * 2#4");
                                                try {
                                                    cp.parseToRecurrenceString();
                                                }
                                                catch (CronParseException e) {
                                                    System.out.println(e);
                                                }
                                                try {
                                                    recurrenceTokens = cp.getRecurrenceString();
                                                    System.out.println("recurrenceTokens: " + recurrenceTokens + " [" + CronParser.recurrenceStringToCronString(recurrenceTokens) + "]  (" + cp.getCronString() + ")");
                                                    assert (cp.getCronString().equals(CronParser.recurrenceStringToCronString(recurrenceTokens))) : "Failed on: " + recurrenceTokens;
                                                }
                                                catch (CronParseException e) {
                                                    e.printStackTrace();
                                                }
                                                assert (!cp.isDayOfMonthValid()) : "isDayOfMonthValid NthDayNameOfMonth";
                                                assert (!cp.isDaysOfWeekValid()) : "isDaysOfWeekValid NthDayNameOfMonth";
                                                assert (cp.isWhichDayOfWeekValid()) : "isWhichDayOfWeekValid NthDayNameOfMonth";
                                                try {
                                                    assert (cp.getWhichDayOfWeek() == 2) : "cp.getWhichDayOfWeek() == 2";
                                                }
                                                catch (CronParseException e1) {
                                                    if ($assertionsDisabled) break block158;
                                                    throw new AssertionError((Object)"CronParseException");
                                                }
                                            }
                                            assert (!cp.isWhichMonthOfYearValid()) : "isWhichMonthOfYearValid NthDayNameOfMonth";
                                            assert (cp.isWhichWeekOfMonthValid()) : "isWhichWeekOfMonthValid NthDayNameOfMonth";
                                            try {
                                                assert (cp.getWhichWeekOfMonth() == 4) : "cp.getWhichWeekOfMonth() == 4";
                                            }
                                            catch (CronParseException e1) {
                                                if ($assertionsDisabled) break block159;
                                                throw new AssertionError((Object)"CronParseException");
                                            }
                                        }
                                        cp = new CronParser("0 33 5 ? * 3L");
                                        try {
                                            cp.parseToRecurrenceString();
                                        }
                                        catch (CronParseException e) {
                                            System.out.println(e);
                                        }
                                        try {
                                            recurrenceTokens = cp.getRecurrenceString();
                                            System.out.println("recurrenceTokens: " + recurrenceTokens + " [" + CronParser.recurrenceStringToCronString(recurrenceTokens) + "]  (" + cp.getCronString() + ")");
                                            assert (cp.getCronString().equals(CronParser.recurrenceStringToCronString(recurrenceTokens))) : "Failed on: " + recurrenceTokens;
                                        }
                                        catch (CronParseException e) {
                                            e.printStackTrace();
                                        }
                                        assert (!cp.isDayOfMonthValid()) : "isDayOfMonthValid LastDayNameOfMonth";
                                        assert (!cp.isDaysOfWeekValid()) : "isDaysOfWeekValid LastDayNameOfMonth";
                                        assert (cp.isWhichDayOfWeekValid()) : "isWhichDayOfWeekValid LastDayNameOfMonth";
                                        try {
                                            assert (cp.getWhichDayOfWeek() == 3) : "cp.getWhichDayOfWeek() == 3";
                                        }
                                        catch (CronParseException e1) {
                                            if ($assertionsDisabled) break block160;
                                            throw new AssertionError((Object)"CronParseException");
                                        }
                                    }
                                    assert (!cp.isWhichMonthOfYearValid()) : "isWhichMonthOfYearValid LastDayNameOfMonth";
                                    assert (!cp.isWhichWeekOfMonthValid()) : "isWhichWeekOfMonthValid LastDayNameOfMonth";
                                    cp = new CronParser("0 1 2 28 2 ?");
                                    try {
                                        cp.parseToRecurrenceString();
                                    }
                                    catch (CronParseException e) {
                                        System.out.println(e);
                                    }
                                    try {
                                        recurrenceTokens = cp.getRecurrenceString();
                                        System.out.println("recurrenceTokens: " + recurrenceTokens + " [" + CronParser.recurrenceStringToCronString(recurrenceTokens) + "]  (" + cp.getCronString() + ")");
                                        assert (cp.getCronString().equals(CronParser.recurrenceStringToCronString(recurrenceTokens))) : "Failed on: " + recurrenceTokens;
                                    }
                                    catch (CronParseException e) {
                                        e.printStackTrace();
                                    }
                                    assert (cp.isDayOfMonthValid()) : "isDayOfMonthValid EveryMonthNameN";
                                    try {
                                        assert (cp.getDayOfMonth() == 28) : "cp.getDayOfMonth() == 28";
                                    }
                                    catch (CronParseException e1) {
                                        if ($assertionsDisabled) break block161;
                                        throw new AssertionError((Object)"CronParseException");
                                    }
                                }
                                assert (!cp.isDaysOfWeekValid()) : "isDaysOfWeekValid EveryMonthNameN";
                                assert (!cp.isWhichDayOfWeekValid()) : "isWhichDayOfWeekValid EveryMonthNameN";
                                assert (cp.isWhichMonthOfYearValid()) : "isWhichMonthOfYearValid EveryMonthNameN";
                                try {
                                    assert (cp.getWhichMonthOfYear() == 2) : "cp.getWhichMonthOfYear() == 2";
                                }
                                catch (CronParseException e1) {
                                    if ($assertionsDisabled) break block162;
                                    throw new AssertionError((Object)"CronParseException");
                                }
                            }
                            assert (!cp.isWhichWeekOfMonthValid()) : "isWhichWeekOfMonthValid EveryMonthNameN";
                            cp = new CronParser("0 3 5 ? 12 7#3");
                            try {
                                cp.parseToRecurrenceString();
                            }
                            catch (CronParseException e) {
                                System.out.println(e);
                            }
                            try {
                                recurrenceTokens = cp.getRecurrenceString();
                                System.out.println("recurrenceTokens: " + recurrenceTokens + " [" + CronParser.recurrenceStringToCronString(recurrenceTokens) + "]  (" + cp.getCronString() + ")");
                                assert (cp.getCronString().equals(CronParser.recurrenceStringToCronString(recurrenceTokens))) : "Failed on: " + recurrenceTokens;
                            }
                            catch (CronParseException e) {
                                e.printStackTrace();
                            }
                            assert (!cp.isDayOfMonthValid()) : "isDayOfMonthValid NthDayNameOfMonthName";
                            assert (!cp.isDaysOfWeekValid()) : "isDaysOfWeekValid NthDayNameOfMonthName";
                            assert (cp.isWhichDayOfWeekValid()) : "isWhichDayOfWeekValid NthDayNameOfMonthName";
                            try {
                                assert (cp.getWhichDayOfWeek() == 7) : "cp.getWhichDayOfWeek() == 7";
                            }
                            catch (CronParseException e1) {
                                if ($assertionsDisabled) break block163;
                                throw new AssertionError((Object)"CronParseException");
                            }
                        }
                        assert (cp.isWhichMonthOfYearValid()) : "isWhichMonthOfYearValid NthDayNameOfMonthName";
                        try {
                            assert (cp.getWhichMonthOfYear() == 12) : "cp.getWhichMonthOfYear() == 12";
                        }
                        catch (CronParseException e1) {
                            if ($assertionsDisabled) break block164;
                            throw new AssertionError((Object)"CronParseException");
                        }
                    }
                    assert (cp.isWhichWeekOfMonthValid()) : "isWhichWeekOfMonthValid NthDayNameOfMonthName";
                    try {
                        assert (cp.getWhichWeekOfMonth() == 3) : "cp.getWhichWeekOfMonth() == 3";
                    }
                    catch (CronParseException e1) {
                        if ($assertionsDisabled) break block165;
                        throw new AssertionError((Object)"CronParseException");
                    }
                }
                cp = new CronParser("0 3 8 ? 6 5L");
                try {
                    cp.parseToRecurrenceString();
                }
                catch (CronParseException e) {
                    System.out.println(e);
                }
                try {
                    recurrenceTokens = cp.getRecurrenceString();
                    System.out.println("recurrenceTokens: " + recurrenceTokens + " [" + CronParser.recurrenceStringToCronString(recurrenceTokens) + "]  (" + cp.getCronString() + ")");
                    assert (cp.getCronString().equals(CronParser.recurrenceStringToCronString(recurrenceTokens))) : "Failed on: " + recurrenceTokens;
                }
                catch (CronParseException e) {
                    e.printStackTrace();
                }
                assert (!cp.isDayOfMonthValid()) : "isDayOfMonthValid LastDayNameOfMonthName";
                assert (!cp.isDaysOfWeekValid()) : "isDaysOfWeekValid LastDayNameOfMonthName";
                assert (cp.isWhichDayOfWeekValid()) : "isWhichDayOfWeekValid LastDayNameOfMonthName";
                try {
                    assert (cp.getWhichDayOfWeek() == 5) : "cp.getWhichDayOfWeek() == 5";
                }
                catch (CronParseException e1) {
                    if ($assertionsDisabled) break block166;
                    throw new AssertionError((Object)"CronParseException");
                }
            }
            assert (cp.isWhichMonthOfYearValid()) : "isWhichMonthOfYearValid LastDayNameOfMonthName";
            try {
                assert (cp.getWhichMonthOfYear() == 6) : "cp.getWhichMonthOfYear() == 6";
            }
            catch (CronParseException e1) {
                if ($assertionsDisabled) break block167;
                throw new AssertionError((Object)"CronParseException");
            }
        }
        assert (!cp.isWhichWeekOfMonthValid()) : "isWhichWeekOfMonthValid LastDayNameOfMonthName";
        boolean bThrewException = false;
        try {
            st = RecurrenceType.stringToScheduleType(RecurrenceType.DayNOfMonth.toString());
            System.out.println("DayNOfMonth=" + st.toString());
        }
        catch (EnumException e1) {
            bThrewException = true;
        }
        assert (!bThrewException) : "Should not have thrown exception";
        bThrewException = false;
        try {
            st = RecurrenceType.stringToScheduleType(RecurrenceType.NthDayNameOfMonth.toString());
            System.out.println("NthDayNameOfMonth=" + st.toString());
        }
        catch (EnumException e1) {
            bThrewException = true;
        }
        assert (!bThrewException) : "Should not have thrown exception";
        bThrewException = false;
        try {
            st = RecurrenceType.stringToScheduleType(RecurrenceType.EveryMonthNameN.toString());
            System.out.println("EveryMonthNameN=" + st.toString());
        }
        catch (EnumException e1) {
            bThrewException = true;
        }
        assert (!bThrewException) : "Should not have thrown exception";
        bThrewException = false;
        String r = null;
        try {
            r = CronParser.recurrenceStringToCronString("EveryNthDayOfMonth 0 22 4 toke");
        }
        catch (CronParseException e) {
            bThrewException = true;
        }
        assert (bThrewException) : "Should have thrown exception";
        bThrewException = false;
        try {
            r = CronParser.recurrenceStringToCronString("WeeklyOn 0 33 6 1,toke,5");
        }
        catch (CronParseException e) {
            bThrewException = true;
        }
        assert (bThrewException) : "Should have thrown exception";
        bThrewException = false;
        try {
            r = CronParser.recurrenceStringToCronString("DayNOfMonth 0 5 toke 13");
        }
        catch (CronParseException e) {
            bThrewException = true;
        }
        assert (bThrewException) : "Should have thrown exception";
        bThrewException = false;
        try {
            r = CronParser.recurrenceStringToCronString("NthDayNameOfMonthName 0 3 5 7 3 toke");
        }
        catch (CronParseException e) {
            bThrewException = true;
        }
        assert (bThrewException) : "Should have thrown exception";
        bThrewException = false;
    }

    static {
        MATCH_MINUTES_RE = MATCH_SECONDS_RE = "^\\s*(\\*|\\d{1,2}[/-]\\d{1,2}|\\d{1,2}(,\\d{1,2})*)\\s*$";
        MATCH_HOURS_RE = MATCH_SECONDS_RE;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RecurrenceType {
        Unknown,
        EveryWeekday,
        WeeklyOn,
        DayNOfMonth,
        NthDayNameOfMonth,
        LastDayNameOfMonth,
        EveryMonthNameN,
        NthDayNameOfMonthName,
        LastDayNameOfMonthName;


        public static RecurrenceType stringToScheduleType(String str) throws EnumException {
            for (RecurrenceType d : EnumSet.range(Unknown, LastDayNameOfMonthName)) {
                if (!d.toString().equals(str)) continue;
                return d;
            }
            throw new EnumException(MSGS.invalidStringForRecurrenceType(str));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum CronField {
        SECONDS(0),
        MINUTES(1),
        HOURS(2),
        DAY_OF_MONTH(3),
        MONTH(4),
        DAY_OF_WEEK(5),
        YEAR(6);

        private final int value;

        private CronField(int value) {
            this.value = value;
        }

        public int value() {
            return this.value;
        }
    }
}

