/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.gwt.widgets.client.utils;

import com.google.gwt.dom.client.Node;
import com.google.gwt.dom.client.NodeList;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.AbsolutePanel;
import com.google.gwt.user.client.ui.HorizontalSplitPanel;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.VerticalSplitPanel;
import com.google.gwt.user.client.ui.Widget;
import org.pentaho.gwt.widgets.client.utils.Rectangle;

public class ElementUtils {
    public static final int LEFT = 0;
    public static final int RIGHT = 1;
    public static final int TOP = 0;
    public static final int BOTTOM = 1;
    private static AbsolutePanel sandbox = new AbsolutePanel();

    public static native void blur(com.google.gwt.dom.client.Element var0);

    public static void removeScrollingFromSplitPane(Widget panel) {
        if (!panel.isAttached()) {
            // empty if block
        }
        if (!(panel instanceof HorizontalSplitPanel || panel instanceof VerticalSplitPanel)) {
            throw new IllegalArgumentException("Widget not expected SplitPane type");
        }
        if (panel instanceof HorizontalSplitPanel) {
            HorizontalSplitPanel hp = (HorizontalSplitPanel)panel;
            ElementUtils.removeScrollingFromUpTo((com.google.gwt.dom.client.Element)hp.getLeftWidget().getElement(), (com.google.gwt.dom.client.Element)hp.getElement());
            ElementUtils.removeScrollingFromUpTo((com.google.gwt.dom.client.Element)hp.getRightWidget().getElement(), (com.google.gwt.dom.client.Element)hp.getElement());
        } else {
            VerticalSplitPanel vp = (VerticalSplitPanel)panel;
            ElementUtils.removeScrollingFromUpTo((com.google.gwt.dom.client.Element)vp.getTopWidget().getElement(), (com.google.gwt.dom.client.Element)vp.getElement());
            ElementUtils.removeScrollingFromUpTo((com.google.gwt.dom.client.Element)vp.getBottomWidget().getElement(), (com.google.gwt.dom.client.Element)vp.getElement());
        }
    }

    public static void removeScrollingFromUpTo(com.google.gwt.dom.client.Element bottom, com.google.gwt.dom.client.Element top) {
        for (com.google.gwt.dom.client.Element ele = bottom; ele != top && ele.getParentElement() != null; ele = ele.getParentElement()) {
            ele.getStyle().setProperty("overflow", "visible");
            ele.getStyle().setProperty("overflowX", "visible");
            ele.getStyle().setProperty("overflowY", "visible");
        }
    }

    public static void killAutoScrolling(com.google.gwt.dom.client.Element ele) {
        ele.getStyle().setProperty("overflow", "visible");
        if (ele.hasChildNodes()) {
            NodeList nodes = ele.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node n = nodes.getItem(i);
                if (!(n instanceof com.google.gwt.dom.client.Element)) continue;
                ElementUtils.killAutoScrolling((com.google.gwt.dom.client.Element)n);
            }
        }
    }

    public static void killAllTextSelection(com.google.gwt.dom.client.Element item) {
        ElementUtils.preventTextSelection(item);
        NodeList children = item.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            ElementUtils.killAllTextSelection((com.google.gwt.dom.client.Element)children.getItem(i));
        }
    }

    public static native void preventTextSelection(com.google.gwt.dom.client.Element var0);

    public static native com.google.gwt.dom.client.Element[] getElementsByTagName(String var0);

    public static native void convertPNGs();

    public static native int[] calculateScrollOffsets(com.google.gwt.dom.client.Element var0);

    public static native int[] calculateOffsets(com.google.gwt.dom.client.Element var0);

    public static com.google.gwt.dom.client.Element findElementAboveByTagName(com.google.gwt.dom.client.Element base, String targetName) {
        com.google.gwt.dom.client.Element parent;
        com.google.gwt.dom.client.Element curEle = base;
        while ((parent = curEle.getParentElement()) != null) {
            if (parent.getTagName().equalsIgnoreCase(targetName)) {
                return parent;
            }
            curEle = parent;
        }
        return null;
    }

    public static boolean elementsOverlap(com.google.gwt.dom.client.Element ele1, com.google.gwt.dom.client.Element ele2) {
        Rectangle r1 = new Rectangle(ele1.getAbsoluteLeft(), ele1.getAbsoluteTop(), ele1.getOffsetWidth(), ele1.getOffsetHeight());
        Rectangle r2 = new Rectangle(ele2.getAbsoluteLeft(), ele2.getAbsoluteTop(), ele2.getOffsetWidth(), ele2.getOffsetHeight());
        return r1.intersects(r2);
    }

    public static Rectangle getSize(Element ele) {
        Rectangle r = new Rectangle();
        r.width = ele.getOffsetWidth();
        r.height = ele.getOffsetHeight();
        if (r.width == 0 && r.height == 0) {
            Element e = DOM.clone((Element)ele, (boolean)true);
            sandbox.getElement().appendChild((Node)e);
            r.width = e.getOffsetWidth();
            r.height = e.getOffsetHeight();
            sandbox.getElement().removeChild((Node)e);
        }
        return r;
    }

    public boolean isVisible(Element ele) {
        if (ele.getStyle().getProperty("display").equals("none")) {
            return false;
        }
        return !ele.getStyle().getProperty("visibility").equals("hidden");
    }

    public static void setupButtonHoverEffect() {
        ElementUtils.setupHoverEffectJS();
    }

    private static native void setupHoverEffectJS();

    static {
        sandbox.getElement().getStyle().setProperty("position", "absolute");
        sandbox.getElement().getStyle().setProperty("overflow", "hidden");
        sandbox.getElement().getStyle().setProperty("width", "0px");
        sandbox.getElement().getStyle().setProperty("height", "0px");
        RootPanel.get().add((Widget)sandbox);
    }
}

