/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.gwt.widgets.client.utils;

import com.google.gwt.dom.client.Element;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.ui.Frame;
import java.util.HashMap;
import java.util.Map;
import org.pentaho.gwt.widgets.client.utils.ElementUtils;

public class FrameUtils {
    private static Map<Frame, FrameTimer> timers = new HashMap<Frame, FrameTimer>();

    private static native void toggleEmbedVisibility(Element var0, boolean var1);

    public static void setEmbedVisibility(Frame frame, boolean visible) {
        if (timers.containsKey(frame)) {
            FrameTimer t = timers.get(frame);
            if (t.visible == visible) {
                return;
            }
            t.cancel();
            t.visible = visible;
            t.schedule(200);
        } else {
            FrameTimer t = new FrameTimer(frame, visible);
            timers.put(frame, t);
            t.schedule(200);
        }
    }

    public static void toggleEmbedVisibility(boolean visible) {
        Element[] frames = new Element[]{};
        try {
            frames = ElementUtils.getElementsByTagName("iframe");
        }
        catch (ClassCastException cce) {
            // empty catch block
        }
        for (Element ele : frames) {
            Frame f = null;
            Object[] tmap = timers.entrySet().toArray();
            for (int i = 0; i < tmap.length; ++i) {
                Map.Entry t = (Map.Entry)tmap[i];
                if (((Frame)t.getKey()).getElement() != ele) continue;
                f = (Frame)t.getKey();
            }
            if (f == null) {
                f = Frame.wrap((Element)ele);
            }
            FrameUtils.setEmbedVisibility(f, visible);
        }
    }

    private static class FrameTimer
    extends Timer {
        Frame frame;
        boolean visible;

        public FrameTimer(Frame frame, boolean visible) {
            this.frame = frame;
            this.visible = visible;
        }

        public void run() {
            FrameUtils.toggleEmbedVisibility((Element)this.frame.getElement(), this.visible);
            timers.remove(this.frame);
        }
    }
}

