/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.gwt.widgets.client.utils;

import com.google.gwt.i18n.client.DateTimeFormat;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.pentaho.gwt.widgets.client.i18n.WidgetsLocalizedMessages;
import org.pentaho.gwt.widgets.client.i18n.WidgetsLocalizedMessagesSingleton;
import org.pentaho.gwt.widgets.client.utils.EnumException;

public class TimeUtil {
    private static final WidgetsLocalizedMessages MSGS = WidgetsLocalizedMessagesSingleton.getInstance().getMessages();
    public static final int HOURS_IN_DAY = 24;
    public static final int MINUTES_IN_HOUR = 60;
    public static final int SECONDS_IN_MINUTE = 60;
    public static final int MILLISECS_IN_SECONDS = 1000;
    public static final int MIN_HOUR = 0;
    public static final int MAX_HOUR = 12;
    public static final int MAX_MINUTE = 60;
    public static final int MAX_SECOND_BY_MILLISEC = 2147483;
    public static final int MAX_MINUTE_BY_MILLISEC = 35791;
    public static final int MAX_HOUR_BY_MILLISEC = 596;
    private static Map<MonthOfYear, Integer> validNumDaysOfMonth = new HashMap<MonthOfYear, Integer>();
    private static DateTimeFormat dateFormatter;
    private static DateTimeFormat dateTimeFormatter;

    private TimeUtil() {
    }

    public static long daysToSecs(long days) {
        return TimeUtil.hoursToSecs(days * 24L);
    }

    public static long hoursToSecs(long hours) {
        return TimeUtil.minutesToSecs(hours * 60L);
    }

    public static long minutesToSecs(long minutes) {
        return minutes * 60L;
    }

    public static long secsToMillisecs(long secs) {
        return secs * 1000L;
    }

    public static long secsToDays(long secs) {
        return secs / 24L / 60L / 60L;
    }

    public static long secsToHours(long secs) {
        return secs / 60L / 60L;
    }

    public static long secsToMinutes(long secs) {
        return secs / 60L;
    }

    public static boolean isSecondsWholeDay(long secs) {
        return TimeUtil.daysToSecs(TimeUtil.secsToDays(secs)) == secs;
    }

    public static boolean isSecondsWholeHour(long secs) {
        return TimeUtil.hoursToSecs(TimeUtil.secsToHours(secs)) == secs;
    }

    public static boolean isSecondsWholeMinute(long secs) {
        return TimeUtil.minutesToSecs(TimeUtil.secsToMinutes(secs)) == secs;
    }

    public static TimeOfDay getTimeOfDayBy0To23Hour(String hour) {
        return Integer.parseInt(hour) < 12 ? TimeOfDay.AM : TimeOfDay.PM;
    }

    public static int to12HourClock(int int0To23hour) {
        assert (int0To23hour >= 0 && int0To23hour <= 23) : "int0To23hour is out of range";
        int int0To11 = int0To23hour < 12 ? int0To23hour : int0To23hour - 12;
        return int0To11;
    }

    public static String to12HourClock(String time) {
        String[] parts = time.split(":");
        int hour = Integer.parseInt(parts[0]);
        if (hour > 12) {
            hour -= 12;
        }
        if (hour == 0) {
            hour = 12;
        }
        return Integer.toString(hour) + ":" + parts[1] + ":" + parts[2];
    }

    public static int map0Through11To12Through11(int int0To11) {
        return int0To11 == 0 ? 12 : int0To11;
    }

    public static long millsecondsToSecs(long milliseconds) {
        return milliseconds / 1000L;
    }

    public static String getDateTimeString(String month, String dayInMonth, String year, String hour, String minute, String second, TimeOfDay timeOfDay) {
        return TimeUtil.getDateString(month, dayInMonth, year) + " " + hour + ":" + minute + ":" + second + " " + timeOfDay.toString();
    }

    public static Date getDateTime(String time, Date date) {
        String strDate = dateFormatter.format(date);
        return dateTimeFormatter.parse(strDate + " " + time);
    }

    public static Date getDate(String strDate) {
        return dateTimeFormatter.parse(strDate);
    }

    public static String getTimePart(String dateTime) {
        String[] parts = dateTime.split("\\s");
        return parts[3] + " " + parts[4];
    }

    public static String getTimePart(Date dateTime) {
        String strDateTime = dateTimeFormatter.format(dateTime);
        return TimeUtil.to12HourClock(TimeUtil.getTimePart(strDateTime));
    }

    public static String getDatePart(String dateTime) {
        String[] parts = dateTime.split("\\s");
        return parts[0] + " " + parts[1] + " " + parts[2];
    }

    public static String get0thTime() {
        return "12:00:00 " + TimeOfDay.AM.toString();
    }

    public static String zeroTimePart(String dateTime) {
        return TimeUtil.getDatePart(dateTime) + " " + TimeUtil.get0thTime();
    }

    public static Date zeroTimePart(Date dateTime) {
        return TimeUtil.getDateTime(TimeUtil.get0thTime(), dateTime);
    }

    public static String getDateString(String month, String dayInMonth, String year) {
        return month + " " + dayInMonth + ", " + year;
    }

    public static boolean isValidNumOfDaysForMonth(int numDays, MonthOfYear month) {
        if (numDays < 1) {
            return false;
        }
        return validNumDaysOfMonth.get((Object)month) <= numDays;
    }

    private static boolean isNumBetween(long low, long num, long high) {
        return num >= low && num <= high;
    }

    public static boolean isDayOfMonth(int num) {
        return TimeUtil.isNumBetween(1L, num, 31L);
    }

    public static boolean isDayOfWeek(int num) {
        return TimeUtil.isNumBetween(1L, num, 7L);
    }

    public static boolean isWeekOfMonth(int num) {
        return TimeUtil.isNumBetween(1L, num, 4L);
    }

    public static boolean isMonthOfYear(int num) {
        return TimeUtil.isNumBetween(1L, num, 12L);
    }

    public static boolean isSecond(int num) {
        return TimeUtil.isNumBetween(0L, num, 59L);
    }

    public static boolean isMinute(int num) {
        return TimeUtil.isNumBetween(0L, num, 59L);
    }

    public static boolean isHour(int num) {
        return TimeUtil.isNumBetween(0L, num, 23L);
    }

    public static void main(String[] args) {
        assert (TimeUtil.daysToSecs(13L) == 1123200L) : "";
        assert (TimeUtil.daysToSecs(13L) != 1123201L) : "";
        assert (TimeUtil.daysToSecs(13L) != 1123199L) : "";
        assert (TimeUtil.hoursToSecs(13L) == 46800L) : "";
        assert (TimeUtil.hoursToSecs(13L) != 46801L) : "";
        assert (TimeUtil.hoursToSecs(13L) != 46799L) : "";
        assert (TimeUtil.minutesToSecs(13L) == 780L) : "";
        assert (TimeUtil.minutesToSecs(13L) != 781L) : "";
        assert (TimeUtil.minutesToSecs(13L) != 779L) : "";
        assert (TimeUtil.secsToDays(1123200L) == 13L) : "";
        assert (TimeUtil.secsToDays(1123201L) != 13L) : "";
        assert (TimeUtil.secsToDays(1123199L) != 13L) : "";
        assert (TimeUtil.secsToHours(46800L) == 13L) : "";
        assert (TimeUtil.secsToHours(46801L) != 13L) : "";
        assert (TimeUtil.secsToHours(46799L) != 13L) : "";
        assert (TimeUtil.secsToMinutes(780L) == 13L) : "";
        assert (TimeUtil.secsToMinutes(781L) != 13L) : "";
        assert (TimeUtil.secsToMinutes(779L) != 13L) : "";
        assert (TimeUtil.isSecondsWholeDay(1123200L)) : "";
        assert (!TimeUtil.isSecondsWholeDay(1123201L)) : "";
        assert (!TimeUtil.isSecondsWholeDay(1123199L)) : "";
        assert (TimeUtil.isSecondsWholeHour(46800L)) : "";
        assert (!TimeUtil.isSecondsWholeHour(46801L)) : "";
        assert (!TimeUtil.isSecondsWholeHour(46799L)) : "";
        assert (TimeUtil.isSecondsWholeMinute(780L)) : "";
        assert (!TimeUtil.isSecondsWholeMinute(781L)) : "";
        assert (!TimeUtil.isSecondsWholeMinute(779L)) : "";
        assert (TimeUtil.getTimeOfDayBy0To23Hour("0") == TimeOfDay.AM) : "hour 0 is AM";
        assert (TimeUtil.getTimeOfDayBy0To23Hour("11") == TimeOfDay.AM) : "hour 11 is AM";
        assert (TimeUtil.getTimeOfDayBy0To23Hour("12") == TimeOfDay.PM) : "hour 12 is PM";
        assert (TimeUtil.getTimeOfDayBy0To23Hour("13") == TimeOfDay.PM) : "hour 13 is PM";
        assert (TimeUtil.getTimeOfDayBy0To23Hour("23") == TimeOfDay.PM) : "hour 23 is PM";
        assert (TimeUtil.to12HourClock(0) == 1) : "0 is 1";
        assert (TimeUtil.to12HourClock(11) == 12) : "11 is 12";
        assert (TimeUtil.to12HourClock(12) == 1) : "12 is 1";
        assert (TimeUtil.to12HourClock(23) == 11) : "23 is 11";
        System.out.println("done");
    }

    static {
        validNumDaysOfMonth.put(MonthOfYear.JAN, 31);
        validNumDaysOfMonth.put(MonthOfYear.FEB, 29);
        validNumDaysOfMonth.put(MonthOfYear.MAR, 31);
        validNumDaysOfMonth.put(MonthOfYear.APR, 30);
        validNumDaysOfMonth.put(MonthOfYear.MAY, 31);
        validNumDaysOfMonth.put(MonthOfYear.JUN, 30);
        validNumDaysOfMonth.put(MonthOfYear.JUL, 31);
        validNumDaysOfMonth.put(MonthOfYear.AUG, 31);
        validNumDaysOfMonth.put(MonthOfYear.SEPT, 30);
        validNumDaysOfMonth.put(MonthOfYear.OCT, 31);
        validNumDaysOfMonth.put(MonthOfYear.NOV, 30);
        validNumDaysOfMonth.put(MonthOfYear.DEC, 31);
        dateFormatter = DateTimeFormat.getLongDateFormat();
        dateTimeFormatter = DateTimeFormat.getFormat((String)MSGS.dateFormatLongMedium());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum WeekOfMonth {
        FIRST(0, TimeUtil.access$000().first()),
        SECOND(1, TimeUtil.access$000().second()),
        THIRD(2, TimeUtil.access$000().third()),
        FOURTH(3, TimeUtil.access$000().fourth()),
        LAST(4, TimeUtil.access$000().last());

        private final int value;
        private final String name;
        private static WeekOfMonth[] week;

        private WeekOfMonth(int value, String name) {
            this.value = value;
            this.name = name;
        }

        public int value() {
            return this.value;
        }

        public String toString() {
            return this.name;
        }

        public static WeekOfMonth get(int idx) {
            return week[idx];
        }

        public static int length() {
            return week.length;
        }

        public static WeekOfMonth stringToWeekOfMonth(String weekOfMonth) throws EnumException {
            for (WeekOfMonth v : EnumSet.range(FIRST, LAST)) {
                if (!v.toString().equals(weekOfMonth)) continue;
                return v;
            }
            throw new EnumException(MSGS.invalidStringForWeekOfMonth(weekOfMonth));
        }

        static {
            week = new WeekOfMonth[]{FIRST, SECOND, THIRD, FOURTH, LAST};
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MonthOfYear {
        JAN(0, TimeUtil.access$000().january()),
        FEB(1, TimeUtil.access$000().february()),
        MAR(2, TimeUtil.access$000().march()),
        APR(3, TimeUtil.access$000().april()),
        MAY(4, TimeUtil.access$000().may()),
        JUN(5, TimeUtil.access$000().june()),
        JUL(6, TimeUtil.access$000().july()),
        AUG(7, TimeUtil.access$000().august()),
        SEPT(8, TimeUtil.access$000().september()),
        OCT(9, TimeUtil.access$000().october()),
        NOV(10, TimeUtil.access$000().november()),
        DEC(11, TimeUtil.access$000().december());

        private final int value;
        private final String name;
        private static MonthOfYear[] year;

        private MonthOfYear(int value, String name) {
            this.value = value;
            this.name = name;
        }

        public int value() {
            return this.value;
        }

        public String toString() {
            return this.name;
        }

        public static MonthOfYear get(int idx) {
            return year[idx];
        }

        public static int length() {
            return year.length;
        }

        static {
            year = new MonthOfYear[]{JAN, FEB, MAR, APR, MAY, JUN, JUL, AUG, SEPT, OCT, NOV, DEC};
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DayOfWeek {
        SUN(0, TimeUtil.access$000().sunday()),
        MON(1, TimeUtil.access$000().monday()),
        TUES(2, TimeUtil.access$000().tuesday()),
        WED(3, TimeUtil.access$000().wednesday()),
        THUR(4, TimeUtil.access$000().thursday()),
        FRI(5, TimeUtil.access$000().friday()),
        SAT(6, TimeUtil.access$000().saturday());

        private final int value;
        private final String name;
        private static DayOfWeek[] week;

        private DayOfWeek(int value, String name) {
            this.value = value;
            this.name = name;
        }

        public int value() {
            return this.value;
        }

        public String toString() {
            return this.name;
        }

        public static DayOfWeek get(int idx) {
            return week[idx];
        }

        public static int length() {
            return week.length;
        }

        static {
            week = new DayOfWeek[]{SUN, MON, TUES, WED, THUR, FRI, SAT};
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TimeOfDay {
        AM(0, TimeUtil.access$000().am()),
        PM(1, TimeUtil.access$000().pm());

        private final int value;
        private final String name;
        private static TimeOfDay[] timeOfDay;

        private TimeOfDay(int value, String name) {
            this.value = value;
            this.name = name;
        }

        public int value() {
            return this.value;
        }

        public String toString() {
            return this.name;
        }

        public static TimeOfDay get(int idx) {
            return timeOfDay[idx];
        }

        public static int length() {
            return timeOfDay.length;
        }

        public static TimeOfDay stringToTimeOfDay(String timeOfDay) throws EnumException {
            for (TimeOfDay v : EnumSet.range(AM, PM)) {
                if (!v.toString().equals(timeOfDay)) continue;
                return v;
            }
            throw new EnumException(MSGS.invalidStringForTimeOfDay(timeOfDay));
        }

        static {
            timeOfDay = new TimeOfDay[]{AM, PM};
        }
    }
}

