/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.gwt.widgets.client.utils.i18n;

import com.google.gwt.http.client.Header;
import com.google.gwt.http.client.Request;
import com.google.gwt.http.client.RequestBuilder;
import com.google.gwt.http.client.RequestCallback;
import com.google.gwt.http.client.RequestException;
import com.google.gwt.http.client.Response;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.DeferredCommand;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.HTML;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.pentaho.gwt.widgets.client.utils.i18n.IResourceBundleLoadCallback;
import org.pentaho.gwt.widgets.client.utils.i18n.PropertiesUtil;
import org.pentaho.gwt.widgets.client.utils.string.StringTokenizer;
import org.pentaho.gwt.widgets.client.utils.string.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceBundle {
    private static final Map<String, String> bundleCache = new HashMap<String, String>();
    public static final String PROPERTIES_EXTENSION = ".properties";
    private HashMap<String, String> bundle = new HashMap();
    private RequestCallback baseCallback = null;
    private RequestCallback langCallback = null;
    private RequestCallback langCountryCallback = null;
    private String path = null;
    private String bundleName = null;
    private IResourceBundleLoadCallback bundleLoadCallback = null;
    private String localeName = StringUtils.defaultIfEmpty(Window.Location.getParameter((String)"locale"), ResourceBundle.getLanguagePreference());
    private String currentAttemptUrl = null;
    private boolean attemptLocalizedFetches = true;
    private Map<String, String> supportedLanguages = null;
    private static HTML entityDecoder = new HTML();

    public ResourceBundle() {
    }

    public ResourceBundle(String path, String bundleName, boolean attemptLocalizedFetches, IResourceBundleLoadCallback bundleLoadCallback) {
        this();
        this.loadBundle(path, bundleName, attemptLocalizedFetches, bundleLoadCallback);
    }

    public void loadBundle(String path, final String bundleName, boolean attemptLocalizedFetches, IResourceBundleLoadCallback bundleLoadCallback) {
        this.bundleName = bundleName;
        this.bundleLoadCallback = bundleLoadCallback;
        this.attemptLocalizedFetches = attemptLocalizedFetches;
        if (!StringUtils.isEmpty(path) && !path.endsWith("/")) {
            path = path + "/";
        }
        this.path = path;
        this.initCallbacks();
        final ResourceBundle supportedLanguagesBundle = new ResourceBundle();
        IResourceBundleLoadCallback supportedLangCallback = new IResourceBundleLoadCallback(){

            public void bundleLoaded(String ignore) {
                if (ResourceBundle.this.supportedLanguages == null) {
                    ResourceBundle.this.supportedLanguages = supportedLanguagesBundle.getMap();
                }
                ResourceBundle.this.currentAttemptUrl = ResourceBundle.this.path + bundleName + ResourceBundle.PROPERTIES_EXTENSION + ResourceBundle.this.getUrlExtras();
                if (bundleCache.containsKey(ResourceBundle.this.currentAttemptUrl)) {
                    DeferredCommand.addCommand((Command)new Command(){

                        public void execute() {
                            ResourceBundle.this.baseCallback.onResponseReceived(null, (Response)new FakeResponse((String)bundleCache.get(ResourceBundle.this.currentAttemptUrl)));
                        }
                    });
                } else {
                    RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.GET, ResourceBundle.this.currentAttemptUrl);
                    try {
                        requestBuilder.sendRequest(null, ResourceBundle.this.baseCallback);
                    }
                    catch (RequestException e) {
                        Window.alert((String)("base load: " + e.getMessage()));
                        ResourceBundle.this.fireBundleLoadCallback();
                    }
                }
            }
        };
        if (attemptLocalizedFetches && this.supportedLanguages == null) {
            supportedLanguagesBundle.loadBundle(path, bundleName + "_supported_languages", false, supportedLangCallback);
        } else {
            supportedLangCallback.bundleLoaded(bundleName + "_supported_languages");
        }
    }

    private void initCallbacks() {
        this.baseCallback = new RequestCallback(){

            public void onError(Request request, Throwable exception) {
                Window.alert((String)("baseCallback: " + exception.getMessage()));
                ResourceBundle.this.fireBundleLoadCallback();
            }

            public void onResponseReceived(Request request, Response response) {
                String propertiesFileText = response.getText();
                if (response.getStatusCode() == 200) {
                    ResourceBundle.this.bundle = PropertiesUtil.buildProperties(propertiesFileText, ResourceBundle.this.bundle);
                    if (!(response instanceof FakeResponse)) {
                        bundleCache.put(ResourceBundle.this.currentAttemptUrl, propertiesFileText);
                    }
                } else {
                    bundleCache.put(ResourceBundle.this.currentAttemptUrl, "");
                }
                if (!ResourceBundle.this.attemptLocalizedFetches) {
                    ResourceBundle.this.fireBundleLoadCallback();
                    return;
                }
                if (ResourceBundle.this.localeName.equalsIgnoreCase("default")) {
                    ResourceBundle.this.fireBundleLoadCallback();
                    return;
                }
                StringTokenizer st = new StringTokenizer(ResourceBundle.this.localeName, '_');
                if (st.countTokens() > 0) {
                    String lang = st.tokenAt(0);
                    ResourceBundle.this.currentAttemptUrl = ResourceBundle.this.path + ResourceBundle.this.bundleName + "_" + lang + ResourceBundle.PROPERTIES_EXTENSION + ResourceBundle.this.getUrlExtras();
                    if (!ResourceBundle.this.isSupportedLanguage(lang) || bundleCache.containsKey(ResourceBundle.this.currentAttemptUrl)) {
                        ResourceBundle.this.langCallback.onResponseReceived(null, (Response)new FakeResponse((String)bundleCache.get(ResourceBundle.this.currentAttemptUrl)));
                    } else {
                        RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.GET, ResourceBundle.this.currentAttemptUrl);
                        requestBuilder.setHeader("Cache-Control", "no-cache");
                        try {
                            requestBuilder.sendRequest(null, ResourceBundle.this.langCallback);
                        }
                        catch (RequestException e) {
                            Window.alert((String)("lang: " + e.getMessage()));
                            ResourceBundle.this.fireBundleLoadCallback();
                        }
                    }
                } else if (st.countTokens() == 0) {
                    ResourceBundle.this.fireBundleLoadCallback();
                    return;
                }
            }
        };
        this.langCallback = new RequestCallback(){

            public void onError(Request request, Throwable exception) {
                Window.alert((String)("langCallback: " + exception.getMessage()));
                ResourceBundle.this.fireBundleLoadCallback();
            }

            public void onResponseReceived(Request request, Response response) {
                StringTokenizer st;
                String propertiesFileText = response.getText();
                if (response.getStatusCode() == 200) {
                    ResourceBundle.this.bundle = PropertiesUtil.buildProperties(propertiesFileText, ResourceBundle.this.bundle);
                    if (!(response instanceof FakeResponse)) {
                        bundleCache.put(ResourceBundle.this.currentAttemptUrl, propertiesFileText);
                    }
                } else {
                    bundleCache.put(ResourceBundle.this.currentAttemptUrl, "");
                }
                if ((st = new StringTokenizer(ResourceBundle.this.localeName, '_')).countTokens() == 2) {
                    ResourceBundle.this.currentAttemptUrl = ResourceBundle.this.path + ResourceBundle.this.bundleName + "_" + ResourceBundle.this.localeName + ResourceBundle.PROPERTIES_EXTENSION + ResourceBundle.this.getUrlExtras();
                    if (!ResourceBundle.this.isSupportedLanguage(ResourceBundle.this.localeName) || bundleCache.containsKey(ResourceBundle.this.currentAttemptUrl)) {
                        ResourceBundle.this.langCountryCallback.onResponseReceived(null, (Response)new FakeResponse((String)bundleCache.get(ResourceBundle.this.currentAttemptUrl)));
                    } else {
                        RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.GET, ResourceBundle.this.currentAttemptUrl);
                        try {
                            requestBuilder.sendRequest(null, ResourceBundle.this.langCountryCallback);
                        }
                        catch (RequestException e) {
                            Window.alert((String)("langCountry: " + e.getMessage()));
                            ResourceBundle.this.fireBundleLoadCallback();
                        }
                    }
                } else {
                    ResourceBundle.this.fireBundleLoadCallback();
                    return;
                }
            }
        };
        this.langCountryCallback = new RequestCallback(){

            public void onError(Request request, Throwable exception) {
                Window.alert((String)("langCountryCallback: " + exception.getMessage()));
                ResourceBundle.this.fireBundleLoadCallback();
            }

            public void onResponseReceived(Request request, Response response) {
                String propertiesFileText = response.getText();
                if (response.getStatusCode() == 200) {
                    ResourceBundle.this.bundle = PropertiesUtil.buildProperties(propertiesFileText, ResourceBundle.this.bundle);
                    if (!(response instanceof FakeResponse)) {
                        bundleCache.put(ResourceBundle.this.currentAttemptUrl, propertiesFileText);
                    }
                } else {
                    bundleCache.put(ResourceBundle.this.currentAttemptUrl, "");
                }
                ResourceBundle.this.fireBundleLoadCallback();
            }
        };
    }

    private void fireBundleLoadCallback() {
        if (this.bundleLoadCallback != null) {
            this.bundleLoadCallback.bundleLoaded(this.bundleName);
        }
    }

    public String getString(String key) {
        String resource = this.bundle.get(key);
        if (resource == null) {
            return key;
        }
        return this.decodeUTF8(resource);
    }

    public String getString(String key, String defaultValue) {
        String resource = this.bundle.get(key);
        if (resource == null) {
            return defaultValue;
        }
        return this.decodeUTF8(resource);
    }

    public String getString(String key, String defaultValue, String ... parameters) {
        String resource = this.bundle.get(key);
        if (resource == null) {
            return defaultValue;
        }
        for (int i = 0; i < parameters.length; ++i) {
            resource = resource.replace("{" + i + "}", parameters[i]);
        }
        return this.decodeUTF8(resource);
    }

    public Set<String> getKeys() {
        return this.bundle.keySet();
    }

    public Map<String, String> getMap() {
        return this.bundle;
    }

    public static void clearCache() {
        bundleCache.clear();
    }

    public void mergeResourceBundle(ResourceBundle inBundle) {
        this.bundle.putAll(inBundle.bundle);
    }

    private String decodeUTF8(String str) {
        if (str == null) {
            return str;
        }
        while (str.indexOf("\\u") != -1) {
            int index = str.indexOf("\\u");
            String hex = str.substring(index + 2, index + 6);
            str = str.substring(0, index) + "&#x" + hex + ";" + str.substring(index + 6);
            entityDecoder.setHTML(str);
            str = entityDecoder.getHTML();
        }
        return str;
    }

    public boolean isSupportedLanguage(String languageCode) {
        if (this.supportedLanguages == null) {
            return true;
        }
        boolean returnValue = this.supportedLanguages.containsKey(languageCode);
        return returnValue;
    }

    public Map<String, String> getSupportedLanguages() {
        return this.supportedLanguages;
    }

    public void setSupportedLanguages(Map<String, String> supportedLanguages) {
        this.supportedLanguages = supportedLanguages;
    }

    private native String getUrlExtras();

    private static native String getLanguagePreference();

    private class FakeResponse
    extends Response {
        private String text;

        public FakeResponse(String text) {
            this.text = text;
        }

        public String getHeader(String arg0) {
            return null;
        }

        public Header[] getHeaders() {
            return null;
        }

        public String getHeadersAsString() {
            return null;
        }

        public int getStatusCode() {
            return 200;
        }

        public String getStatusText() {
            return null;
        }

        public String getText() {
            return this.text;
        }
    }
}

