/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.gwt.widgets.client.utils.string;

public class StringUtils {
    private static final String MATCH_POSITIVE_INTEGER_RE = "^\\s*[0-9]{1,10}\\s*$";

    public static boolean isEmpty(String str) {
        return null == str || "".equals(str.trim());
    }

    public static String defaultString(String str, String xdefault) {
        return StringUtils.isEmpty(str) ? xdefault : str;
    }

    public static String defaultString(String str) {
        return StringUtils.isEmpty(str) ? "" : str;
    }

    public static String defaultIfEmpty(String str, String xdefault) {
        return StringUtils.isEmpty(str) ? xdefault : str;
    }

    public static String addStringToInt(String strAddend, int addend) {
        return Integer.toString(Integer.parseInt(strAddend) + addend);
    }

    public static String multiplyStringWithInt(String strMultiplicand, int multiplier) {
        return Integer.toString(Integer.parseInt(strMultiplicand) * multiplier);
    }

    public static String divideStringWithInt(String strDividend, int divisor) {
        return Integer.toString(Integer.parseInt(strDividend) / divisor);
    }

    public static boolean containsAnyChars(String str, String checkChars) {
        if (StringUtils.isEmpty(str) || StringUtils.isEmpty(checkChars)) {
            return false;
        }
        for (int i = 0; i < checkChars.length(); ++i) {
            if (str.indexOf(checkChars.charAt(i)) < 0) continue;
            return true;
        }
        return false;
    }

    public static boolean isPositiveInteger(String strInt) {
        int length = strInt.length();
        if (length > 10) {
            return false;
        }
        if (length == 10) {
            if (strInt.matches(MATCH_POSITIVE_INTEGER_RE)) {
                try {
                    Integer.parseInt(strInt);
                    return true;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return false;
        }
        return strInt.matches(MATCH_POSITIVE_INTEGER_RE);
    }
}

