/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.gwt.widgets.client.wizards;

import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.DeckPanel;
import com.google.gwt.user.client.ui.DockPanel;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import org.pentaho.gwt.widgets.client.dialogs.DialogBox;
import org.pentaho.gwt.widgets.client.i18n.WidgetsLocalizedMessages;
import org.pentaho.gwt.widgets.client.i18n.WidgetsLocalizedMessagesSingleton;
import org.pentaho.gwt.widgets.client.wizards.IWizardPanel;
import org.pentaho.gwt.widgets.client.wizards.IWizardPanelListener;

public abstract class AbstractWizardDialog
extends DialogBox
implements IWizardPanelListener {
    private static final WidgetsLocalizedMessages MSGS = WidgetsLocalizedMessagesSingleton.getInstance().getMessages();
    private static final int STEPS_COUNT = 15;
    private static final String WIZARD_DECK_PANEL = "pentaho-wizard-deck-panel";
    private static final String WIZARD_BUTTON_PANEL = "pentaho-wizard-button-panel";
    Button backButton = new Button(MSGS.back());
    Button nextButton = new Button(MSGS.next());
    Button cancelButton = new Button(MSGS.cancel());
    Button finishButton = new Button(MSGS.finish());
    ListBox steps = new ListBox();
    DeckPanel wizardDeckPanel = new DeckPanel();
    VerticalPanel stepsList = new VerticalPanel();
    private IWizardPanel[] wizardPanels;
    private boolean canceled = false;

    public AbstractWizardDialog(String title, IWizardPanel[] panels, boolean autohide, boolean modal) {
        super(autohide, modal);
        this.setText(title);
        this.init();
        this.layout();
        this.setWizardPanels(panels);
        this.show();
    }

    protected void init() {
        this.backButton.setStyleName("pentaho-button");
        this.nextButton.setStyleName("pentaho-button");
        this.cancelButton.setStyleName("pentaho-button");
        this.finishButton.setStyleName("pentaho-button");
        this.nextButton.addClickListener(new ClickListener(){

            public void onClick(Widget sender) {
                IWizardPanel previousPanel;
                int oldIndex = AbstractWizardDialog.this.steps.getSelectedIndex();
                int newIndex = oldIndex + 1;
                IWizardPanel nextPanel = (IWizardPanel)AbstractWizardDialog.this.wizardDeckPanel.getWidget(newIndex);
                if (!AbstractWizardDialog.this.onNext(nextPanel, previousPanel = (IWizardPanel)AbstractWizardDialog.this.wizardDeckPanel.getWidget(oldIndex))) {
                    return;
                }
                previousPanel.removeWizardPanelListener(AbstractWizardDialog.this);
                nextPanel.addWizardPanelListener(AbstractWizardDialog.this);
                AbstractWizardDialog.this.updateGUI(newIndex);
            }
        });
        this.backButton.addClickListener(new ClickListener(){

            public void onClick(Widget sender) {
                IWizardPanel currentPanel;
                int oldIndex = AbstractWizardDialog.this.wizardDeckPanel.getVisibleWidget();
                int newIndex = oldIndex - 1;
                IWizardPanel previousPanel = (IWizardPanel)AbstractWizardDialog.this.wizardDeckPanel.getWidget(newIndex);
                if (!AbstractWizardDialog.this.onPrevious(previousPanel, currentPanel = (IWizardPanel)AbstractWizardDialog.this.wizardDeckPanel.getWidget(oldIndex))) {
                    return;
                }
                currentPanel.removeWizardPanelListener(AbstractWizardDialog.this);
                previousPanel.addWizardPanelListener(AbstractWizardDialog.this);
                AbstractWizardDialog.this.updateGUI(newIndex);
            }
        });
        this.cancelButton.addClickListener(new ClickListener(){

            public void onClick(Widget sender) {
                AbstractWizardDialog.this.canceled = true;
                AbstractWizardDialog.this.hide();
            }
        });
        this.finishButton.addClickListener(new ClickListener(){

            public void onClick(Widget sender) {
                if (AbstractWizardDialog.this.onFinish()) {
                    AbstractWizardDialog.this.hide();
                }
            }
        });
        this.steps.setEnabled(false);
    }

    protected void updateGUI(int index) {
        this.stepsList.setVisible(this.wizardDeckPanel.getWidgetCount() > 1);
        this.backButton.setVisible(this.wizardDeckPanel.getWidgetCount() > 1);
        this.nextButton.setVisible(this.wizardDeckPanel.getWidgetCount() > 1);
        this.steps.setSelectedIndex(index);
        this.wizardDeckPanel.showWidget(index);
        this.nextButton.setEnabled(((IWizardPanel)this.wizardDeckPanel.getWidget(index)).canContinue() && index < this.wizardDeckPanel.getWidgetCount() - 1);
        this.backButton.setEnabled(index > 0);
        this.finishButton.setEnabled(((IWizardPanel)this.wizardDeckPanel.getWidget(index)).canFinish());
    }

    protected void layout() {
        SimplePanel deckWrapper = new SimplePanel();
        deckWrapper.setHeight("100%");
        deckWrapper.setWidth("100%");
        deckWrapper.setStyleName("dialog-content");
        DockPanel content = new DockPanel();
        this.stepsList = new VerticalPanel();
        this.stepsList.add((Widget)new Label(MSGS.steps()));
        this.steps.setVisibleItemCount(15);
        this.stepsList.add((Widget)this.steps);
        content.add((Widget)this.stepsList, DockPanel.WEST);
        deckWrapper.setWidget((Widget)this.wizardDeckPanel);
        content.add((Widget)deckWrapper, DockPanel.CENTER);
        this.wizardDeckPanel.addStyleName(WIZARD_DECK_PANEL);
        HorizontalPanel wizardButtonPanel = new HorizontalPanel();
        wizardButtonPanel.setSpacing(2);
        wizardButtonPanel.add((Widget)this.backButton);
        wizardButtonPanel.add((Widget)this.nextButton);
        wizardButtonPanel.add((Widget)this.finishButton);
        wizardButtonPanel.add((Widget)this.cancelButton);
        wizardButtonPanel.addStyleName(WIZARD_BUTTON_PANEL);
        HorizontalPanel wizardButtonPanelWrapper = new HorizontalPanel();
        wizardButtonPanelWrapper.setWidth("100%");
        wizardButtonPanelWrapper.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_RIGHT);
        wizardButtonPanelWrapper.setVerticalAlignment(HasVerticalAlignment.ALIGN_BOTTOM);
        wizardButtonPanelWrapper.add((Widget)wizardButtonPanel);
        content.add((Widget)wizardButtonPanelWrapper, DockPanel.SOUTH);
        content.setCellVerticalAlignment((Widget)wizardButtonPanelWrapper, HasVerticalAlignment.ALIGN_BOTTOM);
        this.add((Widget)content);
        content.setWidth("100%");
        content.setHeight("100%");
    }

    public void setWizardPanels(IWizardPanel[] wizardPanels) {
        this.wizardPanels = wizardPanels;
        this.steps.clear();
        this.wizardDeckPanel.clear();
        if (wizardPanels != null && wizardPanels.length > 0) {
            for (IWizardPanel panel : wizardPanels) {
                this.steps.addItem(panel.getName());
                this.wizardDeckPanel.add((Widget)panel);
            }
            ((IWizardPanel)this.wizardDeckPanel.getWidget(0)).addWizardPanelListener(this);
            if (wizardPanels.length == 1) {
                this.finishButton.setText(MSGS.ok());
            }
            this.updateGUI(0);
        }
    }

    public IWizardPanel[] getWizardPanels() {
        return this.wizardPanels;
    }

    public void panelUpdated(IWizardPanel wizardPanel) {
        int index = this.wizardDeckPanel.getVisibleWidget();
        int lastPanelIndex = this.wizardDeckPanel.getWidgetCount() - 1;
        this.nextButton.setEnabled(wizardPanel.canContinue() && index < lastPanelIndex);
        this.finishButton.setEnabled(wizardPanel.canFinish());
    }

    public boolean wasCancelled() {
        return this.canceled;
    }

    protected abstract boolean onFinish();

    protected abstract boolean onNext(IWizardPanel var1, IWizardPanel var2);

    protected abstract boolean onPrevious(IWizardPanel var1, IWizardPanel var2);
}

