/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.gwt.widgets.client.wizards.panels.validators;

import org.pentaho.gwt.widgets.client.controls.schededitor.RecurrenceEditor;
import org.pentaho.gwt.widgets.client.utils.StringUtils;
import org.pentaho.gwt.widgets.client.utils.TimeUtil;
import org.pentaho.gwt.widgets.client.wizards.panels.validators.DateRangeEditorValidator;
import org.pentaho.gwt.widgets.client.wizards.panels.validators.IUiValidator;

public class RecurrenceEditorValidator
implements IUiValidator {
    private RecurrenceEditor recurrenceEditor = null;
    private DateRangeEditorValidator dateRangeEditorValidator = null;

    public RecurrenceEditorValidator(RecurrenceEditor recurrenceEditor) {
        this.recurrenceEditor = recurrenceEditor;
        this.dateRangeEditorValidator = new DateRangeEditorValidator(recurrenceEditor.getDateRangeEditor());
    }

    public boolean isValid() {
        boolean isValid = true;
        switch (this.recurrenceEditor.getTemporalState()) {
            case SECONDS: {
                RecurrenceEditor.SecondlyRecurrenceEditor sEd = this.recurrenceEditor.getSecondlyEditor();
                String seconds = sEd.getValue();
                if (!StringUtils.isPositiveInteger(seconds) || Integer.parseInt(seconds) <= 0) {
                    isValid = false;
                }
                if (Integer.parseInt(seconds) <= 2147483) break;
                isValid = false;
                break;
            }
            case MINUTES: {
                RecurrenceEditor.MinutelyRecurrenceEditor mEd = this.recurrenceEditor.getMinutelyEditor();
                String minutes = mEd.getValue();
                if (!StringUtils.isPositiveInteger(minutes) || Integer.parseInt(minutes) <= 0) {
                    isValid = false;
                }
                if (Integer.parseInt(minutes) <= 35791) break;
                isValid = false;
                break;
            }
            case HOURS: {
                RecurrenceEditor.HourlyRecurrenceEditor hEd = this.recurrenceEditor.getHourlyEditor();
                String hours = hEd.getValue();
                if (!StringUtils.isPositiveInteger(hours) || Integer.parseInt(hours) <= 0) {
                    isValid = false;
                }
                if (Integer.parseInt(hours) <= 596) break;
                isValid = false;
                break;
            }
            case DAILY: {
                String days;
                RecurrenceEditor.DailyRecurrenceEditor dEd = this.recurrenceEditor.getDailyEditor();
                if (!dEd.isEveryNDays() || StringUtils.isPositiveInteger(days = dEd.getRepeatValue()) && Integer.parseInt(days) > 0) break;
                isValid = false;
                break;
            }
            case WEEKLY: {
                RecurrenceEditor.WeeklyRecurrenceEditor wEd = this.recurrenceEditor.getWeeklyEditor();
                if (wEd.getNumCheckedDays() >= 1) break;
                isValid = false;
                break;
            }
            case MONTHLY: {
                String dayNOfMonth;
                RecurrenceEditor.MonthlyRecurrenceEditor monthlyEd = this.recurrenceEditor.getMonthlyEditor();
                if (!monthlyEd.isDayNOfMonth() || StringUtils.isPositiveInteger(dayNOfMonth = monthlyEd.getDayOfMonth()) && TimeUtil.isDayOfMonth(Integer.parseInt(dayNOfMonth))) break;
                isValid = false;
                break;
            }
            case YEARLY: {
                String dayNOfMonth;
                RecurrenceEditor.YearlyRecurrenceEditor yearlyEd = this.recurrenceEditor.getYearlyEditor();
                if (!yearlyEd.isEveryMonthOnNthDay() || StringUtils.isPositiveInteger(dayNOfMonth = yearlyEd.getDayOfMonth()) && TimeUtil.isDayOfMonth(Integer.parseInt(dayNOfMonth))) break;
                isValid = false;
                break;
            }
        }
        return isValid &= this.dateRangeEditorValidator.isValid();
    }

    public void clear() {
        this.recurrenceEditor.getSecondlyEditor().setValueError(null);
        this.recurrenceEditor.getMinutelyEditor().setValueError(null);
        this.recurrenceEditor.getHourlyEditor().setValueError(null);
        this.recurrenceEditor.getDailyEditor().setRepeatError(null);
        this.recurrenceEditor.getWeeklyEditor().setEveryDayOnError(null);
        this.recurrenceEditor.getMonthlyEditor().setDayNOfMonthError(null);
        this.recurrenceEditor.getYearlyEditor().setDayOfMonthError(null);
        this.dateRangeEditorValidator.clear();
    }
}

