/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.gwt.widgets.client.wizards.panels.validators;

import org.pentaho.gwt.widgets.client.controls.schededitor.ScheduleEditor;
import org.pentaho.gwt.widgets.client.utils.StringUtils;
import org.pentaho.gwt.widgets.client.wizards.panels.validators.CronEditorValidator;
import org.pentaho.gwt.widgets.client.wizards.panels.validators.IUiValidator;
import org.pentaho.gwt.widgets.client.wizards.panels.validators.RecurrenceEditorValidator;
import org.pentaho.gwt.widgets.client.wizards.panels.validators.RunOnceEditorValidator;

public class ScheduleEditorValidator
implements IUiValidator {
    protected ScheduleEditor schedEd;
    protected RecurrenceEditorValidator recurrenceEditorValidator;
    protected RunOnceEditorValidator runOnceEditorValidator;
    protected CronEditorValidator cronEditorValidator;

    public ScheduleEditorValidator(ScheduleEditor schedEd) {
        this.schedEd = schedEd;
        this.recurrenceEditorValidator = new RecurrenceEditorValidator(this.schedEd.getRecurrenceEditor());
        this.runOnceEditorValidator = new RunOnceEditorValidator(this.schedEd.getRunOnceEditor());
        this.cronEditorValidator = new CronEditorValidator(this.schedEd.getCronEditor());
    }

    public boolean isValid() {
        boolean isValid = true;
        if (StringUtils.isEmpty(this.schedEd.getName())) {
            isValid = false;
        }
        if (StringUtils.isEmpty(this.schedEd.getGroupName())) {
            isValid = false;
        }
        switch (this.schedEd.getScheduleType()) {
            case RUN_ONCE: {
                isValid &= this.runOnceEditorValidator.isValid();
                break;
            }
            case SECONDS: 
            case MINUTES: 
            case HOURS: 
            case DAILY: 
            case WEEKLY: 
            case MONTHLY: 
            case YEARLY: {
                isValid &= this.recurrenceEditorValidator.isValid();
                break;
            }
            case CRON: {
                isValid &= this.cronEditorValidator.isValid();
                break;
            }
        }
        return isValid;
    }

    public void clear() {
        this.schedEd.setNameError(null);
        this.schedEd.setGroupNameError(null);
        this.recurrenceEditorValidator.clear();
        this.runOnceEditorValidator.clear();
        this.cronEditorValidator.clear();
    }
}

