/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.gwt.widgets.login.client;

import com.google.gwt.http.client.Request;
import com.google.gwt.http.client.RequestBuilder;
import com.google.gwt.http.client.RequestCallback;
import com.google.gwt.http.client.RequestException;
import com.google.gwt.http.client.Response;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import org.pentaho.gwt.widgets.client.dialogs.IDialogCallback;
import org.pentaho.gwt.widgets.client.dialogs.MessageDialogBox;
import org.pentaho.gwt.widgets.login.client.AuthenticationCanceledException;
import org.pentaho.gwt.widgets.login.client.AuthenticationFailedException;
import org.pentaho.gwt.widgets.login.client.IAuthenticatedGwtCommand;
import org.pentaho.gwt.widgets.login.client.LoginDialog;
import org.pentaho.gwt.widgets.login.client.messages.Messages;

public class AuthenticatedGwtServiceUtil {
    private AuthenticatedGwtServiceUtil() {
    }

    public static void invokeCommand(final IAuthenticatedGwtCommand command, final AsyncCallback theirCallback) {
        command.execute(new AsyncCallback(){

            public void onFailure(final Throwable caught) {
                String[] pathArray = Window.Location.getPath().split("/");
                String webAppPath = "/" + pathArray[1] + "/";
                RequestBuilder builder = new RequestBuilder(RequestBuilder.GET, webAppPath + "mantle/images/spacer.gif");
                builder.setHeader("Content-Type", "application/xml");
                RequestCallback callback = new RequestCallback(){

                    public void onError(Request request, Throwable exception) {
                        theirCallback.onFailure(caught);
                    }

                    public void onResponseReceived(Request request, Response response) {
                        if (401 == response.getStatusCode()) {
                            AuthenticatedGwtServiceUtil.doLogin(command, theirCallback);
                        } else {
                            theirCallback.onFailure(caught);
                        }
                    }
                };
                try {
                    builder.sendRequest("", callback);
                }
                catch (RequestException e) {
                    e.printStackTrace();
                }
            }

            public void onSuccess(Object result) {
                theirCallback.onSuccess(result);
            }
        });
    }

    private static void doLogin(final IAuthenticatedGwtCommand command, final AsyncCallback theirCallback) {
        if (LoginDialog.isHidden()) {
            LoginDialog.performLogin((AsyncCallback)new AsyncCallback<Object>(){

                public void onFailure(Throwable caught) {
                    if (caught instanceof AuthenticationFailedException) {
                        MessageDialogBox dialogBox = new MessageDialogBox(Messages.getString("error"), Messages.getString("invalidLogin"), false, false, true);
                        dialogBox.addStyleName("error-login-dialog");
                        dialogBox.setCallback(new IDialogCallback(){

                            public void cancelPressed() {
                            }

                            public void okPressed() {
                                AuthenticatedGwtServiceUtil.doLogin(command, theirCallback);
                            }
                        });
                        dialogBox.center();
                    } else if (caught instanceof AuthenticationCanceledException) {
                        theirCallback.onFailure(caught);
                    }
                }

                public void onSuccess(Object result) {
                    AuthenticatedGwtServiceUtil.invokeCommand(command, theirCallback);
                }
            });
        }
    }
}

