/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.gwt.widgets.login.client;

import com.google.gwt.http.client.Request;
import com.google.gwt.http.client.RequestBuilder;
import com.google.gwt.http.client.RequestCallback;
import com.google.gwt.http.client.RequestException;
import com.google.gwt.http.client.Response;
import com.google.gwt.http.client.URL;
import com.google.gwt.user.client.Cookies;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.ChangeListener;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.FocusWidget;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.PasswordTextBox;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.LinkedHashMap;
import java.util.Map;
import org.pentaho.gwt.widgets.client.dialogs.IDialogCallback;
import org.pentaho.gwt.widgets.client.dialogs.PromptDialogBox;
import org.pentaho.gwt.widgets.client.utils.StringTokenizer;
import org.pentaho.gwt.widgets.login.client.AuthenticationCanceledException;
import org.pentaho.gwt.widgets.login.client.AuthenticationFailedException;
import org.pentaho.gwt.widgets.login.client.messages.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoginDialog
extends PromptDialogBox {
    private AsyncCallback<Boolean> outerCallback;
    private final TextBox userTextBox = new TextBox();
    private final ListBox usersListBox = new ListBox();
    private final PasswordTextBox passwordTextBox = new PasswordTextBox();
    private CheckBox newWindowChk = new CheckBox();
    private String returnLocation = null;
    private static boolean showUsersList = false;
    private static boolean showNewWindowOption = false;
    private static boolean openInNewWindowDefault = false;
    private static LoginDialog loginDialog;
    private static LinkedHashMap<String, String[]> defaultUsers;
    private final IDialogCallback myCallback = new IDialogCallback(){

        public void cancelPressed() {
            LoginDialog.this.outerCallback.onFailure((Throwable)new AuthenticationCanceledException(Messages.getString("authCanceled")));
        }

        public void okPressed() {
            RequestBuilder builder = new RequestBuilder(RequestBuilder.POST, LoginDialog.this.getWebAppPath() + "j_spring_security_check");
            String username = LoginDialog.this.userTextBox.getText();
            String password = LoginDialog.this.passwordTextBox.getText();
            String requestData = "j_username=" + URL.encodeComponent((String)username) + "&j_password=" + URL.encodeComponent((String)password);
            builder.setHeader("Content-Type", "application/x-www-form-urlencoded");
            RequestCallback callback = new RequestCallback(){

                public void onError(Request request, Throwable exception) {
                    LoginDialog.this.outerCallback.onFailure(exception);
                }

                public void onResponseReceived(Request request, Response response) {
                    if (200 == response.getStatusCode()) {
                        LoginDialog.this.outerCallback.onSuccess((Object)false);
                    } else {
                        LoginDialog.this.outerCallback.onFailure((Throwable)new AuthenticationFailedException(Messages.getString("authFailed")));
                    }
                }
            };
            try {
                builder.sendRequest(requestData, callback);
            }
            catch (RequestException e) {
                e.printStackTrace();
            }
        }
    };

    public LoginDialog() {
        super(Messages.getString("login"), Messages.getString("login"), Messages.getString("cancel"), false, true);
        this.setCallback(this.myCallback);
        this.addStyleName("login-dialog");
        this.getLoginSettingsAndShow(false);
    }

    public void getLoginSettingsAndShow(boolean showUsersListDefault) {
        this.setContent(this.buildLoginPanel(openInNewWindowDefault));
        if (this.isAttached() && this.isVisible()) {
            this.center();
        }
    }

    public LoginDialog(AsyncCallback callback, boolean showNewWindowOption) {
        this();
        this.setCallback((AsyncCallback<Boolean>)callback);
        this.setShowNewWindowOption(showNewWindowOption);
    }

    public void setShowNewWindowOption(boolean show) {
        showNewWindowOption = show;
    }

    public static void performLogin(AsyncCallback callback) {
        loginDialog = new LoginDialog(callback, false);
        loginDialog.show();
        loginDialog.center();
    }

    private Widget buildLoginPanel(boolean openInNewWindowDefault) {
        SimplePanel spacer;
        this.userTextBox.setWidth("100%");
        this.passwordTextBox.setWidth("100%");
        this.usersListBox.setWidth("100%");
        VerticalPanel loginPanel = new VerticalPanel();
        loginPanel.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_LEFT);
        loginPanel.setVerticalAlignment(HasVerticalAlignment.ALIGN_TOP);
        if (showUsersList) {
            this.addDefaultUsers();
            loginPanel.add((Widget)new Label(Messages.getString("sampleUser") + ":"));
            loginPanel.add((Widget)this.usersListBox);
            spacer = new SimplePanel();
            spacer.setHeight("8px");
            loginPanel.add((Widget)spacer);
        }
        loginPanel.add((Widget)new Label(Messages.getString("username") + ":"));
        loginPanel.add((Widget)this.userTextBox);
        spacer = new SimplePanel();
        spacer.setHeight("8px");
        loginPanel.add((Widget)spacer);
        loginPanel.setCellHeight((Widget)spacer, "8px");
        loginPanel.add((Widget)new HTML(Messages.getString("password") + ":"));
        loginPanel.add((Widget)this.passwordTextBox);
        boolean reallyShowNewWindowOption = openInNewWindowDefault;
        String showNewWindowOverride = Window.Location.getParameter((String)"showNewWindowOption");
        if (showNewWindowOverride != null && !"".equals(showNewWindowOverride)) {
            reallyShowNewWindowOption = "true".equals(showNewWindowOverride);
        } else if (this.getReturnLocation() != null && !"".equals(this.getReturnLocation())) {
            StringTokenizer st = new StringTokenizer(this.getReturnLocation(), "?&");
            for (int i = 1; i < st.countTokens(); ++i) {
                StringTokenizer paramTokenizer = new StringTokenizer(st.tokenAt(i), "=");
                if (paramTokenizer.countTokens() != 2 || !paramTokenizer.tokenAt(0).equalsIgnoreCase("showNewWindowOption")) continue;
                reallyShowNewWindowOption = "true".equals(paramTokenizer.tokenAt(1));
                break;
            }
        }
        if (reallyShowNewWindowOption) {
            spacer = new SimplePanel();
            spacer.setHeight("8px");
            loginPanel.add((Widget)spacer);
            loginPanel.setCellHeight((Widget)spacer, "8px");
            this.newWindowChk.setText(Messages.getString("launchInNewWindow"));
            String cookieCheckedVal = Cookies.getCookie((String)"loginNewWindowChecked");
            if (cookieCheckedVal != null) {
                this.newWindowChk.setChecked(Boolean.parseBoolean(cookieCheckedVal));
            } else {
                this.newWindowChk.setChecked(openInNewWindowDefault);
            }
            loginPanel.add((Widget)this.newWindowChk);
        }
        this.userTextBox.setTabIndex(1);
        this.passwordTextBox.setTabIndex(2);
        if (reallyShowNewWindowOption) {
            this.newWindowChk.setTabIndex(3);
        }
        this.passwordTextBox.setText("");
        this.setFocusWidget((FocusWidget)this.userTextBox);
        return loginPanel;
    }

    public void setCallback(AsyncCallback<Boolean> callback) {
        this.outerCallback = callback;
    }

    public void addDefaultUsers() {
        this.usersListBox.clear();
        for (Map.Entry<String, String[]> entry : defaultUsers.entrySet()) {
            this.usersListBox.addItem(entry.getKey());
        }
        this.usersListBox.addChangeListener(new ChangeListener(){

            public void onChange(Widget sender) {
                String key = LoginDialog.this.usersListBox.getValue(LoginDialog.this.usersListBox.getSelectedIndex());
                LoginDialog.this.userTextBox.setText(((String[])defaultUsers.get(key))[0]);
                LoginDialog.this.passwordTextBox.setText(((String[])defaultUsers.get(key))[1]);
            }
        });
    }

    public String getReturnLocation() {
        return this.returnLocation;
    }

    public void setReturnLocation(String returnLocation) {
        this.returnLocation = returnLocation;
        this.setContent(this.buildLoginPanel(openInNewWindowDefault));
    }

    private String getWebAppPath() {
        String[] pathArray = Window.Location.getPath().split("/");
        return "/" + pathArray[1] + "/";
    }

    public static boolean isHidden() {
        if (loginDialog == null) {
            return true;
        }
        return !loginDialog.isShowing();
    }

    static {
        defaultUsers = new LinkedHashMap();
    }
}

