/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.wizard.ui.xul;

import java.awt.HeadlessException;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.pentaho.reporting.engine.classic.core.AbstractReportDefinition;
import org.pentaho.reporting.engine.classic.core.CompoundDataFactory;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.ReportProcessingException;
import org.pentaho.reporting.engine.classic.core.SubReport;
import org.pentaho.reporting.engine.classic.wizard.WizardProcessor;
import org.pentaho.reporting.engine.classic.wizard.WizardProcessorUtil;
import org.pentaho.reporting.engine.classic.wizard.model.WizardSpecification;
import org.pentaho.reporting.engine.classic.wizard.ui.xul.DefaultWizardDesignTimeContext;
import org.pentaho.reporting.engine.classic.wizard.ui.xul.Messages;
import org.pentaho.reporting.engine.classic.wizard.ui.xul.WizardEditorModel;
import org.pentaho.reporting.engine.classic.wizard.ui.xul.components.LinearWizardController;
import org.pentaho.reporting.engine.classic.wizard.ui.xul.components.WizardContentPanel;
import org.pentaho.reporting.engine.classic.wizard.ui.xul.steps.DataSourceAndQueryStep;
import org.pentaho.reporting.engine.classic.wizard.ui.xul.steps.FormatStep;
import org.pentaho.reporting.engine.classic.wizard.ui.xul.steps.LayoutStep;
import org.pentaho.reporting.engine.classic.wizard.ui.xul.steps.LookAndFeelStep;
import org.pentaho.reporting.libraries.base.util.DebugLog;
import org.pentaho.ui.xul.XulComponent;
import org.pentaho.ui.xul.XulDomContainer;
import org.pentaho.ui.xul.XulException;
import org.pentaho.ui.xul.binding.BindingFactory;
import org.pentaho.ui.xul.binding.DefaultBindingFactory;
import org.pentaho.ui.xul.containers.XulDialog;
import org.pentaho.ui.xul.dom.Document;
import org.pentaho.ui.xul.swing.SwingXulLoader;

public class EmbeddedWizard {
    private static final String MAIN_WIZARD_PANEL = "org/pentaho/reporting/engine/classic/wizard/ui/xul/res/main_wizard_panel.xul";
    private Window owner;
    private XulDialog dialog;
    private LinearWizardController wizardController;

    public EmbeddedWizard() throws HeadlessException {
        this(null);
    }

    public EmbeddedWizard(Window owner) throws HeadlessException {
        this.owner = owner;
        this.init();
    }

    private void init() {
        this.wizardController = new LinearWizardController(new WizardEditorModel(), (BindingFactory)new DefaultBindingFactory());
        this.wizardController.addStep(new LookAndFeelStep());
        this.wizardController.addStep(new DataSourceAndQueryStep());
        this.wizardController.addStep(new LayoutStep());
        this.wizardController.addStep(new FormatStep());
        this.wizardController.addPropertyChangeListener("cancelled", new CancelHandler());
        this.wizardController.addPropertyChangeListener("finished", new FinishedHandler());
    }

    public AbstractReportDefinition run(AbstractReportDefinition original) throws ReportProcessingException {
        if (original != null) {
            this.wizardController.getEditorModel().setReportDefinition(original, true);
        } else {
            MasterReport report = new MasterReport();
            report.setDataFactory((DataFactory)new CompoundDataFactory());
            report.setQuery(null);
            this.wizardController.getEditorModel().setReportDefinition((AbstractReportDefinition)report, false);
        }
        try {
            SwingXulLoader loader = new SwingXulLoader();
            loader.setOuterContext((Object)this.owner);
            XulDomContainer mainWizardContainer = new SwingXulLoader().loadXul(MAIN_WIZARD_PANEL);
            new WizardContentPanel(this.wizardController).addContent(mainWizardContainer);
            mainWizardContainer.setOuterContext((Object)this.owner);
            this.wizardController.registerMainXULContainer(mainWizardContainer);
            this.wizardController.onLoad();
            Document documentRoot = mainWizardContainer.getDocumentRoot();
            XulComponent root = documentRoot.getRootElement();
            if (!(root instanceof XulDialog)) {
                throw new XulException(Messages.getInstance().getString("EMBEDDED_WIZARD.Root_Error") + " " + root);
            }
            this.dialog = (XulDialog)root;
            DefaultWizardDesignTimeContext context = new DefaultWizardDesignTimeContext(this.wizardController.getEditorModel(), (Window)this.dialog.getRootObject());
            this.wizardController.setDesignTimeContext(context);
            if (this.wizardController.getEditorModel().isEditing() && this.wizardController.getStep(0).isValid()) {
                this.wizardController.setActiveStep(1);
                if (this.wizardController.getStep(1).isValid()) {
                    this.wizardController.setActiveStep(2);
                }
            }
            this.dialog.show();
        }
        catch (Exception e) {
            DebugLog.log((Object)"Failed to initialze the wizard", (Throwable)e);
            return null;
        }
        if (!this.wizardController.isFinished()) {
            return null;
        }
        AbstractReportDefinition reportDefinition = this.wizardController.getEditorModel().getReportDefinition();
        try {
            WizardSpecification spec = this.wizardController.getEditorModel().getReportSpec();
            WizardProcessorUtil.applyWizardSpec((AbstractReportDefinition)reportDefinition, (WizardSpecification)spec);
            WizardProcessorUtil.ensureWizardProcessorIsAdded((AbstractReportDefinition)reportDefinition, null);
        }
        catch (Exception ex) {
            throw new IllegalStateException();
        }
        if (reportDefinition instanceof MasterReport) {
            return WizardProcessorUtil.materialize((MasterReport)((MasterReport)reportDefinition), (WizardProcessor)new WizardProcessor());
        }
        if (reportDefinition instanceof SubReport) {
            return WizardProcessorUtil.materialize((SubReport)((SubReport)reportDefinition), (WizardProcessor)new WizardProcessor());
        }
        throw new IllegalStateException();
    }

    private class FinishedHandler
    implements PropertyChangeListener {
        private FinishedHandler() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (EmbeddedWizard.this.wizardController.isFinished()) {
                EmbeddedWizard.this.dialog.hide();
            }
        }
    }

    private class CancelHandler
    implements PropertyChangeListener {
        private CancelHandler() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (EmbeddedWizard.this.wizardController.isCancelled()) {
                EmbeddedWizard.this.dialog.hide();
            }
        }
    }
}

