/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.wizard.ui.xul;

import java.util.ArrayList;
import java.util.List;
import org.pentaho.reporting.engine.classic.core.AbstractReportDefinition;
import org.pentaho.reporting.engine.classic.core.CompoundDataFactory;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.ReportProcessingException;
import org.pentaho.reporting.engine.classic.core.Section;
import org.pentaho.reporting.engine.classic.core.designtime.DesignTimeDataSchemaModel;
import org.pentaho.reporting.engine.classic.core.wizard.DataAttributeContext;
import org.pentaho.reporting.engine.classic.core.wizard.DataSchema;
import org.pentaho.reporting.engine.classic.core.wizard.DataSchemaModel;
import org.pentaho.reporting.engine.classic.core.wizard.DefaultDataAttributeContext;
import org.pentaho.reporting.engine.classic.wizard.WizardProcessorUtil;
import org.pentaho.reporting.engine.classic.wizard.model.DefaultWizardSpecification;
import org.pentaho.reporting.engine.classic.wizard.model.WizardSpecification;
import org.pentaho.reporting.engine.classic.wizard.ui.xul.util.SourceFieldDefinition;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;
import org.pentaho.ui.xul.XulEventSourceAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WizardEditorModel
extends XulEventSourceAdapter {
    private static final String RELATIONAL_MODEL_PROPERTY_NAME = "relationalModel";
    private AbstractReportDefinition reportDefinition;
    private AbstractReportDefinition emptyTemplate;
    private boolean relationalModel;
    private DataSchemaModel dataSchemaModel;
    private DataAttributeContext attributeContext;
    private WizardSpecification specification;
    private boolean materialize;
    private boolean editing = false;
    private DataFactory dataFactory;

    public WizardEditorModel(AbstractReportDefinition emptyTemplate) {
        if (emptyTemplate == null) {
            throw new NullPointerException();
        }
        this.materialize = true;
        this.relationalModel = true;
        this.emptyTemplate = emptyTemplate;
        this.attributeContext = new DefaultDataAttributeContext();
        try {
            this.reportDefinition = (AbstractReportDefinition)emptyTemplate.derive();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException();
        }
    }

    public WizardEditorModel() {
        this((AbstractReportDefinition)WizardEditorModel.createDefaultReport());
    }

    private static MasterReport createDefaultReport() {
        MasterReport report = new MasterReport();
        report.setDataFactory((DataFactory)new CompoundDataFactory());
        report.setQuery(null);
        return report;
    }

    public AbstractReportDefinition getReportDefinition() {
        return this.reportDefinition;
    }

    public void setReportDefinition(AbstractReportDefinition reportDefinition, boolean isEditing) {
        if (reportDefinition == null) {
            throw new NullPointerException();
        }
        AbstractReportDefinition oldDefinition = this.reportDefinition;
        this.reportDefinition = reportDefinition;
        if (oldDefinition != reportDefinition) {
            this.dataSchemaModel = null;
            this.specification = this.getReportSpec();
            if (this.dataFactory == null) {
                DataFactory theDataFactory = reportDefinition.getDataFactory();
                if (theDataFactory.getQueryNames().length > 0) {
                    this.dataFactory = reportDefinition.getDataFactory();
                }
            } else {
                reportDefinition.setQuery(oldDefinition.getQuery());
                reportDefinition.setDataFactory(this.dataFactory);
            }
            this.firePropertyChange("reportDefinition", oldDefinition, reportDefinition);
        }
        this.editing = isEditing;
    }

    public void setReportDefinition(AbstractReportDefinition reportDefinition) {
        this.setReportDefinition(reportDefinition, false);
    }

    public AbstractReportDefinition getEmptyTemplate() {
        try {
            return (AbstractReportDefinition)this.emptyTemplate.derive();
        }
        catch (CloneNotSupportedException cne) {
            throw new IllegalStateException();
        }
    }

    public WizardSpecification getReportSpec() {
        if (this.specification == null) {
            try {
                this.specification = WizardProcessorUtil.loadWizardSpecification((AbstractReportDefinition)this.reportDefinition, (ResourceManager)this.reportDefinition.getResourceManager());
                if (this.specification != null) {
                    return this.specification;
                }
            }
            catch (ReportProcessingException reportProcessingException) {
                // empty catch block
            }
            this.specification = new DefaultWizardSpecification();
            WizardProcessorUtil.applyWizardSpec((AbstractReportDefinition)this.reportDefinition, (WizardSpecification)this.specification);
        }
        return this.specification;
    }

    public ResourceKey getDefinitionSource() {
        return this.reportDefinition.getDefinitionSource();
    }

    public boolean isRelationalModel() {
        return this.relationalModel;
    }

    public void setRelationalModel(boolean relationalModel) {
        boolean oldRelational = this.relationalModel;
        this.relationalModel = relationalModel;
        if (oldRelational != relationalModel) {
            this.firePropertyChange(RELATIONAL_MODEL_PROPERTY_NAME, oldRelational, relationalModel);
        }
    }

    public List<SourceFieldDefinition> getSelectableFieldsArray() {
        ArrayList<SourceFieldDefinition> sourceFields = new ArrayList<SourceFieldDefinition>();
        DataSchemaModel localSchemaModel = this.getDataSchema();
        DataSchema dataSchema = localSchemaModel.getDataSchema();
        String[] names = dataSchema.getNames();
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            SourceFieldDefinition fieldDefinition = new SourceFieldDefinition(name, this.getDataSchema().getDataSchema());
            sourceFields.add(fieldDefinition);
        }
        return sourceFields;
    }

    public void updateQuery(DataFactory factory, String queryName) {
        this.getReportDefinition().setQuery(queryName);
        this.getReportDefinition().setDataFactory(factory);
    }

    private static MasterReport findMasterReport(AbstractReportDefinition def) {
        Section parentSection;
        AbstractReportDefinition loopDef = def;
        while (!(loopDef instanceof MasterReport) && (parentSection = def.getParentSection()) != null) {
            loopDef = (AbstractReportDefinition)parentSection.getReportDefinition();
        }
        if (loopDef instanceof MasterReport) {
            return (MasterReport)def;
        }
        return new MasterReport();
    }

    public static DataSchemaModel compileDataSchemaModel(AbstractReportDefinition reportDefinition) {
        return new DesignTimeDataSchemaModel(WizardEditorModel.findMasterReport(reportDefinition), reportDefinition);
    }

    public DataSchemaModel getDataSchema() {
        if (this.dataSchemaModel == null) {
            this.dataSchemaModel = WizardEditorModel.compileDataSchemaModel(this.reportDefinition);
        }
        return this.dataSchemaModel;
    }

    public DataAttributeContext getAttributeContext() {
        return this.attributeContext;
    }

    public boolean isMaterialize() {
        return this.materialize;
    }

    public void setMaterialize(boolean materialize) {
        this.materialize = materialize;
    }

    public boolean isEditing() {
        return this.editing;
    }
}

