/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.wizard.ui.xul.components;

import org.pentaho.reporting.engine.classic.core.designtime.DesignTimeContext;
import org.pentaho.reporting.engine.classic.core.wizard.DataAttributeContext;
import org.pentaho.reporting.engine.classic.wizard.ui.xul.Messages;
import org.pentaho.reporting.engine.classic.wizard.ui.xul.WizardEditorModel;
import org.pentaho.reporting.engine.classic.wizard.ui.xul.components.WizardStep;
import org.pentaho.reporting.libraries.base.util.DebugLog;
import org.pentaho.ui.xul.XulDomContainer;
import org.pentaho.ui.xul.XulEventSourceAdapter;
import org.pentaho.ui.xul.XulException;
import org.pentaho.ui.xul.binding.BindingFactory;
import org.pentaho.ui.xul.components.XulImage;
import org.pentaho.ui.xul.components.XulLabel;
import org.pentaho.ui.xul.containers.XulGrid;
import org.pentaho.ui.xul.containers.XulRow;
import org.pentaho.ui.xul.containers.XulRows;
import org.pentaho.ui.xul.dom.Document;
import org.pentaho.ui.xul.dom.Element;

public abstract class AbstractWizardStep
extends XulEventSourceAdapter
implements WizardStep {
    protected static final Messages messages = Messages.getInstance();
    public static final String VALID_PROPERTY_NAME = "valid";
    public static final String PREVIEWABLE_PROPERTY_NAME = "previewable";
    public static final String FINISHABLE_PROPERTY_NAME = "finishable";
    public static final String STEP_GRID_ID = "step_grid";
    public static final String STEP_ROWS_ID = "step_rows";
    public static final String XUL_ROW_TYPE = "row";
    public static final String XUL_IMAGE_TYPE = "image";
    public static final String XUL_LABEL_TYPE = "label";
    public static final String STEP_IMAGE_SRC = "images/24x24_chevron_green.png";
    public static final String SPACER_IMAGE_SRC = "images/empty_spacer.png";
    private boolean valid;
    private boolean previewable;
    private boolean finishable;
    private WizardEditorModel editorModel;
    private DesignTimeContext designTimeContext;
    private BindingFactory bf;
    private Document document;
    private XulImage stepImage;
    private XulLabel stepLabel;

    protected AbstractWizardStep() {
    }

    public DataAttributeContext getAttributeContext() {
        return this.editorModel.getAttributeContext();
    }

    public void setEditorModel(WizardEditorModel editorModel) {
        this.editorModel = editorModel;
    }

    public WizardEditorModel getEditorModel() {
        return this.editorModel;
    }

    public boolean isValid() {
        return this.valid;
    }

    protected void setValid(boolean valid) {
        boolean oldValid = this.valid;
        this.valid = valid;
        this.firePropertyChange(VALID_PROPERTY_NAME, oldValid, this.valid);
    }

    public void setPreviewable(boolean previewable) {
        boolean oldValue = this.previewable;
        this.previewable = previewable;
        this.firePropertyChange(PREVIEWABLE_PROPERTY_NAME, oldValue, this.previewable);
    }

    public boolean isPreviewable() {
        return this.previewable;
    }

    public void setFinishable(boolean finishable) {
        boolean oldValue = this.finishable;
        this.finishable = finishable;
        this.firePropertyChange(FINISHABLE_PROPERTY_NAME, oldValue, this.finishable);
    }

    public boolean isFinishable() {
        return this.isPreviewable();
    }

    public void setDesignTimeContext(DesignTimeContext designTimeContext) {
        this.designTimeContext = designTimeContext;
    }

    public DesignTimeContext getDesignTimeContext() {
        return this.designTimeContext;
    }

    public void setBindingFactory(BindingFactory bf) {
        this.bf = bf;
    }

    public BindingFactory getBindingFactory() {
        return this.bf;
    }

    public Document getDocument() {
        return this.document;
    }

    public void setDocument(Document document) {
        this.document = document;
    }

    public void createPresentationComponent(XulDomContainer mainWizardContainer) throws XulException {
        XulGrid stepGrid = (XulGrid)mainWizardContainer.getDocumentRoot().getElementById(STEP_GRID_ID);
        XulRows stepRows = (XulRows)mainWizardContainer.getDocumentRoot().getElementById(STEP_ROWS_ID);
        XulRow stepRow = (XulRow)mainWizardContainer.getDocumentRoot().createElement(XUL_ROW_TYPE);
        stepRows.addChild((Element)stepRow);
        this.stepImage = (XulImage)mainWizardContainer.getDocumentRoot().createElement(XUL_IMAGE_TYPE);
        this.stepImage.setSrc(STEP_IMAGE_SRC);
        this.stepImage.setId(this.getStepName());
        this.stepImage.setVisible(false);
        stepRow.addChild((Element)this.stepImage);
        this.stepLabel = (XulLabel)mainWizardContainer.getDocumentRoot().createElement(XUL_LABEL_TYPE);
        this.stepLabel.setValue(this.getStepName());
        this.stepLabel.setFlex(1);
        this.stepLabel.setDisabled(true);
        stepRow.addChild((Element)this.stepLabel);
        stepGrid.update();
    }

    public void stepActivating() {
        this.stepImage.setVisible(true);
        this.stepLabel.setDisabled(false);
        DebugLog.log((Object)("Activating: Step - " + this.getStepName()));
    }

    public boolean stepDeactivating() {
        DebugLog.log((Object)("Deactivating: Step - " + this.getStepName()));
        this.stepImage.setVisible(false);
        this.stepLabel.setDisabled(true);
        return true;
    }
}

