/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.wizard.ui.xul.components;

import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.util.ArrayList;
import org.pentaho.reporting.engine.classic.core.AbstractReportDefinition;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.SubReport;
import org.pentaho.reporting.engine.classic.core.designtime.DesignTimeContext;
import org.pentaho.reporting.engine.classic.core.modules.gui.base.PreviewDialog;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.ExceptionDialog;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.SwingUtil;
import org.pentaho.reporting.engine.classic.wizard.WizardProcessorUtil;
import org.pentaho.reporting.engine.classic.wizard.model.WizardSpecification;
import org.pentaho.reporting.engine.classic.wizard.ui.xul.Messages;
import org.pentaho.reporting.engine.classic.wizard.ui.xul.WizardEditorModel;
import org.pentaho.reporting.engine.classic.wizard.ui.xul.components.AbstractWizardStep;
import org.pentaho.reporting.engine.classic.wizard.ui.xul.components.WizardController;
import org.pentaho.reporting.engine.classic.wizard.ui.xul.components.WizardStep;
import org.pentaho.reporting.libraries.base.util.DebugLog;
import org.pentaho.ui.xul.XulDomContainer;
import org.pentaho.ui.xul.binding.Binding;
import org.pentaho.ui.xul.binding.BindingConvertor;
import org.pentaho.ui.xul.binding.BindingFactory;
import org.pentaho.ui.xul.containers.XulDeck;
import org.pentaho.ui.xul.impl.AbstractXulEventHandler;

public class LinearWizardController
extends AbstractXulEventHandler
implements WizardController {
    private static final Messages messages = Messages.getInstance();
    private static final String DISABLED_PROPERTY_NAME = "disabled";
    private static final String VALID_PROPERTY_NAME = "valid";
    private static final String NOT_DISABLED_PROPERTY = "!disabled";
    private static final String NEXT_BTN_ELEMENT_ID = "next_btn";
    private static final String BACK_BTN_ELEMENT_ID = "back_btn";
    private static final String FINISH_BTN_ELEMENT_ID = "finish_btn";
    private static final String CONTENT_DECK_ELEMENT_ID = "content_deck";
    private ArrayList<WizardStep> steps = new ArrayList();
    private WizardEditorModel editorModel;
    private int activeStep = -1;
    private boolean canceled;
    private boolean finished;
    private XulDomContainer mainXULContainer;
    private BindingFactory bf;
    private Binding nextButtonBinding;
    private Binding finishedButtonBinding;
    private DesignTimeContext designTimeContext;

    public LinearWizardController(WizardEditorModel editorModel, BindingFactory bf) {
        this.editorModel = editorModel;
        this.bf = bf;
    }

    public void setDesignTimeContext(DesignTimeContext designTimeContext) {
        this.designTimeContext = designTimeContext;
        for (WizardStep step : this.steps) {
            step.setDesignTimeContext(designTimeContext);
        }
    }

    public WizardEditorModel getEditorModel() {
        return this.editorModel;
    }

    public void addStep(AbstractWizardStep step) {
        if (step == null) {
            throw new NullPointerException();
        }
        step.setEditorModel(this.editorModel);
        this.steps.add(step);
    }

    public void removeStep(WizardStep step) {
        this.steps.remove(step);
    }

    public WizardStep getStep(int step) {
        return this.steps.get(step);
    }

    public int getStepCount() {
        return this.steps.size();
    }

    public void setActiveStep(int step) {
        WizardStep deactivatingWizardStep;
        int oldActiveStep = this.activeStep;
        if (oldActiveStep >= 0 && !(deactivatingWizardStep = this.steps.get(oldActiveStep)).stepDeactivating()) {
            DebugLog.log((Object)(deactivatingWizardStep.getStepName() + ": Canceled setActiveStep()"));
            return;
        }
        this.activeStep = step;
        WizardStep activatingWizardStep = this.steps.get(this.activeStep);
        this.updateBindings();
        activatingWizardStep.stepActivating();
        XulDeck deck = (XulDeck)this.mainXULContainer.getDocumentRoot().getElementById(CONTENT_DECK_ELEMENT_ID);
        deck.setSelectedIndex(this.activeStep);
        this.firePropertyChange("activeStep", oldActiveStep, this.activeStep);
    }

    public int getActiveStep() {
        return this.activeStep;
    }

    public void initialize() {
        if (this.steps.isEmpty()) {
            throw new IllegalStateException(messages.getString("LINEAR_WIZARD_CONTROLLER.Empty_Steps_Error"));
        }
        for (WizardStep wizardStep : this.steps) {
            wizardStep.setBindings();
        }
        this.bf.setBindingType(Binding.Type.ONE_WAY);
        this.bf.createBinding((Object)this, "activeStep", BACK_BTN_ELEMENT_ID, DISABLED_PROPERTY_NAME, new BindingConvertor[]{new BackButtonBindingConverter()});
        this.setActiveStep(0);
        this.setCancelled(false);
        this.setFinished(false);
    }

    protected void updateBindings() {
        if (this.nextButtonBinding != null) {
            this.nextButtonBinding.destroyBindings();
        }
        if (this.finishedButtonBinding != null) {
            this.finishedButtonBinding.destroyBindings();
        }
        this.bf.setBindingType(Binding.Type.ONE_WAY);
        this.nextButtonBinding = this.bf.createBinding((Object)this.getStep(this.getActiveStep()), VALID_PROPERTY_NAME, NEXT_BTN_ELEMENT_ID, NOT_DISABLED_PROPERTY, new BindingConvertor[0]);
        this.finishedButtonBinding = this.bf.createBinding((Object)this.getStep(this.getActiveStep()), "finishable", FINISH_BTN_ELEMENT_ID, NOT_DISABLED_PROPERTY, new BindingConvertor[0]);
        try {
            this.nextButtonBinding.fireSourceChanged();
            this.finishedButtonBinding.fireSourceChanged();
        }
        catch (Exception e) {
            if (this.designTimeContext == null) {
                ExceptionDialog.showExceptionDialog(null, (String)"Error", (String)e.getMessage(), (Exception)e);
            }
            this.designTimeContext.error(e);
        }
    }

    public void cancel() {
        this.setCancelled(true);
        this.setFinished(false);
    }

    public void setCancelled(boolean canceled) {
        boolean oldCanceled = this.canceled;
        this.canceled = canceled;
        this.firePropertyChange("cancelled", oldCanceled, this.canceled);
    }

    public boolean isCancelled() {
        return this.canceled;
    }

    public void finish() {
        this.setFinished(true);
        this.setCancelled(false);
    }

    public boolean isFinished() {
        return this.finished;
    }

    public void setFinished(boolean finished) {
        boolean oldFinished = this.finished;
        this.finished = finished;
        this.firePropertyChange("finished", oldFinished, this.finished);
    }

    public void next() {
        this.setActiveStep(this.getActiveStep() + 1);
    }

    public void back() {
        this.setActiveStep(this.getActiveStep() - 1);
    }

    public void preview() {
        Window window;
        PreviewDialog dialog = this.designTimeContext != null ? ((window = this.designTimeContext.getParentWindow()) instanceof Dialog ? new PreviewDialog((Dialog)window) : (window instanceof Frame ? new PreviewDialog((Frame)window) : new PreviewDialog())) : new PreviewDialog();
        dialog.setTitle(messages.getString("LINEAR_WIZARD_CONTROLLER.Report_Preview"));
        dialog.setModal(false);
        try {
            AbstractReportDefinition reportDefinition = this.editorModel.getReportDefinition();
            AbstractReportDefinition element = (AbstractReportDefinition)reportDefinition.derive();
            WizardSpecification spec = this.editorModel.getReportSpec();
            element.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/wizard", "enable", (Object)Boolean.TRUE);
            WizardProcessorUtil.applyWizardSpec((AbstractReportDefinition)element, (WizardSpecification)((WizardSpecification)spec.clone()));
            WizardProcessorUtil.ensureWizardProcessorIsAdded((AbstractReportDefinition)element, null);
            if (element instanceof MasterReport) {
                dialog.setReportJob((MasterReport)element);
            } else {
                MasterReport report = new MasterReport();
                report.getReportHeader().addSubReport((SubReport)element);
                dialog.setReportJob(report);
            }
            dialog.pack();
            SwingUtil.centerDialogInParent((Dialog)dialog);
            dialog.setVisible(true);
        }
        catch (Exception e) {
            if (this.designTimeContext != null) {
                this.designTimeContext.error(e);
            }
            ExceptionDialog.showExceptionDialog(null, (String)"Error", (String)e.getMessage(), (Exception)e);
        }
    }

    public String getName() {
        return "wizard_controller";
    }

    public void onLoad() {
        DebugLog.log((Object)"called onLoad()");
        this.initialize();
    }

    public void registerMainXULContainer(XulDomContainer mainWizardContainer) {
        this.mainXULContainer = mainWizardContainer;
        this.bf.setDocument(mainWizardContainer.getDocumentRoot());
    }

    public void setBindingFactory(BindingFactory bf) {
        this.bf = bf;
    }

    public BindingFactory getBindingFactory() {
        return this.bf;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BackButtonBindingConverter
    extends BindingConvertor<Integer, Boolean> {
        private BackButtonBindingConverter() {
        }

        public Boolean sourceToTarget(Integer value) {
            return value <= 0;
        }

        public Integer targetToSource(Boolean value) {
            return null;
        }
    }
}

