/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.wizard.ui.xul.steps;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.pentaho.reporting.engine.classic.core.AbstractReportDefinition;
import org.pentaho.reporting.engine.classic.core.CompoundDataFactory;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.DataRow;
import org.pentaho.reporting.engine.classic.core.StaticDataRow;
import org.pentaho.reporting.engine.classic.core.designtime.DataSourcePlugin;
import org.pentaho.reporting.engine.classic.core.designtime.DesignTimeContext;
import org.pentaho.reporting.engine.classic.core.metadata.DataFactoryMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.DataFactoryRegistry;
import org.pentaho.reporting.engine.classic.core.wizard.DataSchemaModel;
import org.pentaho.reporting.engine.classic.wizard.ui.xul.WizardEditorModel;
import org.pentaho.reporting.engine.classic.wizard.ui.xul.components.AbstractWizardStep;
import org.pentaho.reporting.libraries.base.util.DebugLog;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.ui.xul.XulDomContainer;
import org.pentaho.ui.xul.XulException;
import org.pentaho.ui.xul.binding.Binding;
import org.pentaho.ui.xul.binding.BindingConvertor;
import org.pentaho.ui.xul.containers.XulDialog;
import org.pentaho.ui.xul.containers.XulListbox;
import org.pentaho.ui.xul.containers.XulTree;
import org.pentaho.ui.xul.impl.AbstractXulEventHandler;
import org.pentaho.ui.xul.impl.XulEventHandler;
import org.pentaho.ui.xul.util.AbstractModelNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataSourceAndQueryStep
extends AbstractWizardStep {
    private DesignTimeContext designTimeContext;
    private static final String DATASOURCES_ROOT_NODE_NAME = "Datasources Root";
    private static final String DATASOURCE_AND_QUERY_STEP_OVERLAY = "org/pentaho/reporting/engine/classic/wizard/ui/xul/res/datasource_and_query_step_Overlay.xul";
    private static final String HANDLER_NAME = "datasource_and_query_step_handler";
    private static final String DATASOURCES_TREE_ID = "datasources_tree";
    private static final String DATASOURCE_TYPE_DIALOG_ID = "datasource_type_dialog";
    private static final String DATASOURCE_SELECTIONS_BOX_ID = "datasource_selections_box";
    private static final String EDIT_DATASOURCES_BTN_ID = "edit_datasource_btn";
    private static final String REMOVE_DATASOURCES_BTN_ID = "remove_datasource_btn";
    private static final String ELEMENTS_PROPERTY_NAME = "elements";
    private static final String SELECTED_INDEX_PROPERTY_NAME = "selectedIndex";
    private static final String SELECTED_ROWS_PROPERTY_NAME = "selectedRows";
    private static final String SELECTED_ITEM_PROPERTY_NAME = "selectedItem";
    private static final String CURRENT_QUERY_PROPERTY_NAME = "currentQuery";
    private static final String DATASOURCES_ROOT_PROPERTY_NAME = "dataSourcesRoot";
    private static final String VALUE_PROPERTY_NAME = "value";
    private static final String ENABLED_PROPERTY_NAME = "!disabled";
    private IndiciesToBooleanBindingConverter indiciesToBooleanBindingConverter = new IndiciesToBooleanBindingConverter();
    private DatasourceModelNode dataSourcesRoot;
    private List<XulEditorDataFactoryMetaData> dataFactoryMetas = new ArrayList<XulEditorDataFactoryMetaData>();
    private CompoundDataFactory cdf;

    public DataSourceAndQueryStep() {
        this.refreshMetadata();
    }

    @Override
    public DesignTimeContext getDesignTimeContext() {
        return this.designTimeContext;
    }

    @Override
    public void setDesignTimeContext(DesignTimeContext designTimeContext) {
        this.designTimeContext = designTimeContext;
        this.refreshMetadata();
    }

    private void refreshMetadata() {
        DataFactoryMetaData[] dfmdArray = DataFactoryRegistry.getInstance().getAll();
        Arrays.sort(dfmdArray, new DataFactoryMetaDataComparator());
        for (DataFactoryMetaData dfmd : dfmdArray) {
            if (!dfmd.isEditable() || !dfmd.isEditorAvailable() || dfmd.isHidden()) continue;
            this.dataFactoryMetas.add(new XulEditorDataFactoryMetaData(dfmd));
        }
    }

    @Override
    public void setBindings() {
        this.getBindingFactory().setBindingType(Binding.Type.ONE_WAY);
        this.getBindingFactory().createBinding((Object)this, DATASOURCES_ROOT_PROPERTY_NAME, DATASOURCES_TREE_ID, ELEMENTS_PROPERTY_NAME, new BindingConvertor[0]);
        this.getBindingFactory().createBinding(DATASOURCES_TREE_ID, SELECTED_ITEM_PROPERTY_NAME, (Object)this, CURRENT_QUERY_PROPERTY_NAME, new BindingConvertor[]{new CurrentQueryBindingConverter()});
        this.getBindingFactory().createBinding(DATASOURCES_TREE_ID, SELECTED_ROWS_PROPERTY_NAME, EDIT_DATASOURCES_BTN_ID, ENABLED_PROPERTY_NAME, new BindingConvertor[]{this.indiciesToBooleanBindingConverter});
        this.getBindingFactory().createBinding(DATASOURCES_TREE_ID, SELECTED_ROWS_PROPERTY_NAME, REMOVE_DATASOURCES_BTN_ID, ENABLED_PROPERTY_NAME, new BindingConvertor[]{this.indiciesToBooleanBindingConverter});
    }

    public void editQuery(String queryName) {
        DataFactory dataFactory = this.getOwnerDataFactory(queryName);
        DataFactoryMetaData o = this.getMetaForDataFactory(dataFactory, this.dataFactoryMetas);
        this.editOrCreateDataFactory(o);
    }

    private DataFactoryMetaData getMetaForDataFactory(DataFactory dataFactory, List<XulEditorDataFactoryMetaData> metaDatas) {
        String dfClassName = dataFactory.getClass().getName();
        for (XulEditorDataFactoryMetaData mdfmd : metaDatas) {
            DataFactoryMetaData data = mdfmd.getMetadata();
            String mdFactoryName = data.getName();
            if (!dfClassName.equals(mdFactoryName)) continue;
            return mdfmd.getMetadata();
        }
        return null;
    }

    private int getDataFactoryForMeta(DataFactoryMetaData dfMetaData) {
        for (int i = 0; i < this.cdf.size(); ++i) {
            DataFactory df = this.cdf.getReference(i);
            if (!dfMetaData.getName().equals(df.getClass().getName())) continue;
            return i;
        }
        return -1;
    }

    private DataFactory getOwnerDataFactory(String queryName) {
        return this.cdf.getDataFactoryForQuery(queryName);
    }

    public void createDataFactory() {
        XulDialog datasourceType = (XulDialog)this.getDocument().getElementById(DATASOURCE_TYPE_DIALOG_ID);
        datasourceType.setVisible(true);
        XulListbox box = (XulListbox)this.getDocument().getElementById(DATASOURCE_SELECTIONS_BOX_ID);
        XulEditorDataFactoryMetaData myEditData = (XulEditorDataFactoryMetaData)box.getSelectedItem();
        if (myEditData != null) {
            this.editOrCreateDataFactory(myEditData.getMetadata());
        }
        box.setSelectedIndices(new int[0]);
    }

    public void editOrCreateDataFactory(DataFactoryMetaData o) {
        if (o == null) {
            return;
        }
        if (o.isHidden()) {
            return;
        }
        DataFactory editDataFactory = this.getEditDataFactory(o);
        DataSourcePlugin dataSourcePlugin = o.createEditor();
        DataFactory generatedDataFactory = dataSourcePlugin.performEdit(this.getDesignTimeContext(), editDataFactory, null);
        if (generatedDataFactory != null) {
            this.cdf.add(generatedDataFactory);
            this.cdf = CompoundDataFactory.normalize((DataFactory)this.cdf);
            this.updateDatasourceTree();
        } else if (editDataFactory != null) {
            this.cdf.add(editDataFactory);
        }
        this.setValid(this.validateStep());
    }

    private DataFactory getEditDataFactory(DataFactoryMetaData o) {
        String mdfactoryName = o.getName();
        for (int i = 0; i < this.cdf.size(); ++i) {
            DataFactory df = this.cdf.getReference(i);
            String dfClassName = df.getClass().getName();
            if (!mdfactoryName.equals(dfClassName)) continue;
            this.cdf.remove(i);
            return df;
        }
        return null;
    }

    @Override
    public void stepActivating() {
        super.stepActivating();
        this.cdf = (CompoundDataFactory)this.getEditorModel().getReportDefinition().getDataFactory();
        this.updateDatasourceTree();
        this.setValid(this.validateStep());
    }

    @Override
    public boolean stepDeactivating() {
        this.getEditorModel().getReportDefinition().setDataFactory((DataFactory)this.cdf);
        return super.stepDeactivating();
    }

    public void deleteDataFactory(DataFactoryMetaData userObject) {
        int datasourceIndex = this.getDataFactoryForMeta(userObject);
        if (datasourceIndex >= 0) {
            this.cdf.remove(this.getDataFactoryForMeta(userObject));
        }
    }

    public void deleteConnection(DataFactory datafactory) {
        this.cdf.remove(datafactory);
    }

    private void updateDatasourceTree() {
        DatasourceModelNode newRoot = new DatasourceModelNode(DATASOURCES_ROOT_NODE_NAME, null, DATASOURCE_TYPE.ROOT);
        for (int i = 0; i < this.cdf.size(); ++i) {
            DataFactory df = this.cdf.getReference(i);
            DataFactoryMetaData dfmd = this.getMetaForDataFactory(df, this.dataFactoryMetas);
            if (dfmd == null) continue;
            DatasourceModelNode dfmdNode = this.findUserObjectInTree(dfmd, newRoot);
            if (dfmdNode == null) {
                dfmdNode = new DatasourceModelNode(dfmd.getDisplayName(Locale.getDefault()), dfmd, DATASOURCE_TYPE.DATAFACTORY);
                newRoot.add((Object)dfmdNode);
            }
            DatasourceModelNode dataSourceNode = null;
            String connectionName = dfmd.getDisplayConnectionName(df);
            if (connectionName != null) {
                dataSourceNode = new DatasourceModelNode(connectionName, df, DATASOURCE_TYPE.CONNECTION);
            }
            if (dataSourceNode != null) {
                dfmdNode.add((Object)dataSourceNode);
            }
            for (String queryName : df.getQueryNames()) {
                DatasourceModelNode queryNode = new DatasourceModelNode(queryName, null, DATASOURCE_TYPE.QUERY);
                if (dataSourceNode != null) {
                    dataSourceNode.add((Object)queryNode);
                    continue;
                }
                dfmdNode.add((Object)queryNode);
            }
        }
        this.setDataSourcesRoot(newRoot);
        XulTree tree = (XulTree)this.getDocument().getElementById(DATASOURCES_TREE_ID);
        String currentQuery = this.getCurrentQuery();
        int selectedQueryRow = this.findRowForObject(this.getDataSourcesRoot(), currentQuery, new int[]{0});
        if (selectedQueryRow == -1) {
            int[] selectedRows = new int[]{selectedQueryRow - 1};
            tree.setSelectedRows(selectedRows);
        }
    }

    private int findRowForObject(DatasourceModelNode startNode, Object searchObj, int[] index) {
        if (index == null || index.length != 1) {
            throw new IllegalArgumentException();
        }
        if (searchObj == null) {
            return -1;
        }
        if (ObjectUtilities.equal((Object)searchObj, (Object)startNode.getUserObject())) {
            return index[0];
        }
        Iterator i$ = startNode.iterator();
        while (i$.hasNext()) {
            DatasourceModelNode node = (DatasourceModelNode)((Object)i$.next());
            index[0] = index[0] + 1;
            int result = this.findRowForObject(node, searchObj, index);
            if (result == -1) continue;
            return result;
        }
        return -1;
    }

    private DatasourceModelNode findUserObjectInTree(Object userObj, DatasourceModelNode startNode) {
        if (userObj == null) {
            throw new NullPointerException("UserObject must not be null");
        }
        if (startNode == null) {
            throw new NullPointerException("StartNode must not be null");
        }
        if (userObj.equals(startNode.getUserObject())) {
            return startNode;
        }
        Iterator i$ = startNode.iterator();
        while (i$.hasNext()) {
            DatasourceModelNode childNode = (DatasourceModelNode)((Object)i$.next());
            DatasourceModelNode found = this.findUserObjectInTree(userObj, childNode);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    protected boolean validateStep() {
        AbstractReportDefinition reportDefinition = this.getEditorModel().getReportDefinition();
        if (reportDefinition.getDataFactory() == null || StringUtils.isEmpty((String)reportDefinition.getQuery())) {
            DebugLog.log((Object)("Have no query or no datafactory " + reportDefinition.getDataFactory() + " " + reportDefinition.getQuery()));
            return false;
        }
        String queryName = reportDefinition.getQuery();
        if (!this.cdf.isQueryExecutable(queryName, (DataRow)new StaticDataRow())) {
            return false;
        }
        try {
            AbstractReportDefinition abstractReportDefinition = (AbstractReportDefinition)reportDefinition.derive();
            abstractReportDefinition.setDataFactory(this.cdf.derive());
            DataSchemaModel schemaModel = WizardEditorModel.compileDataSchemaModel(abstractReportDefinition);
            return schemaModel.isValid();
        }
        catch (Exception ee) {
            this.getDesignTimeContext().userError(ee);
            return false;
        }
    }

    @Override
    public void createPresentationComponent(XulDomContainer mainWizardContainer) throws XulException {
        super.createPresentationComponent(mainWizardContainer);
        mainWizardContainer.loadOverlay(DATASOURCE_AND_QUERY_STEP_OVERLAY);
        mainWizardContainer.addEventHandler((XulEventHandler)new DatasourceAndQueryStepHandler());
        XulListbox box = (XulListbox)this.getDocument().getElementById(DATASOURCE_SELECTIONS_BOX_ID);
        box.removeItems();
        for (XulEditorDataFactoryMetaData dfMeta : this.dataFactoryMetas) {
            box.addItem((Object)dfMeta);
        }
        box.addPropertyChangeListener((PropertyChangeListener)new SelectedIndexUpdateHandler());
    }

    public List<XulEditorDataFactoryMetaData> getDataFactoryMetas() {
        return this.dataFactoryMetas;
    }

    public void setDataFactoryMetas(ArrayList<XulEditorDataFactoryMetaData> datas) {
        this.dataFactoryMetas = datas;
    }

    public String getCurrentQuery() {
        return this.getEditorModel().getReportDefinition().getQuery();
    }

    public void setCurrentQuery(String currentQuery) {
        String oldQuery = this.getCurrentQuery();
        if (currentQuery == null || !currentQuery.equals(oldQuery)) {
            this.getEditorModel().getReportDefinition().setQuery(currentQuery);
            this.firePropertyChange(CURRENT_QUERY_PROPERTY_NAME, oldQuery, currentQuery);
            this.setValid(this.validateStep());
        }
    }

    public DatasourceModelNode getDataSourcesRoot() {
        return this.dataSourcesRoot;
    }

    public void setDataSourcesRoot(DatasourceModelNode dataSourcesRoot) {
        DatasourceModelNode oldDataSourcesRoot = this.dataSourcesRoot;
        this.dataSourcesRoot = dataSourcesRoot;
        this.firePropertyChange(DATASOURCES_ROOT_PROPERTY_NAME, (Object)oldDataSourcesRoot, (Object)dataSourcesRoot);
    }

    @Override
    public String getStepName() {
        return messages.getString("DATASOURCE_AND_QUERY_STEP.Step_Name");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class IndiciesToBooleanBindingConverter
    extends BindingConvertor<int[], Boolean> {
        private IndiciesToBooleanBindingConverter() {
        }

        public Boolean sourceToTarget(int[] value) {
            return value.length > 0;
        }

        public int[] targetToSource(Boolean value) {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class DatasourceModelNode
    extends AbstractModelNode<DatasourceModelNode> {
        private DATASOURCE_TYPE type;
        private String value;
        private Object userObject;

        public DatasourceModelNode(String value, Object userObject, DATASOURCE_TYPE type) {
            this.value = value;
            this.userObject = userObject;
            this.type = type;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            String oldValue = this.value;
            this.value = value;
            this.firePropertyChange(DataSourceAndQueryStep.VALUE_PROPERTY_NAME, oldValue, value);
        }

        public DATASOURCE_TYPE getType() {
            return this.type;
        }

        public void setType(DATASOURCE_TYPE type) {
            this.type = type;
        }

        public Object getUserObject() {
            return this.userObject;
        }

        public void setUserObject(Object userObject) {
            this.userObject = userObject;
        }
    }

    protected class DatasourceAndQueryStepHandler
    extends AbstractXulEventHandler {
        public String getName() {
            return DataSourceAndQueryStep.HANDLER_NAME;
        }

        public void doCreateDataFactory() {
            DataSourceAndQueryStep.this.createDataFactory();
        }

        public void doEditDatasource() {
            XulTree tree = (XulTree)this.document.getElementById(DataSourceAndQueryStep.DATASOURCES_TREE_ID);
            DatasourceModelNode node = (DatasourceModelNode)((Object)tree.getSelectedItem());
            switch (node.getType()) {
                case CONNECTION: {
                    DataFactory df = (DataFactory)node.getUserObject();
                    DataFactoryMetaData o = DataSourceAndQueryStep.this.getMetaForDataFactory(df, DataSourceAndQueryStep.this.dataFactoryMetas);
                    DataSourceAndQueryStep.this.editOrCreateDataFactory(o);
                    break;
                }
                case QUERY: {
                    DataSourceAndQueryStep.this.editQuery(node.getValue());
                    break;
                }
            }
        }

        public void doDeleteDatasourceItem() {
            XulTree tree = (XulTree)this.document.getElementById(DataSourceAndQueryStep.DATASOURCES_TREE_ID);
            DatasourceModelNode node = (DatasourceModelNode)((Object)tree.getSelectedItem());
            switch (node.getType()) {
                case DATAFACTORY: {
                    DataSourceAndQueryStep.this.deleteDataFactory((DataFactoryMetaData)node.getUserObject());
                    break;
                }
                case CONNECTION: {
                    DataSourceAndQueryStep.this.deleteConnection((DataFactory)node.getUserObject());
                }
            }
            DataSourceAndQueryStep.this.updateDatasourceTree();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CurrentQueryBindingConverter
    extends BindingConvertor<DatasourceModelNode, String> {
        private CurrentQueryBindingConverter() {
        }

        public String sourceToTarget(DatasourceModelNode value) {
            if (value != null && value.getType() == DATASOURCE_TYPE.QUERY) {
                return value.getValue();
            }
            return DataSourceAndQueryStep.this.getCurrentQuery();
        }

        public DatasourceModelNode targetToSource(String value) {
            return null;
        }
    }

    protected static class XulEditorDataFactoryMetaData {
        private DataFactoryMetaData metadata;

        public XulEditorDataFactoryMetaData(DataFactoryMetaData metadata) {
            if (metadata == null) {
                throw new NullPointerException();
            }
            this.metadata = metadata;
        }

        public String getName() {
            return this.metadata.getDisplayName(Locale.getDefault());
        }

        public DataFactoryMetaData getMetadata() {
            return this.metadata;
        }

        public String toString() {
            return this.getName();
        }
    }

    private class SelectedIndexUpdateHandler
    implements PropertyChangeListener {
        private SelectedIndexUpdateHandler() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (DataSourceAndQueryStep.SELECTED_INDEX_PROPERTY_NAME.equals(evt.getPropertyName())) {
                XulDialog datasourceType = (XulDialog)DataSourceAndQueryStep.this.getDocument().getElementById(DataSourceAndQueryStep.DATASOURCE_TYPE_DIALOG_ID);
                datasourceType.setVisible(false);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DataFactoryMetaDataComparator
    implements Comparator<DataFactoryMetaData> {
        private DataFactoryMetaDataComparator() {
        }

        @Override
        public int compare(DataFactoryMetaData o1, DataFactoryMetaData o2) {
            return o1.getDisplayName(Locale.getDefault()).compareTo(o2.getDisplayName(Locale.getDefault()));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum DATASOURCE_TYPE {
        ROOT,
        DATAFACTORY,
        CONNECTION,
        QUERY;

    }
}

