/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.wizard.ui.xul.steps;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.pentaho.reporting.engine.classic.core.ElementAlignment;
import org.pentaho.reporting.engine.classic.core.function.AggregationFunction;
import org.pentaho.reporting.engine.classic.core.metadata.ExpressionMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.ExpressionRegistry;
import org.pentaho.reporting.engine.classic.core.wizard.DataSchema;
import org.pentaho.reporting.engine.classic.wizard.model.DefaultDetailFieldDefinition;
import org.pentaho.reporting.engine.classic.wizard.model.DefaultGroupDefinition;
import org.pentaho.reporting.engine.classic.wizard.model.DetailFieldDefinition;
import org.pentaho.reporting.engine.classic.wizard.model.FieldDefinition;
import org.pentaho.reporting.engine.classic.wizard.model.GroupDefinition;
import org.pentaho.reporting.engine.classic.wizard.ui.xul.components.AbstractWizardStep;
import org.pentaho.reporting.engine.classic.wizard.ui.xul.steps.AutoWidthBindingConverter;
import org.pentaho.reporting.engine.classic.wizard.ui.xul.steps.BooleanBindingConvertor;
import org.pentaho.reporting.engine.classic.wizard.ui.xul.steps.DataFormatBindingConvertor;
import org.pentaho.reporting.engine.classic.wizard.ui.xul.steps.IntegerToStringBindingConvertor;
import org.pentaho.reporting.engine.classic.wizard.ui.xul.steps.LengthToIntegerBindingConverter;
import org.pentaho.reporting.engine.classic.wizard.ui.xul.util.FieldWrapper;
import org.pentaho.reporting.engine.classic.wizard.ui.xul.util.XulDetailFieldDefinition;
import org.pentaho.reporting.engine.classic.wizard.ui.xul.util.XulGroupDefinition;
import org.pentaho.ui.xul.XulDomContainer;
import org.pentaho.ui.xul.XulException;
import org.pentaho.ui.xul.binding.Binding;
import org.pentaho.ui.xul.binding.BindingConvertor;
import org.pentaho.ui.xul.components.XulButton;
import org.pentaho.ui.xul.containers.XulDeck;
import org.pentaho.ui.xul.containers.XulListbox;
import org.pentaho.ui.xul.impl.AbstractXulEventHandler;
import org.pentaho.ui.xul.impl.XulEventHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormatStep
extends AbstractWizardStep {
    private static final String FORMAT_STEP_OVERLAY = "org/pentaho/reporting/engine/classic/wizard/ui/xul/res/format_step_Overlay.xul";
    private static final String GROUP_FIELDS_PROPERTY_NAME = "groupFields";
    private static final String DETAIL_FIELDS_PROPERTY_NAME = "detailFields";
    private static final String ELEMENTS_PROPERTY_NAME = "elements";
    private static final String SELECTED_INDICES_PROPERTY_NAME = "selectedIndices";
    private static final String SELECTED_INDEX_PROPERTY_NAME = "selectedIndex";
    private static final String CHECKED_PROPERTY_NAME = "checked";
    private static final String ONLY_SHOW_CHANGING_VALUES_PROPERTY_NAME = "onlyShowChangingValues";
    private static final String WIDTH_PROPERTY_NAME = "width";
    private static final String VALUE_PROPERTY_NAME = "value";
    private static final String DISPLAY_NAME_PROPERTY_NAME = "displayName";
    private static final String DATA_FORMAT_PROPERTY_NAME = "dataFormat";
    private static final String ALL_EXPRESSIONS_META_DATAS = "allExpressionMetaDatas";
    private static final String AGGREGATION_FUNCTION_PROPERTY_NAME = "aggregationFunction";
    private static final String GROUP_TOTALS_LABEL_PROPERTY_NAME = "groupTotalsLabel";
    private static final String SELECTED_ITEM_PROPERTY_NAME = "selectedItem";
    private static final String DISABLED_PROPERTY_ID = "disabled";
    private static final String FORMAT_DETAILS_LIST_ID = "format_details_list";
    private static final String FORMAT_GROUPS_LIST_ID = "format_groups_list";
    private static final String FORMAT_DECK_ID = "format_options_deck";
    private static final String FORMAT_DETAIL_DISTINCT_CB_ID = "format_detail_distinct_only_cb";
    private static final String FORMAT_DETAIL_WIDTH_SCALE_ID = "format_detail_width_scale";
    private static final String FORMAT_DETAIL_DISPLAY_NAME_TB_ID = "format_detail_display_name_tb";
    private static final String FORMAT_DETAIL_DATA_ML_ID = "format_detail_data_ml";
    private static final String FORMAT_DETAIL_AGGREGATION_ML_ID = "format_detail_aggregation_ml";
    private static final String FORMAT_GROUP_TOTALS_LABEL_TB_ID = "format_group_totals_tb";
    private static final String FORMAT_GROUP_DISPLAY_NAME_TB_ID = "format_group_display_name_tb";
    private static final String FORMAT_DETAIL_AUTO_WIDTH_CB_ID = "auto_width_cb";
    private static final String FORMAT_DETAIL_WIDTH_LABEL_ID = "format_detail_width_label";
    private static final String ALIGN_DETAIL_LEFT_BTN_ID = "align_detail_left";
    private static final String ALIGN_DETAIL_CENTER_BTN_ID = "align_detail_center";
    private static final String ALIGN_DETAIL_RIGHT_BTN_ID = "align_detail_right";
    private static final String ALIGN_DETAIL_JUSTIFY_BTN_ID = "align_detail_justify";
    private FormatStepHandler formatStepHandler;
    private Binding groupBinding;
    private Binding detailBinding;
    private Binding detailExpressionsBinding;
    private List<Binding> fieldAndGroupBindings;
    private List<MetaDataWrapper> allExpressionMetaDatas = new ArrayList<MetaDataWrapper>();
    private FieldWrapper activeField;
    private Object activeXulWrapper;

    public FormatStep() {
        this.allExpressionMetaDatas.add(new MetaDataWrapper(null));
        for (ExpressionMetaData emd : ExpressionRegistry.getInstance().getAllExpressionMetaDatas()) {
            if (!AggregationFunction.class.isAssignableFrom(emd.getExpressionType())) continue;
            this.allExpressionMetaDatas.add(new MetaDataWrapper(emd));
        }
        this.formatStepHandler = new FormatStepHandler();
        this.fieldAndGroupBindings = new ArrayList<Binding>();
    }

    protected FieldWrapper getActiveField() {
        return this.activeField;
    }

    protected Object getActiveXulWrapper() {
        return this.activeXulWrapper;
    }

    @Override
    public void setBindings() {
        this.getBindingFactory().setBindingType(Binding.Type.ONE_WAY);
        this.getBindingFactory().createBinding(FORMAT_DETAILS_LIST_ID, SELECTED_INDICES_PROPERTY_NAME, FORMAT_DECK_ID, SELECTED_INDEX_PROPERTY_NAME, new BindingConvertor[]{new FormatTypeBinding((XulListbox)this.getDocument().getElementById(FORMAT_DETAILS_LIST_ID), (XulListbox)this.getDocument().getElementById(FORMAT_GROUPS_LIST_ID))});
        this.getBindingFactory().createBinding(FORMAT_GROUPS_LIST_ID, SELECTED_INDICES_PROPERTY_NAME, FORMAT_DECK_ID, SELECTED_INDEX_PROPERTY_NAME, new BindingConvertor[]{new FormatTypeBinding((XulListbox)this.getDocument().getElementById(FORMAT_GROUPS_LIST_ID), (XulListbox)this.getDocument().getElementById(FORMAT_DETAILS_LIST_ID))});
        this.groupBinding = this.getBindingFactory().createBinding((Object)this, GROUP_FIELDS_PROPERTY_NAME, FORMAT_GROUPS_LIST_ID, ELEMENTS_PROPERTY_NAME, new BindingConvertor[0]);
        this.detailBinding = this.getBindingFactory().createBinding((Object)this, DETAIL_FIELDS_PROPERTY_NAME, FORMAT_DETAILS_LIST_ID, ELEMENTS_PROPERTY_NAME, new BindingConvertor[0]);
        this.detailExpressionsBinding = this.getBindingFactory().createBinding((Object)this, ALL_EXPRESSIONS_META_DATAS, FORMAT_DETAIL_AGGREGATION_ML_ID, ELEMENTS_PROPERTY_NAME, new BindingConvertor[0]);
    }

    @Override
    public void stepActivating() {
        super.stepActivating();
        this.setFinishable(true);
        this.setPreviewable(true);
        XulListbox groupList = (XulListbox)this.getDocument().getElementById(FORMAT_GROUPS_LIST_ID);
        XulListbox detailList = (XulListbox)this.getDocument().getElementById(FORMAT_DETAILS_LIST_ID);
        try {
            this.groupBinding.fireSourceChanged();
            this.detailBinding.fireSourceChanged();
            this.detailExpressionsBinding.fireSourceChanged();
            if (groupList.getRowCount() > 0) {
                groupList.setSelectedIndex(0);
            } else {
                detailList.setSelectedIndex(0);
            }
        }
        catch (Exception e) {
            this.getDesignTimeContext().error(e);
        }
    }

    @Override
    public boolean stepDeactivating() {
        super.stepDeactivating();
        this.resetFieldAndGroupBindings();
        XulListbox list = (XulListbox)this.getDocument().getElementById(FORMAT_DETAILS_LIST_ID);
        list.setSelectedIndices(new int[0]);
        list = (XulListbox)this.getDocument().getElementById(FORMAT_GROUPS_LIST_ID);
        list.setSelectedIndices(new int[0]);
        return true;
    }

    private void resetFieldAndGroupBindings() {
        for (Binding binding : this.fieldAndGroupBindings) {
            binding.destroyBindings();
        }
        this.fieldAndGroupBindings.clear();
    }

    public List<FieldWrapper> getGroupFields() {
        ArrayList<FieldWrapper> groups = new ArrayList<FieldWrapper>();
        DataSchema schema = this.getEditorModel().getDataSchema().getDataSchema();
        for (GroupDefinition group : this.getEditorModel().getReportSpec().getGroupDefinitions()) {
            groups.add(new FieldWrapper((FieldDefinition)group, schema));
        }
        return groups;
    }

    public void setGroupFields(List<FieldWrapper> groupFields) {
        List<FieldWrapper> oldGroups = this.getGroupFields();
        GroupDefinition[] fields = new GroupDefinition[groupFields.size()];
        for (int i = 0; i < groupFields.size(); ++i) {
            FieldWrapper fieldWrapper = groupFields.get(i);
            fields[i] = (GroupDefinition)fieldWrapper.getFieldDefinition();
        }
        this.getEditorModel().getReportSpec().setGroupDefinitions(fields);
        this.firePropertyChange(GROUP_FIELDS_PROPERTY_NAME, oldGroups, groupFields);
    }

    public List<FieldWrapper> getDetailFields() {
        ArrayList<FieldWrapper> fields = new ArrayList<FieldWrapper>();
        DataSchema schema = this.getEditorModel().getDataSchema().getDataSchema();
        for (DetailFieldDefinition field : this.getEditorModel().getReportSpec().getDetailFieldDefinitions()) {
            fields.add(new FieldWrapper((FieldDefinition)field, schema));
        }
        return fields;
    }

    public void setDetailFields(List<FieldWrapper> detailFields) {
        List<FieldWrapper> oldFields = this.getDetailFields();
        DetailFieldDefinition[] fields = new DetailFieldDefinition[detailFields.size()];
        for (int i = 0; i < detailFields.size(); ++i) {
            FieldWrapper fieldWrapper = detailFields.get(i);
            fields[i] = (DetailFieldDefinition)fieldWrapper.getFieldDefinition();
        }
        this.getEditorModel().getReportSpec().setDetailFieldDefinitions(fields);
        this.firePropertyChange(DETAIL_FIELDS_PROPERTY_NAME, oldFields, detailFields);
    }

    @Override
    public void createPresentationComponent(XulDomContainer mainWizardContainer) throws XulException {
        super.createPresentationComponent(mainWizardContainer);
        mainWizardContainer.loadOverlay(FORMAT_STEP_OVERLAY);
        mainWizardContainer.addEventHandler((XulEventHandler)this.formatStepHandler);
    }

    @Override
    public String getStepName() {
        return messages.getString("FORMAT_STEP.Step_Name");
    }

    protected void updateBindings(XulListbox activeTree) {
        this.resetFieldAndGroupBindings();
        this.getBindingFactory().setBindingType(Binding.Type.BI_DIRECTIONAL);
        int[] selectedIndices = activeTree.getSelectedIndices();
        if (selectedIndices == null || selectedIndices.length == 0) {
            this.activeField = null;
            this.activeXulWrapper = null;
            return;
        }
        if (activeTree.getId().equals(FORMAT_DETAILS_LIST_ID)) {
            this.activeField = this.getDetailFields().get(selectedIndices[0]);
            XulDetailFieldDefinition fieldDef = new XulDetailFieldDefinition((DefaultDetailFieldDefinition)this.activeField.getFieldDefinition(), this.getEditorModel().getDataSchema().getDataSchema());
            this.activeXulWrapper = fieldDef;
            this.getBindingFactory().setBindingType(Binding.Type.ONE_WAY);
            this.fieldAndGroupBindings.add(this.getBindingFactory().createBinding(FORMAT_DETAIL_WIDTH_SCALE_ID, VALUE_PROPERTY_NAME, FORMAT_DETAIL_WIDTH_LABEL_ID, VALUE_PROPERTY_NAME, new BindingConvertor[]{new IntegerToStringBindingConvertor()}));
            this.fieldAndGroupBindings.add(this.getBindingFactory().createBinding(FORMAT_DETAIL_AUTO_WIDTH_CB_ID, CHECKED_PROPERTY_NAME, FORMAT_DETAIL_WIDTH_SCALE_ID, DISABLED_PROPERTY_ID, new BindingConvertor[0]));
            this.getBindingFactory().setBindingType(Binding.Type.BI_DIRECTIONAL);
            this.fieldAndGroupBindings.add(this.getBindingFactory().createBinding((Object)fieldDef, ONLY_SHOW_CHANGING_VALUES_PROPERTY_NAME, FORMAT_DETAIL_DISTINCT_CB_ID, CHECKED_PROPERTY_NAME, new BindingConvertor[]{new BooleanBindingConvertor()}));
            this.fieldAndGroupBindings.add(this.getBindingFactory().createBinding((Object)fieldDef, WIDTH_PROPERTY_NAME, FORMAT_DETAIL_WIDTH_SCALE_ID, VALUE_PROPERTY_NAME, new BindingConvertor[]{new LengthToIntegerBindingConverter()}));
            this.fieldAndGroupBindings.add(this.getBindingFactory().createBinding((Object)fieldDef, DISPLAY_NAME_PROPERTY_NAME, FORMAT_DETAIL_DISPLAY_NAME_TB_ID, VALUE_PROPERTY_NAME, new BindingConvertor[0]));
            this.fieldAndGroupBindings.add(this.getBindingFactory().createBinding((Object)fieldDef, DATA_FORMAT_PROPERTY_NAME, FORMAT_DETAIL_DATA_ML_ID, SELECTED_ITEM_PROPERTY_NAME, new BindingConvertor[]{new DataFormatBindingConvertor()}));
            this.fieldAndGroupBindings.add(this.getBindingFactory().createBinding((Object)fieldDef, AGGREGATION_FUNCTION_PROPERTY_NAME, FORMAT_DETAIL_AGGREGATION_ML_ID, SELECTED_INDEX_PROPERTY_NAME, new BindingConvertor[]{new AggregationBindingConverter()}));
            this.fieldAndGroupBindings.add(this.getBindingFactory().createBinding((Object)fieldDef, WIDTH_PROPERTY_NAME, FORMAT_DETAIL_AUTO_WIDTH_CB_ID, CHECKED_PROPERTY_NAME, new BindingConvertor[]{new AutoWidthBindingConverter(fieldDef.getWidth())}));
            this.updateAlignmentButtons(fieldDef.getHorizontalAlignment());
        } else if (activeTree.getId().equals(FORMAT_GROUPS_LIST_ID) && this.getGroupFields().size() > 0) {
            this.activeField = this.getGroupFields().get(selectedIndices[0]);
            DefaultGroupDefinition definition = (DefaultGroupDefinition)this.activeField.getFieldDefinition();
            XulGroupDefinition groupDef = new XulGroupDefinition(definition, this.getEditorModel().getDataSchema().getDataSchema());
            this.activeXulWrapper = groupDef;
            this.fieldAndGroupBindings.add(this.getBindingFactory().createBinding((Object)groupDef, GROUP_TOTALS_LABEL_PROPERTY_NAME, FORMAT_GROUP_TOTALS_LABEL_TB_ID, VALUE_PROPERTY_NAME, new BindingConvertor[0]));
            this.fieldAndGroupBindings.add(this.getBindingFactory().createBinding((Object)groupDef, DISPLAY_NAME_PROPERTY_NAME, FORMAT_GROUP_DISPLAY_NAME_TB_ID, VALUE_PROPERTY_NAME, new BindingConvertor[0]));
            ElementAlignment alignment = groupDef.getTotalsHorizontalAlignment();
        }
        for (Binding binding : this.fieldAndGroupBindings) {
            try {
                binding.fireSourceChanged();
            }
            catch (Exception e) {
                this.getDesignTimeContext().error(e);
            }
        }
    }

    private void updateAlignmentButtons(ElementAlignment align) {
        XulButton alignLeftBtn = (XulButton)this.getDocument().getElementById(ALIGN_DETAIL_LEFT_BTN_ID);
        XulButton alignCenterBtn = (XulButton)this.getDocument().getElementById(ALIGN_DETAIL_CENTER_BTN_ID);
        XulButton alignRightBtn = (XulButton)this.getDocument().getElementById(ALIGN_DETAIL_RIGHT_BTN_ID);
        XulButton alignJustifyBtn = (XulButton)this.getDocument().getElementById(ALIGN_DETAIL_JUSTIFY_BTN_ID);
        alignLeftBtn.setSelected(align == ElementAlignment.LEFT);
        alignCenterBtn.setSelected(align == ElementAlignment.CENTER);
        alignRightBtn.setSelected(align == ElementAlignment.RIGHT);
        alignJustifyBtn.setSelected(align == ElementAlignment.JUSTIFY);
    }

    public List<MetaDataWrapper> getAllExpressionMetaDatas() {
        return this.allExpressionMetaDatas;
    }

    protected class FormatStepHandler
    extends AbstractXulEventHandler {
        private static final String HANDLER_NAME = "format_step_controller";

        protected FormatStepHandler() {
        }

        public String getName() {
            return HANDLER_NAME;
        }

        public void setAlignmentLeft() {
            if (FormatStep.this.activeField == null) {
                return;
            }
            FieldDefinition fieldDefinition = FormatStep.this.activeField.getFieldDefinition();
            if (fieldDefinition instanceof DetailFieldDefinition) {
                DetailFieldDefinition definition = (DetailFieldDefinition)fieldDefinition;
                definition.setHorizontalAlignment(ElementAlignment.LEFT);
                FormatStep.this.updateAlignmentButtons(ElementAlignment.LEFT);
            } else if (fieldDefinition instanceof GroupDefinition) {
                GroupDefinition groupDefinition = (GroupDefinition)fieldDefinition;
                groupDefinition.setTotalsHorizontalAlignment(ElementAlignment.LEFT);
                FormatStep.this.updateAlignmentButtons(ElementAlignment.LEFT);
            }
        }

        public void setAlignmentCenter() {
            if (FormatStep.this.activeField == null) {
                return;
            }
            FieldDefinition fieldDefinition = FormatStep.this.activeField.getFieldDefinition();
            if (fieldDefinition instanceof DetailFieldDefinition) {
                DetailFieldDefinition definition = (DetailFieldDefinition)fieldDefinition;
                definition.setHorizontalAlignment(ElementAlignment.CENTER);
                FormatStep.this.updateAlignmentButtons(ElementAlignment.CENTER);
            } else if (fieldDefinition instanceof GroupDefinition) {
                GroupDefinition groupDefinition = (GroupDefinition)fieldDefinition;
                groupDefinition.setTotalsHorizontalAlignment(ElementAlignment.CENTER);
                FormatStep.this.updateAlignmentButtons(ElementAlignment.CENTER);
            }
        }

        public void setAlignmentRight() {
            if (FormatStep.this.activeField == null) {
                return;
            }
            FieldDefinition fieldDefinition = FormatStep.this.activeField.getFieldDefinition();
            if (fieldDefinition instanceof DetailFieldDefinition) {
                DetailFieldDefinition definition = (DetailFieldDefinition)fieldDefinition;
                definition.setHorizontalAlignment(ElementAlignment.RIGHT);
                FormatStep.this.updateAlignmentButtons(ElementAlignment.RIGHT);
            } else if (fieldDefinition instanceof GroupDefinition) {
                GroupDefinition groupDefinition = (GroupDefinition)fieldDefinition;
                groupDefinition.setTotalsHorizontalAlignment(ElementAlignment.RIGHT);
                FormatStep.this.updateAlignmentButtons(ElementAlignment.RIGHT);
            }
        }

        public void setAlignmentJustify() {
            if (FormatStep.this.activeField == null) {
                return;
            }
            FieldDefinition fieldDefinition = FormatStep.this.activeField.getFieldDefinition();
            if (fieldDefinition instanceof DetailFieldDefinition) {
                DetailFieldDefinition definition = (DetailFieldDefinition)fieldDefinition;
                definition.setHorizontalAlignment(ElementAlignment.JUSTIFY);
                FormatStep.this.updateAlignmentButtons(ElementAlignment.JUSTIFY);
            } else if (fieldDefinition instanceof GroupDefinition) {
                GroupDefinition groupDefinition = (GroupDefinition)fieldDefinition;
                groupDefinition.setTotalsHorizontalAlignment(ElementAlignment.JUSTIFY);
                FormatStep.this.updateAlignmentButtons(ElementAlignment.JUSTIFY);
            }
        }
    }

    private static class MetaDataWrapper {
        private ExpressionMetaData emd;

        public MetaDataWrapper(ExpressionMetaData emd) {
            this.emd = emd;
        }

        public ExpressionMetaData getWrappedObject() {
            return this.emd;
        }

        public String toString() {
            if (this.emd == null) {
                return messages.getString("FORMAT_STEP.None");
            }
            return this.emd.getDisplayName(Locale.getDefault());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AggregationBindingConverter
    extends BindingConvertor<Class, Integer> {
        private AggregationBindingConverter() {
        }

        public Integer sourceToTarget(Class value) {
            if (value == null) {
                return 0;
            }
            for (int i = 1; i < FormatStep.this.allExpressionMetaDatas.size(); ++i) {
                ExpressionMetaData data = ((MetaDataWrapper)FormatStep.this.allExpressionMetaDatas.get(i)).getWrappedObject();
                if (data == null) {
                    return 0;
                }
                Class testValue = data.getExpressionType();
                if (!value.equals(testValue)) continue;
                return i;
            }
            return 0;
        }

        public Class targetToSource(Integer value) {
            if (value == null) {
                return null;
            }
            ExpressionMetaData emd = ((MetaDataWrapper)FormatStep.this.allExpressionMetaDatas.get(value)).getWrappedObject();
            if (emd == null) {
                return null;
            }
            return emd.getExpressionType();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FormatTypeBinding
    extends BindingConvertor<int[], Integer> {
        private XulListbox activeTree;
        private XulListbox inactiveTree;

        public FormatTypeBinding(XulListbox activeTree, XulListbox inactiveTree) {
            if (activeTree == null) {
                throw new NullPointerException();
            }
            if (inactiveTree == null) {
                throw new NullPointerException();
            }
            this.activeTree = activeTree;
            this.inactiveTree = inactiveTree;
        }

        public Integer sourceToTarget(int[] value) {
            if (!(this.activeTree.getSelectedIndices() != null && this.activeTree.getSelectedIndices().length >= 1 || this.inactiveTree.getSelectedIndices() != null && this.inactiveTree.getSelectedIndices().length >= 1)) {
                return 0;
            }
            if (value == null || value.length < 1) {
                XulDeck deck = (XulDeck)FormatStep.this.getDocument().getElementById(FormatStep.FORMAT_DECK_ID);
                return deck.getSelectedIndex();
            }
            this.inactiveTree.setSelectedIndices(new int[0]);
            FormatStep.this.updateBindings(this.activeTree);
            if (this.activeTree.getId().equals(FormatStep.FORMAT_DETAILS_LIST_ID)) {
                return 1;
            }
            return 2;
        }

        public int[] targetToSource(Integer value) {
            return null;
        }
    }
}

