/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.wizard.ui.xul.steps;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.pentaho.reporting.engine.classic.core.AbstractReportDefinition;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.designtime.DesignTimeUtil;
import org.pentaho.reporting.engine.classic.wizard.WizardProcessorUtil;
import org.pentaho.reporting.engine.classic.wizard.model.DefaultWizardSpecification;
import org.pentaho.reporting.engine.classic.wizard.model.WizardSpecification;
import org.pentaho.reporting.engine.classic.wizard.ui.xul.WizardEditorModel;
import org.pentaho.reporting.engine.classic.wizard.ui.xul.components.AbstractWizardStep;
import org.pentaho.reporting.libraries.base.util.DebugLog;
import org.pentaho.reporting.libraries.base.util.FilesystemFilter;
import org.pentaho.reporting.libraries.base.util.IOUtils;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.libraries.docbundle.BundleUtilities;
import org.pentaho.reporting.libraries.docbundle.DocumentBundle;
import org.pentaho.reporting.libraries.docbundle.MemoryDocumentBundle;
import org.pentaho.reporting.libraries.docbundle.WriteableDocumentBundle;
import org.pentaho.reporting.libraries.resourceloader.Resource;
import org.pentaho.reporting.libraries.resourceloader.ResourceException;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;
import org.pentaho.ui.xul.XulDomContainer;
import org.pentaho.ui.xul.XulException;
import org.pentaho.ui.xul.binding.Binding;
import org.pentaho.ui.xul.binding.BindingConvertor;
import org.pentaho.ui.xul.components.XulFileDialog;
import org.pentaho.ui.xul.components.XulRadio;
import org.pentaho.ui.xul.components.XulTextbox;
import org.pentaho.ui.xul.containers.XulListbox;
import org.pentaho.ui.xul.impl.AbstractXulEventHandler;
import org.pentaho.ui.xul.impl.XulEventHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LookAndFeelStep
extends AbstractWizardStep {
    private static final String LOOK_AND_FEEL_STEP_OVERLAY = "org/pentaho/reporting/engine/classic/wizard/ui/xul/res/look_and_feel_step_Overlay.xul";
    private static final String HANDLER_NAME = "look_and_feel_handler";
    private static final String SELECTED_PROPERTY_NAME = "selected";
    private static final String SELECTED_INDEX_PROPERTY_NAME = "selectedIndex";
    private static final String START_FROM_FILE_PROPERTY_NAME = "startFromFile";
    private static final String NOT_SELECTED_PROPERTY_NAME = "!selected";
    private static final String FILENAME_PROPERTY_NAME = "fileName";
    private static final String VALUE_PROPERTY_NAME = "value";
    private static final String ELEMENTS_PROPERTY_NAME = "elements";
    private static final String SELECTED_TEMPLATE_PROPERTY_NAME = "selectedTemplate";
    private static final String TEMPLATES_PROPERTY_NAME = "templates";
    private static final String SOURCE_PROPERTY_NAME = "src";
    private static final String NEW_WIZARD_FILE_RB_ID = "new_wizard_file_rb";
    private static final String SELECT_LOOK_AND_FEEL_DECK_ID = "select_lf_deck";
    private static final String WIZARD_FILENAME_TB_ID = "wizard_filename_tb";
    private static final String AVAILABLE_TEMPLATES_LB_ID = "avail_template_lb";
    private static final String TEMPLATE_IMAGE_ID = "template_image";
    private static final String REPORT_EXTENSION = ".prpt";
    private static final String PAINTING_EXTENSION = ".png";
    private String fileName;
    private boolean startFromFile;
    private List<String> templates = new ArrayList<String>();
    private Map<Integer, File> templateHash = new HashMap<Integer, File>();
    private Integer selectedTemplate = -1;
    private boolean selectedTemplateChanged = false;
    private ResourceManager resourceManager = new ResourceManager();

    public LookAndFeelStep() {
        this.resourceManager.registerDefaults();
        this.loadTemplates();
    }

    private void loadTemplates() {
        File homeDir = LookAndFeelStep.computeInstallationDirectory();
        System.out.println(homeDir.getAbsolutePath());
        if (homeDir == null) {
            return;
        }
        File templatesDir = new File(homeDir, TEMPLATES_PROPERTY_NAME);
        if (templatesDir.exists()) {
            File[] reportFiles = templatesDir.listFiles((FilenameFilter)new FilesystemFilter(REPORT_EXTENSION, REPORT_EXTENSION, false));
            ArrayList<String> templateNameList = new ArrayList<String>();
            for (File file : reportFiles) {
                String reportName = this.computeReportName(file);
                if (reportName == null) continue;
                this.templateHash.put(templateNameList.size(), file);
                templateNameList.add(reportName);
            }
            this.setTemplates(templateNameList);
            if (templateNameList.size() > 0) {
                boolean oldSelectedTemplateChanged = this.selectedTemplateChanged;
                if (this.selectedTemplate < 0) {
                    this.setSelectedTemplate(0);
                }
                this.selectedTemplateChanged = oldSelectedTemplateChanged;
            }
        }
    }

    private String computeReportName(File reportFile) {
        try {
            ResourceKey resourceKey = this.resourceManager.createKey((Object)reportFile);
            String reportName = this.computeNameFromMetadata(this.resourceManager, resourceKey);
            if (StringUtils.isEmpty((String)reportName)) {
                return this.computeNameFromReport(this.resourceManager, resourceKey);
            }
            return reportName;
        }
        catch (ResourceException re) {
            return null;
        }
    }

    private String computeNameFromMetadata(ResourceManager resourceManager, ResourceKey key) {
        try {
            Resource res = resourceManager.create(key, null, new Class[]{DocumentBundle.class});
            DocumentBundle rawResource = (DocumentBundle)res.getResource();
            Object possibleTitle = rawResource.getMetaData().getBundleAttribute("http://purl.org/dc/elements/1.1/", "title");
            if (possibleTitle != null) {
                return possibleTitle.toString();
            }
            return null;
        }
        catch (ResourceException re) {
            return null;
        }
    }

    private String computeNameFromReport(ResourceManager resourceManager, ResourceKey key) {
        try {
            Resource res = resourceManager.create(key, null, new Class[]{MasterReport.class});
            MasterReport rawResource = (MasterReport)res.getResource();
            String possibleTitle = rawResource.getName();
            if (possibleTitle != null) {
                return possibleTitle.toString();
            }
            return null;
        }
        catch (ResourceException re) {
            return null;
        }
    }

    public static File computeInstallationDirectory() {
        URL location = LookAndFeelStep.class.getProtectionDomain().getCodeSource().getLocation();
        DebugLog.log((Object)("InstallationDirectory: Protection-Domain: " + location));
        if (location == null) {
            return null;
        }
        if (!"file".equals(location.getProtocol())) {
            DebugLog.log((Object)"InstallationDirectory: Protection-Domain: Protocol failure.");
            return null;
        }
        try {
            File jarPositon = new File(location.getFile());
            if (!jarPositon.isFile()) {
                String file = URLDecoder.decode(location.getFile(), ClassicEngineBoot.getInstance().getGlobalConfig().getConfigProperty("file.encoding", "ISO-8859-1"));
                jarPositon = new File(file);
            }
            DebugLog.log((Object)("InstallationDirectory: JAR file: " + jarPositon));
            if (jarPositon.isFile()) {
                File libDirectory = jarPositon.getCanonicalFile().getParentFile();
                if (libDirectory == null) {
                    DebugLog.log((Object)"InstallationDirectory: No lib directory.");
                    return null;
                }
                DebugLog.log((Object)("InstallationDirectory: Work directory: " + libDirectory.getParentFile()));
                return libDirectory.getParentFile();
            }
        }
        catch (IOException ioe) {
            DebugLog.log((Object)"InstallationDirectory: Failed to decode URL: ", (Throwable)ioe);
        }
        DebugLog.log((Object)"InstallationDirectory: Work directory: Defaulting to current work directory.");
        return new File(".");
    }

    @Override
    public void setBindings() {
        block2: {
            this.getBindingFactory().setBindingType(Binding.Type.ONE_WAY);
            Binding typeBinding = this.getBindingFactory().createBinding(NEW_WIZARD_FILE_RB_ID, SELECTED_PROPERTY_NAME, SELECT_LOOK_AND_FEEL_DECK_ID, SELECTED_INDEX_PROPERTY_NAME, new BindingConvertor[]{new BooleanToIntegerBindingConverter()});
            Binding templatesBinding = this.getBindingFactory().createBinding((Object)this, TEMPLATES_PROPERTY_NAME, AVAILABLE_TEMPLATES_LB_ID, ELEMENTS_PROPERTY_NAME, new BindingConvertor[0]);
            this.getBindingFactory().createBinding((Object)this, SELECTED_TEMPLATE_PROPERTY_NAME, TEMPLATE_IMAGE_ID, SOURCE_PROPERTY_NAME, new BindingConvertor[]{new SelectedTemplateToImageConverter()});
            this.getBindingFactory().setBindingType(Binding.Type.BI_DIRECTIONAL);
            Binding selectedTemplateBinding = this.getBindingFactory().createBinding(AVAILABLE_TEMPLATES_LB_ID, SELECTED_INDEX_PROPERTY_NAME, (Object)this, SELECTED_TEMPLATE_PROPERTY_NAME, new BindingConvertor[0]);
            this.getBindingFactory().createBinding((Object)this, START_FROM_FILE_PROPERTY_NAME, NEW_WIZARD_FILE_RB_ID, NOT_SELECTED_PROPERTY_NAME, new BindingConvertor[0]);
            this.getBindingFactory().createBinding((Object)this, FILENAME_PROPERTY_NAME, WIZARD_FILENAME_TB_ID, VALUE_PROPERTY_NAME, new BindingConvertor[0]);
            try {
                typeBinding.fireSourceChanged();
                templatesBinding.fireSourceChanged();
                selectedTemplateBinding.fireSourceChanged();
            }
            catch (Exception e) {
                if (this.getDesignTimeContext() == null) break block2;
                this.getDesignTimeContext().error(e);
            }
        }
    }

    @Override
    public boolean stepDeactivating() {
        super.stepDeactivating();
        WizardEditorModel editorModel = this.getEditorModel();
        try {
            if (this.startFromFile && this.fileName != null) {
                AbstractReportDefinition substituteReportDefinition = this.loadDefinitionFromFile(new File(this.fileName));
                if (substituteReportDefinition == null) {
                    return false;
                }
                substituteReportDefinition.setName(editorModel.getReportDefinition().getName());
                substituteReportDefinition.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/wizard", "template", (Object)this.fileName);
                editorModel.setReportDefinition(substituteReportDefinition, false);
                return true;
            }
            if (editorModel.isEditing()) {
                if (this.selectedTemplateChanged) {
                    AbstractReportDefinition report;
                    if (this.selectedTemplate == -1) {
                        report = editorModel.getEmptyTemplate();
                    } else {
                        File file = this.templateHash.get(this.selectedTemplate);
                        if (file != null) {
                            this.fileName = file.getAbsolutePath();
                            report = this.loadDefinitionFromFile(file);
                            if (report == null) {
                                return false;
                            }
                        } else {
                            return false;
                        }
                    }
                    WizardSpecification specification = editorModel.getReportSpec();
                    DataFactory dataFactory = editorModel.getReportDefinition().getDataFactory().derive();
                    String oldName = editorModel.getReportDefinition().getName();
                    report.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/wizard", "template", (Object)this.fileName);
                    report.setDataFactory(dataFactory);
                    report.setName(oldName);
                    WizardProcessorUtil.applyWizardSpec((AbstractReportDefinition)report, (WizardSpecification)specification);
                    editorModel.setReportDefinition(report, true);
                    return true;
                }
                return true;
            }
            if (!this.startFromFile && this.selectedTemplate == -1) {
                AbstractReportDefinition report = editorModel.getEmptyTemplate();
                DefaultWizardSpecification specification = new DefaultWizardSpecification();
                WizardProcessorUtil.applyWizardSpec((AbstractReportDefinition)report, (WizardSpecification)specification);
                editorModel.setReportDefinition(report, false);
                return true;
            }
            if (this.selectedTemplate != -1) {
                File reportFile = this.templateHash.get(this.selectedTemplate);
                this.fileName = reportFile != null ? reportFile.getAbsolutePath() : null;
            }
            if (this.fileName == null || this.fileName.length() < 1) {
                return false;
            }
            AbstractReportDefinition fileReportDefinition = this.loadDefinitionFromFile(new File(this.fileName));
            if (fileReportDefinition == null) {
                return false;
            }
            if (fileReportDefinition instanceof MasterReport) {
                DesignTimeUtil.resetTemplate((MasterReport)((MasterReport)fileReportDefinition));
            }
            fileReportDefinition.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/wizard", "template", (Object)this.fileName);
            editorModel.setReportDefinition(fileReportDefinition);
            return true;
        }
        catch (Exception e) {
            this.getDesignTimeContext().error(e);
            return false;
        }
    }

    private AbstractReportDefinition loadDefinitionFromFile(File filename) {
        try {
            ResourceKey selectedFile = this.resourceManager.createKey((Object)filename);
            Resource directly = this.resourceManager.create(selectedFile, null, new Class[]{MasterReport.class});
            MasterReport resource = (MasterReport)directly.getResource();
            DocumentBundle bundle = resource.getBundle();
            if (bundle == null) {
                MemoryDocumentBundle documentBundle = new MemoryDocumentBundle(resource.getContentBase());
                documentBundle.getWriteableDocumentMetaData().setBundleType("application/vnd.pentaho.reporting.classic");
                resource.setBundle((DocumentBundle)documentBundle);
                resource.setContentBase(documentBundle.getBundleMainKey());
            } else {
                MemoryDocumentBundle mem = new MemoryDocumentBundle(resource.getContentBase());
                BundleUtilities.copyStickyInto((WriteableDocumentBundle)mem, (DocumentBundle)bundle);
                BundleUtilities.copyMetaData((MemoryDocumentBundle)mem, (DocumentBundle)bundle);
                resource.setBundle((DocumentBundle)mem);
                resource.setContentBase(mem.getBundleMainKey());
            }
            return (AbstractReportDefinition)resource.derive();
        }
        catch (Exception ex) {
            this.getDesignTimeContext().error(ex);
            return null;
        }
    }

    @Override
    public void stepActivating() {
        super.stepActivating();
        this.selectedTemplateChanged = false;
        if (!this.getEditorModel().isEditing() && ((XulRadio)this.getDocument().getElementById(NEW_WIZARD_FILE_RB_ID)).isSelected() && ((XulListbox)this.getDocument().getElementById(AVAILABLE_TEMPLATES_LB_ID)).getSelectedIndex() == -1) {
            ((XulListbox)this.getDocument().getElementById(AVAILABLE_TEMPLATES_LB_ID)).setSelectedIndex(0);
        }
        this.setValid(this.validateStep());
    }

    private boolean validateStep() {
        if (this.getEditorModel().isEditing()) {
            return true;
        }
        if (this.startFromFile) {
            return this.fileName != null && this.fileName.length() >= 1;
        }
        return true;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        String oldFileName = this.fileName;
        this.fileName = fileName;
        if (!ObjectUtilities.equal((Object)oldFileName, (Object)fileName)) {
            this.setValid(this.validateStep());
        }
    }

    public boolean isStartFromFile() {
        return this.startFromFile;
    }

    public void setStartFromFile(boolean startFromFile) {
        boolean oldStartFromFile = this.startFromFile;
        this.startFromFile = startFromFile;
        if (oldStartFromFile != startFromFile) {
            this.setValid(this.validateStep());
        }
    }

    @Override
    public void createPresentationComponent(XulDomContainer mainWizardContainer) throws XulException {
        super.createPresentationComponent(mainWizardContainer);
        mainWizardContainer.loadOverlay(LOOK_AND_FEEL_STEP_OVERLAY);
        mainWizardContainer.addEventHandler((XulEventHandler)new SelectTemplateStepHandler());
    }

    @Override
    public String getStepName() {
        return messages.getString("LOOK_AND_FEEL_STEP.Step_Name");
    }

    public List<String> getTemplates() {
        return this.templates;
    }

    public void setTemplates(List<String> templates) {
        List<String> oldTemplates = this.templates;
        this.templates = templates;
        this.firePropertyChange(TEMPLATES_PROPERTY_NAME, oldTemplates, this.templates);
    }

    private Integer getIndexForTemplatePath(String absolutePath) {
        if (absolutePath == null || absolutePath.length() < 1) {
            return -1;
        }
        for (int i = 0; i < this.templateHash.size(); ++i) {
            File file = this.templateHash.get(i);
            if (!file.getAbsolutePath().equals(absolutePath)) continue;
            return i;
        }
        return -1;
    }

    public void setSelectedTemplateByPath(String path) {
        this.setSelectedTemplate(this.getIndexForTemplatePath(path));
    }

    public Integer getSelectedTemplate() {
        return this.selectedTemplate;
    }

    public void setSelectedTemplate(Integer selectedTemplate) {
        Integer oldSelectedTemplate = this.selectedTemplate;
        this.selectedTemplate = selectedTemplate;
        this.selectedTemplateChanged = true;
        this.firePropertyChange(SELECTED_TEMPLATE_PROPERTY_NAME, oldSelectedTemplate, this.selectedTemplate);
    }

    protected class SelectTemplateStepHandler
    extends AbstractXulEventHandler {
        private File file;

        protected SelectTemplateStepHandler() {
        }

        public String getName() {
            return LookAndFeelStep.HANDLER_NAME;
        }

        public void selectFile() {
            try {
                XulFileDialog fd = (XulFileDialog)this.document.createElement("filedialog");
                fd.setModalParent((Object)LookAndFeelStep.this.getDesignTimeContext().getParentWindow());
                fd.showOpenDialog();
                this.file = (File)fd.getFile();
                if (this.file != null) {
                    String filePath = this.file.getAbsolutePath();
                    XulTextbox fileTextBox = (XulTextbox)this.document.getElementById(LookAndFeelStep.WIZARD_FILENAME_TB_ID);
                    fileTextBox.setValue(filePath);
                    LookAndFeelStep.this.setFileName(filePath);
                }
            }
            catch (XulException e) {
                LookAndFeelStep.this.getDesignTimeContext().error((Exception)((Object)e));
            }
        }

        public File getFile() {
            return this.file;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SelectedTemplateToImageConverter
    extends BindingConvertor<Integer, String> {
        private SelectedTemplateToImageConverter() {
        }

        public String sourceToTarget(Integer value) {
            if (value != -1) {
                File srcPath = (File)LookAndFeelStep.this.templateHash.get(value);
                File homeDir = LookAndFeelStep.computeInstallationDirectory();
                if (homeDir == null) {
                    return null;
                }
                File templatesDir = new File(homeDir, LookAndFeelStep.TEMPLATES_PROPERTY_NAME);
                if (templatesDir.exists()) {
                    String simpleName = IOUtils.getInstance().stripFileExtension(srcPath.getName());
                    File file = new File(templatesDir, simpleName + LookAndFeelStep.PAINTING_EXTENSION);
                    try {
                        return file.getCanonicalPath();
                    }
                    catch (IOException e) {
                        return file.getAbsolutePath();
                    }
                }
            }
            return null;
        }

        public Integer targetToSource(String value) {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BooleanToIntegerBindingConverter
    extends BindingConvertor<Boolean, Integer> {
        private BooleanToIntegerBindingConverter() {
        }

        public Integer sourceToTarget(Boolean value) {
            return value != false ? 1 : 0;
        }

        public Boolean targetToSource(Integer value) {
            if (value == null) {
                return null;
            }
            if (1 == value) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
    }
}

