/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.amazon;

import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemOptions;
import org.apache.commons.vfs.UserAuthenticator;
import org.apache.commons.vfs.auth.StaticUserAuthenticator;
import org.apache.commons.vfs.impl.DefaultFileSystemConfigBuilder;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.pentaho.amazon.AbstractAmazonJobEntry;
import org.pentaho.amazon.emr.job.AmazonElasticMapReduceJobExecutor;
import org.pentaho.amazon.s3.S3VfsFileChooserHelper;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleFileException;
import org.pentaho.di.core.util.StringUtil;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.variables.Variables;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.core.database.dialog.tags.ExtTextbox;
import org.pentaho.di.ui.core.gui.WindowProperty;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.ui.xul.components.XulTextbox;
import org.pentaho.ui.xul.containers.XulDialog;
import org.pentaho.ui.xul.impl.AbstractXulEventHandler;
import org.pentaho.vfs.ui.VfsFileChooserDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAmazonJobExecutorController
extends AbstractXulEventHandler {
    private static final Class<?> PKG = AmazonElasticMapReduceJobExecutor.class;
    public static final String JOB_ENTRY_NAME = "jobEntryName";
    public static final String HADOOP_JOB_NAME = "hadoopJobName";
    public static final String HADOOP_JOB_FLOW_ID = "hadoopJobFlowId";
    public static final String JAR_URL = "jarUrl";
    public static final String ACCESS_KEY = "accessKey";
    public static final String SECRET_KEY = "secretKey";
    public static final String STAGING_DIR = "stagingDir";
    public static final String STAGING_DIR_FILE = "stagingDirFile";
    public static final String NUM_INSTANCES = "numInstances";
    public static final String MASTER_INSTANCE_TYPE = "masterInstanceType";
    public static final String SLAVE_INSTANCE_TYPE = "slaveInstanceType";
    public static final String CMD_LINE_ARGS = "commandLineArgs";
    public static final String BLOCKING = "blocking";
    public static final String LOGGING_INTERVAL = "loggingInterval";
    public static final String XUL_JOBENTRY_HADOOPJOB_NAME = "jobentry-hadoopjob-name";
    public static final String XUL_ACCESS_KEY1 = "access-key";
    public static final String XUL_SECRET_KEY1 = "secret-key";
    public static final String XUL_JOBENTRY_HADOOPJOB_FLOW_ID = "jobentry-hadoopjob-flow-id";
    public static final String XUL_S3_STAGING_DIRECTORY = "s3-staging-directory";
    public static final String XUL_COMMAND_LINE_ARGUMENTS = "command-line-arguments";
    public static final String XUL_NUM_INSTANCES1 = "num-instances";
    public static final String XUL_LOGGING_INTERVAL1 = "logging-interval";
    public static final String XUL_AMAZON_EMR_JOB_ENTRY_DIALOG = "amazon-emr-job-entry-dialog";
    public static final String XUL_AMAZON_EMR_ERROR_DIALOG = "amazon-emr-error-dialog";
    public static final String XUL_AMAZON_EMR_ERROR_MESSAGE = "amazon-emr-error-message";
    public static final String XUL_JAR_URL = "jar-url";
    public static final String MSG_AMAZON_ELASTIC_MAP_REDUCE_JOB_EXECUTOR_JOB_ENTRY_NAME_ERROR = "AmazonElasticMapReduceJobExecutor.JobEntryName.Error";
    public static final String MSG_AMAZON_ELASTIC_MAP_REDUCE_JOB_EXECUTOR_JOB_FLOW_NAME_ERROR = "AmazonElasticMapReduceJobExecutor.JobFlowName.Error";
    public static final String MSG_AMAZON_ELASTIC_MAP_REDUCE_JOB_EXECUTOR_ACCESS_KEY_ERROR = "AmazonElasticMapReduceJobExecutor.AccessKey.Error";
    public static final String MSG_AMAZON_ELASTIC_MAP_REDUCE_JOB_EXECUTOR_SECRET_KEY_ERROR = "AmazonElasticMapReduceJobExecutor.SecretKey.Error";
    public static final String MSG_AMAZON_ELASTIC_MAP_REDUCE_JOB_EXECUTOR_STAGING_DIR_ERROR = "AmazonElasticMapReduceJobExecutor.StagingDir.Error";
    public static final String MSG_AMAZON_ELASTIC_MAP_REDUCE_JOB_EXECUTOR_MASTER_INSTANCE_TYPE_ERROR = "AmazonElasticMapReduceJobExecutor.MasterInstanceType.Error";
    public static final String MSG_AMAZON_ELASTIC_MAP_REDUCE_JOB_EXECUTOR_SLAVE_INSTANCE_TYPE_ERROR = "AmazonElasticMapReduceJobExecutor.SlaveInstanceType.Error";
    public static final String MSG_DIALOG_ERROR = "Dialog.Error";
    public static final String MSG_AMAZON_ELASTIC_MAP_REDUCE_JOB_EXECUTOR_JAR_URL_ERROR = "AmazonElasticMapReduceJobExecutor.JarURL.Error";
    protected String jobEntryName;
    protected String hadoopJobName;
    protected String hadoopJobFlowId;
    protected String accessKey = "";
    protected String secretKey = "";
    protected String stagingDir = "";
    protected FileObject stagingDirFile = null;
    protected String jarUrl = "";
    protected String numInstances = "2";
    protected String masterInstanceType = "m1.small";
    protected String slaveInstanceType = "m1.small";
    protected String cmdLineArgs;
    protected boolean blocking;
    protected String loggingInterval = "60";
    protected VfsFileChooserDialog fileChooserDialog;
    protected S3VfsFileChooserHelper helper;

    public void accept() {
        this.syncModel();
        String validationErrors = this.buildValidationErrorMessages();
        if (!StringUtil.isEmpty((String)validationErrors)) {
            this.openErrorDialog(BaseMessages.getString(PKG, (String)MSG_DIALOG_ERROR, (String[])new String[0]), validationErrors);
            return;
        }
        this.configureJobEntry();
        this.cancel();
    }

    protected void syncModel() {
        ExtTextbox tempBox = (ExtTextbox)this.getXulDomContainer().getDocumentRoot().getElementById(XUL_JOBENTRY_HADOOPJOB_NAME);
        this.hadoopJobName = ((Text)tempBox.getTextControl()).getText();
        tempBox = (ExtTextbox)this.getXulDomContainer().getDocumentRoot().getElementById(XUL_ACCESS_KEY1);
        this.accessKey = ((Text)tempBox.getTextControl()).getText();
        tempBox = (ExtTextbox)this.getXulDomContainer().getDocumentRoot().getElementById(XUL_SECRET_KEY1);
        this.secretKey = ((Text)tempBox.getTextControl()).getText();
        tempBox = (ExtTextbox)this.getXulDomContainer().getDocumentRoot().getElementById(XUL_JOBENTRY_HADOOPJOB_FLOW_ID);
        this.hadoopJobFlowId = ((Text)tempBox.getTextControl()).getText();
        tempBox = (ExtTextbox)this.getXulDomContainer().getDocumentRoot().getElementById(XUL_S3_STAGING_DIRECTORY);
        this.stagingDir = ((Text)tempBox.getTextControl()).getText();
        try {
            this.stagingDirFile = this.resolveFile(this.stagingDir);
        }
        catch (Exception e) {
            this.stagingDirFile = null;
        }
        tempBox = (ExtTextbox)this.getXulDomContainer().getDocumentRoot().getElementById(XUL_COMMAND_LINE_ARGUMENTS);
        this.cmdLineArgs = ((Text)tempBox.getTextControl()).getText();
        tempBox = (ExtTextbox)this.getXulDomContainer().getDocumentRoot().getElementById(XUL_NUM_INSTANCES1);
        this.numInstances = ((Text)tempBox.getTextControl()).getText();
        tempBox = (ExtTextbox)this.getXulDomContainer().getDocumentRoot().getElementById(XUL_LOGGING_INTERVAL1);
        this.loggingInterval = ((Text)tempBox.getTextControl()).getText();
    }

    protected String buildValidationErrorMessages() {
        String validationErrors = "";
        if (StringUtil.isEmpty((String)this.getJobEntryName())) {
            validationErrors = validationErrors + BaseMessages.getString(PKG, (String)MSG_AMAZON_ELASTIC_MAP_REDUCE_JOB_EXECUTOR_JOB_ENTRY_NAME_ERROR, (String[])new String[0]) + "\n";
        }
        if (StringUtil.isEmpty((String)this.getHadoopJobName())) {
            validationErrors = validationErrors + BaseMessages.getString(PKG, (String)MSG_AMAZON_ELASTIC_MAP_REDUCE_JOB_EXECUTOR_JOB_FLOW_NAME_ERROR, (String[])new String[0]) + "\n";
        }
        if (StringUtil.isEmpty((String)this.getAccessKey())) {
            validationErrors = validationErrors + BaseMessages.getString(PKG, (String)MSG_AMAZON_ELASTIC_MAP_REDUCE_JOB_EXECUTOR_ACCESS_KEY_ERROR, (String[])new String[0]) + "\n";
        }
        if (StringUtil.isEmpty((String)this.getSecretKey())) {
            validationErrors = validationErrors + BaseMessages.getString(PKG, (String)MSG_AMAZON_ELASTIC_MAP_REDUCE_JOB_EXECUTOR_SECRET_KEY_ERROR, (String[])new String[0]) + "\n";
        }
        String s3Protocol = "s3://";
        String sdir = this.getVariableSpace().environmentSubstitute(this.stagingDir);
        if (StringUtil.isEmpty((String)this.getStagingDir())) {
            validationErrors = validationErrors + BaseMessages.getString(PKG, (String)MSG_AMAZON_ELASTIC_MAP_REDUCE_JOB_EXECUTOR_STAGING_DIR_ERROR, (String[])new String[0]) + "\n";
        } else if (!sdir.startsWith(s3Protocol)) {
            validationErrors = validationErrors + BaseMessages.getString(PKG, (String)MSG_AMAZON_ELASTIC_MAP_REDUCE_JOB_EXECUTOR_STAGING_DIR_ERROR, (String[])new String[0]) + "\n";
        }
        if (StringUtil.isEmpty((String)this.getMasterInstanceType())) {
            validationErrors = validationErrors + BaseMessages.getString(PKG, (String)MSG_AMAZON_ELASTIC_MAP_REDUCE_JOB_EXECUTOR_MASTER_INSTANCE_TYPE_ERROR, (String[])new String[0]) + "\n";
        }
        if (StringUtil.isEmpty((String)this.getSlaveInstanceType())) {
            validationErrors = validationErrors + BaseMessages.getString(PKG, (String)MSG_AMAZON_ELASTIC_MAP_REDUCE_JOB_EXECUTOR_SLAVE_INSTANCE_TYPE_ERROR, (String[])new String[0]) + "\n";
        }
        return validationErrors;
    }

    protected void configureJobEntry() {
        this.getJobEntry().setName(this.getJobEntryName());
        ((AbstractAmazonJobEntry)this.getJobEntry()).setHadoopJobName(this.getHadoopJobName());
        ((AbstractAmazonJobEntry)this.getJobEntry()).setHadoopJobFlowId(this.getHadoopJobFlowId());
        ((AbstractAmazonJobEntry)this.getJobEntry()).setAccessKey(this.getAccessKey());
        ((AbstractAmazonJobEntry)this.getJobEntry()).setSecretKey(this.getSecretKey());
        ((AbstractAmazonJobEntry)this.getJobEntry()).setStagingDir(this.getStagingDir());
        ((AbstractAmazonJobEntry)this.getJobEntry()).setJarUrl(this.getJarUrl());
        ((AbstractAmazonJobEntry)this.getJobEntry()).setNumInstances(this.getNumInstances());
        ((AbstractAmazonJobEntry)this.getJobEntry()).setMasterInstanceType(this.getMasterInstanceType());
        ((AbstractAmazonJobEntry)this.getJobEntry()).setSlaveInstanceType(this.getSlaveInstanceType());
        ((AbstractAmazonJobEntry)this.getJobEntry()).setCmdLineArgs(this.getCommandLineArgs());
        ((AbstractAmazonJobEntry)this.getJobEntry()).setBlocking(this.isBlocking());
        ((AbstractAmazonJobEntry)this.getJobEntry()).setLoggingInterval(this.getLoggingInterval());
        this.getJobEntry().setChanged();
    }

    public void init() {
        if (this.getJobEntry() != null) {
            this.setName(this.getJobEntry().getName());
            this.setJobEntryName(this.getJobEntry().getName());
            this.setHadoopJobName(((AbstractAmazonJobEntry)this.getJobEntry()).getHadoopJobName());
            this.setHadoopJobFlowId(((AbstractAmazonJobEntry)this.getJobEntry()).getHadoopJobFlowId());
            this.setAccessKey(((AbstractAmazonJobEntry)this.getJobEntry()).getAccessKey());
            this.setSecretKey(((AbstractAmazonJobEntry)this.getJobEntry()).getSecretKey());
            this.setStagingDir(((AbstractAmazonJobEntry)this.getJobEntry()).getStagingDir());
            this.setJarUrl(((AbstractAmazonJobEntry)this.getJobEntry()).getJarUrl());
            this.setNumInstances(((AbstractAmazonJobEntry)this.getJobEntry()).getNumInstances());
            this.setMasterInstanceType(((AbstractAmazonJobEntry)this.getJobEntry()).getMasterInstanceType());
            this.setSlaveInstanceType(((AbstractAmazonJobEntry)this.getJobEntry()).getSlaveInstanceType());
            this.setCommandLineArgs(((AbstractAmazonJobEntry)this.getJobEntry()).getCmdLineArgs());
            this.setBlocking(((AbstractAmazonJobEntry)this.getJobEntry()).isBlocking());
            this.setLoggingInterval(((AbstractAmazonJobEntry)this.getJobEntry()).getLoggingInterval());
        }
    }

    public void cancel() {
        XulDialog xulDialog = (XulDialog)this.getXulDomContainer().getDocumentRoot().getElementById(XUL_AMAZON_EMR_JOB_ENTRY_DIALOG);
        Shell shell = (Shell)xulDialog.getRootObject();
        if (!shell.isDisposed()) {
            WindowProperty winprop = new WindowProperty(shell);
            PropsUI.getInstance().setScreen(winprop);
            ((Composite)xulDialog.getManagedObject()).dispose();
            shell.dispose();
        }
    }

    public void openErrorDialog(String title, String message) {
        XulDialog errorDialog = (XulDialog)this.getXulDomContainer().getDocumentRoot().getElementById(XUL_AMAZON_EMR_ERROR_DIALOG);
        errorDialog.setTitle(title);
        XulTextbox errorMessage = (XulTextbox)this.getXulDomContainer().getDocumentRoot().getElementById(XUL_AMAZON_EMR_ERROR_MESSAGE);
        errorMessage.setValue(message);
        errorDialog.show();
    }

    public void closeErrorDialog() {
        XulDialog errorDialog = (XulDialog)this.getXulDomContainer().getDocumentRoot().getElementById(XUL_AMAZON_EMR_ERROR_DIALOG);
        errorDialog.hide();
    }

    protected VfsFileChooserDialog getFileChooserDialog() throws KettleFileException {
        if (this.fileChooserDialog == null) {
            VfsFileChooserDialog fileChooserDialog;
            Object rootFile = null;
            FileObject initialFile = null;
            FileObject defaultInitialFile = KettleVFS.getFileObject((String)"file:///c:/");
            this.fileChooserDialog = fileChooserDialog = Spoon.getInstance().getVfsFileChooserDialog(defaultInitialFile, initialFile);
        }
        return this.fileChooserDialog;
    }

    protected FileSystemOptions getFileSystemOptions() throws FileSystemException {
        FileSystemOptions opts = new FileSystemOptions();
        if (!Const.isEmpty((String)this.getAccessKey()) || !Const.isEmpty((String)this.getSecretKey())) {
            StaticUserAuthenticator userAuthenticator = new StaticUserAuthenticator(null, this.getVariableSpace().environmentSubstitute(this.getAccessKey()), this.getVariableSpace().environmentSubstitute(this.getSecretKey()));
            DefaultFileSystemConfigBuilder.getInstance().setUserAuthenticator(opts, (UserAuthenticator)userAuthenticator);
        }
        return opts;
    }

    public FileObject browse(String[] fileFilters, String[] fileFilterNames, String fileUri) throws KettleException, FileSystemException {
        return this.browse(fileFilters, fileFilterNames, fileUri, new FileSystemOptions());
    }

    public FileObject browse(String[] fileFilters, String[] fileFilterNames, String fileUri, int fileDialogMode) throws KettleException, FileSystemException {
        return this.browse(fileFilters, fileFilterNames, fileUri, new FileSystemOptions(), fileDialogMode);
    }

    public FileObject browse(String[] fileFilters, String[] fileFilterNames, String fileUri, FileSystemOptions opts) throws KettleException, FileSystemException {
        return this.browse(fileFilters, fileFilterNames, fileUri, opts, 1);
    }

    public FileObject browse(String[] fileFilters, String[] fileFilterNames, String fileUri, FileSystemOptions opts, int fileDialogMode) throws KettleException, FileSystemException {
        return this.browse(fileFilters, fileFilterNames, fileUri, opts, fileDialogMode, false);
    }

    public FileObject browse(String[] fileFilters, String[] fileFilterNames, String fileUri, FileSystemOptions opts, int fileDialogMode, boolean showFileScheme) throws KettleException, FileSystemException {
        this.getFileChooserHelper().setShowFileScheme(showFileScheme);
        return this.getFileChooserHelper().browse(fileFilters, fileFilterNames, fileUri, opts, fileDialogMode);
    }

    public void browseS3StagingDir() throws KettleException, FileSystemException {
        FileSystemOptions opts;
        String[] fileFilters = new String[]{"*.*"};
        String[] fileFilterNames = new String[]{"All"};
        String stagingDirText = this.getVariableSpace().environmentSubstitute(this.stagingDir);
        FileObject selectedFile = this.browse(fileFilters, fileFilterNames, stagingDirText, opts = this.getFileSystemOptions());
        if (selectedFile != null) {
            this.setStagingDir(selectedFile.getName().getURI());
        }
    }

    public VariableSpace getVariableSpace() {
        if (Spoon.getInstance().getActiveTransformation() != null) {
            return Spoon.getInstance().getActiveTransformation();
        }
        if (Spoon.getInstance().getActiveJob() != null) {
            return Spoon.getInstance().getActiveJob();
        }
        return new Variables();
    }

    public String getName() {
        return "jobEntryController";
    }

    public String getJobEntryName() {
        return this.jobEntryName;
    }

    public void setJobEntryName(String jobEntryName) {
        String previousVal = this.jobEntryName;
        String newVal = jobEntryName;
        this.jobEntryName = jobEntryName;
        this.firePropertyChange(JOB_ENTRY_NAME, previousVal, newVal);
    }

    public String getHadoopJobName() {
        return this.hadoopJobName;
    }

    public void setHadoopJobName(String hadoopJobName) {
        String previousVal = this.hadoopJobName;
        String newVal = hadoopJobName;
        this.hadoopJobName = hadoopJobName;
        this.firePropertyChange(HADOOP_JOB_NAME, previousVal, newVal);
    }

    public String getHadoopJobFlowId() {
        return this.hadoopJobFlowId;
    }

    public void setHadoopJobFlowId(String hadoopJobFlowId) {
        String previousVal = this.hadoopJobFlowId;
        String newVal = hadoopJobFlowId;
        this.hadoopJobFlowId = hadoopJobFlowId;
        this.firePropertyChange(HADOOP_JOB_FLOW_ID, previousVal, newVal);
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public void setAccessKey(String accessKey) {
        String previousVal = this.accessKey;
        String newVal = accessKey;
        this.accessKey = accessKey;
        this.firePropertyChange(ACCESS_KEY, previousVal, newVal);
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public void setSecretKey(String secretKey) {
        String previousVal = this.secretKey;
        String newVal = secretKey;
        this.secretKey = secretKey;
        this.firePropertyChange(SECRET_KEY, previousVal, newVal);
    }

    public String getStagingDir() {
        return this.stagingDir;
    }

    public void setStagingDir(String stagingDir) {
        String previousVal = this.stagingDir;
        String newVal = stagingDir;
        this.stagingDir = stagingDir;
        this.firePropertyChange(STAGING_DIR, previousVal, newVal);
    }

    public FileObject getStagingDirFile() {
        return this.stagingDirFile;
    }

    public void setStagingDirFile(FileObject stagingDirFile) {
        FileObject previousVal = this.stagingDirFile;
        FileObject newVal = stagingDirFile;
        this.stagingDirFile = stagingDirFile;
        this.firePropertyChange(STAGING_DIR_FILE, previousVal, newVal);
    }

    public String getJarUrl() {
        return this.jarUrl;
    }

    public void setJarUrl(String jarUrl) {
        String previousVal = this.jarUrl;
        String newVal = jarUrl;
        this.jarUrl = jarUrl;
        this.firePropertyChange(JAR_URL, previousVal, newVal);
    }

    public String getNumInstances() {
        return this.numInstances;
    }

    public void setNumInstances(String numInstances) {
        String previousVal = this.numInstances;
        String newVal = numInstances;
        this.numInstances = numInstances;
        this.firePropertyChange(NUM_INSTANCES, previousVal, newVal);
    }

    public String getMasterInstanceType() {
        return this.masterInstanceType;
    }

    public void setMasterInstanceType(String masterInstanceType) {
        String previousVal = this.masterInstanceType;
        String newVal = masterInstanceType;
        this.masterInstanceType = masterInstanceType;
        this.firePropertyChange(MASTER_INSTANCE_TYPE, previousVal, newVal);
    }

    public String getSlaveInstanceType() {
        return this.slaveInstanceType;
    }

    public void setSlaveInstanceType(String slaveInstanceType) {
        String previousVal = this.slaveInstanceType;
        String newVal = slaveInstanceType;
        this.slaveInstanceType = slaveInstanceType;
        this.firePropertyChange(SLAVE_INSTANCE_TYPE, previousVal, newVal);
    }

    public void invertBlocking() {
        this.setBlocking(!this.isBlocking());
    }

    public abstract <T extends AbstractAmazonJobEntry> T getJobEntry();

    public abstract <T extends AbstractAmazonJobEntry> void setJobEntry(T var1);

    public String getCommandLineArgs() {
        return this.cmdLineArgs;
    }

    public void setCommandLineArgs(String cmdLineArgs) {
        String previousVal = this.cmdLineArgs;
        String newVal = cmdLineArgs;
        this.cmdLineArgs = cmdLineArgs;
        this.firePropertyChange(CMD_LINE_ARGS, previousVal, newVal);
    }

    public boolean isBlocking() {
        return this.blocking;
    }

    public void setBlocking(boolean blocking) {
        boolean previousVal = this.blocking;
        boolean newVal = blocking;
        this.blocking = blocking;
        this.firePropertyChange(BLOCKING, previousVal, newVal);
    }

    public String getLoggingInterval() {
        return this.loggingInterval;
    }

    public void setLoggingInterval(String loggingInterval) {
        String previousVal = this.loggingInterval;
        String newVal = loggingInterval;
        this.loggingInterval = loggingInterval;
        this.firePropertyChange(LOGGING_INTERVAL, previousVal, newVal);
    }

    public FileObject resolveFile(String fileUri) throws FileSystemException, KettleFileException {
        VariableSpace vs = this.getVariableSpace();
        FileSystemOptions opts = new FileSystemOptions();
        DefaultFileSystemConfigBuilder.getInstance().setUserAuthenticator(opts, (UserAuthenticator)new StaticUserAuthenticator(null, this.getAccessKey(), this.getSecretKey()));
        FileObject file = KettleVFS.getFileObject((String)fileUri, (VariableSpace)vs, (FileSystemOptions)opts);
        return file;
    }

    protected S3VfsFileChooserHelper getFileChooserHelper() throws KettleFileException, FileSystemException {
        if (this.helper == null) {
            XulDialog xulDialog = (XulDialog)this.getXulDomContainer().getDocumentRoot().getElementById(XUL_AMAZON_EMR_JOB_ENTRY_DIALOG);
            Shell shell = (Shell)xulDialog.getRootObject();
            this.helper = new S3VfsFileChooserHelper(shell, this.getFileChooserDialog(), this.getVariableSpace(), this.getFileSystemOptions());
        }
        return this.helper;
    }
}

