/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.amazon.emr.ui;

import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemOptions;
import org.eclipse.swt.widgets.Text;
import org.pentaho.amazon.AbstractAmazonJobEntry;
import org.pentaho.amazon.AbstractAmazonJobExecutorController;
import org.pentaho.amazon.emr.job.AmazonElasticMapReduceJobExecutor;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.util.StringUtil;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.ui.core.database.dialog.tags.ExtTextbox;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AmazonElasticMapReduceJobExecutorController
extends AbstractAmazonJobExecutorController {
    private static final Class<?> PKG = AmazonElasticMapReduceJobExecutor.class;
    private AmazonElasticMapReduceJobExecutor jobEntry = null;

    @Override
    protected void syncModel() {
        super.syncModel();
        ExtTextbox tempBox = (ExtTextbox)this.getXulDomContainer().getDocumentRoot().getElementById("jar-url");
        this.jarUrl = ((Text)tempBox.getTextControl()).getText();
    }

    @Override
    protected String buildValidationErrorMessages() {
        String validationErrors = super.buildValidationErrorMessages();
        if (StringUtil.isEmpty((String)this.jarUrl)) {
            validationErrors = validationErrors + BaseMessages.getString(PKG, (String)"AmazonElasticMapReduceJobExecutor.JarURL.Error", (String[])new String[0]) + "\n";
        }
        return validationErrors;
    }

    public void browseJar() throws KettleException, FileSystemException {
        String[] fileFilters = new String[]{"*.jar;*.zip"};
        String[] fileFilterNames = new String[]{"Java Archives (jar)"};
        FileSystemOptions opts = this.getFileSystemOptions();
        FileObject selectedFile = this.browse(fileFilters, fileFilterNames, this.getVariableSpace().environmentSubstitute(this.jarUrl), opts, 0, true);
        if (selectedFile != null) {
            this.setJarUrl(selectedFile.getName().getURI());
        }
    }

    @Override
    public <T extends AbstractAmazonJobEntry> T getJobEntry() {
        return (T)this.jobEntry;
    }

    @Override
    public <T extends AbstractAmazonJobEntry> void setJobEntry(T jobEntry) {
        this.jobEntry = (AmazonElasticMapReduceJobExecutor)jobEntry;
    }
}

