/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.amazon.hive.ui;

import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemOptions;
import org.eclipse.swt.widgets.Text;
import org.pentaho.amazon.AbstractAmazonJobEntry;
import org.pentaho.amazon.AbstractAmazonJobExecutorController;
import org.pentaho.amazon.hive.job.AmazonHiveJobExecutor;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.util.StringUtil;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.ui.core.database.dialog.tags.ExtTextbox;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AmazonHiveJobExecutorController
extends AbstractAmazonJobExecutorController {
    private static final Class<?> PKG = AmazonHiveJobExecutor.class;
    public static final String Q_URL = "qUrl";
    public static final String BOOTSTRAP_ACTIONS = "bootstrapActions";
    public static final String ALIVE = "alive";
    private String qUrl = "";
    private String bootstrapActions = "";
    private boolean alive = false;
    private AmazonHiveJobExecutor jobEntry;

    @Override
    protected void syncModel() {
        super.syncModel();
        ExtTextbox tempBox = (ExtTextbox)this.getXulDomContainer().getDocumentRoot().getElementById("bootstrap-actions");
        this.bootstrapActions = ((Text)tempBox.getTextControl()).getText();
        tempBox = (ExtTextbox)this.getXulDomContainer().getDocumentRoot().getElementById("q-url");
        this.qUrl = ((Text)tempBox.getTextControl()).getText();
    }

    @Override
    protected String buildValidationErrorMessages() {
        String validationErrors = super.buildValidationErrorMessages();
        if (StringUtil.isEmpty((String)this.qUrl)) {
            validationErrors = validationErrors + BaseMessages.getString(PKG, (String)"AmazonElasticMapReduceJobExecutor.QURL.Error", (String[])new String[0]) + "\n";
        }
        return validationErrors;
    }

    @Override
    protected void configureJobEntry() {
        super.configureJobEntry();
        this.jobEntry.setQUrl(this.qUrl);
        this.jobEntry.setBootstrapActions(this.bootstrapActions);
        this.jobEntry.setAlive(this.isAlive());
    }

    @Override
    public void init() {
        super.init();
        if (this.jobEntry != null) {
            this.setQUrl(this.jobEntry.getQUrl());
            this.setBootstrapActions(this.jobEntry.getBootstrapActions());
            this.setAlive(this.jobEntry.isAlive());
        }
    }

    public void browseQ() throws KettleException, FileSystemException {
        String[] fileFilters = new String[]{"*.*"};
        String[] fileFilterNames = new String[]{"All"};
        FileSystemOptions opts = this.getFileSystemOptions();
        FileObject selectedFile = this.browse(fileFilters, fileFilterNames, this.getVariableSpace().environmentSubstitute(this.qUrl), opts, 0, true);
        if (selectedFile != null) {
            this.setQUrl(selectedFile.getName().getURI());
        }
    }

    public String getQUrl() {
        return this.qUrl;
    }

    public void setQUrl(String qUrl) {
        String previousVal = this.qUrl;
        String newVal = qUrl;
        this.qUrl = qUrl;
        this.firePropertyChange(Q_URL, previousVal, newVal);
    }

    public String getBootstrapActions() {
        return this.bootstrapActions;
    }

    public void setBootstrapActions(String bootstrapActions) {
        String previousVal = this.bootstrapActions;
        String newVal = bootstrapActions;
        this.bootstrapActions = bootstrapActions;
        this.firePropertyChange(BOOTSTRAP_ACTIONS, previousVal, newVal);
    }

    public void invertAlive() {
        this.setAlive(!this.isAlive());
    }

    @Override
    public void invertBlocking() {
        this.setBlocking(!this.isBlocking());
    }

    @Override
    public <T extends AbstractAmazonJobEntry> T getJobEntry() {
        return (T)this.jobEntry;
    }

    @Override
    public <T extends AbstractAmazonJobEntry> void setJobEntry(T jobEntry) {
        this.jobEntry = (AmazonHiveJobExecutor)jobEntry;
    }

    public boolean isAlive() {
        return this.alive;
    }

    public void setAlive(boolean alive) {
        boolean previousVal = this.alive;
        this.alive = alive;
        this.firePropertyChange(ALIVE, previousVal, alive);
    }
}

