/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.cassandra;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import org.apache.cassandra.config.ConfigurationException;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.AsciiType;
import org.apache.cassandra.db.marshal.BooleanType;
import org.apache.cassandra.db.marshal.CompositeType;
import org.apache.cassandra.db.marshal.DateType;
import org.apache.cassandra.db.marshal.DecimalType;
import org.apache.cassandra.db.marshal.DoubleType;
import org.apache.cassandra.db.marshal.DynamicCompositeType;
import org.apache.cassandra.db.marshal.FloatType;
import org.apache.cassandra.db.marshal.Int32Type;
import org.apache.cassandra.db.marshal.IntegerType;
import org.apache.cassandra.db.marshal.LexicalUUIDType;
import org.apache.cassandra.db.marshal.LongType;
import org.apache.cassandra.db.marshal.TypeParser;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.db.marshal.UUIDType;
import org.apache.cassandra.thrift.CfDef;
import org.apache.cassandra.thrift.Column;
import org.apache.cassandra.thrift.ColumnDef;
import org.apache.cassandra.thrift.CqlRow;
import org.apache.cassandra.thrift.KeySlice;
import org.apache.cassandra.thrift.KsDef;
import org.pentaho.cassandra.CassandraConnection;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.i18n.BaseMessages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CassandraColumnMetaData {
    protected static final Class<?> PKG = CassandraColumnMetaData.class;
    public static final String UTF8 = "UTF-8";
    protected String m_columnFamilyName;
    protected String m_keyValidator;
    protected String m_columnComparator;
    protected String m_columnNameEncoding;
    protected String m_defaultValidationClass;
    protected Map<String, String> m_columnMeta;
    protected Map<String, HashSet<Object>> m_indexedVals;
    protected StringBuffer m_schemaDescription;

    public CassandraColumnMetaData(CassandraConnection conn, String columnFamily) throws Exception {
        this.m_columnFamilyName = columnFamily;
        this.refresh(conn);
    }

    public String getDefaultValidationClass() {
        return this.m_defaultValidationClass;
    }

    public void refresh(CassandraConnection conn) throws Exception {
        Iterator colMetaData;
        this.m_schemaDescription = new StringBuffer();
        KsDef keySpace = conn.describeKeyspace();
        List colFams = null;
        if (keySpace == null) {
            throw new Exception(BaseMessages.getString(PKG, (String)"CassandraColumnMetaData.Error.UnableToGetMetaDataForKeyspace", (String[])new String[]{conn.m_keyspaceName}));
        }
        colFams = keySpace.getCf_defs();
        CfDef colDefs = null;
        for (CfDef fam : colFams) {
            String columnFamilyName = fam.getName();
            if (!columnFamilyName.equals(this.m_columnFamilyName)) continue;
            this.m_schemaDescription.append("Column family: " + this.m_columnFamilyName);
            this.m_keyValidator = fam.getKey_validation_class();
            this.m_columnComparator = fam.getComparator_type();
            this.m_defaultValidationClass = fam.getDefault_validation_class();
            this.m_schemaDescription.append("\n\tKey validator: " + this.m_keyValidator);
            this.m_schemaDescription.append("\n\tColumn comparator: " + this.m_columnComparator);
            this.m_schemaDescription.append("\n\tDefault column validator: " + this.m_defaultValidationClass);
            this.m_schemaDescription.append("\n\tRead repair chance: " + fam.getRead_repair_chance());
            this.m_schemaDescription.append("\n\tGC grace: " + fam.getGc_grace_seconds());
            this.m_schemaDescription.append("\n\tMin compaction threshold: " + fam.getMin_compaction_threshold());
            this.m_schemaDescription.append("\n\tMax compaction threshold: " + fam.getMax_compaction_threshold());
            this.m_schemaDescription.append("\n\tReplicate on write: " + fam.replicate_on_write);
            this.m_schemaDescription.append("\n\n\tColumn metadata:");
            colDefs = fam;
            break;
        }
        if (colDefs == null) {
            throw new Exception(BaseMessages.getString(PKG, (String)"CassandraColumnMetaData.Error.UnableToFindRequestedColumnFamily", (String[])new String[]{this.m_columnFamilyName, conn.m_keyspaceName}));
        }
        this.m_columnNameEncoding = this.m_columnComparator;
        this.m_columnMeta = new TreeMap<String, String>();
        this.m_indexedVals = new HashMap<String, HashSet<Object>>();
        String comment = colDefs.getComment();
        if (comment != null && comment.length() > 0) {
            this.extractIndexedMeta(comment, this.m_indexedVals);
        }
        if ((colMetaData = colDefs.getColumn_metadataIterator()) != null) {
            while (colMetaData.hasNext()) {
                ColumnDef currentDef = (ColumnDef)colMetaData.next();
                ByteBuffer b = ByteBuffer.wrap(currentDef.getName());
                String colName = this.getColumnValue(b, this.m_columnComparator).toString();
                String colType = currentDef.getValidation_class();
                this.m_columnMeta.put(colName, colType);
                this.m_schemaDescription.append("\n\tColumn name: " + colName);
                this.m_schemaDescription.append("\n\t\tColumn validator: " + colType);
                String indexName = currentDef.getIndex_name();
                if (!Const.isEmpty((String)indexName)) {
                    this.m_schemaDescription.append("\n\t\tIndex name: " + currentDef.getIndex_name());
                }
                if (!this.m_indexedVals.containsKey(colName)) continue;
                HashSet<Object> indexedVals = this.m_indexedVals.get(colName);
                this.m_schemaDescription.append("\n\t\tLegal values: {");
                int count = 0;
                for (Object val : indexedVals) {
                    this.m_schemaDescription.append(val.toString());
                    if (++count != indexedVals.size()) {
                        this.m_schemaDescription.append(",");
                        continue;
                    }
                    this.m_schemaDescription.append("}");
                }
            }
        }
    }

    protected void extractIndexedMeta(String comment, Map<String, HashSet<Object>> indexedVals) {
        String[] fields;
        if (comment.indexOf("@@@") < 0) {
            return;
        }
        String meta = comment.substring(comment.indexOf("@@@"), comment.lastIndexOf("@@@"));
        meta = meta.replace("@@@", "");
        for (String field : fields = meta.split(";")) {
            String[] parts = (field = field.trim()).split(":");
            if (parts.length != 2) continue;
            String fieldName = parts[0].trim();
            String valsS = parts[1];
            valsS = valsS.replace("{", "");
            String[] vals = (valsS = valsS.replace("}", "")).split(",");
            if (vals.length <= 0) continue;
            HashSet<String> valsSet = new HashSet<String>();
            for (String aVal : vals) {
                valsSet.add(aVal.trim());
            }
            indexedVals.put(fieldName, valsSet);
        }
    }

    public static boolean columnFamilyExists(CassandraConnection conn, String columnFamily) throws Exception {
        boolean found = false;
        KsDef keySpace = conn.describeKeyspace();
        List colFams = null;
        if (keySpace == null) {
            throw new Exception(BaseMessages.getString(PKG, (String)"CassandraColumnMetaData.Error.UnableToGetMetaDataForKeyspace", (String[])new String[]{conn.m_keyspaceName}));
        }
        colFams = keySpace.getCf_defs();
        for (CfDef fam : colFams) {
            String columnFamilyName = fam.getName();
            if (!columnFamilyName.equals(columnFamily)) continue;
            found = true;
            break;
        }
        return found;
    }

    public static List<String> getColumnFamilyNames(CassandraConnection conn) throws Exception {
        KsDef keySpace = conn.describeKeyspace();
        List colFams = null;
        if (keySpace == null) {
            throw new Exception(BaseMessages.getString(PKG, (String)"CassandraColumnMetaData.Error.UnableToGetMetaDataForKeyspace", (String[])new String[]{conn.m_keyspaceName}));
        }
        colFams = keySpace.getCf_defs();
        ArrayList<String> colFamNames = new ArrayList<String>();
        for (CfDef fam : colFams) {
            colFamNames.add(fam.getName());
        }
        return colFamNames;
    }

    public String getSchemaDescription() {
        return this.m_schemaDescription.toString();
    }

    public static String getCassandraTypeForValueMeta(ValueMetaInterface vm) {
        switch (vm.getType()) {
            case 2: {
                return "UTF8Type";
            }
            case 6: {
                return "DecimalType";
            }
            case 4: {
                return "BooleanType";
            }
            case 5: {
                return "LongType";
            }
            case 1: {
                return "DoubleType";
            }
            case 3: {
                return "DateType";
            }
            case 7: 
            case 8: {
                return "BytesType";
            }
        }
        return "UTF8Type";
    }

    public static String getCQLTypeForValueMeta(ValueMetaInterface vm) {
        switch (vm.getType()) {
            case 2: {
                return "varchar";
            }
            case 6: {
                return "decimal";
            }
            case 4: {
                return "boolean";
            }
            case 5: {
                return "bigint";
            }
            case 1: {
                return "double";
            }
            case 3: {
                return "timestamp";
            }
            case 7: 
            case 8: {
                return "blob";
            }
        }
        return "blob";
    }

    public static String kettleValueToCQL(ValueMetaInterface vm, Object value) throws KettleValueException {
        switch (vm.getType()) {
            case 2: {
                UTF8Type u = UTF8Type.instance;
                String toConvert = vm.getString(value);
                ByteBuffer decomposed = u.decompose(toConvert);
                String cassandraString = u.getString(decomposed);
                return CassandraColumnMetaData.escapeSingleQuotes(cassandraString);
            }
            case 6: {
                DecimalType dt = DecimalType.instance;
                BigDecimal toConvert = vm.getBigNumber(value);
                ByteBuffer decomposed = dt.decompose(toConvert);
                String cassandraString = dt.getString(decomposed);
                return cassandraString;
            }
            case 4: {
                BooleanType bt = BooleanType.instance;
                Boolean toConvert = vm.getBoolean(value);
                ByteBuffer decomposed = bt.decompose(toConvert);
                String cassandraString = bt.getString(decomposed);
                return CassandraColumnMetaData.escapeSingleQuotes(cassandraString);
            }
            case 5: {
                LongType lt = LongType.instance;
                Long toConvert = vm.getInteger(value);
                ByteBuffer decomposed = lt.decompose(toConvert);
                String cassandraString = lt.getString(decomposed);
                return cassandraString;
            }
            case 1: {
                DoubleType dt = DoubleType.instance;
                Double toConvert = vm.getNumber(value);
                ByteBuffer decomposed = dt.decompose(toConvert);
                String cassandraString = dt.getString(decomposed);
                return cassandraString;
            }
            case 3: {
                DateType d = DateType.instance;
                Date toConvert = vm.getDate(value);
                ByteBuffer decomposed = d.decompose(toConvert);
                String cassandraFormattedDateString = d.getString(decomposed);
                return CassandraColumnMetaData.escapeSingleQuotes(cassandraFormattedDateString);
            }
            case 7: 
            case 8: {
                throw new KettleValueException(BaseMessages.getString(PKG, (String)"CassandraColumnMetaData.Error.CantConvertBinaryToCQL", (String[])new String[0]));
            }
        }
        throw new KettleValueException(BaseMessages.getString(PKG, (String)"CassandraColumnMetaData.Error.CantConvertType", (String[])new String[]{vm.getName(), vm.getTypeDesc()}));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ByteBuffer kettleValueToByteBuffer(ValueMetaInterface vm, Object value, boolean isKey) throws KettleException {
        String fullTransCoder = this.m_defaultValidationClass;
        if (isKey) {
            fullTransCoder = this.m_keyValidator;
        } else {
            fullTransCoder = this.m_columnMeta.get(vm.getName());
            if (fullTransCoder == null) {
                fullTransCoder = this.m_defaultValidationClass;
            }
        }
        String transCoder = fullTransCoder;
        if (transCoder.indexOf(40) > 0) {
            transCoder = transCoder.substring(0, transCoder.indexOf(40));
        }
        ByteBuffer decomposed = null;
        if (transCoder.indexOf("UTF8Type") > 0) {
            UTF8Type u = UTF8Type.instance;
            decomposed = u.decompose(vm.getString(value));
        } else if (transCoder.indexOf("AsciiType") > 0) {
            AsciiType at = AsciiType.instance;
            decomposed = at.decompose(vm.getString(value));
        } else if (transCoder.indexOf("LongType") > 0) {
            LongType lt = LongType.instance;
            decomposed = lt.decompose(vm.getInteger(value));
        } else if (transCoder.indexOf("DoubleType") > 0) {
            DoubleType dt = DoubleType.instance;
            decomposed = dt.decompose(vm.getNumber(value));
        } else if (transCoder.indexOf("DateType") > 0) {
            DateType dt = DateType.instance;
            decomposed = dt.decompose(vm.getDate(value));
        } else if (transCoder.indexOf("IntegerType") > 0) {
            IntegerType it = IntegerType.instance;
            decomposed = it.decompose(vm.getBigNumber(value).toBigInteger());
        } else if (transCoder.indexOf("FloatType") > 0) {
            FloatType ft = FloatType.instance;
            decomposed = ft.decompose(Float.valueOf(vm.getNumber(value).floatValue()));
        } else if (transCoder.indexOf("LexicalUUIDType") > 0) {
            LexicalUUIDType lt = LexicalUUIDType.instance;
            UUID uuid = UUID.fromString(vm.getString(value));
            decomposed = lt.decompose(uuid);
        } else if (transCoder.indexOf("UUIDType") > 0) {
            UUIDType ut = UUIDType.instance;
            UUID uuid = UUID.fromString(vm.getString(value));
            decomposed = ut.decompose(uuid);
        } else if (transCoder.indexOf("BooleanType") > 0) {
            BooleanType bt = BooleanType.instance;
            decomposed = bt.decompose(vm.getBoolean(value));
        } else if (transCoder.indexOf("Int32Type") > 0) {
            Int32Type it = Int32Type.instance;
            decomposed = it.decompose(Integer.valueOf(vm.getInteger(value).intValue()));
        } else if (transCoder.indexOf("DecimalType") > 0) {
            DecimalType dt = DecimalType.instance;
            decomposed = dt.decompose(vm.getBigNumber(value));
        } else {
            if (transCoder.indexOf("DynamicCompositeType") > 0) {
                AbstractType serializer = null;
                if (!vm.isString()) throw new KettleException(BaseMessages.getString(PKG, (String)"CassandraColumnMetaData.Error.CantConvertTypeThrift", (String[])new String[]{vm.getTypeDesc(), fullTransCoder}));
                try {
                    serializer = TypeParser.parse((String)fullTransCoder);
                    decomposed = ((DynamicCompositeType)serializer).fromString(vm.getString(value));
                }
                catch (ConfigurationException e) {
                    throw new KettleException(e.getMessage(), (Throwable)e);
                }
            }
            if (transCoder.indexOf("CompositeType") > 0) {
                AbstractType serializer = null;
                if (!vm.isString()) throw new KettleException(BaseMessages.getString(PKG, (String)"CassandraColumnMetaData.Error.CantConvertTypeThrift", (String[])new String[]{vm.getTypeDesc(), fullTransCoder}));
                try {
                    serializer = TypeParser.parse((String)fullTransCoder);
                    decomposed = ((CompositeType)serializer).fromString(vm.toString());
                }
                catch (ConfigurationException e) {
                    throw new KettleException(e.getMessage(), (Throwable)e);
                }
            }
        }
        if (decomposed != null) return decomposed;
        throw new KettleException(BaseMessages.getString(PKG, (String)"CassandraColumnMetaData.Error.UnableToConvertValue", (String[])new String[]{vm.getName()}));
    }

    protected static String escapeSingleQuotes(String source) {
        return source.replace("'", "''");
    }

    public ByteBuffer columnNameToByteBuffer(String colName) throws KettleException {
        UTF8Type serializer = null;
        String fullEncoder = this.m_columnComparator;
        String encoder = fullEncoder;
        if (encoder.indexOf(40) > 0) {
            encoder = encoder.substring(0, encoder.indexOf(40));
        }
        if (encoder.indexOf("UTF8Type") > 0) {
            serializer = UTF8Type.instance;
        } else if (encoder.indexOf("AsciiType") > 0) {
            serializer = AsciiType.instance;
        } else if (encoder.indexOf("LongType") > 0) {
            serializer = LongType.instance;
        } else if (encoder.indexOf("DoubleType") > 0) {
            serializer = DoubleType.instance;
        } else if (encoder.indexOf("DateType") > 0) {
            serializer = DateType.instance;
        } else if (encoder.indexOf("IntegerType") > 0) {
            serializer = IntegerType.instance;
        } else if (encoder.indexOf("FloatType") > 0) {
            serializer = FloatType.instance;
        } else if (encoder.indexOf("LexicalUUIDType") > 0) {
            serializer = LexicalUUIDType.instance;
        } else if (encoder.indexOf("UUIDType") > 0) {
            serializer = UUIDType.instance;
        } else if (encoder.indexOf("BooleanType") > 0) {
            serializer = BooleanType.instance;
        } else if (encoder.indexOf("Int32Type") > 0) {
            serializer = Int32Type.instance;
        } else if (encoder.indexOf("DecimalType") > 0) {
            serializer = DecimalType.instance;
        } else {
            if (encoder.indexOf("DynamicCompositeType") > 0) {
                try {
                    serializer = TypeParser.parse((String)fullEncoder);
                }
                catch (ConfigurationException e) {
                    throw new KettleException(e.getMessage(), (Throwable)e);
                }
            }
            if (encoder.indexOf("CompositeType") > 0) {
                try {
                    serializer = TypeParser.parse((String)fullEncoder);
                }
                catch (ConfigurationException e) {
                    throw new KettleException(e.getMessage(), (Throwable)e);
                }
            }
        }
        ByteBuffer result = serializer.fromString(colName);
        return result;
    }

    public ValueMetaInterface getValueMetaForKey() {
        return this.getValueMetaForColumn(this.getKeyName());
    }

    public ValueMetaInterface getValueMetaForColumn(String colName) {
        String type = null;
        if (colName.equals(this.getKeyName())) {
            type = this.m_keyValidator;
        } else {
            type = this.m_columnMeta.get(colName);
            if (type == null) {
                type = this.m_defaultValidationClass;
            }
        }
        int kettleType = 0;
        if (type.indexOf("UTF8Type") > 0 || type.indexOf("AsciiType") > 0 || type.indexOf("UUIDType") > 0 || type.indexOf("CompositeType") > 0) {
            kettleType = 2;
        } else if (type.indexOf("LongType") > 0 || type.indexOf("IntegerType") > 0 || type.indexOf("Int32Type") > 0) {
            kettleType = 5;
        } else if (type.indexOf("DoubleType") > 0 || type.indexOf("FloatType") > 0) {
            kettleType = 1;
        } else if (type.indexOf("DateType") > 0) {
            kettleType = 3;
        } else if (type.indexOf("DecimalType") > 0) {
            kettleType = 6;
        } else if (type.indexOf("BytesType") > 0) {
            kettleType = 8;
        } else if (type.indexOf("BooleanType") > 0) {
            kettleType = 4;
        }
        ValueMeta newVM = new ValueMeta(colName, kettleType);
        if (this.m_indexedVals.containsKey(colName)) {
            newVM.setStorageType(2);
            HashSet<Object> indexedV = this.m_indexedVals.get(colName);
            Object[] iv = indexedV.toArray();
            newVM.setIndex(iv);
        }
        return newVM;
    }

    public List<ValueMetaInterface> getValueMetasForSchema() {
        ArrayList<ValueMetaInterface> newL = new ArrayList<ValueMetaInterface>();
        for (String colName : this.m_columnMeta.keySet()) {
            ValueMetaInterface colVM = this.getValueMetaForColumn(colName);
            newL.add(colVM);
        }
        return newL;
    }

    public Set<String> getColumnNames() {
        return this.m_columnMeta.keySet();
    }

    public boolean columnExistsInSchema(String colName) {
        return this.m_columnMeta.get(colName) != null;
    }

    public String getKeyName() {
        return this.getColumnFamilyName();
    }

    public String getColumnFamilyName() {
        return this.m_columnFamilyName;
    }

    public Object getKeyValue(CqlRow row) throws KettleException {
        ByteBuffer key = row.bufferForKey();
        if (this.m_keyValidator.indexOf("BytesType") > 0) {
            return row.getKey();
        }
        return this.getColumnValue(key, this.m_keyValidator);
    }

    public Object getKeyValue(KeySlice row) throws KettleException {
        ByteBuffer key = row.bufferForKey();
        if (this.m_keyValidator.indexOf("BytesType") > 0) {
            return row.getKey();
        }
        return this.getColumnValue(key, this.m_keyValidator);
    }

    public String getColumnName(Column aCol) throws KettleException {
        ByteBuffer b = aCol.bufferForName();
        String decodedColName = this.getColumnValue(b, this.m_columnComparator).toString();
        return decodedColName;
    }

    private Object getColumnValue(ByteBuffer valueBuff, String decoder) throws KettleException {
        if (valueBuff == null) {
            return null;
        }
        Object result = null;
        UTF8Type deserializer = null;
        String fullDecoder = decoder;
        if (decoder.indexOf(40) > 0) {
            decoder = decoder.substring(0, decoder.indexOf(40));
        }
        if (decoder.indexOf("UTF8Type") > 0) {
            deserializer = UTF8Type.instance;
        } else if (decoder.indexOf("AsciiType") > 0) {
            deserializer = AsciiType.instance;
        } else if (decoder.indexOf("LongType") > 0) {
            deserializer = LongType.instance;
        } else if (decoder.indexOf("DoubleType") > 0) {
            deserializer = DoubleType.instance;
        } else if (decoder.indexOf("DateType") > 0) {
            deserializer = DateType.instance;
        } else {
            if (decoder.indexOf("IntegerType") > 0) {
                deserializer = IntegerType.instance;
                result = new Long(((IntegerType)deserializer).compose(valueBuff).longValue());
                return result;
            }
            if (decoder.indexOf("FloatType") > 0) {
                deserializer = FloatType.instance;
                result = (double)new Double(((FloatType)deserializer).compose(valueBuff).floatValue());
                return result;
            }
            if (decoder.indexOf("LexicalUUIDType") > 0) {
                deserializer = LexicalUUIDType.instance;
                result = new String(((LexicalUUIDType)deserializer).compose(valueBuff).toString());
                return result;
            }
            if (decoder.indexOf("UUIDType") > 0) {
                deserializer = UUIDType.instance;
                result = new String(((UUIDType)deserializer).compose(valueBuff).toString());
                return result;
            }
            if (decoder.indexOf("BooleanType") > 0) {
                deserializer = BooleanType.instance;
            } else {
                if (decoder.indexOf("Int32Type") > 0) {
                    deserializer = Int32Type.instance;
                    result = (long)new Long(((Int32Type)deserializer).compose(valueBuff).intValue());
                    return result;
                }
                if (decoder.indexOf("DecimalType") > 0) {
                    deserializer = DecimalType.instance;
                } else {
                    if (decoder.indexOf("DynamicCompositeType") > 0) {
                        try {
                            deserializer = TypeParser.parse((String)fullDecoder);
                            result = ((DynamicCompositeType)deserializer).getString(valueBuff);
                            return result;
                        }
                        catch (ConfigurationException e) {
                            throw new KettleException(e.getMessage(), (Throwable)e);
                        }
                    }
                    if (decoder.indexOf("CompositeType") > 0) {
                        try {
                            deserializer = TypeParser.parse((String)fullDecoder);
                            result = ((CompositeType)deserializer).getString(valueBuff);
                            return result;
                        }
                        catch (ConfigurationException e) {
                            throw new KettleException(e.getMessage(), (Throwable)e);
                        }
                    }
                }
            }
        }
        if (deserializer == null) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"CassandraColumnMetaData.Error.CantFindADeserializerForType", (String[])new String[]{fullDecoder}));
        }
        result = deserializer.compose(valueBuff);
        return result;
    }

    public Object getColumnValue(Column aCol) throws KettleException {
        String colName = this.getColumnName(aCol);
        if (colName.equals("KEY")) {
            return null;
        }
        String decoder = this.m_columnMeta.get(colName);
        if (decoder == null) {
            decoder = this.m_defaultValidationClass;
        }
        String fullDecoder = decoder;
        if (decoder.indexOf(40) > 0) {
            decoder = decoder.substring(0, decoder.indexOf(40));
        }
        if (decoder.indexOf("BytesType") > 0) {
            return aCol.getValue();
        }
        ByteBuffer valueBuff = aCol.bufferForValue();
        Object result = this.getColumnValue(valueBuff, fullDecoder);
        if (this.m_indexedVals.containsKey(colName)) {
            HashSet<Object> vals = this.m_indexedVals.get(colName);
            int foundIndex = -1;
            Object[] indexedV = vals.toArray();
            for (int i = 0; i < indexedV.length; ++i) {
                if (!indexedV[i].equals(result)) continue;
                foundIndex = i;
                break;
            }
            result = foundIndex >= 0 ? new Integer(foundIndex) : null;
        }
        return result;
    }
}

