/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.database;

import java.sql.Driver;
import org.pentaho.di.core.database.BaseDatabaseMeta;
import org.pentaho.di.core.database.DatabaseInterface;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.plugins.DatabaseMetaPlugin;
import org.pentaho.di.core.row.ValueMetaInterface;

@DatabaseMetaPlugin(type="HIVE", typeDescription="Hadoop Hive")
public class HiveDatabaseMeta
extends BaseDatabaseMeta
implements DatabaseInterface {
    private static final String JAR_FILE = "hive-jdbc-0.6.0.jar";
    protected Integer driverMajorVersion;
    protected Integer driverMinorVersion;

    public HiveDatabaseMeta() throws Throwable {
    }

    HiveDatabaseMeta(int majorVersion, int minorVersion) throws Throwable {
        this.driverMajorVersion = majorVersion;
        this.driverMinorVersion = minorVersion;
    }

    public int[] getAccessTypeList() {
        return new int[]{0};
    }

    public String getAddColumnStatement(String tablename, ValueMetaInterface v, String tk, boolean useAutoinc, String pk, boolean semicolon) {
        return "ALTER TABLE " + tablename + " ADD " + this.getFieldDefinition(v, tk, pk, useAutoinc, true, false);
    }

    public String getDriverClass() {
        return "org.apache.hadoop.hive.jdbc.HiveDriver";
    }

    public String getFieldDefinition(ValueMetaInterface v, String tk, String pk, boolean useAutoinc, boolean addFieldname, boolean addCr) {
        String retval = "";
        String fieldname = v.getName();
        int length = v.getLength();
        int precision = v.getPrecision();
        if (addFieldname) {
            retval = retval + fieldname + " ";
        }
        int type = v.getType();
        switch (type) {
            case 4: {
                retval = retval + "BOOLEAN";
                break;
            }
            case 3: {
                retval = retval + "STRING";
                break;
            }
            case 2: {
                retval = retval + "STRING";
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                if (precision == 0) {
                    if (length > 9) {
                        if (length < 19) {
                            retval = retval + "BIGINT";
                            break;
                        }
                        retval = retval + "FLOAT";
                        break;
                    }
                    retval = retval + "INT";
                    break;
                }
                retval = length > 15 ? retval + "FLOAT" : retval + "DOUBLE";
            }
        }
        return retval;
    }

    public String getModifyColumnStatement(String tablename, ValueMetaInterface v, String tk, boolean useAutoinc, String pk, boolean semicolon) {
        return "ALTER TABLE " + tablename + " MODIFY " + this.getFieldDefinition(v, tk, pk, useAutoinc, true, false);
    }

    public String getURL(String hostname, String port, String databaseName) throws KettleDatabaseException {
        return "jdbc:hive://" + hostname + ":" + port + "/" + databaseName;
    }

    public String[] getUsedLibraries() {
        return new String[]{JAR_FILE};
    }

    public String getSelectCountStatement(String tableName) {
        return "select count(1) from " + tableName;
    }

    public String generateColumnAlias(int columnIndex, String suggestedName) {
        if (this.isDriverVersion(0, 6)) {
            return suggestedName;
        }
        return "_col" + String.valueOf(columnIndex);
    }

    protected synchronized void initDriverInfo() {
        Integer majorVersion = 0;
        Integer minorVersion = 0;
        try {
            Class<?> driverClass = Class.forName("org.apache.hadoop.hive.jdbc.HiveDriver");
            if (driverClass != null) {
                Driver driver = (Driver)driverClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                majorVersion = driver.getMajorVersion();
                minorVersion = driver.getMinorVersion();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.driverMajorVersion = majorVersion;
        this.driverMinorVersion = minorVersion;
    }

    protected boolean isDriverVersion(int majorVersion, int minorVersion) {
        if (this.driverMajorVersion == null) {
            this.initDriverInfo();
        }
        if (majorVersion < this.driverMajorVersion) {
            return true;
        }
        return majorVersion == this.driverMajorVersion && minorVersion <= this.driverMinorVersion;
    }

    public String getStartQuote() {
        return "";
    }

    public String getEndQuote() {
        return "";
    }
}

