/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.hadoop;

import java.io.IOException;
import java.util.Properties;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.impl.DefaultFileSystemManager;
import org.pentaho.di.core.annotations.KettleLifecyclePlugin;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.lifecycle.KettleLifecycleListener;
import org.pentaho.di.core.lifecycle.LifecycleException;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.plugins.KettleLifecyclePluginType;
import org.pentaho.di.core.plugins.PluginInterface;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.hadoop.PluginPropertiesUtil;
import org.pentaho.hadoop.shim.ConfigurationException;
import org.pentaho.hadoop.shim.HadoopConfiguration;
import org.pentaho.hadoop.shim.HadoopConfigurationLocator;
import org.pentaho.hadoop.shim.api.ActiveHadoopConfigurationLocator;
import org.pentaho.hadoop.shim.spi.HadoopConfigurationProvider;

@KettleLifecyclePlugin(id="HadoopConfigurationBootstrap", name="Hadoop Configuration Bootstrap")
public class HadoopConfigurationBootstrap
implements KettleLifecycleListener,
ActiveHadoopConfigurationLocator {
    private static final Class<?> PKG = HadoopConfigurationBootstrap.class;
    public static final String PLUGIN_ID = "HadoopConfigurationBootstrap";
    public static final String PROPERTY_ACTIVE_HADOOP_CONFIGURATION = "active.hadoop.configuration";
    public static final String PROPERTY_HADOOP_CONFIGURATIONS_PATH = "hadoop.configurations.path";
    public static final String DEFAULT_FOLDER_HADOOP_CONFIGURATIONS = "hadoop-configurations";
    private static HadoopConfigurationProvider provider;
    private static LogChannelInterface log;
    private PluginInterface plugin;

    public static synchronized HadoopConfigurationProvider getHadoopConfigurationProvider() throws ConfigurationException {
        if (provider == null) {
            throw new ConfigurationException(BaseMessages.getString(PKG, (String)"HadoopConfigurationBootstrap.NotInitialized", (String[])new String[0]));
        }
        return provider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEnvironmentInit() throws LifecycleException {
        try {
            FileObject hadoopConfigurationsDir = this.resolveHadoopConfigurationsDirectory();
            HadoopConfigurationProvider p = this.initializeHadoopConfigurationProvider(hadoopConfigurationsDir);
            HadoopConfiguration activeConfig = null;
            try {
                activeConfig = p.getActiveConfiguration();
            }
            catch (Exception ex) {
                throw new ConfigurationException(BaseMessages.getString(PKG, (String)"HadoopConfigurationBootstrap.HadoopConfiguration.InvalidActiveConfiguration", (String[])new String[]{this.getActiveConfigurationId()}), (Throwable)ex);
            }
            if (activeConfig == null) {
                throw new ConfigurationException(BaseMessages.getString(PKG, (String)"HadoopConfigurationBootstrap.HadoopConfiguration.InvalidActiveConfiguration", (String[])new String[]{this.getActiveConfigurationId()}));
            }
            HadoopConfigurationBootstrap hadoopConfigurationBootstrap = this;
            synchronized (hadoopConfigurationBootstrap) {
                provider = p;
            }
            log.logDetailed(BaseMessages.getString(PKG, (String)"HadoopConfigurationBootstrap.HadoopConfiguration.Loaded", (String[])new String[0]), new Object[]{provider.getConfigurations().size(), hadoopConfigurationsDir});
        }
        catch (Exception ex) {
            throw new LifecycleException(BaseMessages.getString(PKG, (String)"HadoopConfigurationBootstrap.HadoopConfiguration.StartupError", (String[])new String[0]), (Throwable)ex, true);
        }
    }

    public void onEnvironmentShutdown() {
    }

    protected HadoopConfigurationProvider initializeHadoopConfigurationProvider(FileObject hadoopConfigurationsDir) throws ConfigurationException {
        HadoopConfigurationLocator locator = new HadoopConfigurationLocator();
        locator.init(hadoopConfigurationsDir, (ActiveHadoopConfigurationLocator)this, (DefaultFileSystemManager)KettleVFS.getInstance().getFileSystemManager());
        return locator;
    }

    protected Properties getPluginProperties() throws ConfigurationException {
        try {
            return new PluginPropertiesUtil().loadPluginProperties(this.getPluginInterface());
        }
        catch (Exception ex) {
            throw new ConfigurationException(BaseMessages.getString(PKG, (String)"HadoopConfigurationBootstrap.UnableToLoadPluginProperties", (String[])new String[0]), (Throwable)ex);
        }
    }

    protected PluginInterface getPluginInterface() throws KettleException {
        if (this.plugin == null) {
            PluginInterface pi = PluginRegistry.getInstance().findPluginWithId(KettleLifecyclePluginType.class, PLUGIN_ID);
            if (pi == null) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"HadoopConfigurationBootstrap.CannotLocatePlugin", (String[])new String[0]));
            }
            this.plugin = pi;
        }
        return this.plugin;
    }

    public FileObject locatePluginDirectory() throws ConfigurationException {
        FileObject dir = null;
        boolean exists = false;
        try {
            dir = KettleVFS.getFileObject((String)this.getPluginInterface().getPluginDirectory().toExternalForm());
            exists = dir.exists();
        }
        catch (Exception e) {
            throw new ConfigurationException(BaseMessages.getString(PKG, (String)"HadoopConfigurationBootstrap.PluginDirectoryNotFound", (String[])new String[0]), (Throwable)e);
        }
        if (!exists) {
            throw new ConfigurationException(BaseMessages.getString(PKG, (String)"HadoopConfigurationBootstrap.PluginDirectoryNotFound", (String[])new String[0]));
        }
        return dir;
    }

    public FileObject resolveHadoopConfigurationsDirectory() throws ConfigurationException, IOException, KettleException {
        String hadoopConfigurationPath = this.getPluginProperties().getProperty(PROPERTY_HADOOP_CONFIGURATIONS_PATH, DEFAULT_FOLDER_HADOOP_CONFIGURATIONS);
        return this.locatePluginDirectory().resolveFile(hadoopConfigurationPath);
    }

    public String getActiveConfigurationId() throws ConfigurationException {
        Properties p = null;
        try {
            p = this.getPluginProperties();
        }
        catch (Exception ex) {
            throw new ConfigurationException(BaseMessages.getString(PKG, (String)"HadoopConfigurationBootstrap.UnableToDetermineActiveConfiguration", (String[])new String[0]), (Throwable)ex);
        }
        if (!p.containsKey(PROPERTY_ACTIVE_HADOOP_CONFIGURATION)) {
            throw new ConfigurationException(BaseMessages.getString(PKG, (String)"HadoopConfigurationBootstrap.MissingActiveConfigurationProperty", (String[])new String[]{PROPERTY_ACTIVE_HADOOP_CONFIGURATION}));
        }
        return p.getProperty(PROPERTY_ACTIVE_HADOOP_CONFIGURATION);
    }

    static {
        log = new LogChannel((Object)BaseMessages.getString(PKG, (String)"HadoopConfigurationBootstrap.LoggingPrefix", (String[])new String[0]));
    }
}

