/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.sqoop;

import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.util.StringUtil;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.ArgumentWrapper;
import org.pentaho.di.job.CommandLineArgument;
import org.pentaho.di.job.JobEntryMode;
import org.pentaho.di.job.entries.sqoop.AbstractSqoopJobEntry;
import org.pentaho.di.job.entries.sqoop.SqoopConfig;
import org.pentaho.hadoop.shim.api.Configuration;
import org.pentaho.hadoop.shim.spi.HadoopShim;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqoopUtils {
    public static final String ARG_PREFIX = "--";
    private static final String WHITESPACE = " ";
    private static final String QUOTE = "\"";
    private static final Pattern WHITESPACE_PATTERN = Pattern.compile(" ");
    private static final Pattern QUOTE_PATTERN = Pattern.compile("\"");
    private static final Pattern BACKSLASH_PATTERN = Pattern.compile("\\\\");
    private static final Object[][] ESCAPE_SEQUENCES = new Object[][]{{Pattern.compile("\t"), "\\\\t"}, {Pattern.compile("\b"), "\\\\b"}, {Pattern.compile("\n"), "\\\\n"}, {Pattern.compile("\r"), "\\\\r"}, {Pattern.compile("\f"), "\\\\f"}};

    public static void configureConnectionInformation(SqoopConfig config, HadoopShim shim, Configuration c) {
        String[] jobtrackerInfo;
        String[] namenodeInfo = shim.getNamenodeConnectionInfo(c);
        if (namenodeInfo != null) {
            if (namenodeInfo[0] != null) {
                config.setNamenodeHost(namenodeInfo[0]);
            }
            if (!"-1".equals(namenodeInfo[1])) {
                config.setNamenodePort(namenodeInfo[1]);
            }
        }
        if ((jobtrackerInfo = shim.getJobtrackerConnectionInfo(c)) != null) {
            if (jobtrackerInfo[0] != null) {
                config.setJobtrackerHost(jobtrackerInfo[0]);
            }
            if (jobtrackerInfo[1] != null) {
                config.setJobtrackerPort(jobtrackerInfo[1]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> parseCommandLine(String commandLineString, VariableSpace variableSpace, boolean ignoreSqoopCommand) throws IOException {
        ArrayList<String> args = new ArrayList<String>();
        StringReader reader = new StringReader(commandLineString);
        try {
            StreamTokenizer tokenizer = new StreamTokenizer(reader);
            tokenizer.ordinaryChar(45);
            tokenizer.wordChars(0, 65535);
            tokenizer.whitespaceChars(0, 32);
            tokenizer.quoteChar(34);
            tokenizer.quoteChar(39);
            boolean skipToken = false;
            while (tokenizer.nextToken() != -1) {
                if (tokenizer.sval == null) continue;
                String s = tokenizer.sval;
                if (variableSpace != null) {
                    s = variableSpace.environmentSubstitute(s);
                }
                if (ignoreSqoopCommand && args.isEmpty()) {
                    if ("sqoop".equals(s)) {
                        skipToken = true;
                        continue;
                    }
                    if (skipToken) {
                        ignoreSqoopCommand = false;
                        skipToken = false;
                        continue;
                    }
                }
                args.add(SqoopUtils.escapeEscapeSequences(s));
            }
        }
        finally {
            reader.close();
        }
        return args;
    }

    public static void configureFromCommandLine(SqoopConfig config, String commandLineString, VariableSpace variableSpace) throws IOException, KettleException {
        int i;
        List<String> args = SqoopUtils.parseCommandLine(commandLineString, variableSpace, true);
        HashMap<String, String> argValues = new HashMap<String, String>();
        int peekAhead = i = 0;
        while (i < args.size()) {
            String arg = args.get(i);
            if (SqoopUtils.isArgName(arg)) {
                arg = arg.substring(ARG_PREFIX.length());
            }
            String value = null;
            peekAhead = i + 1;
            if (peekAhead < args.size()) {
                value = args.get(peekAhead);
            }
            if (SqoopUtils.isArgName(value)) {
                value = Boolean.TRUE.toString();
                ++i;
            } else {
                if (variableSpace != null) {
                    value = variableSpace.environmentSubstitute(value);
                }
                i += 2;
            }
            argValues.put(arg, value);
        }
        SqoopUtils.setArgumentStringValues(config, argValues);
    }

    private static boolean isArgName(String s) {
        return s != null && s.startsWith(ARG_PREFIX) && s.length() > ARG_PREFIX.length();
    }

    protected static void setArgumentStringValues(SqoopConfig config, Map<String, String> args) throws KettleException {
        for (Class<?> aClass = config.getClass(); aClass != null; aClass = aClass.getSuperclass()) {
            for (Field field : aClass.getDeclaredFields()) {
                if (!field.isAnnotationPresent(CommandLineArgument.class)) continue;
                CommandLineArgument arg = field.getAnnotation(CommandLineArgument.class);
                String value = args.remove(arg.name());
                try {
                    String fieldName = field.getName().substring(0, 1).toUpperCase() + field.getName().substring(1);
                    Method setter = SqoopUtils.findMethod(config.getClass(), fieldName, new Class[]{String.class}, "set");
                    setter.invoke((Object)config, value);
                }
                catch (Exception ex) {
                    throw new KettleException("Cannot set value of argument \"" + arg.name() + "\" to \"" + value + QUOTE, (Throwable)ex);
                }
            }
        }
        if (!args.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            Iterator<String> i = args.keySet().iterator();
            while (i.hasNext()) {
                sb.append(i.next());
                if (!i.hasNext()) continue;
                sb.append(", ");
            }
            throw new KettleException(BaseMessages.getString(AbstractSqoopJobEntry.class, (String)"ErrorUnknownArguments", (Object[])new Object[]{sb}));
        }
    }

    public static List<String> getCommandLineArgs(SqoopConfig config, VariableSpace variableSpace) throws IOException {
        ArrayList<String> args = new ArrayList<String>();
        if (JobEntryMode.ADVANCED_COMMAND_LINE.equals((Object)config.getModeAsEnum())) {
            return SqoopUtils.parseCommandLine(config.getCommandLine(), variableSpace, true);
        }
        SqoopUtils.appendArguments(args, SqoopUtils.findAllArguments(config), variableSpace);
        return args;
    }

    public static String generateCommandLineString(SqoopConfig config, VariableSpace variableSpace) {
        StringBuilder sb = new StringBuilder();
        ArrayList<ArrayList<String>> buffers = new ArrayList<ArrayList<String>>();
        for (ArgumentWrapper argumentWrapper : SqoopUtils.findAllArguments(config)) {
            ArrayList<String> buffer = new ArrayList<String>(4);
            SqoopUtils.appendArgument(buffer, argumentWrapper, variableSpace);
            if (buffer.isEmpty()) continue;
            buffers.add(buffer);
        }
        Iterator buffersIter = buffers.iterator();
        while (buffersIter.hasNext()) {
            List list = (List)buffersIter.next();
            sb.append((String)list.get(0));
            if (list.size() == 2) {
                sb.append(WHITESPACE);
                sb.append(SqoopUtils.quote((String)list.get(1)));
            }
            if (!buffersIter.hasNext()) continue;
            sb.append(WHITESPACE);
        }
        return sb.toString();
    }

    protected static String escapeEscapeSequences(String s) {
        for (Object[] escapeSequence : ESCAPE_SEQUENCES) {
            s = ((Pattern)escapeSequence[0]).matcher(s).replaceAll((String)escapeSequence[1]);
        }
        return s;
    }

    protected static String quote(String s) {
        String orig = s;
        if (!orig.equals(s = QUOTE_PATTERN.matcher(s).replaceAll("\\\\\"")) || WHITESPACE_PATTERN.matcher(s).find() || BACKSLASH_PATTERN.matcher(s).find()) {
            s = QUOTE + s + QUOTE;
        }
        return s;
    }

    protected static void appendArguments(List<String> args, Set<? extends ArgumentWrapper> arguments, VariableSpace variableSpace) {
        for (ArgumentWrapper argumentWrapper : arguments) {
            SqoopUtils.appendArgument(args, argumentWrapper, variableSpace);
        }
    }

    protected static void appendArgument(List<String> args, ArgumentWrapper arg, VariableSpace variableSpace) {
        String value = arg.getValue();
        if (variableSpace != null) {
            value = variableSpace.environmentSubstitute(value);
        }
        if (arg.isFlag() && Boolean.parseBoolean(value)) {
            args.add(ARG_PREFIX + arg.getName());
        } else if (!arg.isFlag() && value != null) {
            args.add(ARG_PREFIX + arg.getName());
            args.add(value);
        }
    }

    public static Set<? extends ArgumentWrapper> findAllArguments(Object o) {
        LinkedHashSet<ArgumentWrapper> arguments = new LinkedHashSet<ArgumentWrapper>();
        for (Class<?> aClass = o.getClass(); aClass != null; aClass = aClass.getSuperclass()) {
            for (Field f : aClass.getDeclaredFields()) {
                if (!f.isAnnotationPresent(CommandLineArgument.class)) continue;
                CommandLineArgument anno = f.getAnnotation(CommandLineArgument.class);
                String fieldName = f.getName().substring(0, 1).toUpperCase() + f.getName().substring(1);
                Method getter = SqoopUtils.findMethod(aClass, fieldName, null, "get", "is");
                Method setter = SqoopUtils.findMethod(aClass, fieldName, new Class[]{f.getType()}, "set");
                arguments.add(new ArgumentWrapper(anno.name(), SqoopUtils.getDisplayName(anno), anno.flag(), o, getter, setter));
            }
        }
        return arguments;
    }

    public static String getDisplayName(CommandLineArgument anno) {
        return StringUtil.isEmpty((String)anno.displayName()) ? anno.name() : anno.displayName();
    }

    public static Method findMethod(Class<?> aClass, String methodName, Class<?>[] parameterTypes, String ... prefixes) {
        for (String prefix : prefixes) {
            try {
                return aClass.getDeclaredMethod(prefix + methodName, parameterTypes);
            }
            catch (NoSuchMethodException ex) {
            }
        }
        return (aClass = aClass.getSuperclass()) == null ? null : SqoopUtils.findMethod(aClass, methodName, parameterTypes, prefixes);
    }
}

