/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.cassandrainput;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.thrift.Compression;
import org.apache.cassandra.thrift.CqlResult;
import org.apache.cassandra.thrift.CqlRow;
import org.pentaho.cassandra.CassandraColumnMetaData;
import org.pentaho.cassandra.CassandraConnection;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.cassandrainput.CassandraInputData;
import org.pentaho.di.trans.steps.cassandrainput.CassandraInputMeta;

public class CassandraInput
extends BaseStep
implements StepInterface {
    protected CassandraInputMeta m_meta;
    protected CassandraInputData m_data;
    protected CassandraConnection m_connection;
    protected CassandraColumnMetaData m_cassandraMeta;
    protected Iterator<CqlRow> m_resultIterator;
    protected Map<String, Integer> m_outputFormatMap = new HashMap<String, Integer>();

    public CassandraInput(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        if (this.first) {
            this.first = false;
            this.m_data = (CassandraInputData)sdi;
            this.m_meta = (CassandraInputMeta)smi;
            String hostS = this.environmentSubstitute(this.m_meta.getCassandraHost());
            String portS = this.environmentSubstitute(this.m_meta.getCassandraPort());
            String timeoutS = this.environmentSubstitute(this.m_meta.getSocketTimeout());
            String userS = this.m_meta.getUsername();
            String passS = this.m_meta.getPassword();
            if (!Const.isEmpty((String)userS) && !Const.isEmpty((String)passS)) {
                userS = this.environmentSubstitute(userS);
                passS = this.environmentSubstitute(passS);
            }
            String keyspaceS = this.environmentSubstitute(this.m_meta.getCassandraKeyspace());
            if (Const.isEmpty((String)hostS) || Const.isEmpty((String)portS) || Const.isEmpty((String)keyspaceS)) {
                throw new KettleException("Some connection details are missing!!");
            }
            this.logBasic(BaseMessages.getString(CassandraInputMeta.PKG, (String)"CassandraInput.Info.Connecting", (String[])new String[]{hostS, portS, keyspaceS}));
            try {
                this.m_connection = Const.isEmpty((String)timeoutS) ? CassandraInputData.getCassandraConnection(hostS, Integer.parseInt(portS), userS, passS) : CassandraInputData.getCassandraConnection(hostS, Integer.parseInt(portS), userS, passS, Integer.parseInt(timeoutS));
                this.m_connection.setKeyspace(keyspaceS);
            }
            catch (Exception ex) {
                this.closeConnection();
                throw new KettleException(ex.getMessage(), (Throwable)ex);
            }
            String colFamName = CassandraInputData.getColumnFamilyNameFromCQLSelectQuery(this.environmentSubstitute(this.m_meta.getCQLSelectQuery()));
            if (Const.isEmpty((String)colFamName)) {
                throw new KettleException(BaseMessages.getString(CassandraInputMeta.PKG, (String)"CassandraInput.Error.NonExistentColumnFamily", (String[])new String[0]));
            }
            try {
                if (!CassandraColumnMetaData.columnFamilyExists(this.m_connection, colFamName)) {
                    throw new KettleException(BaseMessages.getString(CassandraInputMeta.PKG, (String)"CassandraInput.Error.NonExistentColumnFamily", (String[])new String[]{colFamName, keyspaceS}));
                }
            }
            catch (Exception ex) {
                this.closeConnection();
                throw new KettleException(ex.getMessage(), (Throwable)ex);
            }
            this.m_data.setOutputRowMeta((RowMetaInterface)new RowMeta());
            this.m_meta.getFields(this.m_data.getOutputRowMeta(), this.getStepname(), null, null, (VariableSpace)this);
            if (this.m_data.getOutputRowMeta().size() == 0) {
                throw new KettleException(BaseMessages.getString(CassandraInputMeta.PKG, (String)"CassandraInput.Error.QueryWontProduceOutputFields", (String[])new String[0]));
            }
            if (!this.m_meta.getOutputKeyValueTimestampTuples()) {
                for (int i = 0; i < this.m_data.getOutputRowMeta().size(); ++i) {
                    String fieldName = this.m_data.getOutputRowMeta().getValueMeta(i).getName();
                    this.m_outputFormatMap.put(fieldName, i);
                }
            }
            try {
                this.logBasic(BaseMessages.getString(CassandraInputMeta.PKG, (String)"CassandraInput.Info.GettintMetaData", (String[])new String[]{colFamName}));
                this.m_cassandraMeta = new CassandraColumnMetaData(this.m_connection, colFamName);
            }
            catch (Exception e) {
                this.closeConnection();
                throw new KettleException(e.getMessage(), (Throwable)e);
            }
            String queryS = this.environmentSubstitute(this.m_meta.getCQLSelectQuery());
            Compression compression = this.m_meta.getUseCompression() ? Compression.GZIP : Compression.NONE;
            try {
                if (!this.m_meta.getUseThriftIO()) {
                    this.logBasic(BaseMessages.getString(CassandraInputMeta.PKG, (String)"CassandraInput.Info.ExecutingQuery", (String[])new String[]{queryS, this.m_meta.getUseCompression() ? BaseMessages.getString(CassandraInputMeta.PKG, (String)"CassandraInput.Info.UsingGZIPCompression", (String[])new String[0]) : ""}));
                    byte[] queryBytes = this.m_meta.getUseCompression() ? CassandraInputData.compressQuery(queryS, compression) : queryS.getBytes();
                    CqlResult result = this.m_connection.getClient().execute_cql_query(ByteBuffer.wrap(queryBytes), compression);
                    this.m_resultIterator = result.getRowsIterator();
                } else if (this.m_meta.getOutputKeyValueTimestampTuples()) {
                    List<String> userCols = this.m_meta.m_specificCols != null && this.m_meta.m_specificCols.size() > 0 ? this.m_meta.m_specificCols : null;
                    this.m_data.sliceModeInit(this.m_cassandraMeta, userCols, this.m_meta.m_rowLimit, this.m_meta.m_colLimit, this.m_meta.m_rowBatchSize, this.m_meta.m_colBatchSize);
                    List<Object[]> batch = this.m_data.cassandraRowToKettleTupleSliceMode(this.m_cassandraMeta, this.m_connection);
                    while (batch != null) {
                        for (Object[] r : batch) {
                            this.putRow(this.m_data.getOutputRowMeta(), r);
                            if (!this.log.isRowLevel()) continue;
                            this.log.logRowlevel(this.toString(), new Object[]{"Outputted row #" + this.getProcessed() + " : " + r});
                        }
                        batch = this.m_data.cassandraRowToKettleTupleSliceMode(this.m_cassandraMeta, this.m_connection);
                    }
                    this.closeConnection();
                    this.setOutputDone();
                    return false;
                }
            }
            catch (Exception e) {
                this.closeConnection();
                throw new KettleException(e.getMessage(), (Throwable)e);
            }
        }
        if (this.m_resultIterator.hasNext()) {
            CqlRow nextRow = this.m_resultIterator.next();
            Object[] outputRowData = null;
            if (this.m_meta.getOutputKeyValueTimestampTuples()) {
                Iterator columnIterator = nextRow.getColumnsIterator();
                if (this.m_meta.m_isSelectStarQuery) {
                    columnIterator.next();
                }
                while ((outputRowData = this.m_data.cassandraRowToKettleTupleMode(this.m_cassandraMeta, nextRow, columnIterator)) != null) {
                    this.putRow(this.m_data.getOutputRowMeta(), outputRowData);
                    if (!this.log.isRowLevel()) continue;
                    this.log.logRowlevel(this.toString(), new Object[]{"Outputted row #" + this.getProcessed() + " : " + outputRowData});
                }
            } else {
                outputRowData = this.m_data.cassandraRowToKettle(this.m_cassandraMeta, nextRow, this.m_outputFormatMap);
                this.putRow(this.m_data.getOutputRowMeta(), outputRowData);
                if (this.log.isRowLevel()) {
                    this.log.logRowlevel(this.toString(), new Object[]{"Outputted row #" + this.getProcessed() + " : " + outputRowData});
                }
            }
        } else {
            this.closeConnection();
            this.setOutputDone();
            return false;
        }
        if (this.checkFeedback(this.getProcessed())) {
            this.logBasic("Read " + this.getProcessed() + " rows from Cassandra");
        }
        return true;
    }

    public void setStopped(boolean stopped) {
        if (this.isStopped() && stopped) {
            return;
        }
        super.setStopped(stopped);
        if (stopped) {
            this.closeConnection();
        }
    }

    protected void closeConnection() {
        if (this.m_connection != null) {
            this.logBasic(BaseMessages.getString(CassandraInputMeta.PKG, (String)"CassandraInput.Info.ClosingConnection", (String[])new String[0]));
            this.m_connection.close();
        }
    }
}

