/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.cassandrainput;

import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.Deflater;
import org.apache.cassandra.thrift.Column;
import org.apache.cassandra.thrift.ColumnOrSuperColumn;
import org.apache.cassandra.thrift.ColumnParent;
import org.apache.cassandra.thrift.Compression;
import org.apache.cassandra.thrift.ConsistencyLevel;
import org.apache.cassandra.thrift.CqlRow;
import org.apache.cassandra.thrift.KeyRange;
import org.apache.cassandra.thrift.KeySlice;
import org.apache.cassandra.thrift.SlicePredicate;
import org.apache.cassandra.thrift.SliceRange;
import org.apache.cassandra.thrift.TimedOutException;
import org.pentaho.cassandra.CassandraColumnMetaData;
import org.pentaho.cassandra.CassandraConnection;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.trans.step.BaseStepData;
import org.pentaho.di.trans.step.StepDataInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CassandraInputData
extends BaseStepData
implements StepDataInterface {
    protected RowMetaInterface m_outputRowMeta;
    protected boolean m_newSliceQuery = false;
    protected List<String> m_requestedCols = null;
    protected int m_sliceRowsMax;
    protected int m_sliceColsMax;
    protected int m_sliceRowsBatchSize;
    protected int m_sliceColsBatchSize;
    protected SliceRange m_sliceRange;
    protected KeyRange m_keyRange;
    protected SlicePredicate m_slicePredicate;
    protected ColumnParent m_colParent;
    int m_rowIndex;
    int m_colIndex;
    protected List<KeySlice> m_cassandraRows;
    protected List<ColumnOrSuperColumn> m_currentCols;
    protected List<Object[]> m_converted;
    protected int m_colCount;
    protected int m_rowCount;

    public RowMetaInterface getOutputRowMeta() {
        return this.m_outputRowMeta;
    }

    public void setOutputRowMeta(RowMetaInterface rmi) {
        this.m_outputRowMeta = rmi;
    }

    public static CassandraConnection getCassandraConnection(String host, int port, String username, String password) throws Exception {
        return new CassandraConnection(host, port, username, password, -1);
    }

    public static CassandraConnection getCassandraConnection(String host, int port, String username, String password, int timeout) throws Exception {
        return new CassandraConnection(host, port, username, password, timeout);
    }

    public void sliceModeInit(CassandraColumnMetaData meta, List<String> colNames, int maxRows, int maxCols, int rowBatchSize, int colBatchSize) throws KettleException {
        this.m_newSliceQuery = true;
        this.m_requestedCols = colNames;
        this.m_sliceRowsMax = maxRows;
        this.m_sliceColsMax = maxCols;
        this.m_sliceRowsBatchSize = rowBatchSize;
        this.m_sliceColsBatchSize = colBatchSize;
        this.m_rowIndex = 0;
        this.m_colIndex = 0;
        if (this.m_sliceColsBatchSize <= 0) {
            this.m_sliceColsBatchSize = Integer.MAX_VALUE;
        }
        if (this.m_sliceRowsBatchSize <= 0) {
            this.m_sliceRowsBatchSize = Integer.MAX_VALUE;
        }
        ArrayList<ByteBuffer> specificCols = null;
        if (this.m_requestedCols != null && this.m_requestedCols.size() > 0) {
            specificCols = new ArrayList<ByteBuffer>();
            for (String colName : this.m_requestedCols) {
                ByteBuffer encoded = meta.columnNameToByteBuffer(colName);
                specificCols.add(encoded);
            }
        }
        this.m_slicePredicate = new SlicePredicate();
        if (specificCols == null) {
            this.m_sliceRange = new SliceRange(ByteBuffer.wrap(new byte[0]), ByteBuffer.wrap(new byte[0]), false, this.m_sliceColsBatchSize);
            this.m_slicePredicate.setSlice_range(this.m_sliceRange);
        } else {
            this.m_slicePredicate.setColumn_names(specificCols);
        }
        this.m_keyRange = new KeyRange(this.m_sliceRowsBatchSize);
        this.m_keyRange.setStart_key(new byte[0]);
        this.m_keyRange.setEnd_key(new byte[0]);
        this.m_colParent = new ColumnParent(meta.getColumnFamilyName());
        this.m_converted = new ArrayList<Object[]>();
    }

    private void advanceToNonEmptyRow() {
        KeySlice row = this.m_cassandraRows.get(this.m_rowIndex);
        this.m_currentCols = row.getColumns();
        int skipSize = 0;
        while (this.m_currentCols.size() == skipSize && this.m_rowIndex < this.m_cassandraRows.size() - 1) {
            ++this.m_rowIndex;
            row = this.m_cassandraRows.get(this.m_rowIndex);
            this.m_currentCols = row.getColumns();
        }
        if (this.m_currentCols.size() == skipSize) {
            this.m_currentCols = null;
        }
    }

    private void getNextBatchOfRows(CassandraConnection conn) throws Exception {
        if (this.m_requestedCols == null) {
            this.m_sliceRange = this.m_sliceRange.setStart(ByteBuffer.wrap(new byte[0]));
            this.m_sliceRange = this.m_sliceRange.setFinish(ByteBuffer.wrap(new byte[0]));
            this.m_slicePredicate.setSlice_range(this.m_sliceRange);
        }
        this.m_keyRange.setStart_key(this.m_cassandraRows.get(this.m_cassandraRows.size() - 1).getKey());
        this.m_cassandraRows = conn.getClient().get_range_slices(this.m_colParent, this.m_slicePredicate, this.m_keyRange, ConsistencyLevel.ONE);
        this.m_colCount = 0;
        this.m_rowIndex = 1;
        if (this.m_cassandraRows == null || this.m_cassandraRows.size() <= 1 || this.m_rowCount == this.m_sliceRowsMax) {
            this.m_currentCols = null;
            this.m_cassandraRows = null;
        } else {
            this.advanceToNonEmptyRow();
        }
    }

    private void getNextBatchOfColumns(CassandraConnection conn) throws Exception {
        this.m_sliceRange = this.m_sliceRange.setStart(this.m_currentCols.get(this.m_currentCols.size() - 1).getColumn().bufferForName());
        this.m_slicePredicate.setSlice_range(this.m_sliceRange);
        this.m_currentCols = conn.getClient().get_slice(this.m_cassandraRows.get(this.m_rowIndex).bufferForKey(), this.m_colParent, this.m_slicePredicate, ConsistencyLevel.ONE);
        if (this.m_currentCols == null || this.m_currentCols.size() <= 1) {
            ++this.m_rowCount;
            ++this.m_rowIndex;
            this.m_colCount = 0;
            if (this.m_rowIndex == this.m_cassandraRows.size()) {
                this.getNextBatchOfRows(conn);
                while (this.m_cassandraRows != null && this.m_currentCols == null) {
                    this.getNextBatchOfRows(conn);
                }
            } else {
                this.advanceToNonEmptyRow();
                while (this.m_cassandraRows != null && this.m_currentCols == null) {
                    this.getNextBatchOfRows(conn);
                }
            }
        } else {
            this.m_currentCols.remove(0);
        }
    }

    public List<Object[]> cassandraRowToKettleTupleSliceMode(CassandraColumnMetaData metaData, CassandraConnection conn) throws KettleException {
        this.m_converted.clear();
        try {
            KeySlice row;
            int timeouts;
            for (timeouts = 0; timeouts < 5; ++timeouts) {
                try {
                    if (this.m_newSliceQuery) {
                        this.m_cassandraRows = conn.getClient().get_range_slices(this.m_colParent, this.m_slicePredicate, this.m_keyRange, ConsistencyLevel.ONE);
                        if (this.m_cassandraRows == null || this.m_cassandraRows.size() == 0) {
                            return null;
                        }
                        this.advanceToNonEmptyRow();
                        while (this.m_cassandraRows != null && this.m_currentCols == null) {
                            this.getNextBatchOfRows(conn);
                        }
                        if (this.m_cassandraRows == null) {
                            return null;
                        }
                        this.m_colCount = 0;
                        this.m_rowCount = 0;
                        this.m_newSliceQuery = false;
                    } else {
                        if (this.m_rowCount == this.m_sliceRowsMax) {
                            return null;
                        }
                        if (this.m_rowIndex == this.m_cassandraRows.size()) {
                            this.getNextBatchOfRows(conn);
                            while (this.m_cassandraRows != null && this.m_currentCols == null) {
                                this.getNextBatchOfRows(conn);
                            }
                            if (this.m_cassandraRows == null) {
                                return null;
                            }
                        } else if (this.m_colCount == -1) {
                            row = this.m_cassandraRows.get(this.m_rowIndex);
                            this.m_currentCols = row.getColumns();
                            this.m_colCount = 0;
                        } else {
                            this.getNextBatchOfColumns(conn);
                            if (this.m_rowCount == this.m_sliceRowsMax) {
                                return null;
                            }
                            if (this.m_cassandraRows == null) {
                                return null;
                            }
                        }
                    }
                    break;
                }
                catch (TimedOutException e) {
                    continue;
                }
            }
            if (timeouts == 5) {
                throw new KettleException("Maximum number of consecutive timeouts exceeded");
            }
            row = this.m_cassandraRows.get(this.m_rowIndex);
            Object rowKey = metaData.getKeyValue(row);
            if (rowKey == null) {
                throw new KettleException("Unable to obtain a key value for the row!");
            }
            String keyName = metaData.getKeyName();
            int keyIndex = this.m_outputRowMeta.indexOfValue(keyName);
            if (keyIndex < 0) {
                throw new KettleException("Unable to find the key field name '" + keyName + "' in the output row meta data!");
            }
            for (int i = 0; i < this.m_currentCols.size(); ++i) {
                Object[] outputRowData = RowDataUtil.allocateRowData((int)this.m_outputRowMeta.size());
                outputRowData[keyIndex] = rowKey;
                Column col = this.m_currentCols.get(i).getColumn();
                String colName = metaData.getColumnName(col);
                Object colValue = metaData.getColumnValue(col);
                if (colValue == null) continue;
                outputRowData[1] = colName;
                String stringV = colValue.toString();
                outputRowData[2] = stringV;
                if (colValue instanceof Date) {
                    ValueMeta tempDateMeta = new ValueMeta("temp", 3);
                    stringV = tempDateMeta.getString(colValue);
                    outputRowData[2] = stringV;
                } else if (colValue instanceof byte[]) {
                    outputRowData[2] = colValue;
                }
                long timestampL = col.getTimestamp();
                outputRowData[3] = timestampL;
                this.m_converted.add(outputRowData);
                ++this.m_colCount;
                if (this.m_colCount != this.m_sliceColsMax || this.m_requestedCols != null) continue;
                this.m_colCount = -1;
                ++this.m_rowCount;
                ++this.m_rowIndex;
                break;
            }
            if (this.m_requestedCols != null) {
                this.m_colCount = -1;
                ++this.m_rowCount;
                ++this.m_rowIndex;
            }
        }
        catch (Exception ex) {
            throw new KettleException(ex.getMessage(), (Throwable)ex);
        }
        return this.m_converted;
    }

    public Object[] cassandraRowToKettleTupleMode(CassandraColumnMetaData metaData, CqlRow cassandraRow, Iterator<Column> cassandraColIter) throws KettleException {
        Column aCol;
        Object[] outputRowData = RowDataUtil.allocateRowData((int)this.m_outputRowMeta.size());
        Object key = metaData.getKeyValue(cassandraRow);
        if (key == null) {
            throw new KettleException("Unable to obtain a key value for the row!");
        }
        String keyName = metaData.getKeyName();
        int keyIndex = this.m_outputRowMeta.indexOfValue(keyName);
        if (keyIndex < 0) {
            throw new KettleException("Unable to find the key field name '" + keyName + "' in the output row meta data!");
        }
        outputRowData[keyIndex] = key;
        if (cassandraColIter.hasNext()) {
            aCol = cassandraColIter.next();
            String colName = metaData.getColumnName(aCol);
            if (colName.equals("KEY")) {
                if (cassandraColIter.hasNext()) {
                    aCol = cassandraColIter.next();
                    colName = metaData.getColumnName(aCol);
                } else {
                    return null;
                }
            }
            while (metaData.getColumnValue(aCol) == null) {
                if (cassandraColIter.hasNext()) {
                    aCol = cassandraColIter.next();
                    colName = metaData.getColumnName(aCol);
                    continue;
                }
                return null;
            }
            outputRowData[1] = colName;
            Object colValue = metaData.getColumnValue(aCol);
            String stringV = colValue.toString();
            outputRowData[2] = stringV;
            if (colValue instanceof Date) {
                ValueMeta tempDateMeta = new ValueMeta("temp", 3);
                stringV = tempDateMeta.getString(colValue);
                outputRowData[2] = stringV;
            } else if (colValue instanceof byte[]) {
                outputRowData[2] = colValue;
            }
        } else {
            return null;
        }
        long timestampL = aCol.getTimestamp();
        outputRowData[3] = timestampL;
        return outputRowData;
    }

    public Object[] cassandraRowToKettle(CassandraColumnMetaData metaData, CqlRow cassandraRow, Map<String, Integer> outputFormatMap) throws KettleException {
        Object[] outputRowData = RowDataUtil.allocateRowData((int)this.m_outputRowMeta.size());
        Object key = metaData.getKeyValue(cassandraRow);
        if (key == null) {
            throw new KettleException("Unable to obtain a key value for the row!");
        }
        String keyName = metaData.getKeyName();
        int keyIndex = this.m_outputRowMeta.indexOfValue(keyName);
        if (keyIndex < 0) {
            throw new KettleException("Unable to find the key field name '" + keyName + "' in the output row meta data!");
        }
        outputRowData[keyIndex] = key;
        List rowColumns = cassandraRow.getColumns();
        for (Column aCol : rowColumns) {
            Object colValue;
            String colName = metaData.getColumnName(aCol);
            Integer outputIndex = outputFormatMap.get(colName);
            if (outputIndex == null) continue;
            outputRowData[outputIndex.intValue()] = colValue = metaData.getColumnValue(aCol);
        }
        return outputRowData;
    }

    public static String getColumnFamilyNameFromCQLSelectQuery(String subQ) {
        String result = null;
        if (Const.isEmpty((String)subQ)) {
            return null;
        }
        if (!subQ.toLowerCase().startsWith("select")) {
            return null;
        }
        if (subQ.indexOf(59) < 0) {
            return null;
        }
        if (subQ.toLowerCase().lastIndexOf("where") > 0) {
            subQ = subQ.substring(0, subQ.toLowerCase().lastIndexOf("where"));
        }
        int fromIndex = subQ.toLowerCase().indexOf("from");
        String tempS = subQ.toLowerCase();
        int offset = fromIndex;
        while (fromIndex > 0 && tempS.charAt(fromIndex - 1) != ' ' && fromIndex + 4 < tempS.length() && tempS.charAt(fromIndex + 4) != ' ') {
            tempS = tempS.substring(fromIndex + 4, tempS.length());
            fromIndex = tempS.indexOf("from");
            offset += 4 + fromIndex;
        }
        fromIndex = offset;
        if (fromIndex < 0) {
            return null;
        }
        result = subQ.substring(fromIndex + 4, subQ.length()).trim();
        result = result.indexOf(32) > 0 ? result.substring(0, result.indexOf(32)) : result.replace(";", "");
        if (result.length() == 0) {
            return null;
        }
        return result;
    }

    public static byte[] compressQuery(String queryStr, Compression compression) {
        byte[] data = queryStr.getBytes(Charset.forName("UTF-8"));
        Deflater compressor = new Deflater();
        compressor.setInput(data);
        compressor.finish();
        ByteArrayOutputStream byteArray = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while (!compressor.finished()) {
            int size = compressor.deflate(buffer);
            byteArray.write(buffer, 0, size);
        }
        return byteArray.toByteArray();
    }
}

