/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.cassandrainput;

import java.util.ArrayList;
import org.apache.cassandra.thrift.InvalidRequestException;
import org.eclipse.swt.custom.LineStyleListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.pentaho.cassandra.CassandraColumnMetaData;
import org.pentaho.cassandra.CassandraConnection;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.util.StringUtil;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDialogInterface;
import org.pentaho.di.trans.steps.cassandrainput.CassandraInputData;
import org.pentaho.di.trans.steps.cassandrainput.CassandraInputMeta;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.dialog.ShowMessageDialog;
import org.pentaho.di.ui.core.widget.StyledTextComp;
import org.pentaho.di.ui.core.widget.TextVar;
import org.pentaho.di.ui.trans.step.BaseStepDialog;
import org.pentaho.di.ui.trans.steps.tableinput.SQLValuesHighlight;

public class CassandraInputDialog
extends BaseStepDialog
implements StepDialogInterface {
    private static final Class<?> PKG = CassandraInputMeta.class;
    private final CassandraInputMeta m_currentMeta;
    private final CassandraInputMeta m_originalMeta;
    private Label m_stepnameLabel;
    private Text m_stepnameText;
    private Label m_hostLab;
    private TextVar m_hostText;
    private Label m_portLab;
    private TextVar m_portText;
    private Label m_userLab;
    private TextVar m_userText;
    private Label m_passLab;
    private TextVar m_passText;
    private Label m_keyspaceLab;
    private TextVar m_keyspaceText;
    private Label m_compressionLab;
    private Button m_useCompressionBut;
    private Label m_outputTuplesLab;
    private Button m_outputTuplesBut;
    private Label m_useThriftLab;
    private Button m_useThriftBut;
    private Label m_timeoutLab;
    private TextVar m_timeoutText;
    private Label m_positionLab;
    private Button m_showSchemaBut;
    private Label m_cqlLab;
    private StyledTextComp m_cqlText;

    public CassandraInputDialog(Shell parent, Object in, TransMeta tr, String name) {
        super(parent, (BaseStepMeta)in, tr, name);
        this.m_currentMeta = (CassandraInputMeta)((Object)in);
        this.m_originalMeta = (CassandraInputMeta)((Object)this.m_currentMeta.clone());
    }

    public String open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, this.m_currentMeta);
        ModifyListener lsMod = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CassandraInputDialog.this.m_currentMeta.setChanged();
            }
        };
        this.changed = this.m_currentMeta.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"CassandraInputDialog.Shell.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = 4;
        this.m_stepnameLabel = new Label((Composite)this.shell, 131072);
        this.m_stepnameLabel.setText(BaseMessages.getString(PKG, (String)"CassandraInputDialog.StepName.Label", (String[])new String[0]));
        this.props.setLook((Control)this.m_stepnameLabel);
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.right = new FormAttachment(middle, -margin);
        fd.top = new FormAttachment(0, margin);
        this.m_stepnameLabel.setLayoutData((Object)fd);
        this.m_stepnameText = new Text((Composite)this.shell, 18436);
        this.m_stepnameText.setText(this.stepname);
        this.props.setLook((Control)this.m_stepnameText);
        this.m_stepnameText.addModifyListener(lsMod);
        fd = new FormData();
        fd.left = new FormAttachment(middle, 0);
        fd.top = new FormAttachment(0, margin);
        fd.right = new FormAttachment(100, 0);
        this.m_stepnameText.setLayoutData((Object)fd);
        this.m_hostLab = new Label((Composite)this.shell, 131072);
        this.props.setLook((Control)this.m_hostLab);
        this.m_hostLab.setText(BaseMessages.getString(PKG, (String)"CassandraInputDialog.Hostname.Label", (String[])new String[0]));
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)this.m_stepnameText, margin);
        fd.right = new FormAttachment(middle, -margin);
        this.m_hostLab.setLayoutData((Object)fd);
        this.m_hostText = new TextVar((VariableSpace)this.transMeta, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.m_hostText);
        this.m_hostText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CassandraInputDialog.this.m_hostText.setToolTipText(CassandraInputDialog.this.transMeta.environmentSubstitute(CassandraInputDialog.this.m_hostText.getText()));
            }
        });
        this.m_hostText.addModifyListener(lsMod);
        fd = new FormData();
        fd.right = new FormAttachment(100, 0);
        fd.top = new FormAttachment((Control)this.m_stepnameText, margin);
        fd.left = new FormAttachment(middle, 0);
        this.m_hostText.setLayoutData((Object)fd);
        this.m_portLab = new Label((Composite)this.shell, 131072);
        this.props.setLook((Control)this.m_portLab);
        this.m_portLab.setText(BaseMessages.getString(PKG, (String)"CassandraInputDialog.Port.Label", (String[])new String[0]));
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)this.m_hostText, margin);
        fd.right = new FormAttachment(middle, -margin);
        this.m_portLab.setLayoutData((Object)fd);
        this.m_portText = new TextVar((VariableSpace)this.transMeta, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.m_portText);
        this.m_portText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CassandraInputDialog.this.m_portText.setToolTipText(CassandraInputDialog.this.transMeta.environmentSubstitute(CassandraInputDialog.this.m_portText.getText()));
            }
        });
        this.m_portText.addModifyListener(lsMod);
        fd = new FormData();
        fd.right = new FormAttachment(100, 0);
        fd.top = new FormAttachment((Control)this.m_hostText, margin);
        fd.left = new FormAttachment(middle, 0);
        this.m_portText.setLayoutData((Object)fd);
        this.m_timeoutLab = new Label((Composite)this.shell, 131072);
        this.props.setLook((Control)this.m_timeoutLab);
        this.m_timeoutLab.setText(BaseMessages.getString(PKG, (String)"CassandraInputDialog.Timeout.Label", (String[])new String[0]));
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)this.m_portText, margin);
        fd.right = new FormAttachment(middle, -margin);
        this.m_timeoutLab.setLayoutData((Object)fd);
        this.m_timeoutText = new TextVar((VariableSpace)this.transMeta, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.m_timeoutText);
        this.m_timeoutText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CassandraInputDialog.this.m_timeoutText.setToolTipText(CassandraInputDialog.this.transMeta.environmentSubstitute(CassandraInputDialog.this.m_timeoutText.getText()));
            }
        });
        this.m_timeoutText.addModifyListener(lsMod);
        fd = new FormData();
        fd.right = new FormAttachment(100, 0);
        fd.top = new FormAttachment((Control)this.m_portText, margin);
        fd.left = new FormAttachment(middle, 0);
        this.m_timeoutText.setLayoutData((Object)fd);
        this.m_userLab = new Label((Composite)this.shell, 131072);
        this.props.setLook((Control)this.m_userLab);
        this.m_userLab.setText(BaseMessages.getString(PKG, (String)"CassandraInputDialog.User.Label", (String[])new String[0]));
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)this.m_timeoutText, margin);
        fd.right = new FormAttachment(middle, -margin);
        this.m_userLab.setLayoutData((Object)fd);
        this.m_userText = new TextVar((VariableSpace)this.transMeta, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.m_userText);
        this.m_userText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CassandraInputDialog.this.m_userText.setToolTipText(CassandraInputDialog.this.transMeta.environmentSubstitute(CassandraInputDialog.this.m_userText.getText()));
            }
        });
        this.m_userText.addModifyListener(lsMod);
        fd = new FormData();
        fd.right = new FormAttachment(100, 0);
        fd.top = new FormAttachment((Control)this.m_timeoutText, margin);
        fd.left = new FormAttachment(middle, 0);
        this.m_userText.setLayoutData((Object)fd);
        this.m_passLab = new Label((Composite)this.shell, 131072);
        this.props.setLook((Control)this.m_passLab);
        this.m_passLab.setText(BaseMessages.getString(PKG, (String)"CassandraInputDialog.Password.Label", (String[])new String[0]));
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)this.m_userText, margin);
        fd.right = new FormAttachment(middle, -margin);
        this.m_passLab.setLayoutData((Object)fd);
        this.m_passText = new TextVar((VariableSpace)this.transMeta, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.m_passText);
        this.m_passText.setEchoChar('*');
        this.m_passText.getTextWidget().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CassandraInputDialog.this.checkPasswordVisible();
            }
        });
        this.m_passText.addModifyListener(lsMod);
        fd = new FormData();
        fd.right = new FormAttachment(100, 0);
        fd.top = new FormAttachment((Control)this.m_userText, margin);
        fd.left = new FormAttachment(middle, 0);
        this.m_passText.setLayoutData((Object)fd);
        this.m_keyspaceLab = new Label((Composite)this.shell, 131072);
        this.props.setLook((Control)this.m_keyspaceLab);
        this.m_keyspaceLab.setText(BaseMessages.getString(PKG, (String)"CassandraInputDialog.Keyspace.Label", (String[])new String[0]));
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)this.m_passText, margin);
        fd.right = new FormAttachment(middle, -margin);
        this.m_keyspaceLab.setLayoutData((Object)fd);
        this.m_keyspaceText = new TextVar((VariableSpace)this.transMeta, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.m_keyspaceText);
        this.m_keyspaceText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CassandraInputDialog.this.m_keyspaceText.setToolTipText(CassandraInputDialog.this.transMeta.environmentSubstitute(CassandraInputDialog.this.m_keyspaceText.getText()));
            }
        });
        fd = new FormData();
        fd.right = new FormAttachment(100, 0);
        fd.top = new FormAttachment((Control)this.m_passText, margin);
        fd.left = new FormAttachment(middle, 0);
        this.m_keyspaceText.setLayoutData((Object)fd);
        this.m_outputTuplesLab = new Label((Composite)this.shell, 131072);
        this.props.setLook((Control)this.m_outputTuplesLab);
        this.m_outputTuplesLab.setText(BaseMessages.getString(PKG, (String)"CassandraInputDialog.OutputTuples.Label", (String[])new String[0]));
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)this.m_keyspaceText, margin);
        fd.right = new FormAttachment(middle, -margin);
        this.m_outputTuplesLab.setLayoutData((Object)fd);
        this.m_outputTuplesBut = new Button((Composite)this.shell, 32);
        this.props.setLook((Control)this.m_outputTuplesBut);
        fd = new FormData();
        fd.right = new FormAttachment(100, 0);
        fd.top = new FormAttachment((Control)this.m_keyspaceText, margin);
        fd.left = new FormAttachment(middle, 0);
        this.m_outputTuplesBut.setLayoutData((Object)fd);
        this.m_outputTuplesBut.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CassandraInputDialog.this.checkWidgets();
            }
        });
        this.m_useThriftLab = new Label((Composite)this.shell, 131072);
        this.props.setLook((Control)this.m_useThriftLab);
        this.m_useThriftLab.setText(BaseMessages.getString(PKG, (String)"CassandraInputDialog.Thrift.Label", (String[])new String[0]));
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)this.m_outputTuplesBut, margin);
        fd.right = new FormAttachment(middle, -margin);
        this.m_useThriftLab.setLayoutData((Object)fd);
        this.m_useThriftBut = new Button((Composite)this.shell, 32);
        this.props.setLook((Control)this.m_useThriftBut);
        fd = new FormData();
        fd.right = new FormAttachment(100, 0);
        fd.top = new FormAttachment((Control)this.m_outputTuplesBut, margin);
        fd.left = new FormAttachment(middle, 0);
        this.m_useThriftBut.setLayoutData((Object)fd);
        this.m_compressionLab = new Label((Composite)this.shell, 131072);
        this.props.setLook((Control)this.m_compressionLab);
        this.m_compressionLab.setText(BaseMessages.getString(PKG, (String)"CassandraInputDialog.UseCompression.Label", (String[])new String[0]));
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)this.m_useThriftBut, margin);
        fd.right = new FormAttachment(middle, -margin);
        this.m_compressionLab.setLayoutData((Object)fd);
        this.m_useCompressionBut = new Button((Composite)this.shell, 32);
        this.props.setLook((Control)this.m_useCompressionBut);
        fd = new FormData();
        fd.right = new FormAttachment(100, 0);
        fd.left = new FormAttachment(middle, 0);
        fd.top = new FormAttachment((Control)this.m_useThriftBut, margin);
        this.m_useCompressionBut.setLayoutData((Object)fd);
        this.m_useCompressionBut.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CassandraInputDialog.this.m_currentMeta.setChanged();
            }
        });
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.setButtonPositions(new Button[]{this.wOK, this.wCancel}, margin, (Control)this.m_cqlText);
        this.m_positionLab = new Label((Composite)this.shell, 0);
        this.props.setLook((Control)this.m_positionLab);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.right = new FormAttachment(middle, -margin);
        fd.bottom = new FormAttachment((Control)this.wOK, -margin);
        this.m_positionLab.setLayoutData((Object)fd);
        this.m_showSchemaBut = new Button((Composite)this.shell, 8);
        this.m_showSchemaBut.setText(BaseMessages.getString(PKG, (String)"CassandraInputDialog.Schema.Button", (String[])new String[0]));
        this.props.setLook((Control)this.m_showSchemaBut);
        fd = new FormData();
        fd.right = new FormAttachment(100, 0);
        fd.bottom = new FormAttachment((Control)this.wOK, -margin);
        this.m_showSchemaBut.setLayoutData((Object)fd);
        this.m_showSchemaBut.addSelectionListener((SelectionListener)new SelectionAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void widgetSelected(SelectionEvent e) {
                RowMeta outputF = new RowMeta();
                CassandraConnection conn = null;
                try {
                    String hostS = CassandraInputDialog.this.transMeta.environmentSubstitute(CassandraInputDialog.this.m_hostText.getText());
                    String portS = CassandraInputDialog.this.transMeta.environmentSubstitute(CassandraInputDialog.this.m_portText.getText());
                    String userS = CassandraInputDialog.this.m_userText.getText();
                    String passS = CassandraInputDialog.this.m_passText.getText();
                    if (!Const.isEmpty((String)userS) && !Const.isEmpty((String)passS)) {
                        userS = CassandraInputDialog.this.transMeta.environmentSubstitute(userS);
                        passS = CassandraInputDialog.this.transMeta.environmentSubstitute(passS);
                    }
                    String keyspaceS = CassandraInputDialog.this.transMeta.environmentSubstitute(CassandraInputDialog.this.m_keyspaceText.getText());
                    String cqlText = CassandraInputDialog.this.transMeta.environmentSubstitute(CassandraInputDialog.this.m_cqlText.getText());
                    conn = CassandraInputData.getCassandraConnection(hostS, Integer.parseInt(portS), userS, passS);
                    try {
                        conn.setKeyspace(keyspaceS);
                    }
                    catch (InvalidRequestException ire) {
                        CassandraInputDialog.this.logError(BaseMessages.getString((Class)PKG, (String)"CassandraInputDialog.Error.ProblemGettingSchemaInfo.Message", (String[])new String[0]) + ":\n\n" + ire.why, ire);
                        new ErrorDialog(CassandraInputDialog.this.shell, BaseMessages.getString((Class)PKG, (String)"CassandraInputDialog.Error.ProblemGettingSchemaInfo.Title", (String[])new String[0]), BaseMessages.getString((Class)PKG, (String)"CassandraInputDialog.Error.ProblemGettingSchemaInfo.Message", (String[])new String[0]) + ":\n\n" + ire.why, (Exception)((Object)ire));
                        if (conn != null) {
                            conn.close();
                        }
                        return;
                    }
                    String colFam = CassandraInputData.getColumnFamilyNameFromCQLSelectQuery(cqlText);
                    if (Const.isEmpty((String)colFam)) {
                        throw new Exception(BaseMessages.getString((Class)PKG, (String)"CassandraInput.Error.NoFromClauseInQuery", (String[])new String[0]));
                    }
                    if (!CassandraColumnMetaData.columnFamilyExists(conn, colFam)) {
                        throw new Exception(BaseMessages.getString((Class)PKG, (String)"CassandraInput.Error.NonExistentColumnFamily", (String[])new String[]{colFam, keyspaceS}));
                    }
                    CassandraColumnMetaData cassMeta = new CassandraColumnMetaData(conn, colFam);
                    String schemaDescription = cassMeta.getSchemaDescription();
                    ShowMessageDialog smd = new ShowMessageDialog(CassandraInputDialog.this.shell, 34, "Schema info", schemaDescription, true);
                    smd.open();
                }
                catch (Exception e1) {
                    CassandraInputDialog.this.logError(BaseMessages.getString((Class)PKG, (String)"CassandraInputDialog.Error.ProblemGettingSchemaInfo.Message", (String[])new String[0]) + ":\n\n" + e1.getMessage(), e1);
                    new ErrorDialog(CassandraInputDialog.this.shell, BaseMessages.getString((Class)PKG, (String)"CassandraInputDialog.Error.ProblemGettingSchemaInfo.Title", (String[])new String[0]), BaseMessages.getString((Class)PKG, (String)"CassandraInputDialog.Error.ProblemGettingSchemaInfo.Message", (String[])new String[0]) + ":\n\n" + e1.getMessage(), e1);
                }
                finally {
                    if (conn != null) {
                        conn.close();
                    }
                }
            }
        });
        this.m_cqlLab = new Label((Composite)this.shell, 0);
        this.props.setLook((Control)this.m_cqlLab);
        this.m_cqlLab.setText(BaseMessages.getString(PKG, (String)"CassandraInputDialog.CQL.Label", (String[])new String[0]));
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)this.m_useCompressionBut, margin);
        fd.right = new FormAttachment(middle, -margin);
        this.m_cqlLab.setLayoutData((Object)fd);
        this.m_cqlText = new StyledTextComp((VariableSpace)this.transMeta, (Composite)this.shell, 19202, "");
        this.props.setLook((Control)this.m_cqlText, 1);
        this.m_cqlText.addModifyListener(lsMod);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)this.m_cqlLab, margin);
        fd.right = new FormAttachment(100, -2 * margin);
        fd.bottom = new FormAttachment((Control)this.m_showSchemaBut, -margin);
        this.m_cqlText.setLayoutData((Object)fd);
        this.m_cqlText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CassandraInputDialog.this.setPosition();
                CassandraInputDialog.this.m_cqlText.setToolTipText(CassandraInputDialog.this.transMeta.environmentSubstitute(CassandraInputDialog.this.m_cqlText.getText()));
            }
        });
        this.m_cqlText.addLineStyleListener((LineStyleListener)new SQLValuesHighlight());
        this.m_cqlText.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                CassandraInputDialog.this.setPosition();
            }

            public void keyReleased(KeyEvent e) {
                CassandraInputDialog.this.setPosition();
            }
        });
        this.m_cqlText.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                CassandraInputDialog.this.setPosition();
            }

            public void focusLost(FocusEvent e) {
                CassandraInputDialog.this.setPosition();
            }
        });
        this.m_cqlText.addMouseListener(new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                CassandraInputDialog.this.setPosition();
            }

            public void mouseDown(MouseEvent e) {
                CassandraInputDialog.this.setPosition();
            }

            public void mouseUp(MouseEvent e) {
                CassandraInputDialog.this.setPosition();
            }
        });
        this.lsCancel = new Listener(){

            public void handleEvent(Event e) {
                CassandraInputDialog.this.cancel();
            }
        };
        this.lsOK = new Listener(){

            public void handleEvent(Event e) {
                CassandraInputDialog.this.ok();
            }
        };
        this.wCancel.addListener(13, this.lsCancel);
        this.wOK.addListener(13, this.lsOK);
        this.lsDef = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                CassandraInputDialog.this.ok();
            }
        };
        this.m_stepnameText.addSelectionListener((SelectionListener)this.lsDef);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                CassandraInputDialog.this.cancel();
            }
        });
        this.setSize();
        this.getData();
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.stepname;
    }

    private void checkWidgets() {
        if (this.m_outputTuplesBut.getSelection()) {
            this.m_useThriftBut.setEnabled(true);
        } else {
            this.m_useThriftBut.setSelection(false);
            this.m_useThriftBut.setEnabled(false);
        }
    }

    protected void ok() {
        if (Const.isEmpty((String)this.m_stepnameText.getText())) {
            return;
        }
        this.stepname = this.m_stepnameText.getText();
        this.m_currentMeta.setCassandraHost(this.m_hostText.getText());
        this.m_currentMeta.setCassandraPort(this.m_portText.getText());
        this.m_currentMeta.setSocketTimeout(this.m_timeoutText.getText());
        this.m_currentMeta.setUsername(this.m_userText.getText());
        this.m_currentMeta.setPassword(this.m_passText.getText());
        this.m_currentMeta.setCassandraKeyspace(this.m_keyspaceText.getText());
        this.m_currentMeta.setUseCompression(this.m_useCompressionBut.getSelection());
        this.m_currentMeta.setOutputKeyValueTimestampTuples(this.m_outputTuplesBut.getSelection());
        this.m_currentMeta.setUseThriftIO(this.m_useThriftBut.getSelection());
        this.m_currentMeta.setCQLSelectQuery(this.m_cqlText.getText());
        if (!((Object)((Object)this.m_originalMeta)).equals((Object)this.m_currentMeta)) {
            this.m_currentMeta.setChanged();
            this.changed = this.m_currentMeta.hasChanged();
        }
        this.dispose();
    }

    protected void cancel() {
        this.stepname = null;
        this.m_currentMeta.setChanged(this.changed);
        this.dispose();
    }

    protected void getData() {
        if (!Const.isEmpty((String)this.m_currentMeta.getCassandraHost())) {
            this.m_hostText.setText(this.m_currentMeta.getCassandraHost());
        }
        if (!Const.isEmpty((String)this.m_currentMeta.getCassandraPort())) {
            this.m_portText.setText(this.m_currentMeta.getCassandraPort());
        }
        if (!Const.isEmpty((String)this.m_currentMeta.getSocketTimeout())) {
            this.m_timeoutText.setText(this.m_currentMeta.getSocketTimeout());
        }
        if (!Const.isEmpty((String)this.m_currentMeta.getUsername())) {
            this.m_userText.setText(this.m_currentMeta.getUsername());
        }
        if (!Const.isEmpty((String)this.m_currentMeta.getPassword())) {
            this.m_passText.setText(this.m_currentMeta.getPassword());
        }
        if (!Const.isEmpty((String)this.m_currentMeta.getCassandraKeyspace())) {
            this.m_keyspaceText.setText(this.m_currentMeta.getCassandraKeyspace());
        }
        this.m_useCompressionBut.setSelection(this.m_currentMeta.getUseCompression());
        this.m_outputTuplesBut.setSelection(this.m_currentMeta.getOutputKeyValueTimestampTuples());
        this.m_useThriftBut.setSelection(this.m_currentMeta.getUseThriftIO());
        if (!Const.isEmpty((String)this.m_currentMeta.getCQLSelectQuery())) {
            this.m_cqlText.setText(this.m_currentMeta.getCQLSelectQuery());
        }
        this.checkWidgets();
    }

    protected void setPosition() {
        String scr = this.m_cqlText.getText();
        int linenr = this.m_cqlText.getLineAtOffset(this.m_cqlText.getCaretOffset()) + 1;
        int posnr = this.m_cqlText.getCaretOffset();
        int colnr = 0;
        while (posnr > 0 && scr.charAt(posnr - 1) != '\n' && scr.charAt(posnr - 1) != '\r') {
            --posnr;
            ++colnr;
        }
        this.m_positionLab.setText(BaseMessages.getString(PKG, (String)"CassandraInputDialog.Position.Label", (String[])new String[]{"" + linenr, "" + colnr}));
    }

    private void checkPasswordVisible() {
        String password = this.m_passText.getText();
        ArrayList list = new ArrayList();
        StringUtil.getUsedVariables((String)password, list, (boolean)true);
        if (list.size() == 0) {
            this.m_passText.setEchoChar('*');
        } else {
            this.m_passText.setEchoChar('\u0000');
        }
    }
}

