/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.cassandraoutput;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.thrift.Mutation;
import org.pentaho.cassandra.CassandraColumnMetaData;
import org.pentaho.cassandra.CassandraConnection;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.cassandraoutput.CassandraOutputData;
import org.pentaho.di.trans.steps.cassandraoutput.CassandraOutputMeta;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CassandraOutput
extends BaseStep
implements StepInterface {
    protected CassandraOutputMeta m_meta;
    protected CassandraOutputData m_data;
    protected CassandraColumnMetaData m_cassandraMeta;
    protected Map<ByteBuffer, Map<String, List<Mutation>>> m_thriftBatch;
    protected StringBuilder m_batchInsertCQL;
    protected List<Object[]> m_batch;
    protected int m_rowsSeen;
    protected int m_batchSize = 100;
    protected String m_consistency = null;
    protected String m_columnFamilyName;
    protected int m_keyIndex = -1;
    protected int m_cqlBatchInsertTimeout = 0;
    protected int m_batchSplitFactor = 10;
    protected boolean m_useThriftIO;

    public CassandraOutput(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initialize(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        this.m_meta = (CassandraOutputMeta)smi;
        this.m_data = (CassandraOutputData)sdi;
        this.first = false;
        this.m_rowsSeen = 0;
        String hostS = this.environmentSubstitute(this.m_meta.getCassandraHost());
        String portS = this.environmentSubstitute(this.m_meta.getCassandraPort());
        String userS = this.m_meta.getUsername();
        String passS = this.m_meta.getPassword();
        String batchTimeoutS = this.environmentSubstitute(this.m_meta.getCQLBatchInsertTimeout());
        String batchSplitFactor = this.environmentSubstitute(this.m_meta.getCQLSubBatchSize());
        String schemaHostS = this.environmentSubstitute(this.m_meta.getSchemaHost());
        String schemaPortS = this.environmentSubstitute(this.m_meta.getSchemaPort());
        if (Const.isEmpty((String)schemaHostS)) {
            schemaHostS = hostS;
        }
        if (Const.isEmpty((String)schemaPortS)) {
            schemaPortS = portS;
        }
        if (!Const.isEmpty((String)userS) && !Const.isEmpty((String)passS)) {
            userS = this.environmentSubstitute(userS);
            passS = this.environmentSubstitute(passS);
        }
        String keyspaceS = this.environmentSubstitute(this.m_meta.getCassandraKeyspace());
        this.m_columnFamilyName = this.environmentSubstitute(this.m_meta.getColumnFamilyName());
        String keyField = this.environmentSubstitute(this.m_meta.getKeyField());
        try {
            if (!Const.isEmpty((String)batchTimeoutS)) {
                try {
                    this.m_cqlBatchInsertTimeout = Integer.parseInt(batchTimeoutS);
                    if (this.m_cqlBatchInsertTimeout < 500) {
                        this.logBasic(BaseMessages.getString(CassandraOutputMeta.PKG, (String)"CassandraOutput.Message.MinimumTimeout", (String[])new String[0]));
                        this.m_cqlBatchInsertTimeout = 500;
                    }
                }
                catch (NumberFormatException e) {
                    this.logError(BaseMessages.getString(CassandraOutputMeta.PKG, (String)"CassandraOutput.Error.CantParseTimeout", (String[])new String[0]));
                    this.m_cqlBatchInsertTimeout = 10000;
                }
            }
            if (!Const.isEmpty((String)batchSplitFactor)) {
                try {
                    this.m_batchSplitFactor = Integer.parseInt(batchSplitFactor);
                }
                catch (NumberFormatException e) {
                    this.logError(BaseMessages.getString(CassandraOutputMeta.PKG, (String)"CassandraOutput.Error.CantParseSubBatchSize", (String[])new String[0]));
                }
            }
            if (Const.isEmpty((String)hostS) || Const.isEmpty((String)portS) || Const.isEmpty((String)keyspaceS)) {
                throw new KettleException(BaseMessages.getString(CassandraOutputMeta.PKG, (String)"CassandraOutput.Error.MissingConnectionDetails", (String[])new String[0]));
            }
            if (Const.isEmpty((String)this.m_columnFamilyName)) {
                throw new KettleException(BaseMessages.getString(CassandraOutputMeta.PKG, (String)"CassandraOutput.Error.NoColumnFamilySpecified", (String[])new String[0]));
            }
            if (Const.isEmpty((String)keyField)) {
                throw new KettleException(BaseMessages.getString(CassandraOutputMeta.PKG, (String)"CassandraOutput.Error.NoIncomingKeySpecified", (String[])new String[0]));
            }
            this.m_keyIndex = this.getInputRowMeta().indexOfValue(keyField);
            if (this.m_keyIndex < 0) {
                throw new KettleException(BaseMessages.getString(CassandraOutputMeta.PKG, (String)"CassandraOutput.Error.CantFindKeyField", (String[])new String[]{keyField}));
            }
            this.logBasic(BaseMessages.getString(CassandraOutputMeta.PKG, (String)"CassandraOutput.Message.ConnectingForSchemaOperations", (String[])new String[]{schemaHostS, schemaPortS, keyspaceS}));
            CassandraConnection connection = null;
            try {
                connection = this.openConnection(true);
                if (!CassandraColumnMetaData.columnFamilyExists(connection, this.m_columnFamilyName)) {
                    if (this.m_meta.getCreateColumnFamily()) {
                        boolean result = CassandraOutputData.createColumnFamily(connection, this.m_columnFamilyName, this.getInputRowMeta(), this.m_keyIndex, this.m_meta.getUseCompression());
                        if (!result) {
                            throw new KettleException(BaseMessages.getString(CassandraOutputMeta.PKG, (String)"CassandraOutput.Error.NeedAtLeastOneFieldAppartFromKey", (String[])new String[0]));
                        }
                    } else {
                        throw new KettleException(BaseMessages.getString(CassandraOutputMeta.PKG, (String)"CassandraOutput.Error.ColumnFamilyDoesNotExist", (String[])new String[]{this.m_columnFamilyName, keyspaceS}));
                    }
                }
                this.logBasic(BaseMessages.getString(CassandraOutputMeta.PKG, (String)"CassandraOutput.Message.GettingMetaData", (String[])new String[]{this.m_columnFamilyName}));
                this.m_cassandraMeta = new CassandraColumnMetaData(connection, this.m_columnFamilyName);
                if (CassandraOutputData.numFieldsToBeWritten(this.m_columnFamilyName, this.getInputRowMeta(), this.m_keyIndex, this.m_cassandraMeta, this.m_meta.getInsertFieldsNotInMeta()) < 2) {
                    throw new KettleException(BaseMessages.getString(CassandraOutputMeta.PKG, (String)"CassandraOutput.Error.NeedAtLeastOneFieldAppartFromKey", (String[])new String[0]));
                }
                this.m_data.setOutputRowMeta(this.getInputRowMeta());
                String batchSize = this.environmentSubstitute(this.m_meta.getBatchSize());
                if (!Const.isEmpty((String)batchSize)) {
                    try {
                        this.m_batchSize = Integer.parseInt(batchSize);
                    }
                    catch (NumberFormatException e) {
                        this.logError(BaseMessages.getString(CassandraOutputMeta.PKG, (String)"CassandraOutput.Error.CantParseBatchSize", (String[])new String[0]));
                        this.m_batchSize = 100;
                    }
                } else {
                    throw new KettleException(BaseMessages.getString(CassandraOutputMeta.PKG, (String)"CassandraOutput.Error.NoBatchSizeSet", (String[])new String[0]));
                }
                if (this.m_meta.getUpdateCassandraMeta()) {
                    CassandraOutputData.updateCassandraMeta(connection, this.m_columnFamilyName, this.getInputRowMeta(), this.m_keyIndex, this.m_cassandraMeta);
                }
                if (this.m_meta.getTruncateColumnFamily()) {
                    CassandraOutputData.truncateColumnFamily(connection, this.m_columnFamilyName);
                }
                this.m_useThriftIO = this.m_meta.getUseThriftIO();
                if (!Const.isEmpty((String)this.m_meta.getAprioriCQL())) {
                    String aprioriCQL = this.environmentSubstitute(this.m_meta.getAprioriCQL());
                    this.logBasic(BaseMessages.getString(CassandraOutputMeta.PKG, (String)"CassandraOutput.Message.ExecutingAprioriCQL", (String[])new String[]{this.m_columnFamilyName, aprioriCQL}));
                    CassandraOutputData.executeAprioriCQL(connection, aprioriCQL, this.log, this.m_meta.getUseCompression());
                }
            }
            finally {
                if (connection != null) {
                    this.closeConnection(connection);
                    connection = null;
                }
            }
            this.m_consistency = this.environmentSubstitute(this.m_meta.getConsistency());
            this.m_batchInsertCQL = CassandraOutputData.newCQLBatch(this.m_batchSize, this.m_consistency);
            this.m_batch = new ArrayList<Object[]>();
        }
        catch (Exception ex) {
            this.logError(BaseMessages.getString(CassandraOutputMeta.PKG, (String)"CassandraOutput.Error.InitializationProblem", (String[])new String[0]), ex);
        }
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        Object[] r = this.getRow();
        if (r == null) {
            if (this.m_rowsSeen > 0) {
                this.doBatch();
            }
            this.m_batchInsertCQL = null;
            this.m_batch = null;
            this.m_thriftBatch = null;
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            this.initialize(smi, sdi);
        }
        this.m_batch.add(r);
        ++this.m_rowsSeen;
        if (this.m_rowsSeen == this.m_batchSize) {
            this.doBatch();
        }
        return true;
    }

    protected void doBatch() throws KettleException {
        try {
            this.doBatch(this.m_batch);
        }
        catch (Exception e) {
            this.logError(BaseMessages.getString(CassandraOutputMeta.PKG, (String)"CassandraOutput.Error.CommitFailed", (Object[])new Object[]{this.m_batchInsertCQL.toString(), e}));
            throw new KettleException(e.fillInStackTrace());
        }
        this.m_batch.clear();
        this.m_rowsSeen = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doBatch(List<Object[]> batch) throws Exception {
        int size;
        CassandraConnection connection;
        block22: {
            if (this.isStopped()) {
                this.logDebug(BaseMessages.getString(CassandraOutputMeta.PKG, (String)"CassandraOutput.Message.StoppedSkippingBatch", (String[])new String[0]));
                return;
            }
            if (batch == null || batch.isEmpty()) {
                this.logDebug(BaseMessages.getString(CassandraOutputMeta.PKG, (String)"CassandraOutput.Message.SkippingEmptyBatch", (String[])new String[0]));
                return;
            }
            connection = null;
            size = batch.size();
            if (this.m_useThriftIO) {
                this.m_thriftBatch = CassandraOutputData.newThriftBatch(size);
            } else {
                this.m_batchInsertCQL = CassandraOutputData.newCQLBatch(this.m_batchSize, this.m_consistency);
            }
            int rowsAdded = 0;
            for (Object[] r : batch) {
                if (this.m_useThriftIO) {
                    if (!CassandraOutputData.addRowToThriftBatch(this.m_thriftBatch, this.m_columnFamilyName, this.getInputRowMeta(), this.m_keyIndex, r, this.m_cassandraMeta, this.m_meta.getInsertFieldsNotInMeta(), this.log)) continue;
                    ++rowsAdded;
                    continue;
                }
                if (!CassandraOutputData.addRowToCQLBatch(this.m_batchInsertCQL, this.m_columnFamilyName, this.getInputRowMeta(), this.m_keyIndex, r, this.m_cassandraMeta, this.m_meta.getInsertFieldsNotInMeta(), this.log)) continue;
                ++rowsAdded;
            }
            if (rowsAdded != 0) break block22;
            this.logDebug(BaseMessages.getString(CassandraOutputMeta.PKG, (String)"CassandraOutput.Message.SkippingEmptyBatch", (String[])new String[0]));
            this.closeConnection(connection);
            connection = null;
            return;
        }
        try {
            if (!this.m_useThriftIO) {
                CassandraOutputData.completeCQLBatch(this.m_batchInsertCQL);
            }
            connection = this.openConnection(false);
            this.logDetailed(BaseMessages.getString(CassandraOutputMeta.PKG, (String)"CassandraOutput.Message.CommittingBatch", (String[])new String[]{this.m_columnFamilyName, "" + size}));
            if (this.m_useThriftIO) {
                CassandraOutputData.commitThriftBatch(this.m_thriftBatch, this.m_consistency, connection, this.m_cqlBatchInsertTimeout);
            } else {
                CassandraOutputData.commitCQLBatch(this.m_batchInsertCQL, connection, this.m_meta.getUseCompression(), this.m_cqlBatchInsertTimeout);
            }
            this.closeConnection(connection);
            connection = null;
        }
        catch (Exception e) {
            try {
                ArrayList<Object[]> subBatch;
                this.closeConnection(connection);
                connection = null;
                this.logDetailed(BaseMessages.getString(CassandraOutputMeta.PKG, (String)"CassandraOutput.Error.FailedToInsertBatch", (String[])new String[]{"" + size}), new Object[]{e});
                this.logDetailed(BaseMessages.getString(CassandraOutputMeta.PKG, (String)"CassandraOutput.Message.WillNowTrySplittingIntoSubBatches", (String[])new String[0]));
                if (size == 1) {
                    if (this.getStepMeta().isDoingErrorHandling()) {
                        this.putError(this.getInputRowMeta(), batch.get(0), 1L, e.getMessage(), null, "ERR_INSERT01");
                    }
                } else if (size > this.m_batchSplitFactor) {
                    subBatch = new ArrayList<Object[]>();
                    while (batch.size() > this.m_batchSplitFactor) {
                        while (subBatch.size() < this.m_batchSplitFactor && batch.size() > 0) {
                            subBatch.add(batch.remove(batch.size() - 1));
                        }
                        this.doBatch(subBatch);
                        subBatch.clear();
                    }
                    this.doBatch(batch);
                } else {
                    subBatch = new ArrayList();
                    while (batch.size() > 0) {
                        subBatch.clear();
                        subBatch.add(batch.remove(batch.size() - 1));
                        this.doBatch(subBatch);
                    }
                }
                this.closeConnection(connection);
                connection = null;
            }
            catch (Throwable throwable) {
                this.closeConnection(connection);
                connection = null;
                throw throwable;
            }
        }
    }

    public void setStopped(boolean stopped) {
        if (this.isStopped() && stopped) {
            return;
        }
        super.setStopped(stopped);
    }

    protected CassandraConnection openConnection(boolean forSchemaChanges) throws KettleException {
        String hostS = this.environmentSubstitute(this.m_meta.getCassandraHost());
        String portS = this.environmentSubstitute(this.m_meta.getCassandraPort());
        String userS = this.m_meta.getUsername();
        String passS = this.m_meta.getPassword();
        String timeoutS = this.environmentSubstitute(this.m_meta.getSocketTimeout());
        String schemaHostS = this.environmentSubstitute(this.m_meta.getSchemaHost());
        String schemaPortS = this.environmentSubstitute(this.m_meta.getSchemaPort());
        if (Const.isEmpty((String)schemaHostS)) {
            schemaHostS = hostS;
        }
        if (Const.isEmpty((String)schemaPortS)) {
            schemaPortS = portS;
        }
        if (!Const.isEmpty((String)userS) && !Const.isEmpty((String)passS)) {
            userS = this.environmentSubstitute(userS);
            passS = this.environmentSubstitute(passS);
        }
        String keyspaceS = this.environmentSubstitute(this.m_meta.getCassandraKeyspace());
        CassandraConnection connection = null;
        try {
            if (Const.isEmpty((String)timeoutS)) {
                connection = forSchemaChanges ? CassandraOutputData.getCassandraConnection(schemaHostS, Integer.parseInt(schemaPortS), userS, passS) : CassandraOutputData.getCassandraConnection(hostS, Integer.parseInt(portS), userS, passS);
            } else {
                int sockTimeout = 30000;
                try {
                    sockTimeout = Integer.parseInt(timeoutS);
                }
                catch (NumberFormatException e) {
                    this.logError(BaseMessages.getString(CassandraOutputMeta.PKG, (String)"CassandraOutput.Error.CantParseSocketTimeout", (String[])new String[0]));
                }
                connection = forSchemaChanges ? CassandraOutputData.getCassandraConnection(schemaHostS, Integer.parseInt(schemaPortS), userS, passS, sockTimeout) : CassandraOutputData.getCassandraConnection(hostS, Integer.parseInt(portS), userS, passS, sockTimeout);
            }
            connection.setKeyspace(keyspaceS);
        }
        catch (Exception ex) {
            this.closeConnection(connection);
            throw new KettleException(ex.getMessage(), (Throwable)ex);
        }
        return connection;
    }

    protected void closeConnection(CassandraConnection conn) {
        if (conn != null) {
            this.logBasic(BaseMessages.getString(CassandraOutputMeta.PKG, (String)"CassandraOutput.Message.ClosingConnection", (String[])new String[0]));
            conn.close();
        }
    }
}

