/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.cassandraoutput;

import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.zip.Deflater;
import org.apache.cassandra.thrift.CfDef;
import org.apache.cassandra.thrift.Column;
import org.apache.cassandra.thrift.ColumnDef;
import org.apache.cassandra.thrift.ColumnOrSuperColumn;
import org.apache.cassandra.thrift.Compression;
import org.apache.cassandra.thrift.ConsistencyLevel;
import org.apache.cassandra.thrift.InvalidRequestException;
import org.apache.cassandra.thrift.KsDef;
import org.apache.cassandra.thrift.Mutation;
import org.apache.cassandra.thrift.SchemaDisagreementException;
import org.apache.cassandra.thrift.TimedOutException;
import org.apache.cassandra.thrift.UnavailableException;
import org.apache.thrift.TException;
import org.pentaho.cassandra.CassandraColumnMetaData;
import org.pentaho.cassandra.CassandraConnection;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.step.BaseStepData;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.steps.cassandraoutput.CassandraOutputMeta;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CassandraOutputData
extends BaseStepData
implements StepDataInterface {
    protected RowMetaInterface m_outputRowMeta;

    public RowMetaInterface getOutputRowMeta() {
        return this.m_outputRowMeta;
    }

    public void setOutputRowMeta(RowMetaInterface rmi) {
        this.m_outputRowMeta = rmi;
    }

    public static CassandraConnection getCassandraConnection(String host, int port, String username, String password) throws Exception {
        return new CassandraConnection(host, port, username, password, -1);
    }

    public static CassandraConnection getCassandraConnection(String host, int port, String username, String password, int timeout) throws Exception {
        return new CassandraConnection(host, port, username, password, timeout);
    }

    public static Map<ByteBuffer, Map<String, List<Mutation>>> newThriftBatch(int numRows) {
        return new HashMap<ByteBuffer, Map<String, List<Mutation>>>(numRows);
    }

    public static StringBuilder newCQLBatch(int numRows, String consistency) {
        StringBuilder batch = new StringBuilder(numRows * 80);
        batch.append("BEGIN BATCH");
        if (!Const.isEmpty((String)consistency)) {
            batch.append(" USING CONSISTENCY ").append(consistency);
        }
        batch.append("\n");
        return batch;
    }

    public static void completeCQLBatch(StringBuilder batch) {
        batch.append("APPLY BATCH");
    }

    public static void commitCQLBatch(StringBuilder batch, final CassandraConnection conn, final boolean compressCQL, int timeout) throws Exception {
        final byte[] toSend = compressCQL ? CassandraOutputData.compressQuery(batch.toString(), Compression.GZIP) : batch.toString().getBytes(Charset.forName("UTF-8"));
        long start = System.currentTimeMillis();
        long time = System.currentTimeMillis() - start;
        final Exception[] e = new Exception[1];
        final AtomicBoolean done = new AtomicBoolean(false);
        Thread t = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    conn.getClient().execute_cql_query(ByteBuffer.wrap(toSend), compressCQL ? Compression.GZIP : Compression.NONE);
                }
                catch (Exception ex) {
                    e[0] = ex;
                }
                finally {
                    done.set(true);
                }
            }
        });
        t.start();
        while (!done.get()) {
            time = System.currentTimeMillis() - start;
            if (timeout > 0 && time > (long)timeout) {
                try {
                    t.stop();
                }
                catch (Exception ex) {
                    // empty catch block
                }
                throw new KettleException(BaseMessages.getString(CassandraOutputMeta.PKG, (String)"CassandraOutput.Error.TimeoutReached", (String[])new String[0]));
            }
            Thread.sleep(100L);
        }
        if (e[0] != null) {
            throw e[0];
        }
    }

    public static void commitThriftBatch(final Map<ByteBuffer, Map<String, List<Mutation>>> thriftBatch, String consistency, final CassandraConnection conn, int timeout) throws Exception {
        ConsistencyLevel levelToUse = ConsistencyLevel.ANY;
        if (!Const.isEmpty((String)consistency)) {
            try {
                levelToUse = ConsistencyLevel.valueOf((String)consistency);
            }
            catch (IllegalArgumentException ex) {
                // empty catch block
            }
        }
        final ConsistencyLevel fLevelToUse = levelToUse;
        long start = System.currentTimeMillis();
        long time = System.currentTimeMillis() - start;
        final Exception[] e = new Exception[1];
        final AtomicBoolean done = new AtomicBoolean(false);
        Thread t = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    conn.getClient().batch_mutate(thriftBatch, fLevelToUse);
                }
                catch (Exception ex) {
                    e[0] = ex;
                }
                finally {
                    done.set(true);
                }
            }
        });
        t.start();
        while (!done.get()) {
            time = System.currentTimeMillis() - start;
            if (timeout > 0 && time > (long)timeout) {
                try {
                    t.stop();
                }
                catch (Exception ex) {
                    // empty catch block
                }
                throw new KettleException(BaseMessages.getString(CassandraOutputMeta.PKG, (String)"CassandraOutput.Error.TimeoutReached", (String[])new String[0]));
            }
            Thread.sleep(100L);
        }
        if (e[0] != null) {
            throw e[0];
        }
    }

    public static void commitCQLBatch(StringBuilder batch, CassandraConnection conn, boolean compressCQL) throws Exception {
        byte[] toSend = null;
        toSend = compressCQL ? CassandraOutputData.compressQuery(batch.toString(), Compression.GZIP) : batch.toString().getBytes(Charset.forName("UTF-8"));
        conn.getClient().execute_cql_query(ByteBuffer.wrap(toSend), compressCQL ? Compression.GZIP : Compression.NONE);
    }

    protected static boolean preAddChecks(RowMetaInterface inputMeta, int keyIndex, Object[] row, LogChannelInterface log) throws KettleException {
        ValueMetaInterface keyMeta = inputMeta.getValueMeta(keyIndex);
        if (keyMeta.isNull(row[keyIndex])) {
            log.logError(BaseMessages.getString(CassandraOutputMeta.PKG, (String)"CassandraOutput.Error.SkippingRowNullKey", (Object[])row));
            return false;
        }
        boolean ok = false;
        for (int i = 0; i < inputMeta.size(); ++i) {
            ValueMetaInterface v;
            if (i == keyIndex || (v = inputMeta.getValueMeta(i)).isNull(row[i])) continue;
            ok = true;
            break;
        }
        if (!ok) {
            log.logError(BaseMessages.getString(CassandraOutputMeta.PKG, (String)"CassandraOutput.Error.SkippingRowNoNonNullValues", (String[])new String[]{keyMeta.getString(row[keyIndex])}));
        }
        return ok;
    }

    public static boolean addRowToThriftBatch(Map<ByteBuffer, Map<String, List<Mutation>>> thriftBatch, String colFamilyName, RowMetaInterface inputMeta, int keyIndex, Object[] row, CassandraColumnMetaData cassandraMeta, boolean insertFieldsNotInMetaData, LogChannelInterface log) throws KettleException {
        if (!CassandraOutputData.preAddChecks(inputMeta, keyIndex, row, log)) {
            return false;
        }
        ValueMetaInterface keyMeta = inputMeta.getValueMeta(keyIndex);
        ByteBuffer keyBuff = cassandraMeta.kettleValueToByteBuffer(keyMeta, row[keyIndex], true);
        Map<String, List<Mutation>> mapCF = thriftBatch.get(keyBuff);
        List<Mutation> mutList = null;
        if (mapCF != null) {
            mutList = mapCF.get(colFamilyName);
        } else {
            mapCF = new HashMap<String, List<Mutation>>(1);
            mutList = new ArrayList<Mutation>();
        }
        for (int i = 0; i < inputMeta.size(); ++i) {
            ValueMetaInterface colMeta;
            String colName;
            if (i == keyIndex || !cassandraMeta.columnExistsInSchema(colName = (colMeta = inputMeta.getValueMeta(i)).getName()) && !insertFieldsNotInMetaData || colMeta.isNull(row[i])) continue;
            Column col = new Column(cassandraMeta.columnNameToByteBuffer(colName));
            col = col.setValue(cassandraMeta.kettleValueToByteBuffer(colMeta, row[i], false));
            col = col.setTimestamp(System.currentTimeMillis());
            ColumnOrSuperColumn cosc = new ColumnOrSuperColumn();
            cosc.setColumn(col);
            Mutation mut = new Mutation();
            mut.setColumn_or_supercolumn(cosc);
            mutList.add(mut);
        }
        mapCF.put(colFamilyName, mutList);
        thriftBatch.put(keyBuff, mapCF);
        return true;
    }

    public static boolean addRowToCQLBatch(StringBuilder batch, String colFamilyName, RowMetaInterface inputMeta, int keyIndex, Object[] row, CassandraColumnMetaData cassandraMeta, boolean insertFieldsNotInMetaData, LogChannelInterface log) throws KettleException {
        if (!CassandraOutputData.preAddChecks(inputMeta, keyIndex, row, log)) {
            return false;
        }
        ValueMetaInterface keyMeta = inputMeta.getValueMeta(keyIndex);
        batch.append("INSERT INTO ").append(colFamilyName).append(" (KEY");
        for (int i = 0; i < inputMeta.size(); ++i) {
            ValueMetaInterface colMeta;
            String colName;
            if (i == keyIndex || !cassandraMeta.columnExistsInSchema(colName = (colMeta = inputMeta.getValueMeta(i)).getName()) && !insertFieldsNotInMetaData || colMeta.isNull(row[i])) continue;
            batch.append(", '").append(colName).append("'");
        }
        batch.append(") VALUES (");
        String keyString = CassandraColumnMetaData.kettleValueToCQL(keyMeta, row[keyIndex]);
        batch.append("'").append(keyString).append("'");
        for (int i = 0; i < inputMeta.size(); ++i) {
            ValueMetaInterface colMeta;
            String colName;
            if (i == keyIndex || !cassandraMeta.columnExistsInSchema(colName = (colMeta = inputMeta.getValueMeta(i)).getName()) && !insertFieldsNotInMetaData || colMeta.isNull(row[i])) continue;
            batch.append(", '").append(CassandraColumnMetaData.kettleValueToCQL(colMeta, row[i])).append("'");
        }
        batch.append(")\n");
        return true;
    }

    protected static int numFieldsToBeWritten(String colFamilyName, RowMetaInterface inputMeta, int keyIndex, CassandraColumnMetaData cassandraMeta, boolean insertFieldsNotInMetaData) {
        int count = 1;
        for (int i = 0; i < inputMeta.size(); ++i) {
            ValueMetaInterface colMeta;
            String colName;
            if (i == keyIndex || !cassandraMeta.columnExistsInSchema(colName = (colMeta = inputMeta.getValueMeta(i)).getName()) && !insertFieldsNotInMetaData) continue;
            ++count;
        }
        return count;
    }

    public static void truncateColumnFamily(CassandraConnection conn, String columnFamily) throws Exception {
        String cqlCommand = "TRUNCATE " + columnFamily;
        conn.getClient().execute_cql_query(ByteBuffer.wrap(cqlCommand.getBytes()), Compression.NONE);
    }

    public static void updateCassandraMeta(CassandraConnection conn, String colFamilyName, RowMetaInterface inputMeta, int keyIndex, CassandraColumnMetaData cassandraMeta) throws Exception {
        KsDef keySpace = conn.describeKeyspace();
        List colFams = null;
        if (keySpace == null) {
            throw new Exception(BaseMessages.getString(CassandraOutputMeta.PKG, (String)"CassandraOutput.Error.UnableToGetKeyspaceMetaData", (String[])new String[0]));
        }
        colFams = keySpace.getCf_defs();
        CfDef colFamDefToUpdate = null;
        for (CfDef fam : colFams) {
            String columnFamilyName = fam.getName();
            if (!columnFamilyName.equals(colFamilyName)) continue;
            colFamDefToUpdate = fam;
            break;
        }
        if (colFamDefToUpdate == null) {
            throw new Exception(BaseMessages.getString(CassandraOutputMeta.PKG, (String)"CassandraOutput.Error.CantUpdateMetaData", (String[])new String[]{colFamilyName}));
        }
        String comment = colFamDefToUpdate.getComment();
        ArrayList<ValueMetaInterface> indexedVals = new ArrayList<ValueMetaInterface>();
        for (int i = 0; i < inputMeta.size(); ++i) {
            String colName;
            if (i == keyIndex) continue;
            ValueMetaInterface colMeta = inputMeta.getValueMeta(i);
            if (colMeta.getStorageType() == 2) {
                indexedVals.add(colMeta);
            }
            if (cassandraMeta.columnExistsInSchema(colName = colMeta.getName())) continue;
            String colType = CassandraColumnMetaData.getCassandraTypeForValueMeta(colMeta);
            ColumnDef newCol = new ColumnDef(ByteBuffer.wrap(colName.getBytes()), colType);
            colFamDefToUpdate.addToColumn_metadata(newCol);
        }
        if (indexedVals.size() > 0) {
            String before = "";
            String after = "";
            String meta = "";
            if (comment != null && comment.length() > 0 && comment.indexOf("@@@") >= 0) {
                before = comment.substring(0, comment.indexOf("@@@"));
                after = comment.substring(comment.lastIndexOf("@@@") + 3, comment.length());
                meta = comment.substring(comment.indexOf("@@@", comment.lastIndexOf("@@@")));
                meta = meta.replace("@@@", "");
            }
            StringBuffer buff = new StringBuffer();
            buff.append(meta);
            for (ValueMetaInterface vm : indexedVals) {
                String colName = vm.getName();
                if (meta.indexOf(colName) >= 0) continue;
                Object[] legalVals = vm.getIndex();
                if (buff.length() > 0) {
                    buff.append(";").append(colName).append(":{");
                } else {
                    buff.append(colName).append(":{");
                }
                for (int i = 0; i < legalVals.length; ++i) {
                    buff.append(legalVals[i].toString());
                    if (i == legalVals.length - 1) continue;
                    buff.append(",");
                }
                buff.append("}");
            }
            comment = before + "@@@" + buff.toString() + "@@@" + after;
            colFamDefToUpdate.setComment(comment);
        }
        conn.getClient().system_update_column_family(colFamDefToUpdate);
        cassandraMeta.refresh(conn);
    }

    public static void executeAprioriCQL(CassandraConnection conn, String cql, LogChannelInterface log, boolean compressCQL) {
        String[] cqlRequests = cql.split(";");
        if (cqlRequests.length > 0) {
            for (String cqlC : cqlRequests) {
                if (!(cqlC = cqlC.trim()).endsWith(";")) {
                    cqlC = cqlC + ";";
                }
                byte[] toSend = null;
                toSend = compressCQL ? CassandraOutputData.compressQuery(cqlC, Compression.GZIP) : cqlC.getBytes(Charset.forName("UTF-8"));
                String errorMessage = null;
                try {
                    conn.getClient().execute_cql_query(ByteBuffer.wrap(toSend), compressCQL ? Compression.GZIP : Compression.NONE);
                }
                catch (InvalidRequestException e) {
                    errorMessage = e.why;
                }
                catch (UnavailableException e) {
                    errorMessage = e.getMessage();
                }
                catch (TimedOutException e) {
                    errorMessage = e.getMessage();
                }
                catch (SchemaDisagreementException e) {
                    errorMessage = e.getMessage();
                }
                catch (TException e) {
                    errorMessage = e.getMessage();
                }
                if (errorMessage == null) continue;
                log.logBasic("Unable to execute a priori CQL command '" + cqlC + "'. (" + errorMessage + ")");
            }
        }
    }

    public static boolean createColumnFamily(CassandraConnection conn, String colFamilyName, RowMetaInterface inputMeta, int keyIndex, boolean compressCQL) throws Exception {
        StringBuffer buff = new StringBuffer();
        buff.append("CREATE COLUMNFAMILY " + colFamilyName);
        ValueMetaInterface kvm = inputMeta.getValueMeta(keyIndex);
        buff.append(" (KEY ").append("'" + CassandraColumnMetaData.getCQLTypeForValueMeta(kvm) + "'");
        buff.append(" PRIMARY KEY");
        ArrayList<ValueMetaInterface> indexedVals = new ArrayList<ValueMetaInterface>();
        if (inputMeta.size() > 1) {
            for (int i = 0; i < inputMeta.size(); ++i) {
                if (i == keyIndex) continue;
                ValueMetaInterface vm = inputMeta.getValueMeta(i);
                if (vm.getStorageType() == 2) {
                    indexedVals.add(vm);
                }
                String colName = vm.getName();
                String colType = "'" + CassandraColumnMetaData.getCQLTypeForValueMeta(vm) + "'";
                buff.append(", ");
                buff.append("'" + colName + "'").append(" ");
                buff.append(colType);
            }
        } else {
            return false;
        }
        if (indexedVals.size() == 0) {
            buff.append(");");
        } else {
            buff.append(") WITH comment = '@@@");
            int count = 0;
            for (ValueMetaInterface vm : indexedVals) {
                String colName = vm.getName();
                Object[] legalVals = vm.getIndex();
                buff.append(colName).append(":{");
                for (int i = 0; i < legalVals.length; ++i) {
                    buff.append(legalVals[i].toString());
                    if (i == legalVals.length - 1) continue;
                    buff.append(",");
                }
                buff.append("}");
                if (count != indexedVals.size() - 1) {
                    buff.append(";");
                }
                ++count;
            }
            buff.append("@@@';");
        }
        byte[] toSend = null;
        toSend = compressCQL ? CassandraOutputData.compressQuery(buff.toString(), Compression.GZIP) : buff.toString().getBytes(Charset.forName("UTF-8"));
        conn.getClient().execute_cql_query(ByteBuffer.wrap(toSend), compressCQL ? Compression.GZIP : Compression.NONE);
        return true;
    }

    public static byte[] compressQuery(String queryStr, Compression compression) {
        byte[] data = queryStr.getBytes(Charset.forName("UTF-8"));
        Deflater compressor = new Deflater();
        compressor.setInput(data);
        compressor.finish();
        ByteArrayOutputStream byteArray = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while (!compressor.finished()) {
            int size = compressor.deflate(buffer);
            byteArray.write(buffer, 0, size);
        }
        return byteArray.toByteArray();
    }
}

