/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.cassandraoutput;

import org.eclipse.swt.custom.LineStyleListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.core.gui.WindowProperty;
import org.pentaho.di.ui.core.widget.StyledTextComp;
import org.pentaho.di.ui.spoon.job.JobGraph;
import org.pentaho.di.ui.trans.step.BaseStepDialog;
import org.pentaho.di.ui.trans.steps.tableinput.SQLValuesHighlight;

public class EnterCQLDialog
extends Dialog {
    private static Class<?> PKG = EnterCQLDialog.class;
    protected String m_title;
    protected String m_originalCQL;
    protected String m_currentCQL;
    protected Shell m_parent;
    protected Shell m_shell;
    protected Button m_ok;
    protected Button m_cancel;
    protected Listener m_lsCancel;
    protected Listener m_lsOK;
    protected PropsUI m_props;
    protected StyledTextComp m_cqlText;
    protected TransMeta m_transMeta;
    protected ModifyListener m_lsMod;

    public EnterCQLDialog(Shell parent, TransMeta transMeta, ModifyListener lsMod, String title, String cql) {
        super(parent, 0);
        this.m_parent = parent;
        this.m_props = PropsUI.getInstance();
        this.m_title = title;
        this.m_originalCQL = cql;
        this.m_transMeta = transMeta;
        this.m_lsMod = lsMod;
    }

    public String open() {
        Display display = this.m_parent.getDisplay();
        this.m_shell = new Shell(this.m_parent, 68848);
        this.m_props.setLook((Control)this.m_shell);
        this.m_shell.setImage(GUIResource.getInstance().getImageSpoon());
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.m_shell.setLayout((Layout)formLayout);
        this.m_shell.setText(this.m_title);
        int margin = 4;
        this.m_cqlText = new StyledTextComp((VariableSpace)this.m_transMeta, (Composite)this.m_shell, 19202, "");
        this.m_props.setLook((Control)this.m_cqlText, 1);
        this.m_cqlText.setText(this.m_originalCQL);
        this.m_currentCQL = this.m_originalCQL;
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, -2 * margin);
        fd.bottom = new FormAttachment(100, -50);
        this.m_cqlText.setLayoutData((Object)fd);
        this.m_cqlText.addModifyListener(this.m_lsMod);
        this.m_cqlText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EnterCQLDialog.this.m_cqlText.setToolTipText(EnterCQLDialog.this.m_transMeta.environmentSubstitute(EnterCQLDialog.this.m_cqlText.getText()));
            }
        });
        this.m_cqlText.addLineStyleListener((LineStyleListener)new SQLValuesHighlight());
        this.m_ok = new Button((Composite)this.m_shell, 8);
        this.m_ok.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.m_cancel = new Button((Composite)this.m_shell, 8);
        this.m_cancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        BaseStepDialog.positionBottomButtons((Composite)this.m_shell, (Button[])new Button[]{this.m_ok, this.m_cancel}, (int)margin, null);
        this.m_lsCancel = new Listener(){

            public void handleEvent(Event e) {
                EnterCQLDialog.this.cancel();
            }
        };
        this.m_lsOK = new Listener(){

            public void handleEvent(Event e) {
                EnterCQLDialog.this.ok();
            }
        };
        this.m_ok.addListener(13, this.m_lsOK);
        this.m_cancel.addListener(13, this.m_lsCancel);
        this.m_shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                EnterCQLDialog.this.checkCancel(e);
            }
        });
        BaseStepDialog.setSize((Shell)this.m_shell);
        this.m_shell.open();
        while (!this.m_shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.m_currentCQL;
    }

    public void dispose() {
        this.m_props.setScreen(new WindowProperty(this.m_shell));
        this.m_shell.dispose();
    }

    protected void ok() {
        this.m_currentCQL = this.m_cqlText.getText();
        this.dispose();
    }

    protected void cancel() {
        this.m_currentCQL = this.m_originalCQL;
        this.dispose();
    }

    public void checkCancel(ShellEvent e) {
        String newText = this.m_cqlText.getText();
        if (!newText.equals(this.m_originalCQL)) {
            int save = JobGraph.showChangedWarning((Shell)this.m_shell, (String)this.m_title);
            if (save == 256) {
                e.doit = false;
            } else if (save == 64) {
                this.ok();
            } else {
                this.cancel();
            }
        } else {
            this.cancel();
        }
    }
}

